/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.Contact;
import at.emini.physics2D.Event;
import at.emini.physics2D.EventSet;
import at.emini.physics2D.ExternalForce;
import at.emini.physics2D.Joint;
import at.emini.physics2D.Landscape;
import at.emini.physics2D.Motor;
import at.emini.physics2D.MultiShape;
import at.emini.physics2D.ParticleEmitter;
import at.emini.physics2D.PhysicsEventListener;
import at.emini.physics2D.Script;
import at.emini.physics2D.Shape;
import at.emini.physics2D.ShapeSet;
import at.emini.physics2D.Spring;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class World {
    private PhysicsEventListener s;
    private FXVector t = new FXVector(0, 409600);
    private int u = 0;
    private int v = 0;
    static int a = 204;
    static long b = 0x1000000 / a;
    private static int w = 10;
    private static int x = 5;
    public static final int M_SHAPE_MAX_VERTICES = 12;
    protected ShapeSet mShapeSet = new ShapeSet();
    protected EventSet mEventSet = new EventSet();
    private Body[] y = new Body[128];
    private int z = Integer.MIN_VALUE;
    private int A = Integer.MAX_VALUE;
    int c = 0;
    Body[] d = new Body[128];
    private int B = 0;
    private int C = 0;
    private int D = this.c;
    private Landscape E = new Landscape();
    int e = 0;
    Contact[] f = new Contact[128];
    static int g = 0;
    static Contact[] h = new Contact[32];
    int i = 0;
    Constraint[] j = new Constraint[32];
    protected Vector mParticles = new Vector();
    protected Vector mForces = new Vector();
    Script[] k = new Script[32];
    int l = 0;
    Body[] m = new Body[32];
    int[] n = new int[32];
    int[] o = new int[32];
    int[] p = new int[32];
    int q = 0;
    static int r = 0;
    protected UserData mUserData = null;

    public World() {
    }

    protected World(ShapeSet shapeSet) {
        this.mShapeSet = shapeSet;
    }

    public World(World world) {
        if (world == null) {
            return;
        }
        this.mShapeSet = world.mShapeSet.copy();
        this.t.assign(world.t);
        this.u = world.u;
        this.v = world.v;
        this.z = world.z;
        this.A = world.A;
        this.addWorld(world);
        this.mEventSet = world.mEventSet.copy();
        if (world.E != null) {
            this.setLandscape(world.E.copy());
        }
        if (world.mUserData != null) {
            this.mUserData = world.mUserData.copy();
        }
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader) {
        return World.loadWorld(physicsFileReader, null);
    }

    public static World loadWorld(PhysicsFileReader physicsFileReader, UserData userData) {
        int n = physicsFileReader.getVersion();
        if ((n & 0xFF00) < 256 || (n & 0xFF00) > 2560) {
            return null;
        }
        World world = new World();
        Vector<Shape> vector = new Vector<Shape>();
        Vector<Body> vector2 = new Vector<Body>();
        int n2 = 0;
        while (n2 != -1) {
            switch (n2) {
                case 1: {
                    int n3;
                    int n4;
                    int n5 = physicsFileReader.next();
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector.addElement(Shape.loadShape(physicsFileReader, userData));
                    }
                    if (n > 2048) {
                        n4 = physicsFileReader.next();
                        for (n3 = 0; n3 < n4; ++n3) {
                            vector.addElement(MultiShape.loadShape(physicsFileReader, userData, vector));
                        }
                    }
                    world.mShapeSet.registerShapes(vector);
                    break;
                }
                case 2: {
                    int n4;
                    int n6 = physicsFileReader.next();
                    for (n4 = 0; n4 < n6; ++n4) {
                        Body body = Body.loadBody(physicsFileReader, vector, userData);
                        vector2.addElement(body);
                        world.addBody(body);
                    }
                    break;
                }
                case 6: {
                    world.setLandscape(Landscape.loadLandscape(physicsFileReader));
                    break;
                }
                case 3: {
                    int n4;
                    int n7 = physicsFileReader.next();
                    for (n4 = 0; n4 < n7; ++n4) {
                        world.addConstraint(World.loadConstraint(physicsFileReader, vector2, userData));
                    }
                    break;
                }
                case 4: {
                    int n3;
                    int n4;
                    int n8 = physicsFileReader.next();
                    for (n4 = 0; n4 < n8; ++n4) {
                        world.addScript(Script.loadScript(physicsFileReader));
                    }
                    world.q = physicsFileReader.next();
                    for (n4 = 0; n4 < world.q; ++n4) {
                        n3 = physicsFileReader.next();
                        int n9 = physicsFileReader.next();
                        if (n9 < 0 || n9 >= vector2.size() || n3 >= n8) continue;
                        world.n[n4] = physicsFileReader.next();
                        world.m[n4] = (Body)vector2.elementAt(physicsFileReader.next());
                    }
                    break;
                }
                case 5: {
                    int n4;
                    int n10 = physicsFileReader.next();
                    for (n4 = 0; n4 < n10; ++n4) {
                        world.addEvent(Event.loadEvent(physicsFileReader, world, userData));
                    }
                    break;
                }
                case 7: {
                    world.setGravity(physicsFileReader.nextVector());
                    if (physicsFileReader.getVersion() > 2304) {
                        world.setDampingLateralFX(physicsFileReader.nextInt());
                        world.setDampingRotationalFX(physicsFileReader.nextInt());
                    } else {
                        int n11 = 4096 - physicsFileReader.nextInt();
                        world.setDampingLateralFX(n11);
                        world.setDampingRotationalFX(n11);
                    }
                    if (physicsFileReader.getVersion() <= 1792) break;
                    String string = physicsFileReader.nextString();
                    if (userData == null) break;
                    world.mUserData = userData.createNewUserData(string, 6);
                    break;
                }
                case 8: {
                    int n4;
                    int n12 = physicsFileReader.next();
                    for (n4 = 0; n4 < n12; ++n4) {
                        world.addParticleEmitter(ParticleEmitter.loadParticleEmitter(physicsFileReader, world, userData));
                    }
                    break;
                }
            }
            if ((n & 0xFF00) == 256) {
                if (++n2 == 4) {
                    ++n2;
                }
                if (n2 <= 5) continue;
                break;
            }
            n2 = physicsFileReader.next();
        }
        physicsFileReader.close();
        return world;
    }

    public static int getTimestepFX() {
        return a;
    }

    public static long getInverseTimestepFX() {
        return b;
    }

    public static void setTimestepFX(int n) {
        a = n;
        b = 0x1000000 / a;
    }

    public static void setConstraintIterations(int n) {
        w = n;
    }

    public void setPhysicsEventListener(PhysicsEventListener physicsEventListener) {
        this.s = physicsEventListener;
    }

    public void setSimulationArea(int n, int n2) {
        this.z = n << 12;
        this.A = n2 << 12;
    }

    public ShapeSet getShapeSet() {
        return this.mShapeSet;
    }

    public Body[] addWorld(World world) {
        Body body;
        int n;
        int n2 = world.B;
        Body[] bodyArray = new Body[n2];
        for (n = 0; n < world.c; ++n) {
            body = world.d[n].copy();
            this.addBody(body);
            body.calculateAABB(0);
            bodyArray[world.d[n].mId] = body;
        }
        for (n = 0; n < world.i; ++n) {
            this.addConstraint(world.j[n].copy(bodyArray));
        }
        for (n = 0; n < world.l; ++n) {
            this.addScript(world.k[n].copy());
        }
        for (n = 0; n < world.q; ++n) {
            body = bodyArray[world.m[n].mId];
            this.k[world.n[n]].applyToBody(body, this);
            this.o[n] = world.o[n];
            this.p[n] = world.p[n];
        }
        for (n = 0; n < world.mParticles.size(); ++n) {
            this.addParticleEmitter(((ParticleEmitter)world.mParticles.elementAt(n)).copy(bodyArray));
        }
        for (n = 0; n < world.mForces.size(); ++n) {
            this.addExternalForce(((ExternalForce)world.mForces.elementAt(n)).copy(bodyArray));
        }
        Vector vector = world.mEventSet.getEvents();
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            this.addEvent(((Event)vector.elementAt(i)).copy(bodyArray));
        }
        Landscape landscape = world.getLandscape();
        for (int i = 0; i < landscape.mSegmentCount; ++i) {
            this.E.addSegment(new FXVector(landscape.mStartpoints[i]), new FXVector(landscape.mEndpoints[i]), landscape.mFaces[i]);
        }
        return bodyArray;
    }

    public void addBody(Body body) {
        if (body != null) {
            body.mId = this.B++;
            this.d = World.a(this.d, this.c);
            this.d[this.c++] = body;
            this.mShapeSet.registerShape(body.mShape);
            this.a();
            body.forceUpdate();
        }
    }

    public void setLandscape(Landscape landscape) {
        this.E = landscape;
    }

    public Landscape getLandscape() {
        return this.E;
    }

    public void addParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.mParticles.addElement(particleEmitter);
        }
    }

    public void addExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.mForces.addElement(externalForce);
        }
    }

    public void removeBody(Body body) {
        int n;
        int n2;
        if (body.mId < 0) {
            return;
        }
        for (n2 = 0; n2 < this.c; ++n2) {
            if (this.d[n2] != body) continue;
            this.d[n2] = null;
            break;
        }
        this.c = World.a((Object[])this.d, this.c);
        this.a();
        for (n2 = 0; n2 < this.q; ++n2) {
            if (this.m[n2] != body) continue;
            this.o[n2] = -1;
            this.p[n2] = -1;
            this.n[n2] = -1;
            this.m[n2] = null;
            World.b(this.o, this.q);
            World.b(this.p, this.q);
            World.b(this.n, this.q);
            this.q = World.a((Object[])this.m, this.q);
        }
        n2 = this.i;
        for (n = 0; n < n2; ++n) {
            if (!this.j[n].concernsBody(body)) continue;
            this.j[n] = null;
        }
        this.i = World.a(this.j, this.i);
        n = this.mParticles.size();
        for (n2 = n - 1; n2 >= 0; --n2) {
            ParticleEmitter particleEmitter = (ParticleEmitter)this.mParticles.elementAt(n2);
            if (particleEmitter.getEmitter() != body) continue;
            this.mParticles.removeElementAt(n2);
        }
        n2 = this.e;
        for (n = 0; n < n2; ++n) {
            if (!this.f[n].concernsBody(body)) continue;
            this.f[n] = null;
        }
        this.e = World.a((Object[])this.f, this.e);
    }

    public void removeConstraint(Constraint constraint) {
        int n = this.i;
        for (int i = 0; i < n; ++i) {
            if (this.j[i] != constraint) continue;
            this.j[i] = null;
        }
        this.i = World.a(this.j, this.i);
    }

    public void removeScript(Script script) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.l; ++n) {
            if (this.k[n] != script) continue;
            this.k[n] = null;
            n2 = n;
            --this.l;
            for (int i = n; i < this.l; ++i) {
                this.k[i] = this.k[i + 1];
            }
            break;
        }
        for (n = 0; n < this.q; ++n) {
            if (this.o[n] != n2) continue;
            this.o[n] = -1;
            this.p[n] = -1;
            this.n[n] = -1;
            this.m[n] = null;
            World.b(this.o, this.q);
            World.b(this.p, this.q);
            World.b(this.n, this.q);
            this.q = World.a((Object[])this.m, this.q);
            return;
        }
    }

    public void removeEvent(Event event) {
        this.mEventSet.removeEvent(event);
    }

    public void removeParticleEmitter(ParticleEmitter particleEmitter) {
        if (particleEmitter != null) {
            this.mParticles.removeElement(particleEmitter);
        }
    }

    public void removeExternalForce(ExternalForce externalForce) {
        if (externalForce != null) {
            this.mForces.removeElement(externalForce);
        }
    }

    static final int[] a(int[] nArray, int n) {
        if (nArray.length <= n) {
            int[] nArray2 = new int[nArray.length + 32];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    static final short[] a(short[] sArray, int n) {
        if (sArray.length <= n) {
            short[] sArray2 = new short[sArray.length + 32];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    private static Body[] a(Body[] bodyArray, int n) {
        if (bodyArray.length <= n) {
            Body[] bodyArray2 = new Body[bodyArray.length + 32];
            System.arraycopy(bodyArray, 0, bodyArray2, 0, bodyArray.length);
            return bodyArray2;
        }
        return bodyArray;
    }

    static final Contact[] a(Contact[] contactArray, int n) {
        if (contactArray.length <= n) {
            Contact[] contactArray2 = new Contact[contactArray.length + 32];
            System.arraycopy(contactArray, 0, contactArray2, 0, contactArray.length);
            return contactArray2;
        }
        return contactArray;
    }

    static final FXVector[] a(FXVector[] fXVectorArray, int n) {
        if (fXVectorArray.length <= n) {
            FXVector[] fXVectorArray2 = new FXVector[fXVectorArray.length + 32];
            System.arraycopy(fXVectorArray, 0, fXVectorArray2, 0, fXVectorArray.length);
            return fXVectorArray2;
        }
        return fXVectorArray;
    }

    public Body findBodyById(int n) {
        if ((n = this.bodyIndexOf(n)) < 0) {
            return null;
        }
        return this.d[n];
    }

    protected Body findBody(Body body) {
        if (body == null) {
            return null;
        }
        int n = this.bodyIndexOf(body.mId);
        if (n < 0) {
            return null;
        }
        return this.d[n];
    }

    public Body findBodyAt(int n, int n2) {
        Body[] bodyArray = this.getBodies();
        FXVector fXVector = new FXVector();
        for (int i = 0; i < this.getBodyCount(); ++i) {
            Body body = bodyArray[i];
            fXVector.assignFX(n, n2);
            if (n < body.getAABBMinXFX() || n > body.getAABBMaxXFX() || n2 < body.getAABBMinYFX() || n2 > body.getAABBMaxYFX()) continue;
            FXVector[] fXVectorArray = body.getAxes();
            FXVector[] fXVectorArray2 = body.getVertices();
            boolean bl = true;
            for (int j = 0; j < fXVectorArray.length; ++j) {
                long l;
                long l2 = (long)fXVector.xFX * (long)fXVectorArray[j].xFX + (long)fXVector.yFX * (long)fXVectorArray[j].yFX >> 12;
                long l3 = l = (long)fXVectorArray2[0].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[0].yFX * (long)fXVectorArray[j].yFX >> 12;
                for (int k = 1; k < fXVectorArray2.length; ++k) {
                    long l4 = (long)fXVectorArray2[k].xFX * (long)fXVectorArray[j].xFX + (long)fXVectorArray2[k].yFX * (long)fXVectorArray[j].yFX >> 12;
                    if (l > l4) {
                        l = l4;
                    }
                    if (l3 >= l4) continue;
                    l3 = l4;
                }
                if (l <= l2 && l3 >= l2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return body;
        }
        return null;
    }

    public int bodyIndexOf(int n) {
        for (int i = 0; i < this.c; ++i) {
            if (this.d[i].mId != n) continue;
            return i;
        }
        return -1;
    }

    protected Constraint findConstraint(Constraint constraint) {
        int n = this.indexOf(constraint);
        if (n < 0) {
            return null;
        }
        return this.j[n];
    }

    public int indexOf(Constraint constraint) {
        if (constraint == null) {
            return -1;
        }
        for (int i = 0; i < this.i; ++i) {
            if (!this.j[i].equals(constraint)) continue;
            return i;
        }
        return -1;
    }

    public void addConstraint(Constraint constraint) {
        if (constraint != null) {
            Constraint[] constraintArray;
            int n = this.i;
            Constraint[] constraintArray2 = this.j;
            if (this.j.length <= n) {
                Constraint[] constraintArray3 = new Constraint[constraintArray2.length + 32];
                System.arraycopy(constraintArray2, 0, constraintArray3, 0, constraintArray2.length);
                constraintArray = constraintArray3;
            } else {
                constraintArray = constraintArray2;
            }
            this.j = constraintArray;
            this.j[this.i++] = constraint;
        }
    }

    public void addScript(Script script) {
        if (script != null) {
            Script[] scriptArray;
            int n = this.l;
            Script[] scriptArray2 = this.k;
            if (this.k.length <= n) {
                Script[] scriptArray3 = new Script[scriptArray2.length + 32];
                System.arraycopy(scriptArray2, 0, scriptArray3, 0, scriptArray2.length);
                scriptArray = scriptArray3;
            } else {
                scriptArray = scriptArray2;
            }
            this.k = scriptArray;
            this.k[this.l++] = script;
        }
    }

    protected void addScriptBody(int n, Body body) {
        this.n[this.q] = n;
        this.m[this.q++] = body;
    }

    public void addEvent(Event event) {
        this.mEventSet.registerEvent(event);
    }

    public void setGravity(int n) {
        this.t = new FXVector(0, n << 12);
    }

    public void setGravity(FXVector fXVector) {
        this.t = fXVector;
    }

    public void setDampingLateralFX(int n) {
        this.u = n;
    }

    public void setDampingRotationalFX(int n) {
        this.v = n;
    }

    public void tick() {
        int n;
        int n2;
        int n3;
        Body[] bodyArray = this.d;
        Constraint[] constraintArray = this.j;
        for (n3 = 0; n3 < this.q; ++n3) {
            if (this.m[n3] == null) continue;
            this.k[this.n[n3]].executeScript(n3, this);
        }
        for (n3 = 0; n3 < this.mForces.size(); ++n3) {
            ((ExternalForce)this.mForces.elementAt(n3)).applyForce(bodyArray, this.c);
        }
        for (n3 = this.C; n3 < this.D; ++n3) {
            Body body = bodyArray[n3];
            if (body.a && body.c) {
                body.applyAcceleration(this.t);
            }
            body.calculateAABB(a);
        }
        this.checkCollisions();
        Contact.a(this.f, this.e);
        Contact.a(this.f, this.e, this.E);
        for (n3 = 0; n3 < this.mParticles.size(); ++n3) {
            ((ParticleEmitter)this.mParticles.elementAt(n3)).applyAcceleration(this.t, a);
        }
        this.collideParticles();
        for (n3 = 0; n3 < this.e; ++n3) {
            this.f[n3].precalculate();
        }
        for (n3 = 0; n3 < this.i; ++n3) {
            constraintArray[n3].precalculate();
        }
        for (r = 0; r < w; ++r) {
            for (n3 = 0; n3 < this.i; ++n3) {
                constraintArray[n3].applyMomentum();
            }
            for (n3 = 0; n3 < this.e; ++n3) {
                this.f[n3].applyMomentum();
            }
        }
        for (n3 = 0; n3 < this.i; ++n3) {
            constraintArray[n3].postStep();
        }
        n3 = 4096 - this.u;
        int n4 = 4096 - this.v;
        for (n2 = this.C; n2 < this.D; ++n2) {
            bodyArray[n2].integrateVelocity(a);
            bodyArray[n2].updateVelocity(n3, n4);
        }
        for (n2 = 0; n2 < this.e; ++n2) {
            this.f[n2].precalculatePositionCorrection(a);
        }
        long l = 0L;
        long l2 = 0L;
        for (r = 0; r < x; ++r) {
            for (int i = 0; i < this.e; ++i) {
                l2 = this.f[i].applyMomentumPositionCorrectionFX();
                l = l < l2 ? l2 : l;
            }
            if (l < 32L) break;
        }
        for (n = this.C; n < this.D; ++n) {
            bodyArray[n].integrateVirtualVelocity(a, this.t);
        }
        for (n = 0; n < this.mParticles.size(); ++n) {
            ((ParticleEmitter)this.mParticles.elementAt(n)).integrateParticles();
        }
        if (this.s != null) {
            this.mEventSet.checkEvents(this, this.s);
        }
    }

    protected void checkCollisions() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.e; ++n3) {
            this.f[n3] = null;
        }
        n3 = this.e = 0;
        this.E.initCollision();
        this.a();
        int n4 = 0;
        int n5 = 0;
        for (n2 = this.C; n2 < this.D; ++n2) {
            n = this.d[n2].e;
            this.E.collisionCheckBody(this, this.d[n2]);
            for (int i = 0; i < n5; ++i) {
                if (this.y[i] == null) continue;
                if (this.y[i].f < n) {
                    --n4;
                    this.y[i] = null;
                    continue;
                }
                if (this.d[n2].g > this.y[i].h || this.y[i].g > this.d[n2].h) continue;
                Body body = this.y[i];
                Body body2 = this.d[n2];
                World world = this;
                if (!body2.a && !body.a || (body2.i & body.i) != 0 || !body2.b || !body.b) continue;
                if (body2.mShape instanceof MultiShape || body.mShape instanceof MultiShape) {
                    int n6 = 1;
                    int n7 = 1;
                    if (body2.mShape instanceof MultiShape) {
                        n6 = ((MultiShape)body2.mShape).getShapeCount();
                    }
                    if (body.mShape instanceof MultiShape) {
                        n7 = ((MultiShape)body.mShape).getShapeCount();
                    }
                    for (int j = 0; j < n6; ++j) {
                        for (int k = 0; k < n7; ++k) {
                            Contact contact = Collision.detectCollision(body2, j, body, k);
                            if (contact == null) continue;
                            world.f = World.a(world.f, world.e);
                            world.f[world.e] = contact;
                            ++world.e;
                        }
                    }
                    continue;
                }
                Contact contact = Collision.detectCollision(body2, body);
                if (contact == null) continue;
                world.f = World.a(world.f, world.e);
                world.f[world.e] = contact;
                ++world.e;
            }
            this.y = World.a(this.y, n5);
            this.y[n5++] = this.d[n2];
            if (n5 <= ++n4 << 1) continue;
            n5 = World.a((Object[])this.y, n5);
        }
        this.E.resetContacts();
        for (n2 = this.C; n2 < this.D; ++n2) {
            this.d[n2].resetContacts();
        }
        this.E.getBody();
        for (n = n3; n < this.e; ++n) {
            Contact contact = this.f[n];
            this.f[n].g = false;
            contact.a.addContact(contact);
            contact.c.addContact(contact);
        }
    }

    protected void collideParticles() {
        for (int i = 0; i < this.mParticles.size(); ++i) {
            ParticleEmitter particleEmitter = (ParticleEmitter)this.mParticles.elementAt(i);
            if (!particleEmitter.a) continue;
            int n = 0;
            int n2 = 0;
            for (int j = this.C; j < this.D; ++j) {
                while (n < particleEmitter.mMaxParticleCount && (particleEmitter.mLife[n] <= 0 || this.d[j].e > particleEmitter.mXFX[n])) {
                    ++n;
                }
                for (n2 = n; n2 < particleEmitter.mMaxParticleCount && (particleEmitter.mLife[n2] <= 0 || this.d[j].f > particleEmitter.mXFX[n2]); ++n2) {
                    FXVector fXVector;
                    if (particleEmitter.mLife[n2] <= 0 || this.d[j].g >= particleEmitter.mYFX[n2] || this.d[j].h <= particleEmitter.mYFX[n2] || (fXVector = Collision.detectCollision(this.d[j], particleEmitter.mXFX[n2], particleEmitter.mYFX[n2])) == null) continue;
                    particleEmitter.collide(fXVector, n2);
                }
            }
            this.E.collideParticles(particleEmitter);
        }
    }

    private static int a(Object[] objectArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (objectArray[n3] != null && n3 < n) {
                ++n3;
            }
            while (objectArray[n] == null && n3 < n) {
                --n;
            }
            if (n3 < n) {
                objectArray[n3] = objectArray[n];
                objectArray[n] = null;
            }
            if (objectArray[n] == null) {
                n2 = n;
            }
            --n;
        }
        while (n2 > 0 && objectArray[n2 - 1] == null) {
            --n2;
        }
        return n2;
    }

    static final int b(int[] nArray, int n) {
        int n2 = n--;
        int n3 = 0;
        while (n3 < n) {
            while (nArray[n3] != -1 && n3 < n) {
                ++n3;
            }
            while (nArray[n] == -1 && n3 < n) {
                --n;
            }
            if (n3 < n) {
                nArray[n3] = nArray[n];
                nArray[n] = -1;
                n2 = n;
            }
            --n;
        }
        return n2;
    }

    private final void a() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.c; ++n) {
            Body body = this.d[n];
            for (n2 = n - 1; n2 >= 0 && this.d[n2].e > body.e; --n2) {
                this.d[n2 + 1] = this.d[n2];
            }
            this.d[n2 + 1] = body;
        }
        this.C = -1;
        this.D = this.c;
        for (n = 0; n < this.c; ++n) {
            if (this.C < 0 && this.d[n].f > this.z) {
                this.C = n;
            }
            if (this.d[n].e >= this.A) continue;
            this.D = n + 1;
        }
        if (this.C < 0) {
            this.C = 0;
        }
    }

    public FXVector getGravity() {
        return this.t;
    }

    public int getDampingLateralFX() {
        return this.u;
    }

    public int getDampingRotationalFX() {
        return this.v;
    }

    public static Constraint loadConstraint(PhysicsFileReader physicsFileReader, Vector vector, UserData userData) {
        int n = physicsFileReader.next();
        switch (n) {
            case 0: {
                return Joint.loadJoint(physicsFileReader, vector, userData);
            }
            case 1: {
                return Spring.loadSpring(physicsFileReader, vector, userData);
            }
            case 3: {
                return Motor.loadMotor(physicsFileReader, vector, userData);
            }
        }
        return null;
    }

    public Vector getEvents() {
        return this.mEventSet.getEvents();
    }

    public Vector getParticleEmitters() {
        return this.mParticles;
    }

    protected int getAreaStartFX() {
        return this.z;
    }

    protected int getAreaEndFX() {
        return this.A;
    }

    public int getBodyCount() {
        return this.c;
    }

    public Body[] getBodies() {
        return this.d;
    }

    public int getBodyStartIndex() {
        return this.C;
    }

    public int getBodyEndIndex() {
        return this.D;
    }

    public int getConstraintCount() {
        return this.i;
    }

    public Constraint[] getConstraints() {
        return this.j;
    }

    public int getContactCount() {
        return this.e;
    }

    public Contact[] getContacts() {
        return this.f;
    }

    public int getScriptCount() {
        return this.l;
    }

    public Script[] getScripts() {
        return this.k;
    }

    public Script getScript(int n) {
        return this.k[n];
    }

    protected int getScriptBodyCount() {
        return this.q;
    }

    protected Body[] getScriptBodies() {
        return this.m;
    }

    protected int[] getScriptIndices() {
        return this.n;
    }

    public Contact[] getContactsForBody(Body contactArray) {
        Contact[] contactArray2 = new Contact[8];
        int n = 0;
        contactArray = contactArray.getContacts();
        for (int i = 0; i < contactArray.length && contactArray[i] != null; ++i) {
            contactArray2[n++] = contactArray[i];
        }
        return contactArray2;
    }

    public void translate(FXVector fXVector) {
        int n = this.getBodyCount();
        Body[] bodyArray = this.getBodies();
        for (int i = 0; i < n; ++i) {
            bodyArray[i].positionFX().xFX += fXVector.xFX;
            bodyArray[i].positionFX().yFX += fXVector.yFX;
            bodyArray[i].calculateAABB(0);
        }
    }

    public long getBodyTotalEnergyFX(Body body) {
        long l = body.velocityFX().lengthSquareFX() / 2;
        long l2 = -((int)((long)body.positionFX().yFX * (long)this.t.yFX) >> 12);
        return l + (l2 += (long)(-((int)((long)body.positionFX().xFX * (long)this.t.xFX) >> 12)));
    }
}

