/*
 * Decompiled with CFR 0.152.
 */
package com.thinkink.Game;

import com.thinkink.Game.LineManager;
import com.thinkink.Game.MainCanvas;
import com.thinkink.app.GeneralFunction;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Line {
    private static final Image LOCK_IMG = GeneralFunction.createImage("maincanvas/lock.png");
    private static final Image BOMB_IMG = GeneralFunction.createImage("maincanvas/bomb.png");
    private static final Image LIFE_IMG = GeneralFunction.createImage("maincanvas/life.png");
    private final Image lineImg;
    private int X;
    private int Y;
    private int endX;
    private int endY;
    private final int width;
    private final int height;
    private boolean isBomb;
    private boolean isLife;
    private boolean isLock;
    private Callback callback;
    private final boolean isHorizon;
    private int count;
    private Image[] bombImages;
    private long startTimer;
    private long time = 8000L;

    public Line(Image lineImg, int X, int Y, Callback callback) {
        this.lineImg = Image.createImage((Image)lineImg);
        this.width = lineImg.getWidth();
        this.height = lineImg.getHeight();
        this.X = X;
        this.Y = Y;
        this.endX = X + this.width;
        this.endY = Y + this.height;
        if (this.width > 30) {
            this.isHorizon = true;
            this.bombImages = new Image[this.width / 22];
        } else {
            this.isHorizon = false;
            this.bombImages = new Image[this.height / 22];
        }
        this.callback = callback;
    }

    protected void paint(Graphics g) {
        block4: {
            g.drawImage(this.lineImg, this.X, this.Y, 0);
            if (!this.isBomb && !this.isLife && !this.isLock) break block4;
            if (this.isHorizon) {
                for (int i = 0; i < this.bombImages.length; ++i) {
                    g.drawImage(this.bombImages[i], this.X + i * 22, this.Y, 0);
                }
            } else {
                for (int i = 0; i < this.bombImages.length; ++i) {
                    g.drawImage(this.bombImages[i], this.X, this.Y + i * 22, 0);
                }
            }
        }
    }

    protected boolean pointerPressed(int x, int y) {
        if (x > this.X && x < this.endX && y > this.Y && y < this.endY) {
            ++this.count;
            if (!this.isLock) {
                this.callback.linePressed();
                return true;
            }
            if (this.count >= 5) {
                this.callback.linePressed();
                return true;
            }
            this.isBomb = false;
            return true;
        }
        return false;
    }

    public Image getLineImg() {
        return this.lineImg;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isIsBomb() {
        return this.isBomb;
    }

    public boolean isIsLife() {
        return this.isLife;
    }

    public void setIsLife(boolean isLife) {
        this.isBomb = false;
        this.isLock = false;
        this.isLife = isLife;
        this.bombTimer();
        this.setBombImage();
    }

    public boolean isIsLock() {
        return this.isLock;
    }

    public void setIsLock(boolean isLock) {
        this.isBomb = false;
        this.isLife = false;
        this.isLock = isLock;
        this.setBombImage();
    }

    public void setIsBomb(boolean isBomb) {
        this.isLock = false;
        this.isLife = false;
        this.isBomb = isBomb;
        this.bombTimer();
        this.setBombImage();
    }

    public void setX(int X) {
        this.X = X;
        this.endX = X + this.width;
    }

    public void setY(int Y) {
        this.Y = Y;
        this.endY = Y + this.height;
    }

    public void setBombImage() {
        block4: {
            block5: {
                block3: {
                    if (!this.isBomb) break block3;
                    for (int i = 0; i < this.bombImages.length; ++i) {
                        this.bombImages[i] = BOMB_IMG;
                    }
                    break block4;
                }
                if (!this.isLife) break block5;
                for (int i = 0; i < this.bombImages.length; ++i) {
                    this.bombImages[i] = LIFE_IMG;
                }
                break block4;
            }
            if (!this.isLock) break block4;
            for (int i = 0; i < this.bombImages.length; ++i) {
                this.bombImages[i] = LOCK_IMG;
            }
        }
    }

    private void bombTimer() {
        this.startTimer = System.currentTimeMillis();
    }

    public long updateTimer() {
        long currentTime = System.currentTimeMillis() - this.startTimer;
        if (currentTime > 10000L) {
            if (this.isBomb) {
                LineManager.soundManger.playSound("bomb_explode");
                MainCanvas.threadStatus = false;
            } else if (this.isLife) {
                this.isLife = false;
            }
        }
        return currentTime;
    }

    public static interface Callback {
        public void linePressed();
    }
}

