/*
 * Decompiled with CFR 0.152.
 */
package com.thinkink.Game;

import com.thinkink.Game.LevelCanvas;
import com.thinkink.Game.Line;
import com.thinkink.Game.MainCanvas;
import com.thinkink.app.GeneralFunction;
import com.thinkink.utility.SoundManger;
import com.thinkink.utility.Timer;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LineManager
implements Line.Callback {
    private static final Image[] LINES = new Image[80];
    private final Image timerStrip = GeneralFunction.createImage("maincanvas/lineV.png");
    private final Image bombTimer = GeneralFunction.createImage("maincanvas/bombtimer.png");
    private final Image lifeTimer = GeneralFunction.createImage("maincanvas/lifetimer.png");
    private final int bombTimerX;
    private final int lifeTimerX;
    private final int timerY;
    public static final SoundManger soundManger;
    private int removedIndex = 399;
    private final Random random;
    private final Line[] line = new Line[400];
    private int multiplier = 1;
    private int countinuousHit;
    private Timer timer;
    private final int mode;
    private boolean bombTimerStatus;
    private boolean lifeTimerStatus;
    private LineTimer bLineTimer;
    private LineTimer lLineTimer;
    int count = 0;
    public static int score;
    public static int lines;
    int Counter;

    public LineManager(int mode) {
        this.bombTimerX = 190;
        this.lifeTimerX = 215;
        this.timerY = 0;
        score = 0;
        this.mode = mode;
        this.random = new Random();
        int preVIndex = 1;
        int X = 104;
        int Y = 50;
        this.line[0] = new Line(LINES[preVIndex], X, Y, this);
        for (int i = 1; i < this.line.length; ++i) {
            int ttt;
            int index = this.getRandomIndex(preVIndex, 80);
            Image img = LINES[index];
            preVIndex = index;
            X = this.random.nextInt(this.line[i - 1].getWidth()) + this.line[i - 1].getX() - 10;
            Y = this.random.nextInt(this.line[i - 1].getHeight()) + this.line[i - 1].getY() - 10;
            if (X < 10) {
                X = 10;
            }
            if (Y < 50) {
                Y = 50;
            }
            this.line[i] = new Line(img, X, Y, this);
            if (this.line[i].getEndX() > 230) {
                ttt = this.line[i - 1].getEndX() - this.line[i].getWidth();
                if (ttt < 3) {
                    this.line[i].setX(this.random.nextInt(7) + 3);
                } else {
                    this.line[i].setX(ttt);
                }
            } else {
                this.line[i].setX(X);
            }
            if (this.line[i].getEndY() > 350) {
                ttt = this.line[i - 1].getEndY() - this.line[i].getHeight();
                if (ttt < 50) {
                    this.line[i].setY(Y - (this.line[i].getEndY() - 350 + this.random.nextInt(30)));
                    continue;
                }
                this.line[i].setY(ttt);
                continue;
            }
            this.line[i].setY(Y);
        }
        if (mode != 2) {
            this.timer = new Timer();
        }
    }

    protected void paint(Graphics g) {
        for (int i = this.removedIndex - 30; i <= this.removedIndex; ++i) {
            this.line[i].paint(g);
        }
        if (this.mode != 2) {
            this.timer.paint(g);
        }
        g.drawString("X" + this.multiplier, 25, 4, 0);
        ++this.count;
        if (this.bombTimerStatus) {
            g.drawImage(this.bombTimer, 190, 0, 0);
            this.bLineTimer.paint(g);
        }
        if (this.lifeTimerStatus) {
            g.drawImage(this.lifeTimer, 215, 0, 0);
            this.lLineTimer.paint(g);
        }
    }

    protected void pointerRelesed(int x, int y) {
        if (!this.line[this.removedIndex].pointerPressed(x, y)) {
            this.countinuousHit = 0;
            this.setMultiPlier();
            if (this.mode == 2) {
                MainCanvas.threadStatus = false;
            }
            soundManger.playSound("missline2");
        } else {
            this.setMultiPlier();
            if (this.mode == 0) {
                if (this.removedIndex % 14 == 0) {
                    if (this.removedIndex - 8 > 0) {
                        this.line[this.removedIndex - 8].setIsBomb(true);
                    }
                    this.bombTimerStatus = true;
                    this.bLineTimer = new LineTimer(this.line[this.removedIndex - 8], 190, 0);
                } else if (this.removedIndex % 10 == 0) {
                    if (this.removedIndex - 8 > 0) {
                        this.line[this.removedIndex - 8].setIsLock(true);
                    }
                } else if (this.removedIndex % 18 == 0) {
                    if (this.removedIndex - 8 > 0) {
                        this.line[this.removedIndex - 8].setIsLife(true);
                    }
                    this.lifeTimerStatus = true;
                    this.lLineTimer = new LineTimer(this.line[this.removedIndex - 8], 215, 0);
                }
            }
            soundManger.playSound("linePop2");
        }
    }

    public void linePressed() {
        ++lines;
        if (2 != LevelCanvas.currentMode && this.line[this.removedIndex].isIsLife()) {
            this.timer.setGameStartTime();
        }
        if (this.removedIndex > 1) {
            --this.removedIndex;
        } else {
            MainCanvas.threadStatus = true;
        }
        ++this.countinuousHit;
        score += this.multiplier;
    }

    private int getRandomIndex(int index, int num) {
        int j = this.random.nextInt(num);
        boolean indexselected = false;
        while (!indexselected) {
            if (index != j) {
                index = j;
                indexselected = true;
                continue;
            }
            j = this.random.nextInt(num);
        }
        return index;
    }

    public void setCounter() {
        ++this.Counter;
    }

    private void setMultiPlier() {
        switch (this.countinuousHit) {
            case 0: {
                this.multiplier = 1;
                break;
            }
            case 5: {
                this.multiplier = 2;
                break;
            }
            case 12: {
                this.multiplier = 3;
                break;
            }
            case 20: {
                this.multiplier = 4;
            }
        }
    }

    public void update() {
        if (LevelCanvas.currentMode != 2) {
            this.timer.updateTimer();
        }
        if (this.mode == 0) {
            if (this.lifeTimerStatus) {
                this.line[this.removedIndex].updateTimer();
                this.lifeTimerStatus = this.lLineTimer.updateTimer();
            }
            if (this.bombTimerStatus) {
                this.line[this.removedIndex].updateTimer();
                this.bombTimerStatus = this.bLineTimer.updateTimer();
            }
        }
    }

    static {
        for (int i = 0; i < LINES.length; ++i) {
            LineManager.LINES[i] = GeneralFunction.createImage("maincanvas/vertical/" + i + ".png");
        }
        soundManger = new SoundManger();
    }

    private class LineTimer {
        private Image strip;
        private int height;
        private int width;
        private Line line;
        private int X;
        private int Y;

        public LineTimer(Line line, int X, int Y) {
            this.strip = LineManager.this.timerStrip;
            this.height = this.strip.getHeight();
            this.width = this.strip.getWidth();
            this.line = line;
            this.X = X;
            this.Y = Y;
        }

        protected void paint(Graphics g) {
            g.drawImage(this.strip, this.X, this.Y, 0);
        }

        private boolean updateTimer() {
            int time = (int)this.line.updateTimer() / 1000;
            int h = this.height * (10 - time);
            if (h > 0) {
                this.strip = GeneralFunction.scaleImage(this.strip, this.width, h / 10);
                return true;
            }
            return false;
        }
    }
}

