/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.general;

import com.twistfuture.Apps.TwistMidlet;
import com.twistfuture.Game.LevelCanvas;
import com.twistfuture.app.GeneralFunction;
import com.twistfuture.app.GeneralInfo;
import com.twistfuture.general.AboutOrHelp;
import com.twistfuture.general.FBLikeCanvas;
import com.twistfuture.general.PrivacyPolicyForm;
import com.twistfuture.utility.Button;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenu
extends Canvas
implements Button.ButtonCallback,
TwistMidlet.Callback {
    private final String[] btnString = new String[]{"play", "about", "more", "privacy", "help", "exit"};
    private final Button[] buttons;
    private final int btnlength;
    private final Image bg;

    public MainMenu() {
        this.setFullScreenMode(true);
        this.bg = GeneralFunction.createImage("general/bg.png");
        if (!GeneralInfo.ISASHA) {
            this.btnlength = this.btnString.length;
        } else {
            this.btnlength = this.btnString.length - 1;
            this.addCommand(new Command("exit", 7, 0));
            this.setCommandListener(new CommandListener(){

                public void commandAction(Command c, Displayable d) {
                    MainMenu.this.buttonClicked(MainMenu.this.btnlength);
                }
            });
        }
        this.buttons = new Button[this.btnlength];
    }

    private void loadImage() {
        for (int i = 0; i < this.btnlength; ++i) {
            this.buttons[i] = new Button(GeneralFunction.createImage("mainmenu/" + this.btnString[i] + ".png"), 0, 0, i, this);
            if (i < 3) {
                this.buttons[i].SetCordinate(35 + i * 106, 50);
                continue;
            }
            this.buttons[i].SetCordinate(20 + (i - 3) * 106, 130);
        }
    }

    private void loadAdd() {
        TwistMidlet.mMidlet.registerForUP(this);
        TwistMidlet.mMidlet.registerForDown(this);
    }

    protected void showNotify() {
        this.loadImage();
        this.loadAdd();
    }

    protected void hideNotify() {
        Runtime.getRuntime().gc();
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bg, 0, 0, 0);
        for (int i = 0; i < this.btnlength; ++i) {
            this.buttons[i].paint(g);
        }
        TwistMidlet.mMidlet.paintAd(g);
    }

    protected void pointerPressed(int x, int y) {
        for (int i = 0; i < this.btnlength; ++i) {
            this.buttons[i].pointerPressed(x, y);
        }
        TwistMidlet.mMidlet.adClicked(x, y);
    }

    public void areaToRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }

    public void buttonClicked(int aButtonId) {
        Runtime.getRuntime().gc();
        switch (aButtonId) {
            case 0: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new LevelCanvas());
                break;
            }
            case 1: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new AboutOrHelp(AboutOrHelp.ABOUT));
                break;
            }
            case 2: {
                try {
                    TwistMidlet.mMidlet.platformRequest("http://store.ovi.com/publisher/Twisfuture");
                }
                catch (ConnectionNotFoundException connectionNotFoundException) {}
                break;
            }
            case 3: {
                new PrivacyPolicyForm().displayPrivacyPolicyForm();
                break;
            }
            case 4: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new AboutOrHelp(AboutOrHelp.HELP));
                break;
            }
            case 5: {
                TwistMidlet.mDisplay.setCurrent((Displayable)new FBLikeCanvas());
            }
        }
    }

    public void callRepaint(int xcordi, int ycordi, int width, int height) {
        this.repaint();
    }

    public void FileEndReachOfMedia(int fileno) {
    }
}

