/*
 * Decompiled with CFR 0.152.
 */
package com.twistfuture.main;

import com.twistfuture.app.App;
import com.twistfuture.main.Ball;
import com.twistfuture.main.Box;
import com.twistfuture.main.Fall;
import com.twistfuture.main.Glass;
import com.twistfuture.main.GlassBall;
import com.twistfuture.main.GlassContainer;
import com.twistfuture.main.TwistCanvas;
import com.twistfuture.utill.PlaySound;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class BoxContainer
implements PlaySound.CallBack {
    final int[] BALL_X = new int[]{124, 110, 100, 118, 106, 124, 112, 100, 118, 106, 100, 127, 111, 120, 137, 108, 91, 147, 130, 100, 140, 116, 125, 81, 90, 134, 106, 96, 117, 72, 157, 80, 147, 88, 103, 155, 144, 129, 113, 94, 123, 137, 131, 101, 112, 168};
    final int[] BALL_Y = new int[]{215, 215, 215, 207, 207, 200, 200, 200, 192, 192, 185, 187, 185, 180, 184, 178, 181, 179, 177, 176, 173, 171, 169, 178, 173, 166, 167, 167, 163, 175, 175, 169, 172, 164, 158, 165, 164, 160, 155, 157, 153, 156, 148, 150, 145, 172};
    public Vector vector_Box = new Vector();
    private final Vector vector_Falling = new Vector();
    private Glass glass;
    public final GlassContainer glassContainer;
    private int randomValue;
    public boolean isGameOver;
    private PlaySound playSound;
    public boolean checkBox;
    int[] fallx = new int[]{124, 116, 108, 122, 114, 106, 97, 89, 82};

    public BoxContainer() {
        this.glassContainer = new GlassContainer(this);
        for (int i = 0; i < Glass.glass_Color.length; ++i) {
            this.glass = new Glass(App.createImage("glass/" + Glass.glass_Color[i] + ".png"), 190, -150 * i, i, Glass.glass_Color[i]);
            this.glassContainer.addElement(this.glass);
        }
        this.playSound = new PlaySound(this);
    }

    private boolean checkGlassBall() {
        for (int i = 0; i < this.glassContainer.vector_Glass.size(); ++i) {
            Glass glass = (Glass)this.glassContainer.vector_Glass.elementAt(i);
            if (glass.getNoOfBalls() >= 1) continue;
            return true;
        }
        return false;
    }

    public void update() {
        if (this.glassContainer.checkGlass && this.glassContainer.vector_Glass.size() < 1 && !this.checkGlassBall()) {
            this.isGameOver = true;
            this.glassContainer.setScoreAndLevel();
            this.playSound.playSample("sound/end.mp3", false, 1, "audio/mpeg");
        }
        this.glassContainer.moveGlass();
        this.removeElement();
    }

    private boolean checkWithBall(Ball ball) {
        for (int i = 0; i < this.vector_Box.size() && !this.vector_Box.isEmpty(); ++i) {
            Box box = (Box)this.vector_Box.elementAt(i);
            if (!ball.getSprite().collidesWith(box.getImage(), box.getX(), box.getY(), false)) continue;
            return true;
        }
        return false;
    }

    public boolean checkCollisionWithBall(Ball ball) {
        if (ball.getSprite().collidesWith(TwistCanvas.sprite_Angle_Left, true) || ball.getSprite().collidesWith(TwistCanvas.sprite_Angle_Right, true) || ball.getSprite().collidesWith(TwistCanvas.sprite_CloseLine, true) || this.checkWithBall(ball)) {
            Box box = new Box(ball.getImage(), ball.getX(), ball.getY(), ball.getId(), "white");
            this.addElement(box);
            return true;
        }
        return false;
    }

    public boolean checkCollisionWithGlassBall(GlassBall glassBall) {
        if (glassBall.getY() > 128) {
            Box box = new Box(glassBall.getImage(), glassBall.getX(), glassBall.getY(), glassBall.getGlassID(), glassBall.getColor());
            this.addElement(box);
            return true;
        }
        return false;
    }

    private void resetBallPosition() {
        for (int i = 0; i < this.vector_Box.size(); ++i) {
            Box b1 = (Box)this.vector_Box.elementAt(i);
            b1.setX(this.BALL_X[i]);
            b1.setY(this.BALL_Y[i] - 25);
        }
    }

    public void addElement(Box box) {
        this.vector_Box.addElement(box);
        this.resetBallPosition();
        this.checkBox = true;
    }

    public void removeElement() {
        for (int i = 0; i < this.vector_Falling.size(); ++i) {
            Fall f = (Fall)this.vector_Falling.elementAt(i);
            f.setY(f.getY() + 5);
            if (this.glassContainer.checkCollisionWithBoxBall(f)) {
                this.playSound.playSample("sound/ballglass.mp3", false, 1, "audio/mpeg");
                this.vector_Falling.removeElement(f);
                continue;
            }
            if (f.getY() <= 320) continue;
            this.vector_Falling.removeElement(f);
        }
    }

    public void paint(Graphics g) {
        int i;
        for (i = 0; i < this.vector_Box.size(); ++i) {
            Box box = (Box)this.vector_Box.elementAt(i);
            box.paint(g);
        }
        this.glassContainer.paint(g);
        for (i = 0; i < this.vector_Falling.size(); ++i) {
            Fall f = (Fall)this.vector_Falling.elementAt(i);
            f.paint(g);
        }
    }

    public void pointerPressed(int x, int y) {
        this.randomValue = App.getRandom(1, 5);
        if (this.randomValue > this.vector_Box.size()) {
            this.randomValue = this.vector_Box.size();
        }
        for (int i = 0; i < this.randomValue && this.randomValue <= this.vector_Box.size(); ++i) {
            Box b = (Box)this.vector_Box.elementAt(i);
            Fall fall = new Fall(b.getImage(), this.fallx[i], b.getY(), b.getId(), b.getColor());
            this.vector_Falling.addElement(fall);
            this.vector_Box.removeElement(b);
        }
    }

    public void fileReachedEndOfMedia(int fileno) {
    }
}

