/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme;

import com.emobtech.googleanalyticsme.Request;
import com.emobtech.googleanalyticsme.TrackingURL;
import com.emobtech.googleanalyticsme.util.StringUtil;
import com.emobtech.googleanalyticsme.util.URLEncoder;

public final class PageView
extends Request {
    private String title;
    private String uri;

    public PageView(String uri) {
        this(null, uri);
    }

    public PageView(String title, String uri) {
        if (StringUtil.isEmpty(uri)) {
            throw new IllegalArgumentException("URI must not be empty.");
        }
        this.title = title;
        this.uri = !uri.startsWith("/") ? "/" + uri : uri;
    }

    TrackingURL trackingURL() {
        TrackingURL turl = super.trackingURL();
        turl.addParameter("utmp", URLEncoder.encode(this.uri));
        if (!StringUtil.isEmpty(this.title)) {
            turl.addParameter("utmdt", URLEncoder.encode(this.title));
        }
        return turl;
    }
}

