/*
 * Decompiled with CFR 0.152.
 */
package com.emobtech.googleanalyticsme.util;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;

public final class URLEncoder {
    public static String encode(String s) {
        return URLEncoder.encode(s, System.getProperty("microedition.encoding"));
    }

    public static String encode(String s, String enc) {
        ByteArrayInputStream bIn;
        if (s == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        try {
            bIn = new ByteArrayInputStream(s.getBytes(enc));
        }
        catch (UnsupportedEncodingException e) {
            bIn = new ByteArrayInputStream(s.getBytes());
        }
        int c = bIn.read();
        StringBuffer ret = new StringBuffer();
        while (c >= 0) {
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 46 || c == 45 || c == 42 || c == 95) {
                ret.append((char)c);
            } else if (c == 32) {
                ret.append("%20");
            } else if (c < 128) {
                ret.append(URLEncoder.getHexChar(c));
            } else if (c < 224) {
                ret.append(URLEncoder.getHexChar(c));
                ret.append(URLEncoder.getHexChar(bIn.read()));
            } else if (c < 240) {
                ret.append(URLEncoder.getHexChar(c));
                ret.append(URLEncoder.getHexChar(bIn.read()));
                ret.append(URLEncoder.getHexChar(bIn.read()));
            }
            c = bIn.read();
        }
        return ret.toString();
    }

    private static String getHexChar(int c) {
        return (c < 16 ? "%0" : "%") + Integer.toHexString(c).toUpperCase();
    }

    private URLEncoder() {
    }
}

