/*
 * Decompiled with CFR 0.152.
 */
package com.spice.twozerofoureight.gamescreen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RMSData {
    private static RecordStore rs = null;
    public static final String Sound_REC_STORE = "2048SOUND_STORE";
    public static final String Score_REC_STORE = "2048SCORE_STORE";
    public static final String TOTALCOINS = "2048COINS_STORE";
    public static final String GRIDDATA = "2048GRID_STORE12";
    public static final String GRIDScore = "2048GRID_SCORE100";
    private static long score = 0L;
    static int id;
    static int[] CellValues;
    static byte[] rec;

    static {
        CellValues = new int[16];
    }

    public static void openRecStore(String RecordStoreName) {
        try {
            rs = RecordStore.openRecordStore((String)RecordStoreName, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeRecStore() {
        try {
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addRecStore(long value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(value);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] rec = baos.toByteArray();
        try {
            int id = rs.addRecord(rec, 0, rec.length);
            System.out.println("id hai: " + id);
        }
        catch (RecordStoreException e) {
            System.out.println("addrecord catch");
        }
    }

    public static long getScore() {
        return RMSData.readRecRecords(Score_REC_STORE, 1);
    }

    public static void setScore(long score) {
        RMSData.updateRecRecords(Score_REC_STORE, 1, score);
    }

    public static long getGridScore() {
        return RMSData.readRecRecords(GRIDScore, 1);
    }

    public static void setGridScore(long score) {
        RMSData.updateRecRecords(GRIDScore, 1, score);
    }

    public static long getClassicGameTotalCoins() {
        return RMSData.readRecRecords(TOTALCOINS, 1);
    }

    public static void setClassicGameTotalCoins(long totalCoins) {
        RMSData.updateRecRecords(TOTALCOINS, 1, totalCoins);
    }

    public static int[] getGridData() {
        return RMSData.readGridData(GRIDDATA);
    }

    public static void setGridData(int[] cellValues) {
        RMSData.updateGridData(GRIDDATA, cellValues);
    }

    public static boolean isSoundEnabled() {
        return RMSData.readRecRecords(Sound_REC_STORE, 1) == 1L;
    }

    public static void setSoundEnabled(boolean isEnabled) {
        if (isEnabled) {
            RMSData.updateRecRecords(Sound_REC_STORE, 1, 1L);
        } else {
            RMSData.updateRecRecords(Sound_REC_STORE, 1, 0L);
        }
    }

    public static long readRecRecords(String RecordStoreName, int recordID) {
        RMSData.openRecStore(RecordStoreName);
        try {
            if (rs.getNumRecords() != 0) {
                if (rs.getRecord(recordID) != null) {
                    score = RMSData.byteArraytoInt(rs.getRecord(recordID));
                }
            } else {
                RMSData.addRecStore(0L);
                score = RMSData.byteArraytoInt(rs.getRecord(recordID));
                System.out.println(" added");
            }
        }
        catch (Exception e) {
            System.out.println(" readRecRecords catch");
        }
        RMSData.closeRecStore();
        return score;
    }

    public static int[] readGridData(String RecordStoreName) {
        RMSData.openRecStore(RecordStoreName);
        try {
            System.out.println("RMSData.readGridData()..............................:" + rs.getNumRecords());
            if (rs.getNumRecords() != 0) {
                int i = 1;
                while (i <= rs.getNumRecords()) {
                    byte[] record = rs.getRecord(i);
                    DataInputStream dos = new DataInputStream(new ByteArrayInputStream(record));
                    RMSData.CellValues[i - 1] = dos.readInt();
                    System.out.println("values" + CellValues[i - 1]);
                    dos.close();
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.out.println(" readRecRecords catch" + e);
        }
        RMSData.closeRecStore();
        return CellValues;
    }

    public static void updateRecRecords(String RecordStoreName, int recordId, long score) {
        RMSData.openRecStore(RecordStoreName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(score);
            dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] rec = baos.toByteArray();
        try {
            rs.setRecord(recordId, rec, 0, rec.length);
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
        RMSData.closeRecStore();
    }

    public static boolean doWeHaveAnySavedGameState() {
        try {
            RMSData.openRecStore(GRIDDATA);
            boolean bool = rs.getNumRecords() != 0;
            RMSData.closeRecStore();
            return bool;
        }
        catch (RecordStoreNotOpenException e) {
            RMSData.closeRecStore();
            return false;
        }
    }

    public static void updateGridData(String RecordStoreName, int[] cellValues) {
        RMSData.openRecStore(RecordStoreName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int i = 1;
        while (i <= cellValues.length) {
            try {
                dos.writeInt(cellValues[i - 1]);
                dos.flush();
                rec = baos.toByteArray();
                baos.reset();
                try {
                    rs.setRecord(i, rec, 0, rec.length);
                }
                catch (InvalidRecordIDException e) {
                    System.out.println("id get: " + rs.addRecord(rec, 0, rec.length));
                }
            }
            catch (Exception e) {
                System.out.println("upgrade" + e);
            }
            ++i;
        }
        RMSData.closeRecStore();
    }

    public static int byteArraytoInt(byte[] by) {
        int value = 0;
        int i = 0;
        while (i < by.length) {
            value = (value << 8) + (by[i] & 0xFF);
            ++i;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteRecRecords() {
        RecordEnumeration re = null;
        try {
            re = rs.enumerateRecords(null, null, true);
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        int rid = 0;
        try {
            while (true) {
                if (!re.hasNextElement()) {
                    return;
                }
                rid = re.nextRecordId();
                try {
                    rs.deleteRecord(rid);
                }
                catch (RecordStoreNotOpenException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidRecordIDException ex) {
                    ex.printStackTrace();
                }
                catch (RecordStoreException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (InvalidRecordIDException ex) {
            ex.printStackTrace();
        }
    }
}

