/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jellyworld.animationlistener;

import in.spice.jellyworld.animationlistener.Animation;
import in.spice.jellyworld.animationlistener.AnimationCompleteCallBack;
import in.spice.jellyworld.common.JewelConstants;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ColumnAnimation
extends Animation {
    private int colNum;
    private int currentFrame;
    private int totalRows;
    private int paintCount;
    private AnimationCompleteCallBack callBack;
    private boolean isAnimationComplete;

    public ColumnAnimation(int colNum, int totalRows, AnimationCompleteCallBack callback) {
        this.colNum = colNum;
        this.totalRows = totalRows;
        this.callBack = callback;
    }

    public void drawAnimation(Graphics graphics, int xoffset, int yoffset) {
        if (this.isAnimationComplete) {
            this.callBack.isAnimationComplete(this);
            return;
        }
        ++this.currentFrame;
        ++this.paintCount;
        if (this.currentFrame >= JewelConstants.flashColsImages.length) {
            this.currentFrame = 0;
        }
        Image bitmap = JewelConstants.flashColsImages[this.currentFrame];
        graphics.drawImage(bitmap, xoffset + this.colNum * JewelConstants.GEM_WIDTH + (JewelConstants.GEM_WIDTH - bitmap.getWidth()) / 2, yoffset, 0);
        if (this.isAnimationComplete()) {
            this.callBack.isAnimationComplete(this);
            this.isAnimationComplete = true;
        }
    }

    public boolean isAnimationComplete() {
        return this.paintCount > 4 * JewelConstants.flashColsImages.length;
    }

    public int getColumnNum() {
        return this.colNum;
    }
}

