/*
 * Decompiled with CFR 0.152.
 */
package in.spice.jewelworld.objects;

import in.spice.jewelworld.common.JewelConstants;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JewelObj
extends JewelConstants {
    private static final int INCREMENT_FACTOR = JewelConstants.GEM_HEIGHT / 3;
    private int initalX;
    private int initialY;
    private int finalY;
    private int finalX;
    private int color;
    private int powerType;
    private int animationType = JewelConstants.ANIMATION_NONE;
    private int currentGlobalAlpha = 255;
    private int freqToChangeFrame = 3;
    private int currentFrame;
    private int curFreq;
    private int powerFactor;
    private int currentPowerFreqFactor;

    public JewelObj(int initalX, int initalY, int finalX, int finalY, int color, int powerType) {
        this.setInitalX(initalX);
        this.setInitialY(initalY);
        this.setColor(color);
        this.setPowerType(powerType);
        this.setFinalY(finalY);
        this.setFinalX(finalX);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void setPowerType(int powerType) {
        this.powerType = powerType;
    }

    public int getPowerType() {
        return this.powerType;
    }

    public void setFinalXAndFinalY(int finalX, int finalY) {
        this.setFinalX(finalX);
        this.setFinalY(finalY);
    }

    public void setAnimationType(int animationType) {
        this.animationType = animationType;
        this.currentGlobalAlpha = 255;
    }

    public void incrmentOrDecrIfReqd() {
        if (this.getInitialXCoord() != this.getFinalXCoord()) {
            if (this.getInitialXCoord() < this.getFinalXCoord()) {
                this.setInitialXCoord(this.getInitialXCoord() + INCREMENT_FACTOR);
                if (this.getInitialXCoord() > this.getFinalXCoord()) {
                    this.setInitialXCoord(this.getFinalXCoord());
                }
            } else {
                this.setInitialXCoord(this.getInitialXCoord() - INCREMENT_FACTOR);
                if (this.getInitialXCoord() < this.getFinalXCoord()) {
                    this.setInitialXCoord(this.getFinalXCoord());
                }
            }
        }
        if (this.getInitialYCoord() != this.getFinalYCoord()) {
            if (this.getInitialYCoord() < this.getFinalYCoord()) {
                this.setInitialYCoord(this.getInitialYCoord() + INCREMENT_FACTOR);
                if (this.getInitialYCoord() > this.getFinalYCoord()) {
                    this.setInitialYCoord(this.getFinalYCoord());
                }
            } else {
                this.setInitialYCoord(this.getInitialYCoord() - INCREMENT_FACTOR);
                if (this.getInitialYCoord() < this.getFinalYCoord()) {
                    this.setInitialYCoord(this.getFinalYCoord());
                }
            }
        }
    }

    public void drawGems(Graphics graphics, int xoffset, int yoffset) {
        this.incrmentOrDecrIfReqd();
        Image img = null;
        switch (this.color) {
            case 7: {
                img = JewelConstants._imgBlue;
                break;
            }
            case 5: {
                img = JewelConstants._imgGreen;
                break;
            }
            case 4: {
                img = JewelConstants._imgOrange;
                break;
            }
            case 3: {
                img = JewelConstants._imgPurple;
                break;
            }
            case 2: {
                img = JewelConstants._imgRed;
                break;
            }
            case 1: {
                img = JewelConstants._imgWhite;
                break;
            }
            case 6: {
                img = JewelConstants._imgYellow;
            }
        }
        if (img != null) {
            graphics.drawImage(img, this.getInitialXCoord() + xoffset, this.getInitialYCoord() + yoffset, 0);
        }
        if (this.animationType == JewelConstants.ANIMATION_BOMB) {
            ++this.curFreq;
            if (this.freqToChangeFrame == this.curFreq) {
                ++this.currentFrame;
            }
            if (this.currentFrame >= JewelConstants.blastImages.length) {
                this.setAnimationType(JewelConstants.ANIMATION_NONE);
            }
        } else if (this.animationType == JewelConstants.ANIMATION_ROW_COLUMN) {
            this.currentGlobalAlpha -= 5;
            if (this.currentGlobalAlpha < 0) {
                this.currentGlobalAlpha = 0;
                this.setAnimationType(JewelConstants.ANIMATION_NONE);
                this.currentGlobalAlpha = 255;
            }
        } else if (this.animationType == JewelConstants.ANIMATION_RANDOM) {
            this.currentGlobalAlpha -= 5;
            if (this.currentGlobalAlpha < 0) {
                this.currentGlobalAlpha = 0;
                this.setAnimationType(JewelConstants.ANIMATION_NONE);
                this.currentGlobalAlpha = 255;
            }
        }
        img = null;
        switch (this.powerType) {
            case 0: {
                ++this.currentPowerFreqFactor;
                if (this.currentPowerFreqFactor == this.freqToChangeFrame) {
                    this.currentPowerFreqFactor = 0;
                    ++this.powerFactor;
                }
                if (this.powerFactor >= JewelConstants._imgBOMB.length) {
                    this.powerFactor = 0;
                }
                img = JewelConstants._imgBOMB[this.powerFactor];
                break;
            }
            case 1: {
                ++this.currentPowerFreqFactor;
                if (this.currentPowerFreqFactor == this.freqToChangeFrame) {
                    this.currentPowerFreqFactor = 0;
                    ++this.powerFactor;
                }
                if (this.powerFactor >= JewelConstants._imgROWS_COL.length) {
                    this.powerFactor = 0;
                }
                img = JewelConstants._imgROWS_COL[this.powerFactor];
                break;
            }
            case 2: {
                ++this.currentPowerFreqFactor;
                if (this.currentPowerFreqFactor == this.freqToChangeFrame) {
                    this.currentPowerFreqFactor = 0;
                    ++this.powerFactor;
                }
                if (this.powerFactor >= JewelConstants._imgRANDOM.length) {
                    this.powerFactor = 0;
                }
                img = JewelConstants._imgRANDOM[this.powerFactor];
            }
        }
        if (img != null) {
            graphics.drawImage(img, this.getInitialXCoord() + xoffset, this.getInitialYCoord() + yoffset, 0);
        }
    }

    public boolean equals(JewelObj obj) {
        if (this.color == 0) {
            return false;
        }
        return obj.getColor() == this.getColor();
    }

    public boolean equals(int color) {
        if (color == 0) {
            return false;
        }
        return this.getColor() == color;
    }

    public boolean isNull() {
        return this.getColor() == 0;
    }

    public void setInitalX(int initalX) {
        this.initalX = initalX * JewelConstants.GEM_WIDTH;
    }

    private int getInitialXCoord() {
        return this.initalX;
    }

    private int getInitialYCoord() {
        return this.initialY;
    }

    public int getFinalXCoord() {
        return this.finalX;
    }

    private void setInitialXCoord(int initalX) {
        this.initalX = initalX;
    }

    private void setInitialYCoord(int initialY) {
        this.initialY = initialY;
    }

    private int getFinalYCoord() {
        return this.finalY;
    }

    public int getInitalX() {
        return this.initalX / JewelConstants.GEM_WIDTH;
    }

    public void setInitialY(int initialY) {
        this.initialY = initialY * JewelConstants.GEM_HEIGHT;
    }

    public int getInitialY() {
        return this.initialY / JewelConstants.GEM_HEIGHT;
    }

    public void setFinalY(int finalY) {
        this.finalY = finalY * JewelConstants.GEM_HEIGHT;
    }

    public int getFinalY() {
        return this.finalY / JewelConstants.GEM_HEIGHT;
    }

    public void setFinalX(int finalX) {
        this.finalX = finalX * JewelConstants.GEM_WIDTH;
    }

    public int getFinalX() {
        return this.finalX / JewelConstants.GEM_WIDTH;
    }

    public void setAsNull() {
        this.setColor(0);
    }

    public boolean isFalling() {
        return this.finalX != this.initalX || this.initialY != this.finalY;
    }
}

