/*
 * Decompiled with CFR 0.152.
 */
package com.inodesoft.libs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class IGifDecoder {
    protected static final int STATUS_OK = 0;
    protected static final int STATUS_FORMAT_ERROR = 1;
    protected static final int STATUS_OPEN_ERROR = 2;
    protected DataInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int loopCount = 1;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected int pixelAspect;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected int lx;
    protected int ly;
    protected int lw;
    protected int lh;
    protected static Image imageData;
    protected static Image lastImage;
    protected byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected int[] dest;
    protected int[] prev;
    protected Vector frames;
    protected int frameCount;

    IGifDecoder() {
    }

    protected int getDelay(int paramInt) {
        this.delay = -1;
        if (paramInt >= 0 && paramInt < this.frameCount) {
            this.delay = ((GifFrame)this.frames.elementAt((int)paramInt)).delay;
        }
        return this.delay;
    }

    protected int getFrameCount() {
        return this.frameCount;
    }

    protected Image getImage() {
        return this.getFrame(0);
    }

    protected int getLoopCount() {
        return this.loopCount;
    }

    protected void setPixels() {
        int n;
        int m;
        int k;
        try {
            this.dest = new int[this.width * this.height];
            imageData.getRGB(this.dest, 0, this.width, 0, 0, this.width, this.height);
        }
        catch (Exception localException1) {
            // empty catch block
        }
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                int i = this.frameCount - 2;
                lastImage = i > 0 ? this.getFrame(i - 1) : null;
            }
            if (lastImage != null) {
                try {
                    this.prev = new int[this.width * this.height];
                    lastImage.getRGB(this.prev, 0, this.width, 0, 0, this.width, this.height);
                }
                catch (Exception localException2) {
                    // empty catch block
                }
                System.arraycopy(this.prev, 0, this.dest, 0, this.width * this.height);
                if (this.lastDispose == 2) {
                    int j = 0;
                    if (!this.transparency) {
                        j = this.lastBgColor;
                    }
                    for (k = 0; k < this.lh; ++k) {
                        m = (this.ly + k) * this.width + this.lx;
                        n = m + this.lw;
                        for (int i1 = m; i1 < n; ++i1) {
                            this.dest[i1] = j;
                        }
                    }
                }
            }
        }
        int j = 1;
        k = 8;
        m = 0;
        for (n = 0; n < this.ih; ++n) {
            int i1 = n;
            if (this.interlace) {
                if (m >= this.ih) {
                    switch (++j) {
                        case 2: {
                            m = 4;
                            break;
                        }
                        case 3: {
                            m = 2;
                            k = 4;
                            break;
                        }
                        case 4: {
                            m = 1;
                            k = 2;
                        }
                    }
                }
                i1 = m;
                m += k;
            }
            if ((i1 += this.iy) >= this.height) continue;
            int i2 = i1 * this.width;
            int i3 = i2 + this.ix;
            int i4 = i3 + this.iw;
            if (i2 + this.width < i4) {
                i4 = i2 + this.width;
            }
            int i5 = n * this.iw;
            while (i3 < i4) {
                int i6;
                int i7;
                if ((i7 = this.act[i6 = this.pixels[i5++] & 0xFF]) != 0) {
                    this.dest[i3] = i7;
                }
                ++i3;
            }
        }
        imageData = Image.createRGBImage((int[])this.dest, (int)this.width, (int)this.height, (boolean)false);
    }

    protected Image getFrame(int paramInt) {
        Image localImage = null;
        if (paramInt >= 0 && paramInt < this.frameCount && paramInt < this.frames.size()) {
            localImage = ((GifFrame)this.frames.elementAt((int)paramInt)).image;
        }
        return localImage;
    }

    protected int read(DataInputStream paramDataInputStream) {
        this.init();
        if (paramDataInputStream != null) {
            this.in = paramDataInputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            if (null != paramDataInputStream) {
                paramDataInputStream.close();
                paramDataInputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    protected int read(InputStream paramInputStream) {
        this.init();
        if (paramInputStream != null) {
            if (!(paramInputStream instanceof DataInputStream)) {
                this.in = new DataInputStream(paramInputStream);
            }
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            if (null != paramInputStream) {
                paramInputStream.close();
                this.in.close();
                paramInputStream = null;
                this.in = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read(String paramString) {
        this.status = 0;
        try {
            InputStream localInputStream = this.getClass().getResourceAsStream(paramString);
            this.status = this.read(localInputStream);
            if (null != this.in) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception localException1) {
                    // empty catch block
                }
            }
        }
        catch (Exception localException2) {
            this.status = 2;
            if (null != this.in) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            if (null != this.in) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (Exception exception) {}
            }
        }
        return this.status;
    }

    protected void decodeImageData() {
        int i = -1;
        int j = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < j) {
            this.pixels = new byte[j];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int i10 = this.read();
        int m = 1 << i10;
        int i2 = m + 1;
        int k = m + 2;
        int i4 = i;
        int i1 = i10 + 1;
        int n = (1 << i1) - 1;
        for (int i6 = 0; i6 < m; ++i6) {
            this.prefix[i6] = 0;
            this.suffix[i6] = (byte)i6;
        }
        int i13 = 0;
        int i14 = 0;
        int i12 = 0;
        int i11 = 0;
        int i7 = 0;
        int i5 = 0;
        int i9 = 0;
        int i8 = 0;
        while (i8 < j) {
            if (i12 == 0) {
                if (i5 < i1) {
                    if (i7 == 0) {
                        i7 = this.readBlock();
                        if (i7 <= 0) break;
                        i13 = 0;
                    }
                    i9 += (this.block[i13] & 0xFF) << i5;
                    i5 += 8;
                    ++i13;
                    --i7;
                    continue;
                }
                int i6 = i9 & n;
                i9 >>= i1;
                i5 -= i1;
                if (i6 > k || i6 == i2) break;
                if (i6 == m) {
                    i1 = i10 + 1;
                    n = (1 << i1) - 1;
                    k = m + 2;
                    i4 = i;
                    continue;
                }
                if (i4 == i) {
                    this.pixelStack[i12++] = this.suffix[i6];
                    i4 = i6;
                    i11 = i6;
                    continue;
                }
                int i3 = i6;
                if (i6 == k) {
                    this.pixelStack[i12++] = (byte)i11;
                    i6 = i4;
                }
                while (i6 > m) {
                    this.pixelStack[i12++] = this.suffix[i6];
                    i6 = this.prefix[i6];
                }
                i11 = this.suffix[i6] & 0xFF;
                if (k >= 4096) break;
                this.pixelStack[i12++] = (byte)i11;
                this.prefix[k] = (short)i4;
                this.suffix[k] = (byte)i11;
                if ((++k & n) == 0 && k < 4096) {
                    ++i1;
                    n += k;
                }
                i4 = i3;
                continue;
            }
            this.pixels[i14++] = this.pixelStack[--i12];
            ++i8;
        }
        for (i8 = i14; i8 < j; ++i8) {
            this.pixels[i8] = 0;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new Vector();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int i = 0;
        try {
            i = this.in.read();
        }
        catch (IOException localIOException) {
            this.status = 1;
        }
        return i;
    }

    protected int readBlock() {
        int i;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            try {
                int j = 0;
                for (i = 0; i < this.blockSize && (j = this.in.read(this.block, i, this.blockSize - i)) != -1; i += j) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (i < this.blockSize) {
                this.status = 1;
            }
        }
        return i;
    }

    protected int[] readColorTable(int paramInt) {
        int i = 3 * paramInt;
        int[] arrayOfInt = null;
        byte[] arrayOfByte = new byte[i];
        int j = 0;
        try {
            for (j = 0; j < i; ++j) {
                arrayOfByte[j] = this.in.readByte();
            }
        }
        catch (IOException localIOException) {
            // empty catch block
        }
        if (j < i) {
            this.status = 1;
        } else {
            arrayOfInt = new int[256];
            int k = 0;
            int m = 0;
            while (k < paramInt) {
                int n = arrayOfByte[m++] & 0xFF;
                int i1 = arrayOfByte[m++] & 0xFF;
                int i2 = arrayOfByte[m++] & 0xFF;
                arrayOfInt[k++] = 0xFF000000 | n << 16 | i1 << 8 | i2;
            }
        }
        return arrayOfInt;
    }

    protected void readContents() {
        boolean i = false;
        while (!i && !this.err()) {
            int j = this.read();
            block0 : switch (j) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    j = this.read();
                    switch (j) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            String str = "";
                            for (int k = 0; k < 11; ++k) {
                                str = str + (char)this.block[k];
                            }
                            if (str.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    i = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int i = this.read();
        this.dispose = (i & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (i & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        String str = "";
        for (int i = 0; i < 6; ++i) {
            str = str + (char)this.read();
        }
        if (!str.startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int i = this.read();
        this.lctFlag = (i & 0x80) != 0;
        this.interlace = (i & 0x40) != 0;
        this.lctSize = 2 << (i & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int j = 0;
        if (this.transparency) {
            j = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        imageData = Image.createImage((int)this.width, (int)this.height);
        this.setPixels();
        this.frames.addElement(new GifFrame(imageData, this.delay));
        ++this.frameCount;
        if (this.transparency) {
            this.act[this.transIndex] = j;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int i = this.read();
        this.gctFlag = (i & 0x80) != 0;
        this.gctSize = 2 << (i & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int i = this.block[1] & 0xFF;
            int j = this.block[2] & 0xFF;
            this.loopCount = j << 8 | i;
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lx = this.ix;
        this.ly = this.iy;
        this.lw = this.iw;
        this.lh = this.ih;
        lastImage = imageData;
        this.lastBgColor = this.bgColor;
        boolean i = false;
        boolean j = false;
        boolean k = false;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    void closeAllConnections() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class GifFrame {
        public Image image;
        public int delay;

        public GifFrame(Image paramImage, int paramInt) {
            this.image = paramImage;
            this.delay = paramInt;
        }
    }
}

