/*
 * Decompiled with CFR 0.152.
 */
package com.lq.ext;

import com.lq.ext.BLServer;
import com.lq.ext.IBluetooth;
import com.lq.ext.Processor;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.StreamConnection;

public class BLClient
implements Runnable,
DiscoveryListener {
    public Thread thread;
    public DiscoveryAgent discoveryAgent;
    public static final UUID ECHO_SERVER_UUID = new UUID("F0E0D0C0B0A000908070605040302010", false);
    public Vector vService = new Vector(1);
    public Vector vRemoteDevicesFound = new Vector(1);
    public Vector vTrans = new Vector(1);
    public Processor processor;
    public IBluetooth ib;
    public byte bStatus;
    public static final byte STATUS_NONE = -1;
    public static final byte STATUS_DEVICE_SEARCHING = 0;
    public static final byte STATUS_SERVICE_SEARCHING = 2;
    public static final byte STATUS_CONNECTING = 1;
    public Vector vServicesRecord = new Vector();
    public Vector vTime = new Vector();
    public Vector vName = new Vector();
    public int[] transIDs;
    public long lTime;
    public boolean isSearchDone;
    public static long lTimeSpend = 0L;
    public ServiceRecord serviceRecord;

    public BLClient(IBluetooth ib) {
        this.ib = ib;
    }

    public void lunch() {
        this.thread = null;
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        switch (this.bStatus) {
            case 2: {
                BLClient bLClient = this;
                synchronized (bLClient) {
                    try {
                        LocalDevice localdevice = LocalDevice.getLocalDevice();
                        this.discoveryAgent = localdevice.getDiscoveryAgent();
                        lTimeSpend = System.currentTimeMillis();
                        this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                        try {
                            this.wait();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (BluetoothStateException e) {
                        this.ib.error("Init:" + e.getMessage(), (byte)1);
                        e.printStackTrace();
                        return;
                    }
                    this.transIDs = new int[this.vRemoteDevicesFound.size()];
                    if (this.vRemoteDevicesFound.size() > 0) {
                        for (int i = 0; i < this.vRemoteDevicesFound.size(); ++i) {
                            RemoteDevice device = (RemoteDevice)this.vRemoteDevicesFound.elementAt(i);
                            try {
                                UUID[] uuids = new UUID[]{BLServer.UUID_SERVER};
                                this.transIDs[i] = this.discoveryAgent.searchServices(null, uuids, device, (DiscoveryListener)this);
                                this.wait();
                                continue;
                            }
                            catch (Exception e) {
                                this.ib.error("Discover:" + i + "|" + e.getMessage(), (byte)1);
                                e.printStackTrace();
                            }
                        }
                    }
                    break;
                }
            }
            case 0: {
                try {
                    LocalDevice localdevice = LocalDevice.getLocalDevice();
                    this.discoveryAgent = localdevice.getDiscoveryAgent();
                    lTimeSpend = System.currentTimeMillis();
                    this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                    break;
                }
                catch (BluetoothStateException e) {
                    this.ib.error("Init:" + e.getMessage(), (byte)1);
                    e.printStackTrace();
                    return;
                }
            }
            case 1: {
                StreamConnection connection = null;
                String url = "";
                String er = "0";
                try {
                    url = this.serviceRecord.getConnectionURL(0, false);
                    er = er + "0";
                    url = this.solution(this.serviceRecord);
                    er = er + "0";
                    if (url == null) {
                        er = er + "0";
                        url = this.solution(this.serviceRecord);
                        er = er + "0";
                    }
                    connection = (StreamConnection)UnAds.open(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.ib.error("Connect:" + er + ":" + url, (byte)5);
                    this.close();
                    return;
                }
                try {
                    this.processor = new Processor(connection, this.ib);
                    this.processor.start();
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.ib.error("trans:" + ex.getMessage(), (byte)5);
                    this.close();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.bStatus = (byte)-1;
        BLClient bLClient = this;
        synchronized (bLClient) {
            this.notify();
        }
        try {
            this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.discoveryAgent = null;
        if (this.processor != null) {
            this.processor.close();
        }
    }

    public boolean doServiceSearch() {
        boolean flag = false;
        this.transIDs = new int[this.vRemoteDevicesFound.size()];
        if (this.vRemoteDevicesFound.size() > 0) {
            for (int i = 0; i < this.vRemoteDevicesFound.size(); ++i) {
                RemoteDevice device = (RemoteDevice)this.vRemoteDevicesFound.elementAt(i);
                try {
                    UUID[] uuids = new UUID[]{ECHO_SERVER_UUID};
                    this.transIDs[i] = this.discoveryAgent.searchServices(null, uuids, device, (DiscoveryListener)this);
                }
                catch (Exception e) {
                    this.ib.error("Searching:" + e.getMessage(), (byte)1);
                    e.printStackTrace();
                    continue;
                }
                flag = true;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        this.bStatus = (byte)2;
        BLClient bLClient = this;
        synchronized (bLClient) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        this.vTrans.addElement("" + transID);
        if (this.vTrans.size() == this.transIDs.length) {
            this.isSearchDone = true;
            String[] str = null;
            if (this.vServicesRecord.size() > 0 && this.vName.size() > 0) {
                str = new String[this.vName.size()];
                for (int i = 0; i < this.vName.size(); ++i) {
                    str[i] = (String)this.vName.elementAt(i);
                }
            }
            this.bStatus = (byte)-1;
            this.ib.serviceSearchCompleted(str);
        } else {
            BLClient bLClient = this;
            synchronized (bLClient) {
                this.notify();
            }
        }
    }

    private void isStrInVector(String str) {
        String tempStr = null;
        for (int i = 0; i < this.vName.size(); ++i) {
            tempStr = String.valueOf(this.vName.elementAt(i));
            if (!tempStr.equals(str)) continue;
            this.vName.removeElementAt(i);
            this.vServicesRecord.removeElementAt(i);
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] serviceRecords) {
        for (int i = 0; i < serviceRecords.length; ++i) {
            this.lTime = (System.currentTimeMillis() - lTimeSpend) / 1000L;
            this.vTime.addElement(this.lTime + "");
            try {
                String s = serviceRecords[i].getHostDevice().getFriendlyName(false);
                s = s.trim();
                if (s.equals("")) {
                    this.vName.addElement("unknow name");
                    continue;
                }
                this.isStrInVector(s);
                this.vServicesRecord.addElement(serviceRecords[i]);
                this.vName.addElement(s);
                continue;
            }
            catch (Exception ex) {
                this.ib.error(ex.getMessage(), (byte)1);
                ex.printStackTrace();
            }
        }
        lTimeSpend = System.currentTimeMillis();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        if (this.vRemoteDevicesFound.indexOf(remoteDevice) == -1) {
            this.vRemoteDevicesFound.addElement(remoteDevice);
        }
    }

    public void startSearch() {
        this.bStatus = (byte)2;
        this.isSearchDone = false;
        this.vServicesRecord.removeAllElements();
        this.vService.removeAllElements();
        this.vRemoteDevicesFound.removeAllElements();
        this.vName.removeAllElements();
        this.vTrans.removeAllElements();
        this.vTime.removeAllElements();
        this.lunch();
    }

    public void makeConnect(int iServiceSelected) {
        this.bStatus = 1;
        this.serviceRecord = (ServiceRecord)this.vServicesRecord.elementAt(iServiceSelected);
        this.lunch();
    }

    public void send(String data) {
        this.processor.send(data);
    }

    public String solution(ServiceRecord service) {
        DataElement descriptorList = service.getAttributeValue(4);
        Enumeration enumeration = (Enumeration)descriptorList.getValue();
        enumeration.nextElement();
        DataElement RFCOMMdescriptor = (DataElement)enumeration.nextElement();
        enumeration = (Enumeration)RFCOMMdescriptor.getValue();
        enumeration.nextElement();
        DataElement RFCOMMchannelNum = (DataElement)enumeration.nextElement();
        try {
            long channel;
            if (11 == RFCOMMchannelNum.getDataType() || 12 == RFCOMMchannelNum.getDataType() || 20 == RFCOMMchannelNum.getDataType()) {
                long channelNum;
                byte[] allBytes = (byte[])RFCOMMchannelNum.getValue();
                channel = channelNum = (long)allBytes[0];
            } else {
                long channelID;
                channel = channelID = RFCOMMchannelNum.getLong();
            }
            StringBuffer nameBuffer = new StringBuffer(69);
            nameBuffer.append("btspp");
            nameBuffer.append("://");
            nameBuffer.append(service.getHostDevice().getBluetoothAddress());
            nameBuffer.append(":");
            nameBuffer.append(channel);
            nameBuffer.append(";authenticate=false");
            nameBuffer.append(";encrypt=false");
            nameBuffer.append(";master=false");
            String name = nameBuffer.toString();
            return name;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchServices(RemoteDevice remoteDevice) {
        try {
            BLClient bLClient = this;
            synchronized (bLClient) {
                UUID[] targetUUIDs = new UUID[]{new UUID(4353L)};
                this.discoveryAgent.searchServices(null, targetUUIDs, remoteDevice, (DiscoveryListener)this);
            }
        }
        catch (BluetoothStateException be) {
            this.ib.error(be.getMessage(), (byte)1);
            be.printStackTrace();
        }
    }
}

