/*
 * Decompiled with CFR 0.152.
 */
package com.lq.ext;

import com.lq.ext.IBluetooth;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.io.StreamConnection;

public class Processor
implements Runnable {
    public volatile boolean isReady;
    public StreamConnection conn;
    public DataInputStream in;
    public DataOutputStream out;
    public Vector sendMessages;
    public IBluetooth ib;

    public Processor(StreamConnection conn, IBluetooth ib) {
        this.ib = ib;
        this.conn = conn;
        this.sendMessages = new Vector();
    }

    public synchronized void start() {
        new Thread(this).start();
    }

    public void run() {
        try {
            this.in = new DataInputStream(this.conn.openInputStream());
            this.out = new DataOutputStream(this.conn.openOutputStream());
            Write write = new Write(this.ib);
            new Thread(write).start();
            this.ib.connectReady();
        }
        catch (Exception e) {
            this.ib.error(e.getMessage(), (byte)5);
            e.printStackTrace();
        }
        while (!this.isReady) {
            try {
                int length = this.in.read();
                byte[] temp = new byte[length];
                this.in.read(temp);
                this.ib.receive(temp);
            }
            catch (Exception e) {
                System.out.println("sdfasdfasdfasdfadfasdfasd");
                this.ib.error(e.getMessage(), (byte)5);
                e.printStackTrace();
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isReady) {
            Processor e2;
            Object object = this;
            synchronized (object) {
                this.isReady = true;
            }
            object = this.sendMessages;
            synchronized (object) {
                this.sendMessages.notify();
            }
            if (this.out != null) {
                try {
                    this.out.close();
                    object = this;
                    synchronized (object) {
                        this.out = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (this.in != null) {
                try {
                    this.in.close();
                    e2 = this;
                    synchronized (e2) {
                        this.in = null;
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
            if (this.conn != null) {
                try {
                    this.conn.close();
                    e2 = this;
                    synchronized (e2) {
                        this.conn = null;
                    }
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String data) {
        Vector vector = this.sendMessages;
        synchronized (vector) {
            this.sendMessages.addElement(data);
            this.sendMessages.notify();
        }
    }

    private class Write
    implements Runnable {
        public IBluetooth ib;

        public Write(IBluetooth ib) {
            this.ib = ib;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Processor.this.isReady) {
                Vector vector = Processor.this.sendMessages;
                synchronized (vector) {
                    if (Processor.this.sendMessages.size() == 0) {
                        try {
                            Processor.this.sendMessages.wait();
                        }
                        catch (InterruptedException ex) {
                            System.out.println("error 1");
                            ex.printStackTrace();
                        }
                    }
                    try {
                        if (Processor.this.sendMessages.size() > 0) {
                            String stmp = (String)Processor.this.sendMessages.elementAt(0);
                            byte[] temp = stmp.getBytes();
                            Processor.this.out.write(temp.length);
                            Processor.this.out.write(temp);
                            Processor.this.out.flush();
                            Processor.this.sendMessages.removeElementAt(0);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("error 2");
                        Processor.this.isReady = true;
                        this.ib.error(e.getMessage(), (byte)5);
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

