/*
 * Decompiled with CFR 0.152.
 */
package com.lq.net;

import com.lq.net.IBase;
import com.lq.net.IHighScore;
import com.lq.net.LQLemonLive;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Graphics;

public class LQHighScore {
    public static final byte PLAYER_ID = 0;
    public static final byte PLAYER_NAME = 1;
    public static final byte PLAYER_TIME = 2;
    public static final byte PLAYER_TIRES = 3;
    public static final byte PLAYER_TRANSMISION = 4;
    public static final byte PLAYER_TERRAIN = 5;
    public static final byte PLAYER_WEATHER = 6;
    public static final int MAX_CIRCUITS = 11;
    public static int[] max_highscores = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int MAX_RECORDS_HIGHSCORE = 10;
    public static String[][][] highScores = new String[11][MAX_RECORDS_HIGHSCORE][7];
    public static int[] totalPlayers = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int circuit = 0;
    public int iOk = -1;
    public int iSLeft = -1;
    public int iSRight = -1;
    public int iUp = -1;
    public int iDown = -1;
    public int iLeft = -1;
    public int iRight = -1;
    public IHighScore iConn;
    public IBase iBase;
    public int iScreenW;
    public int iScreenH;
    public byte bCharW;
    public byte bCharH;
    public byte bCharSpace;
    public byte bUIStatus;
    public static final byte STATUS_INPUT_NAME = 0;
    public static final byte STATUS_INPUT_TEL = 1;
    public static final byte STATUS_ERROR = 2;
    public static final byte STATUS_CONFIRM_UPLOAD = 3;
    public static final byte STATUS_HIGHSCORES = 4;
    public static final byte STATUS_SCORES_LIST = 6;
    public static final byte STATUS_UPLOAD = 5;
    public static final byte STATUS_WAITING = -1;
    public static final byte STATUS_UPLOAD_FINISHED = 71;
    public static final String[] CHAR_LETTER = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "."};
    public static final String[] CHAR_NUMS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    public byte[] bArrayNameIndex;
    public byte[] bArrayTelIndex;
    public String[][] sArrayScores = null;
    public String sScores;
    public HttpConnection con;
    public int iCircuitID;
    public int iMinTime;
    public static final String URL_SEND = "http://scores.lemonquest.com/valentinorossi/send.php";
    public static final String URL_GET = "http://scores.lemonquest.com/valentinorossi/get.php";
    public static final String URL_TOP10 = "http://scores.lemonquest.com/valentinorossi/top10.php";
    public static final String URL_TOP5 = "http://www.lemonquest.com/koh/processScore.php?idCompany=1";
    public static final byte MODEL_ONLY_HIGNSCORES = 0;
    public static final byte MODEL_HIGNSCORES_DATA = 1;
    public byte bModel;
    public byte bHighscoresIndex;
    public boolean isPainted;
    public byte bRunStatus;
    public static final byte STATUS_RUN_NONE = 0;
    public static final byte STATUS_RUN_LOAD_SCORES = 1;
    public static final byte STATUS_RUN_UPLOAD_SCORES = 2;
    public static final byte STATUS_RUN_UPLOAD_DATA = 3;
    public static final byte STATUS_RUN_LOAD_DATA = 4;
    public byte bTime = 0;
    public boolean isShow = false;
    public byte bCurrentColIndex;
    public byte[] bArrayTemp;
    public int myPosition = 0;
    public boolean isOnlyShow;
    public int iPlayerID;
    public byte[] bArrayData;
    public static final int NUM_REG_HIGHSCORE = 5;
    public int loadIndex;

    public LQHighScore(IHighScore iScore) {
        this.iConn = iScore;
        this.iBase = (IBase)((Object)iScore);
    }

    public void setModel(byte bModel) {
        this.bModel = bModel;
    }

    public void startUpload(String sScore) {
        this.initInput();
        this.sScores = sScore;
        this.bUIStatus = (byte)3;
        this.bArrayTemp = this.bArrayNameIndex;
    }

    private void initInput() {
        this.bArrayNameIndex = null;
        this.bArrayTelIndex = null;
        this.bArrayNameIndex = new byte[3];
        this.bArrayTelIndex = new byte[9];
    }

    public void downloadData(int iPlayerID) {
        this.iPlayerID = iPlayerID;
        this.isPainted = false;
        this.bRunStatus = (byte)4;
        this.bUIStatus = (byte)-1;
    }

    public void downloadScoresList(int iCircuitID, boolean isOnlyShow) {
        this.isOnlyShow = isOnlyShow;
        this.iCircuitID = iCircuitID;
        this.bUIStatus = (byte)-1;
        this.isPainted = false;
        this.bRunStatus = 1;
    }

    private void startUpload() {
        this.bUIStatus = (byte)-1;
        this.isPainted = false;
        this.bRunStatus = (byte)2;
    }

    public void draw(Graphics g) {
        this.iBase.drawBackground(g);
        switch (this.bUIStatus) {
            case 3: {
                this.iConn.drawUploadConfirm(g);
                this.iBase.drawLeftSoftKey(g);
                break;
            }
            case 2: {
                this.iConn.drawError(g);
                this.iBase.drawLeftSoftKey(g);
                break;
            }
            case -1: {
                this.iBase.drawWaiting(g);
                this.isPainted = true;
                break;
            }
            case 0: {
                this.drawInputField(g, this.bArrayNameIndex, CHAR_LETTER);
                this.iBase.drawLeftSoftKey(g);
                break;
            }
            case 1: {
                this.drawInputField(g, this.bArrayTelIndex, CHAR_NUMS);
                this.iBase.drawLeftSoftKey(g);
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                this.iConn.drawHighScores(g, this.sArrayScores, -1);
                this.iBase.drawLeftSoftKey(g);
                break;
            }
            case 6: {
                this.iConn.drawHighScores(g, this.sArrayScores, this.bHighscoresIndex);
                this.iBase.drawLeftSoftKey(g);
            }
        }
    }

    public void process() {
        if (!this.isPainted) {
            return;
        }
        switch (this.bRunStatus) {
            case 1: {
                if (this.bModel == 0) {
                    this.getHighscoresSample();
                    break;
                }
                this.getHighScores();
                break;
            }
            case 2: {
                if (this.bModel == 0) {
                    this.submitHighscores();
                    break;
                }
                this.submitGameData();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.downloadData();
                this.iConn.downloadDataCompleted(LQLemonLive.strDecoder(this.bArrayData));
                this.bRunStatus = 0;
            }
        }
    }

    private void drawInputField(Graphics g, byte[] bArrayIndex, String[] sChar) {
        int y = (this.iScreenH - this.bCharH) / 2;
        int x = (this.iScreenW - (this.bCharW * bArrayIndex.length + this.bCharSpace * (bArrayIndex.length - 1))) / 2;
        for (int i = 0; i < bArrayIndex.length; ++i) {
            int bh;
            g.setColor(0xFFFFFF);
            if (bArrayIndex[i] == -1) {
                bh = 2;
                g.fillRect(x, y + (this.bCharH - bh) / 2, (int)this.bCharW, bh);
            }
            if (i == this.bCurrentColIndex && this.isShow) {
                bh = 2;
                g.fillRect(x, y + this.bCharH, (int)this.bCharW, bh);
            }
            x += this.bCharSpace + this.bCharW;
        }
        byte by = this.bTime;
        this.bTime = (byte)(by + 1);
        if (by >= 5) {
            this.isShow = !this.isShow;
            this.bTime = 0;
        }
    }

    public String getName(byte[] bArrayIndex, String[] charList) {
        StringBuffer sb = new StringBuffer(bArrayIndex.length);
        for (int i = 0; i < bArrayIndex.length; ++i) {
            sb.append(charList[bArrayIndex[i]]);
        }
        return sb.toString();
    }

    public void keyPressed(int key) {
        int keyCode = Math.abs(key);
        switch (this.bUIStatus) {
            case 3: {
                if (keyCode == this.iSLeft) {
                    this.bUIStatus = 0;
                    break;
                }
                if (keyCode != this.iSRight) break;
                this.iConn.resumeGame();
                break;
            }
            case 2: {
                if (keyCode == this.iSLeft) {
                    this.bUIStatus = 0;
                    break;
                }
                if (keyCode != this.iSRight) break;
                this.iConn.resumeGame();
                break;
            }
            case 0: 
            case 1: {
                if (keyCode == this.iOk || key == 53 || keyCode == this.iSLeft) {
                    if (this.bUIStatus == 0) {
                        this.bUIStatus = 1;
                        this.bCurrentColIndex = 0;
                        this.bArrayTemp = this.bArrayTelIndex;
                        break;
                    }
                    this.startUpload();
                    break;
                }
                if (keyCode == this.iSRight) {
                    this.bCurrentColIndex = 0;
                    if (this.bUIStatus == 1) {
                        this.bUIStatus = 0;
                        this.bCurrentColIndex = 0;
                        this.bArrayTemp = this.bArrayNameIndex;
                        break;
                    }
                    this.iConn.resumeGame();
                    break;
                }
                if (keyCode == this.iUp || key == 50) {
                    byte by = this.bCurrentColIndex;
                    this.bArrayTemp[by] = (byte)(this.bArrayTemp[by] + 1);
                    if (this.bArrayTemp[this.bCurrentColIndex] < (this.bUIStatus == 1 ? CHAR_NUMS.length : CHAR_LETTER.length)) break;
                    this.bArrayTemp[this.bCurrentColIndex] = 0;
                    break;
                }
                if (keyCode == this.iDown || key == 56) {
                    byte by = this.bCurrentColIndex;
                    this.bArrayTemp[by] = (byte)(this.bArrayTemp[by] - 1);
                    if (this.bArrayTemp[this.bCurrentColIndex] >= 0) break;
                    this.bArrayTemp[this.bCurrentColIndex] = (byte)((this.bUIStatus == 1 ? CHAR_NUMS.length : CHAR_LETTER.length) - 1);
                    break;
                }
                if (keyCode == this.iLeft || key == 52) {
                    this.bCurrentColIndex = (byte)(this.bCurrentColIndex - 1);
                    if (this.bCurrentColIndex >= 0) break;
                    this.bCurrentColIndex = (byte)(this.bArrayTemp.length - 1);
                    break;
                }
                if (keyCode != this.iRight && key != 54) break;
                this.bCurrentColIndex = (byte)(this.bCurrentColIndex + 1);
                if (this.bCurrentColIndex < this.bArrayTemp.length) break;
                this.bCurrentColIndex = 0;
                break;
            }
            case 4: {
                if (keyCode != this.iSLeft && keyCode != this.iSRight) break;
                this.iConn.resumeGame();
                break;
            }
            case 6: {
                if (keyCode == this.iSRight) {
                    this.iConn.resumeGame();
                    break;
                }
                if (keyCode == this.iSLeft) {
                    this.downloadData(Integer.parseInt(this.sArrayScores[this.bHighscoresIndex][0]));
                    break;
                }
                if (keyCode == this.iUp || key == 50) {
                    this.bHighscoresIndex = (byte)(this.bHighscoresIndex - 1);
                    if (this.bHighscoresIndex >= 0) break;
                    this.bHighscoresIndex = (byte)(this.sArrayScores.length - 1);
                    break;
                }
                if (keyCode != this.iDown && key != 56) break;
                this.bHighscoresIndex = (byte)(this.bHighscoresIndex + 1);
                if (this.bHighscoresIndex < this.sArrayScores.length) break;
                this.bHighscoresIndex = 0;
            }
        }
    }

    public void setScreenSize(int iScreenW, int iScreenH) {
        this.iScreenW = iScreenW;
        this.iScreenH = iScreenH;
    }

    public void setCharAttribute(int bCharW, int bCharH, int bCharSpace) {
        this.bCharW = (byte)bCharW;
        this.bCharH = (byte)bCharH;
        this.bCharSpace = (byte)bCharSpace;
    }

    public void setKeyCode(int iOk, int iSLeft, int iSRight, int iUp, int iDown, int iLeft, int iRight) {
        this.iOk = iOk;
        this.iSLeft = iSLeft;
        this.iSRight = iSRight;
        this.iRight = iRight;
        this.iUp = iUp;
        this.iDown = iDown;
        this.iLeft = iLeft;
        this.iRight = iRight;
    }

    public void processDone(byte bUiStatus) {
        this.bRunStatus = 0;
        this.bUIStatus = bUiStatus;
    }

    public String getInputName() {
        return this.getName(this.bArrayNameIndex, CHAR_LETTER);
    }

    public String getInputTel() {
        return this.getName(this.bArrayTelIndex, CHAR_NUMS);
    }

    public void submitHighscores() {
        String req = null;
        DataInputStream in = null;
        String name = this.getInputName();
        String totalTime = "100";
        String tel = this.getInputTel();
        String family = "s40dp1";
        req = "&p1=" + name + "&p2=" + String.valueOf(this.sScores) + "&p3=" + String.valueOf(totalTime) + "&s=" + family + "&tl=" + tel;
        String cadena = URL_TOP5 + req;
        if (!cadena.startsWith("http:")) {
            cadena = "http:http://www.lemonquest.com/koh/processScore.php?idCompany=1" + req;
        }
        System.out.println("cadena--->" + cadena);
        try {
            String pushret;
            this.con = null;
            this.con = (HttpConnection)UnAds.open(cadena);
            this.con.setRequestProperty("User-Agent", "LQGame83625ghedfsdh7388jfvle7jdhbc");
            this.con.setRequestMethod("GET");
            in = this.con.openDataInputStream();
            int respuesta = this.con.getResponseCode();
            System.out.println("respuesta--->" + respuesta);
            if (respuesta == 200) {
                int contentLength = (int)this.con.getLength();
                if (contentLength == -1) {
                    contentLength = 255;
                }
                StringBuffer res = new StringBuffer(contentLength);
                for (int i = 0; i < contentLength; ++i) {
                    res.append((char)((InputStream)in).read());
                }
                pushret = res.toString();
                if (pushret.compareTo("\n0\n") == 0) {
                    this.processDone((byte)2);
                    return;
                }
            } else {
                this.processDone((byte)2);
                return;
            }
            ((InputStream)in).close();
            this.closeConnection();
            this.myPosition = Integer.parseInt(this.parseParam(pushret).trim()) + 1;
            System.out.println("myPosition--->" + this.myPosition);
            this.getHighscoresSample();
        }
        catch (Exception e) {
            this.processDone((byte)2);
        }
    }

    public void getHighscoresSample() {
        DataInputStream in = null;
        String req = "&t=1";
        String cadena = URL_TOP5 + req;
        if (!cadena.startsWith("http:")) {
            cadena = "http:http://www.lemonquest.com/koh/processScore.php?idCompany=1" + req;
        }
        try {
            this.con = (HttpConnection)UnAds.open(cadena);
            this.con.setRequestMethod("GET");
            this.con.setRequestProperty("User-Agent", "LQGame83625ghedfsdh7388jfvle7jdhbc");
            in = this.con.openDataInputStream();
            if (this.con.getResponseCode() == 200) {
                int contentLength = (int)this.con.getLength();
                if (contentLength == -1) {
                    contentLength = 255;
                }
                StringBuffer res = new StringBuffer(contentLength);
                for (int i = 0; i < contentLength; ++i) {
                    res.append((char)((InputStream)in).read());
                }
                String ret = res.toString();
                if (ret.compareTo("\n0\n") == 0) {
                    this.processDone((byte)2);
                    return;
                }
                ret = ret.substring(1);
                System.out.println(ret);
                this.loadHighscoresSample(ret);
                ((InputStream)in).close();
                this.closeConnection();
                this.processDone((byte)4);
            } else {
                this.processDone((byte)2);
                this.closeConnection();
            }
        }
        catch (Exception e) {
            this.processDone((byte)2);
            this.closeConnection();
            e.printStackTrace();
        }
    }

    public void getHighScores() {
        DataInputStream in = null;
        String cadena_get = "?circuit=" + this.iCircuitID;
        try {
            HttpConnection con = null;
            con = (HttpConnection)UnAds.open(URL_TOP10 + cadena_get);
            con.setRequestProperty("User-Agent", "LQGame83625ghedfsdh7388jfvle7jdhbc");
            con.setRequestMethod("POST");
            in = con.openDataInputStream();
            if (con.getResponseCode() == 200) {
                int c;
                StringBuffer res = new StringBuffer();
                while ((c = ((InputStream)in).read()) != -1) {
                    res.append((char)c);
                }
                String ret = res.toString();
                System.out.println(ret);
                if (ret.compareTo("\n0\n") == 0) {
                    // empty if block
                }
                ((InputStream)in).close();
                con.close();
                this.loadTop10List(ret);
                this.processDone(this.isOnlyShow ? (byte)4 : 6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void submitData(byte[] bDataArray, int iCircuitId, int iMinTime) {
        this.initInput();
        this.bArrayData = null;
        this.bArrayData = bDataArray;
        this.iCircuitID = iCircuitId;
        this.iMinTime = iMinTime;
        this.bUIStatus = (byte)3;
        this.bArrayTemp = this.bArrayNameIndex;
    }

    public void submitGameData() {
        int size_package = 1024;
        String name = this.getInputName();
        String phone = this.getInputTel();
        String time = "" + this.iMinTime;
        String extend = "extends";
        String circuit = "" + this.iCircuitID;
        String url_get = "";
        DataInputStream in = null;
        DataOutputStream out = null;
        int responseCode = 0;
        url_get = "?name=" + name + "&circuit=" + circuit + "&time=" + time + "&extends=" + extend + "&phone=" + phone + "&type=frames";
        try {
            System.out.println(URL_SEND + url_get);
            this.con = (HttpConnection)UnAds.open(URL_SEND + url_get);
            this.con.setRequestMethod("POST");
            this.con.setRequestProperty("Content-Length", Integer.toString(size_package * 3));
            this.con.setRequestProperty("User-Agent", "LQGame84625ghedfsdh7388jfvle7jdhbc");
            out = new DataOutputStream(this.con.openDataOutputStream());
            out.write(LQLemonLive.strEncoder(this.bArrayData));
            out.flush();
            in = new DataInputStream(this.con.openInputStream());
            responseCode = this.con.getResponseCode();
            if (responseCode == 200) {
                StringBuffer res = new StringBuffer();
                int c = 0;
                while ((c = in.read()) != -1) {
                    res.append((char)c);
                }
                String ret = res.toString();
                System.out.println("ret:" + ret);
                this.downloadScoresList(this.iCircuitID, true);
            }
            out.close();
            this.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processDone((byte)2);
        }
    }

    public boolean downloadData() {
        this.bArrayData = null;
        DataInputStream in = null;
        String url_get = "?id=" + this.iPlayerID;
        try {
            this.con = null;
            this.con = (HttpConnection)UnAds.open(URL_GET + url_get);
            this.con.setRequestProperty("User-Agent", "LQGame83625ghedfsdh7388jfvle7jdhbc");
            this.con.setRequestMethod("POST");
            in = this.con.openDataInputStream();
            if (this.con.getResponseCode() == 200) {
                int contentLength = (int)this.con.getLength();
                if (contentLength > 0) {
                    byte[] bArrayData = new byte[contentLength];
                    for (int i = 0; i < contentLength; ++i) {
                        byte bTemp;
                        bArrayData[i] = bTemp = (byte)((InputStream)in).read();
                    }
                    this.bArrayData = bArrayData;
                }
                ((InputStream)in).close();
                this.closeConnection();
                return true;
            }
            this.closeConnection();
            this.processDone((byte)2);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processDone((byte)2);
            return false;
        }
    }

    public void loadTop10List(String dato) {
        this.sArrayScores = null;
        this.loadIndex = 0;
        int maxPlayerNums = Integer.parseInt(this.parseParam(dato));
        String[][] sArrayTop10 = new String[maxPlayerNums][];
        for (int i = 0; i < maxPlayerNums; ++i) {
            sArrayTop10[i] = new String[4];
            sArrayTop10[i][0] = this.parseParam(dato);
            sArrayTop10[i][1] = this.parseParam(dato);
            sArrayTop10[i][2] = this.parseParam(dato);
        }
        this.sArrayScores = sArrayTop10;
        int totalPlayers = Integer.parseInt(this.parseParam(dato));
    }

    public void loadHighscoresSample(String dato) {
        this.loadIndex = 0;
        this.sArrayScores = new String[5][4];
        for (int i = 0; i < 5; ++i) {
            this.sArrayScores[i][0] = this.parseParam(dato);
            this.sArrayScores[i][1] = this.parseParam(dato);
            this.sArrayScores[i][2] = this.parseParam(dato);
            this.sArrayScores[i][3] = this.parseParam(dato);
        }
    }

    private String parseParam(String s) {
        try {
            if (s == null) {
                return "0";
            }
            if (s.compareTo("fin") == 0) {
                return "0";
            }
            String sParser = "";
            while (s.charAt(this.loadIndex) != '#') {
                sParser = sParser + s.charAt(this.loadIndex);
                ++this.loadIndex;
            }
            ++this.loadIndex;
            return sParser;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "*";
        }
    }

    public void closeConnection() {
        try {
            this.con.close();
            this.con = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

