/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class LQFunctions {
    public static int[] crc_table;
    public static final int[] seno;
    public static final int CHARACTER_ENTER = 65533;

    public static long getCRC32(byte[] buf, int off, int len) {
        int c;
        if (crc_table == null) {
            crc_table = new int[256];
            for (int n = 0; n < 256; ++n) {
                c = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c & 1) != 0) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                LQFunctions.crc_table[n] = c;
            }
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public static long getCRC32(byte[] buf) {
        int c;
        int off = 0;
        int len = buf.length;
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public static long getCRC32(String text) {
        return LQFunctions.getCRC32(text.getBytes());
    }

    public static boolean changePNGPalette(byte[] data, short[][] colors) {
        int readPoint = 8;
        while (readPoint < data.length) {
            int length = (data[readPoint] << 24) + (data[readPoint + 1] << 16) + (data[readPoint + 2] << 8) + (data[readPoint + 3] & 0xFF);
            if (data[readPoint + 4] == 80 && data[readPoint + 5] == 76 && data[readPoint + 6] == 84 && data[readPoint + 7] == 69) {
                int paletteChunkOffset = readPoint + 8;
                for (int i = 0; i < colors.length; ++i) {
                    int position = paletteChunkOffset + colors[i][0] * 3;
                    data[position] = (byte)(colors[i][1] & 0xFF);
                    data[position + 1] = (byte)(colors[i][2] & 0xFF);
                    data[position + 2] = (byte)(colors[i][3] & 0xFF);
                }
                long crc = LQFunctions.getCRC32(data, readPoint + 4, length + 4);
                int crcPosition = readPoint + 8 + length;
                data[crcPosition] = (byte)((crc & 0xFFFFFFFFFF000000L) >> 24);
                data[crcPosition + 1] = (byte)((crc & 0xFF0000L) >> 16);
                data[crcPosition + 2] = (byte)((crc & 0xFFF00L) >> 8);
                data[crcPosition + 3] = (byte)(crc & 0xFFL);
                return true;
            }
            readPoint = readPoint + 8 + length + 4;
        }
        return false;
    }

    public static boolean changePNGPalette(byte[] data, int[] colors) {
        short[][] colorData = new short[colors.length][4];
        for (int j = 0; j < colors.length; ++j) {
            int color = colors[j];
            colorData[j][0] = (short)(color >> 24 & 0xFF);
            colorData[j][1] = (short)(color >> 16 & 0xFF);
            colorData[j][2] = (short)(color >> 8 & 0xFF);
            colorData[j][3] = (short)(color & 0xFF);
        }
        return LQFunctions.changePNGPalette(data, colorData);
    }

    public static byte[] getResourceAsByteArray(String file) {
        byte[] buffer = new byte[64];
        try {
            int length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(baos.getClass().getResourceAsStream(file));
            while ((length = dis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] data = baos.toByteArray();
            dis.close();
            baos.close();
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DataInputStream getResourceAsStream(String file) {
        try {
            DataInputStream dis = new DataInputStream(file.getClass().getResourceAsStream(file));
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int seno(int g) {
        if ((g = Math.abs(g)) >= 360) {
            g %= 360;
        }
        if (g <= 90) {
            return seno[g];
        }
        if (g > 90 && g <= 180) {
            return seno[90 - (g - 90)];
        }
        if (g > 180 && g <= 270) {
            return -seno[g - 180];
        }
        return -seno[360 - g];
    }

    public static int coseno(int g) {
        if ((g = Math.abs(g)) >= 360) {
            g %= 360;
        }
        if (g <= 90) {
            return LQFunctions.seno(90 - g);
        }
        if (g > 90 && g <= 180) {
            return -LQFunctions.seno(g - 90);
        }
        if (g > 180 && g <= 270) {
            return LQFunctions.seno(270 - (g - 180));
        }
        return -LQFunctions.seno(360 - (g - 270));
    }

    public static int tangente(int g) {
        return LQFunctions.seno(g) / LQFunctions.coseno(g);
    }

    public static final String[] loadLang(String file) {
        int i;
        byte[] data = LQFunctions.getResourceAsByteArray(file);
        int numLines = 1;
        for (i = 0; i < data.length; ++i) {
            if (data[i] != 10) continue;
            ++numLines;
        }
        String[] lang = new String[numLines];
        int indexStart = 0;
        for (i = 0; i < numLines; ++i) {
            int index = indexStart;
            do {
                if ((data[index] & 0xFF) != 65533) continue;
                data[index] = 10;
            } while (++index < data.length && data[index] != 10 && data[index] != 13);
            lang[i] = new String(data, indexStart, index - indexStart);
            indexStart += index - indexStart + 1;
            if (index >= data.length || data[index] != 13) continue;
            ++indexStart;
        }
        return lang;
    }

    public static final String[] loadLangUnicode(DataInputStream dis, int numLines) {
        String[] lang = new String[numLines];
        try {
            for (int i = 0; i < numLines; ++i) {
                String s = dis.readUTF();
                lang[i] = s = LQFunctions.replace(s, "\ufffd", "\n");
            }
            dis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lang;
    }

    public static final String[] loadLang(DataInputStream dis, int numLines) {
        String[] lang = new String[numLines];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < numLines; ++i) {
            baos.reset();
            try {
                int b = dis.readByte();
                do {
                    if ((b & 0xFF) == 65533) {
                        b = 10;
                    }
                    baos.write(b);
                } while ((b = (int)((byte)dis.readUnsignedByte())) != 10 && b != 13);
                lang[i] = new String(baos.toByteArray(), 0, baos.size());
                if (b != 13) continue;
                b = dis.readByte();
                continue;
            }
            catch (EOFException eofe) {
                lang[i] = new String(baos.toByteArray(), 0, baos.size());
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return lang;
    }

    public static void deleteRecordStore(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            db.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void store(String recordStoreName, ByteArrayOutputStream baos) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            byte[] b = baos.toByteArray();
            db.addRecord(b, 0, b.length);
            db.closeRecordStore();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataInputStream load(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(re.nextRecord());
            DataInputStream dis = new DataInputStream(bais);
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTimeText(long time) {
        StringBuffer sb = new StringBuffer();
        int min = (int)(time /= 1000L) / 60;
        if (min < 10) {
            sb.append("0");
        }
        sb.append(min);
        sb.append(':');
        int sec = (int)time - min * 60;
        if (sec < 10) {
            sb.append("0");
        }
        sb.append(sec);
        return sb.toString();
    }

    public static String replace(String text, String tagSearch, String tagReplace) {
        if (text.length() == 0) {
            return text;
        }
        int searchLength = tagSearch.length();
        if (searchLength == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int index = text.indexOf(tagSearch);
        while (index != -1) {
            if (index != 0) {
                result.append(text.substring(0, index - searchLength + tagSearch.length()) + tagReplace);
            } else {
                result.append(tagReplace);
            }
            text = text.substring(index + searchLength);
            index = text.indexOf(tagSearch);
        }
        result.append(text);
        return result.toString();
    }

    static {
        seno = new int[]{0, 175, 349, 523, 698, 872, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2250, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6157, 6293, 6428, 6561, 6691, 6820, 6947, 7071, 7193, 7314, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8192, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9511, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};
    }
}

