/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import com.lq.util.LQFont;
import com.lq.util.LQKey;
import javax.microedition.lcdui.Graphics;

public class LQPage {
    public String txt = null;
    public String titleTxt = "TITLE";
    public LQFont font = null;
    public int txtX = 0;
    public int txtY = 0;
    public int txtW = 240;
    public int txtH = 320;
    public int smallLineHeight = 15;
    public int txtScrollPos;
    public int maxScrollPos;
    public int maxNumsLine;
    public int maxNumsLinePage;
    public static final int MODE_LINE = 0;
    public static final int MODE_PAGE = 1;
    public static final int MODE_AUTO = 2;
    public int mode;
    public int barMaxHeight;
    public int barMinHeight;
    public int indexPage;
    public int maxPageNumber;
    public static final int CLEW_PAGENUMBER = 1;
    public static final int CLEW_BAR = 2;
    public int clew;

    public LQPage(LQFont font1, String title1, String txt1) {
        this.titleTxt = title1;
        this.txt = txt1;
        this.font = font1;
        this.smallLineHeight = this.font.getFontHeight() + this.font.getLineSpacing();
        this.setXYWH(0, 0, 160, 213);
        this.set_modePage();
    }

    public void set_modeLine() {
        this.mode = 0;
        this.clear_clew();
        this.set_clew(2);
        this.setXYWH(this.txtX, this.txtY, this.txtW, this.txtH);
    }

    public void set_modePage() {
        this.mode = 1;
        this.clear_clew();
        this.set_clew(1);
        this.set_clew(2);
        this.setXYWH(this.txtX, this.txtY, this.txtW, this.txtH);
    }

    private void set_clew(int Clew1) {
        if ((this.clew & Clew1) == 0) {
            this.clew |= Clew1;
        }
    }

    private void clear_clew() {
        this.clew = 0;
    }

    public void setXYWH(int x, int y, int w, int h) {
        this.txtX = x;
        this.txtY = y;
        this.txtW = w;
        this.txtH = h;
        Object[] lineData = this.font.getLineData(this.txt, this.txtW);
        this.maxNumsLine = lineData.length;
        this.maxNumsLinePage = this.txtH / this.smallLineHeight;
        this.maxScrollPos = this.maxNumsLine * this.smallLineHeight;
        boolean is1 = false;
        if (this.maxScrollPos % (this.maxNumsLinePage * this.smallLineHeight) == 0) {
            is1 = true;
        } else {
            this.maxScrollPos -= this.maxScrollPos % (this.maxNumsLinePage * this.smallLineHeight);
        }
        this.maxPageNumber = this.maxScrollPos / (this.maxNumsLinePage * this.smallLineHeight);
        if (!is1) {
            ++this.maxPageNumber;
        }
        if (this.maxPageNumber == 0) {
            this.maxPageNumber = 1;
        }
        if (is1) {
            this.maxScrollPos = (this.maxPageNumber - 1) * (this.maxNumsLinePage * this.smallLineHeight);
        }
        this.barMaxHeight = this.maxNumsLinePage * this.smallLineHeight;
        this.barMinHeight = this.maxScrollPos == 0 ? this.barMaxHeight : this.maxNumsLinePage * this.barMaxHeight / this.maxNumsLine;
        if (this.barMinHeight > this.barMaxHeight) {
            this.barMinHeight = this.barMaxHeight;
        }
        this.txtScrollPos = 0;
        this.indexPage = 1;
    }

    public void draw(Graphics g, int align) {
        this.drawTitle(g);
        this.drawPageNumber(g);
        this.drawBar(g);
        g.setClip(0, 0, 800, 800);
        g.setColor(0xFF0000);
        g.drawRect(this.txtX, this.txtY, this.txtW, this.txtH);
        System.out.println("txtScrollPos:" + this.txtScrollPos);
        this.font.setArea(true, this.txtX, this.txtY, this.txtW, this.txtH);
        this.font.drawString(g, this.txt, this.txtX, this.txtY + this.txtScrollPos, this.txtW, this.txtH - this.txtScrollPos, align);
        this.font.setArea(false, 0, 0, 0, 0);
        g.setClip(0, 0, 800, 800);
    }

    public void drawTitle(Graphics g) {
        this.font.drawString(g, this.titleTxt.toCharArray(), 120, 8, 17);
    }

    public void drawPageNumber(Graphics g) {
        if ((this.clew & 1) == 0) {
            return;
        }
        g.setClip(0, 0, 240, 320);
        String str_pageNum = this.indexPage + "/" + this.maxPageNumber;
        this.font.drawString(g, str_pageNum, (240 - this.font.getLineWidth(str_pageNum.toCharArray())) / 2, 320 - this.smallLineHeight - 8, 800, 800, 20);
    }

    public void drawBar(Graphics g) {
        if ((this.clew & 2) == 0) {
            return;
        }
        g.setClip(0, 0, 240, 320);
        int y_barMin = this.maxScrollPos == 0 ? this.txtY : this.txtY + (this.barMaxHeight - this.barMinHeight) * this.txtScrollPos / -this.maxScrollPos;
        int w_bar = 10;
        int x_bar = 240 - w_bar - 6;
        g.setColor(65535);
        g.fillRect(x_bar - 2, this.txtY - 2, w_bar + 4, this.barMaxHeight + 4);
        g.setColor(0xFF0000);
        g.fillRect(x_bar, y_barMin, w_bar, this.barMinHeight);
    }

    public void mov2End() {
        if (this.mode == 0) {
            this.txtScrollPos = -this.maxScrollPos;
        } else if (this.mode == 1 && this.indexPage < this.maxPageNumber) {
            this.txtScrollPos -= this.maxNumsLinePage * this.smallLineHeight * (this.maxPageNumber - this.indexPage);
            this.indexPage = this.maxPageNumber;
        }
    }

    public void updata() {
        if (this.mode == 0) {
            if (LQKey.isKeyPressed(1) || LQKey.isKeyHold(1)) {
                this.txtScrollPos += this.smallLineHeight;
                if (this.txtScrollPos > 0) {
                    this.txtScrollPos = 0;
                }
            }
            if (LQKey.isKeyPressed(2) || LQKey.isKeyHold(2)) {
                this.txtScrollPos -= this.smallLineHeight;
                if (this.txtScrollPos <= -this.maxScrollPos) {
                    this.txtScrollPos = -this.maxScrollPos;
                }
            }
        } else if (this.mode == 1) {
            if (LQKey.isKeyPressed(1) && this.indexPage > 1) {
                this.txtScrollPos += this.maxNumsLinePage * this.smallLineHeight;
                --this.indexPage;
            }
            if (LQKey.isKeyPressed(2) && this.indexPage < this.maxPageNumber) {
                this.txtScrollPos -= this.maxNumsLinePage * this.smallLineHeight;
                ++this.indexPage;
            }
        }
    }
}

