/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import com.lq.util.LQFont;
import javax.microedition.lcdui.Graphics;

public class LQTextBox {
    public static final long WAITING_TIME = 1000L;
    public boolean enable = false;
    public int width = 0;
    public int height = 0;
    public int borderSize = 2;
    public int colorBorderOff = 2261776;
    public int colorBackgroundOff = 996872;
    public int colorBorderOn = 16251248;
    public int colorBackgroundOn = 996872;
    public LQFont font = null;
    public StringBuffer text = null;
    public long lastKeyPressed = 0L;
    public int posLetter = 0;
    public int indexLast = 0;
    public char[][] letters = null;
    public char[] alphabet = null;
    public int maxCapacity = 0;
    public int charsWidth = 0;
    public int widthChar = 0;
    public int numCharsToPaint = 0;
    public String textToPaint = "";

    public LQTextBox(LQFont _font, int maxChars, int _charsWidth) {
        this.font = _font;
        this.text = new StringBuffer(maxChars);
        this.maxCapacity = maxChars;
        this.charsWidth = _charsWidth;
        this.widthChar = this.font.getLineWidth("W".toCharArray()) + this.font.getCharSpacing();
        int flag = 4;
        this.width = (this.charsWidth + flag) * this.widthChar + this.borderSize * 5;
        this.height = this.font.getFontHeight() + 4 * this.borderSize;
        this.setAlphabet(" 0+()[]", "1.,@!?", "abc2ABC", "def3DEF", "ghi4GHI", "jkl5JKL", "mno6MNO", "pqrs7PQRS", "tuv8TUV", "wxyz9WXYZ");
    }

    public void setAlphabet(String _key0, String _key1, String _key2, String _key3, String _key4, String _key5, String _key6, String _key7, String _key8, String _key9) {
        this.letters = new char[10][];
        this.letters[0] = _key0.toCharArray();
        this.letters[1] = _key1.toCharArray();
        this.letters[2] = _key2.toCharArray();
        this.letters[3] = _key3.toCharArray();
        this.letters[4] = _key4.toCharArray();
        this.letters[5] = _key5.toCharArray();
        this.letters[6] = _key6.toCharArray();
        this.letters[7] = _key7.toCharArray();
        this.letters[8] = _key8.toCharArray();
        this.letters[9] = _key9.toCharArray();
    }

    public void setSize(int _width, int _height, int _borderSize) {
        this.width = _width;
        this.height = _height;
        this.borderSize = _borderSize;
    }

    public void setColor(int _colorBackgroundOn, int _colorBorderOn, int _colorBackgroundOff, int _colorBorderOff) {
        this.colorBackgroundOn = _colorBackgroundOn;
        this.colorBorderOn = _colorBorderOn;
        this.colorBackgroundOff = _colorBackgroundOff;
        this.colorBorderOff = _colorBorderOff;
    }

    public String getText() {
        return this.text.toString();
    }

    public void setText(String t) {
        this.text = new StringBuffer(t);
    }

    public void keyPressed(char key, int keyCode) {
        int index = key - 48;
        if (key >= '0' && key <= '9' && this.text.length() < this.maxCapacity) {
            if (System.currentTimeMillis() < this.lastKeyPressed + 1000L && index == this.indexLast) {
                this.posLetter = (this.posLetter + 1) % this.letters[index].length;
                this.text.setCharAt(this.text.length() - 1, this.letters[index][this.posLetter]);
            } else {
                this.indexLast = index;
                this.posLetter = 0;
                this.text.append(this.letters[index][this.posLetter]);
            }
            this.lastKeyPressed = System.currentTimeMillis();
        } else if (key >= '0' && key <= '9' && this.text.length() == this.maxCapacity && System.currentTimeMillis() < this.lastKeyPressed + 1000L && index == this.indexLast) {
            this.posLetter = (this.posLetter + 1) % this.letters[index].length;
            this.text.setCharAt(this.text.length() - 1, this.letters[index][this.posLetter]);
            this.lastKeyPressed = System.currentTimeMillis();
        } else if (keyCode == -3 || keyCode == -8) {
            if (this.text.length() > 0) {
                this.text.deleteCharAt(this.text.length() - 1);
            }
        } else if (keyCode == -7) {
            this.lastKeyPressed = 0L;
        }
        int length = this.font.getLineWidth(this.text.toString().toCharArray());
        this.textToPaint = null;
        if (length >= this.width - this.widthChar * 2) {
            this.numCharsToPaint = this.charsWidth;
            while (this.font.getLineWidth(this.text.toString().substring(0, this.numCharsToPaint).toCharArray()) < this.width - this.widthChar * 2) {
                ++this.numCharsToPaint;
            }
            this.textToPaint = this.text.toString().substring(this.text.length() - this.numCharsToPaint, this.text.length());
        } else {
            this.numCharsToPaint = 0;
        }
    }

    public void paint(Graphics g, int x, int y) {
        g.setClip(x, y, this.width + 1, this.height + 1);
        if (this.enable) {
            g.setColor(this.colorBorderOn);
            g.fillRect(x, y, this.width, this.height);
            g.setColor(this.colorBackgroundOn);
            g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
            if (System.currentTimeMillis() / 500L % 2L == 0L) {
                g.setColor(this.colorBorderOn);
                if (this.numCharsToPaint > this.charsWidth) {
                    g.fillRect(x + this.font.getLineWidth(this.textToPaint.toCharArray()) + 3 * this.borderSize, y + 2 * this.borderSize, this.borderSize, this.height - 4 * this.borderSize);
                } else {
                    g.fillRect(x + this.font.getLineWidth(this.text.toString().toCharArray()) + 3 * this.borderSize, y + 2 * this.borderSize, this.borderSize, this.height - 4 * this.borderSize);
                }
            }
        } else {
            g.setColor(this.colorBorderOff);
            g.fillRect(x, y, this.width, this.height);
            g.setColor(this.colorBackgroundOff);
            g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
        }
        if (this.numCharsToPaint > this.charsWidth) {
            this.font.drawString(g, this.textToPaint.toCharArray(), x + 2 * this.borderSize, y + 2 * this.borderSize, 20);
        } else {
            this.font.drawString(g, this.text.toString().toCharArray(), x + 2 * this.borderSize, y + 2 * this.borderSize, 20);
        }
    }

    public void paintCentered(Graphics g, int x, int y, int _colorBorderOn) {
        if (this.enable) {
            this.colorBorderOn = _colorBorderOn;
        }
        this.paintCentered(g, x, y);
    }

    public void drawSelectRect(Graphics g, int x, int y, int colorBorderOn, int colorBackgroundOn) {
        g.setClip(x, y, this.width + 1, this.height + 1);
        g.setColor(colorBorderOn);
        g.fillRect(x, y, this.width, this.height);
        g.setColor(colorBackgroundOn);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
    }

    public void drawDisableRect(Graphics g, int x, int y, int colorBorderOff, int colorBackgroundOff) {
        g.setClip(x, y, this.width + 1, this.height + 1);
        g.setColor(colorBorderOff);
        g.fillRect(x, y, this.width, this.height);
        g.setColor(colorBackgroundOff);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
    }

    public void drawSelectRect(Graphics g, int x, int y) {
        g.setClip(x, y, this.width + 1, this.height + 1);
        g.setColor(this.colorBorderOn);
        g.fillRect(x, y, this.width, this.height);
        g.setColor(this.colorBackgroundOn);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
    }

    public void drawDisableRect(Graphics g, int x, int y) {
        g.setClip(x, y, this.width + 1, this.height + 1);
        g.setColor(this.colorBorderOff);
        g.fillRect(x, y, this.width, this.height);
        g.setColor(this.colorBackgroundOff);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
    }

    public void drawTxtOnRect(Graphics g, int x, int y, String text) {
        this.font.drawString(g, text.toString().toCharArray(), x + 2 * this.borderSize, y + 2 * this.borderSize, 20);
    }

    public void paintCentered(Graphics g, int w, int y) {
        this.paint(g, (w - this.width) / 2, y);
    }
}

