/*
 * Decompiled with CFR 0.152.
 */
package animation;

import animation.Animation;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GroupAnimation {
    static final int EXTEND_PER_UNIT = 6;
    static final int EXTEND_PER_FLIP = 2;
    static final int ANIMID = 0;
    static final int ACTID = 1;
    static final int BEGIN = 2;
    static final int LOOP = 3;
    static final int POSX = 4;
    static final int POSY = 5;
    Animation[] m_anims;
    int[][] m_unit;
    boolean[][] m_flip;

    public void realize() {
        this.m_anims = null;
        this.m_unit = null;
        this.m_flip = null;
    }

    public static String readString(DataInputStream fp) throws IOException {
        StringBuffer tmp = new StringBuffer(20);
        int len = fp.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                tmp.append(fp.readChar());
            }
        }
        return new String(tmp);
    }

    public GroupAnimation(String animFile) {
        try {
            DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream(animFile));
            this.read(is);
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void read(DataInputStream fo) throws Exception {
        int i;
        int filesize = fo.readUnsignedShort();
        int ver = fo.readUnsignedShort();
        int sz = fo.readInt();
        this.m_anims = new Animation[sz];
        for (i = 0; i < sz; ++i) {
            Image ima;
            String animpath = GroupAnimation.readString(fo);
            String imgpath = GroupAnimation.readString(fo);
            this.m_anims[i] = new Animation();
            DataInputStream is = new DataInputStream(animpath.getClass().getResourceAsStream(animpath));
            this.m_anims[i].loadAnimation(is);
            is.close();
            this.m_anims[i].s_images = ima = Image.createImage((String)imgpath);
            this.m_anims[i].simaWidth = ima.getWidth();
            this.m_anims[i].simaHeight = ima.getHeight();
        }
        sz = fo.readInt();
        this.m_unit = new int[sz][];
        this.m_flip = new boolean[sz][];
        for (i = 0; i < this.m_unit.length; ++i) {
            int j;
            sz = fo.readInt();
            this.m_unit[i] = new int[sz * 6];
            this.m_flip[i] = new boolean[sz * 2];
            for (j = 0; j < this.m_unit[i].length; ++j) {
                this.m_unit[i][j] = fo.readInt();
            }
            for (j = 0; j < this.m_flip[i].length; ++j) {
                this.m_flip[i][j] = fo.readBoolean();
            }
        }
    }

    public boolean draw(Graphics g, int group, int x, int y, int time) {
        boolean end = true;
        try {
            if (group < 0 || group >= this.m_unit.length) {
                System.err.println("no group");
                return true;
            }
            int unitlen = this.m_unit[group].length / 6;
            for (int i = 0; i < unitlen; ++i) {
                if (this.drawunit(g, group, i, x, y, time)) continue;
                end = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return end;
    }

    public boolean drawunit(Graphics g, int group, int index, int x, int y, int time) throws Exception {
        int i;
        int[] curunit = this.m_unit[group];
        int iunit = index * 6;
        if (time < curunit[iunit + 2]) {
            return false;
        }
        if (curunit[iunit + 0] < 0 || curunit[iunit + 1] < 0 || curunit[iunit + 0] >= this.m_anims.length) {
            System.err.println("no anim");
            return true;
        }
        Animation ani = this.m_anims[curunit[iunit + 0]];
        if (curunit[iunit + 1] >= ani.m_nFrames.length) {
            System.err.println("no act");
            return true;
        }
        time -= curunit[iunit + 2];
        int duration = 0;
        short[] act = ani.m_actions[curunit[iunit + 1]];
        int actsz = act.length / 2;
        for (i = 0; i < actsz; ++i) {
            duration += ani.durframe(curunit[iunit + 1], i);
        }
        if (duration < 1) {
            System.err.println("no dur");
            return true;
        }
        int alldur = curunit[iunit + 3] * duration;
        if (time >= alldur) {
            return true;
        }
        if (time > duration) {
            time %= duration;
        } else if (time == duration) {
            time = 0;
        }
        int iflip = index << 1;
        duration = 0;
        for (i = 0; i < actsz; ++i) {
            if (time >= (duration += ani.durframe(curunit[iunit + 1], i))) continue;
            ani.draw(g, x + curunit[iunit + 4], y + curunit[iunit + 5], this.m_flip[group][iflip], this.m_flip[group][iflip + 1], ani.getFrame(curunit[iunit + 1], i));
            break;
        }
        return time + 1 >= alldur;
    }
}

