/*
 * Decompiled with CFR 0.152.
 */
package com.lq.util;

import java.util.Hashtable;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public final class LQRms {
    public boolean isOpen = false;
    public String name;
    public RecordStore rs;
    public static Hashtable hashtable;
    public static String cookieName;

    public LQRms() {
        hashtable = new Hashtable();
    }

    public void open(String uniqueName) throws RecordStoreFullException, RecordStoreNotFoundException, RecordStoreException {
        if (this.isOpen) {
            return;
        }
        this.name = uniqueName;
        this.rs = RecordStore.openRecordStore((String)uniqueName, (boolean)true);
        this.isOpen = true;
        cookieName = uniqueName;
        RecordEnumeration re = this.rs.enumerateRecords(null, null, true);
        while (re.hasNextElement()) {
            int id = re.nextRecordId();
            String data = new String(this.rs.getRecord(id));
            this.makeItems(data);
        }
    }

    public void openNew(String uniqueName) throws Exception {
        this.rs = RecordStore.openRecordStore((String)uniqueName, (boolean)true);
    }

    public void addNew(byte[] data) {
    }

    private String makeItems(String item) throws RecordStoreNotFoundException {
        int pos1 = item.indexOf(":");
        int pos2 = item.indexOf(":", pos1 + 1);
        if (pos1 > 0 && pos2 > pos1) {
            String key = item.substring(pos1 + 1, pos2);
            String value = item.substring(pos2 + 1, item.length());
            hashtable.put(key, value);
            return key;
        }
        throw new RecordStoreNotFoundException("Error record item:" + item.getClass());
    }

    public void close() {
        if (this.isOpen) {
            try {
                this.rs.closeRecordStore();
                this.rs = null;
                this.isOpen = false;
                if (hashtable != null) {
                    hashtable.clear();
                }
                hashtable = null;
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addRecord(String key, String value) throws RecordStoreNotOpenException, RecordStoreFullException, RecordStoreException {
        String item = this.name + ":" + key + ":" + value;
        this.rs.addRecord(item.getBytes(), 0, item.getBytes().length);
        hashtable.put(key, value);
    }

    public void setRecord(String key, String value) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreFullException, RecordStoreException {
        if (hashtable.containsKey(key)) {
            hashtable.put(key, value);
            RecordEnumeration re = this.rs.enumerateRecords(null, null, true);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                String data = new String(this.rs.getRecord(id));
                if (!key.equals(this.getItemKey(data))) continue;
                String setdata = this.name + ":" + key + ":" + value;
                byte[] buffer = setdata.getBytes();
                this.rs.setRecord(id, buffer, 0, buffer.length);
                break;
            }
        } else {
            this.addRecord(key, value);
        }
    }

    public String getRecord(String key) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        try {
            return (String)hashtable.get(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public int getRecordAsInt(String key, int defaultValue) {
        int i = 0;
        try {
            String temp = (String)hashtable.get(key);
            i = temp == null ? defaultValue : Integer.parseInt((String)hashtable.get(key));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            i = defaultValue;
        }
        return i;
    }

    private String getItemKey(String item) throws RecordStoreNotFoundException {
        int pos1 = item.indexOf(":");
        int pos2 = item.indexOf(":", pos1 + 1);
        if (pos1 > 0 && pos2 > pos1) {
            String key = item.substring(pos1 + 1, pos2);
            return key;
        }
        throw new RecordStoreNotFoundException("Error record item:" + item.getClass());
    }

    public static void destroy(String uniqueName) {
        try {
            RecordStore.deleteRecordStore((String)uniqueName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean matches(byte[] arg0) {
        String item = new String(arg0);
        return item.startsWith(cookieName);
    }

    public void setRecordByte(String key, byte[] data) throws RecordStoreNotOpenException, RecordStoreFullException, RecordStoreException {
        String temp = new String(data);
        this.setRecord(key, temp);
    }

    public byte[] getRecordByte(String key) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        byte[] data = null;
        String temp = this.getRecord(key);
        if (temp != null) {
            data = temp.getBytes();
        }
        return data;
    }

    public static void saveRms(String db, String[] key, String[] value) {
        try {
            LQRms r = new LQRms();
            r.open(db);
            for (int i = 0; i < key.length; ++i) {
                r.setRecord(key[i], value[i]);
            }
            r.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String[] getRms(String db, String[] key) {
        String[] temp = new String[key.length];
        try {
            LQRms r = new LQRms();
            r.open(db);
            for (int i = 0; i < key.length; ++i) {
                temp[i] = r.getRecord(key[i]);
            }
            r.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return temp;
    }

    public static void saveRmsByte(String db, String key, byte[] data) {
        try {
            LQRms r = new LQRms();
            r.open(db);
            r.setRecordByte(key, data);
            r.close();
        }
        catch (RecordStoreNotFoundException ex) {
        }
        catch (RecordStoreFullException ex) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static byte[] getRmsByte(String db, String key) {
        byte[] b = null;
        try {
            LQRms r = new LQRms();
            r.open(db);
            b = r.getRecordByte(key);
            r.close();
        }
        catch (RecordStoreNotFoundException ex) {
        }
        catch (RecordStoreFullException ex) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return b;
    }
}

