/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

import com.inode.utils.SSFunctions;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SSFont {
    public int fontHeight;
    public int charSpacing;
    public int lineSpacing;
    public int spaceSize;
    public int numSymbols;
    public int numLetters;
    public int currentPalette;
    public short[][] symbols;
    public char[] letterChars;
    public short[][] letterSymbols;
    public Image[] image;

    public SSFont(DataInputStream dis, int[][] palettes) {
        try {
            int j;
            byte version = dis.readByte();
            this.numSymbols = dis.readUnsignedByte();
            this.symbols = new short[this.numSymbols][6];
            for (j = 0; j < this.numSymbols; ++j) {
                this.symbols[j][0] = (short)dis.readUnsignedByte();
                this.symbols[j][1] = (short)dis.readUnsignedByte();
                this.symbols[j][2] = (short)dis.readUnsignedByte();
                this.symbols[j][3] = (short)dis.readUnsignedByte();
                this.symbols[j][4] = dis.readByte();
                this.symbols[j][5] = dis.readByte();
            }
            this.fontHeight = dis.readUnsignedByte();
            this.charSpacing = dis.readByte();
            this.lineSpacing = dis.readUnsignedByte();
            this.spaceSize = dis.readUnsignedByte();
            this.numLetters = dis.readUnsignedByte();
            this.letterChars = new char[this.numLetters];
            this.letterSymbols = new short[this.numLetters][];
            for (j = 0; j < this.numLetters; ++j) {
                this.letterChars[j] = dis.readChar();
                int numSymbolsLetter = dis.readUnsignedByte();
                this.letterSymbols[j] = new short[numSymbolsLetter];
                for (int k = 0; k < numSymbolsLetter; ++k) {
                    this.letterSymbols[j][k] = (short)dis.readUnsignedByte();
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[128];
            int readed = dis.read(buffer);
            while (readed != -1) {
                baos.write(buffer, 0, readed);
                readed = dis.read(buffer);
            }
            buffer = baos.toByteArray();
            this.image = new Image[palettes == null ? 1 : palettes.length + 1];
            this.image[0] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
            int i = 1;
            while (0 < palettes.length) {
                SSFunctions.changePNGPalette(buffer, palettes[i - 1]);
                this.image[i] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                ++i;
            }
            this.currentPalette = 0;
            baos.close();
            dis.close();
            baos = null;
            dis = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentPalette(int numPalette) {
        if (numPalette < this.image.length) {
            this.currentPalette = numPalette;
        }
    }

    public short[][] getLineData(char[] text, int width) {
        Vector<short[]> lines = new Vector<short[]>();
        int lineStart = 0;
        int lineEnd = 0;
        int lineWidth = 0;
        boolean noData = true;
        int nextWordStart = 0;
        int processWidth = 0;
        int lastCharType = 48;
        for (int index = 0; index < text.length; ++index) {
            char actualCharacter = text[index];
            switch (actualCharacter) {
                case ' ': {
                    if (lastCharType == 67) {
                        lineEnd = index - 1;
                        lineWidth = processWidth - this.getCharSpacing();
                    }
                    processWidth += this.getSpaceSize() + this.getCharSpacing();
                    lastCharType = 83;
                    break;
                }
                case '\n': {
                    lineEnd = index - 1;
                    lineWidth = processWidth - this.getCharSpacing();
                    lastCharType = 78;
                    break;
                }
                default: {
                    if (noData) {
                        lineStart = index;
                        noData = false;
                    }
                    if (lastCharType == 83) {
                        nextWordStart = index;
                    } else if (lastCharType == 78) {
                        nextWordStart = index;
                    }
                    processWidth += this.getCharacterWidth(actualCharacter) + this.getCharSpacing();
                    lastCharType = 67;
                }
            }
            if (index == text.length - 1) {
                lineEnd = index;
                lineWidth = processWidth - this.getCharSpacing();
                lastCharType = 78;
            }
            if (processWidth < width && lastCharType != 78) continue;
            short[] lineData = new short[3];
            if (!noData) {
                lineData[0] = (short)lineStart;
                lineData[1] = (short)lineEnd;
                lineData[2] = (short)lineWidth;
            }
            lines.addElement(lineData);
            if (nextWordStart <= lineEnd) {
                noData = true;
            } else {
                lineStart = nextWordStart;
                processWidth -= (nextWordStart - lineEnd) * this.getSpaceSize() - 2;
            }
            processWidth -= lineWidth + this.getCharSpacing();
        }
        short[][] result = new short[lines.size()][];
        Enumeration e = lines.elements();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short[])e.nextElement();
        }
        return result;
    }

    private int getCharacterWidth(char character) {
        short[] charSymbol = this.getSymbolByCharacter(character, 0);
        if (charSymbol == null) {
            if (character == ' ') {
                return this.getSpaceSize();
            }
            System.out.println("Character " + character + " not found");
            return 0;
        }
        return charSymbol[2];
    }

    private short[] getSymbolByCharacter(char character, int numSymbol) {
        int charIndex = this.binarySearchOnChars(character, 0, this.letterChars.length - 1);
        if (charIndex == -1) {
            return null;
        }
        return this.symbols[this.letterSymbols[charIndex][numSymbol]];
    }

    private int binarySearchOnChars(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.letterChars[mid] == character) {
            return mid;
        }
        if (character < this.letterChars[mid]) {
            return this.binarySearchOnChars(character, left, mid - 1);
        }
        return this.binarySearchOnChars(character, mid + 1, right);
    }

    public int drawChar(Graphics graphics, char character, int x, int y) {
        if (character == ' ') {
            return this.getSpaceSize();
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.letterChars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        short[] f = this.letterSymbols[charIndex];
        int result = this.drawSymbol(graphics, this.symbols[f[0]], x, y);
        for (int i = 1; i < f.length; ++i) {
            result = Math.max(result, this.drawSymbol(graphics, this.symbols[f[i]], x, y));
        }
        return result;
    }

    public int getLineWidth(char[] text) {
        int totalWidth = 0;
        if (text.length < 1) {
            return 0;
        }
        totalWidth += this.getCharacterWidth(text[0]);
        for (int i = 1; i < text.length; ++i) {
            char auxChar = text[i];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.getCharSpacing();
        }
        return totalWidth;
    }

    private int drawSymbol(Graphics g, short[] symbol, int x, int y) {
        g.setClip(x -= symbol[4], y -= symbol[5], (int)symbol[2], (int)symbol[3]);
        g.drawImage(this.image[this.currentPalette], x - symbol[0], y - symbol[1], 20);
        return symbol[2];
    }

    public int drawString(Graphics g, char[] text, int x, int y, int anchor, int maxPixelsWidth) {
        if (this.getLineWidth(text) > maxPixelsWidth) {
            StringBuffer newText = new StringBuffer(text.length);
            for (int i = 0; i < text.length; ++i) {
                if (maxPixelsWidth - this.getCharacterWidth(text[i]) > this.getCharacterWidth('.')) {
                    maxPixelsWidth -= this.getCharacterWidth(text[i]);
                } else {
                    newText.append('.');
                    break;
                }
                newText.append(text[i]);
            }
            return this.drawString(g, newText.toString().toCharArray(), x, y, anchor);
        }
        return this.drawString(g, text, x, y, anchor);
    }

    public int drawString(Graphics g, char[] text, int x, int y, int anchor) {
        if ((anchor & 0x10) != 0) {
            y += this.getFontHeight();
        } else if ((anchor & 0x20) != 0) {
            y -= this.getLineSpacing();
        } else if ((anchor & 2) != 0) {
            y += this.getFontHeight() / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i = 0; i < text.length; ++i) {
                textWidth = textWidth + this.drawChar(g, text[i], x + textWidth, y) + this.getCharSpacing();
            }
        } else {
            for (int i = 0; i < text.length; ++i) {
                x = x + this.drawChar(g, text[i], x, y) + this.getCharSpacing();
            }
        }
        return textWidth;
    }

    public int drawString(Graphics g, char[] text, int x, int y, int width, int height, int anchor, int firstLine, int scrollbarWidth, int color) {
        int frameWidth = width - scrollbarWidth;
        int maxLinesToWrite = 0;
        short[][] mLineData = this.getLineData(text, frameWidth);
        maxLinesToWrite = Math.min(height / (this.getFontHeight() + this.getLineSpacing()), mLineData.length);
        firstLine = Math.min(firstLine, mLineData.length - maxLinesToWrite);
        this.drawFastString(g, text, x, y, frameWidth, height, anchor, firstLine, maxLinesToWrite);
        if (scrollbarWidth > 0) {
            int gapHeight = maxLinesToWrite * height / mLineData.length;
            int gapPosY = y + firstLine * height / mLineData.length;
            g.setClip(x + frameWidth - 1, y, scrollbarWidth, height);
            g.setColor(color);
            g.fillRect(x + frameWidth + 1, gapPosY, scrollbarWidth - 4, gapHeight);
            g.drawRect(x + frameWidth - 1, y, scrollbarWidth - 1, height - 1);
        }
        return firstLine;
    }

    public int drawStringWave(Graphics g, char[] text, int x, int y, int startDegree, int lengthWaveInLetters, int maxY, int anchor) {
        int degree = startDegree % 360;
        int incDegree = 360 / lengthWaveInLetters;
        if ((anchor & 0x10) != 0) {
            y += this.getFontHeight();
        } else if ((anchor & 0x20) != 0) {
            y -= this.getLineSpacing();
        } else if ((anchor & 2) != 0) {
            y += this.getFontHeight() / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(text);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i = 0; i < text.length; ++i) {
                int diffY = SSFunctions.seno(degree) * maxY / 10000;
                textWidth = textWidth + this.drawChar(g, text[i], x + textWidth, y + diffY) + this.getCharSpacing();
                degree += incDegree;
            }
        } else {
            for (int i = 0; i < text.length; ++i) {
                int diffY = SSFunctions.seno(degree) * maxY / 10000;
                x = x + this.drawChar(g, text[i], x, y + diffY) + this.getCharSpacing();
                degree += incDegree;
            }
        }
        return textWidth;
    }

    public short[][] drawString(Graphics g, char[] data, int x, int y, int width, int height, int anchor) {
        short[][] mLineData = this.getLineData(data, width);
        this.drawFastString(g, data, x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public short[][] drawFastString(Graphics g, char[] data, int x, int y, int width, int height, int anchor, short[][] mLineData) {
        int textHeight;
        int maxLines = height / (this.getFontHeight() + this.getLineSpacing());
        if (maxLines < 1) {
            maxLines = 1;
        }
        if (mLineData.length < maxLines) {
            maxLines = mLineData.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.getFontHeight() + (height - textHeight >> 1) : (y += this.getFontHeight()));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        boolean textWidth = false;
        for (int i = 0; i < maxLines; ++i) {
            textWidth = false;
            if (mLineData[i][2] != 0) {
                this.drawFastString(g, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
        return mLineData;
    }

    public int getMaxNumLines(short[][] mLineData, int height) {
        return height / (this.getFontHeight() + this.lineSpacing);
    }

    public short[][] drawFastString(Graphics g, char[] data, int x, int y, int width, int height, int anchor, int firstLine, int linesToDraw) {
        int textHeight;
        short[][] mLineData = this.getLineData(data, width);
        int maxLines = height / (this.getFontHeight() + this.getLineSpacing());
        if (linesToDraw < maxLines) {
            maxLines = linesToDraw;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? (y += height - textHeight >> 1) : (y += this.getFontHeight()));
        this.drawFastString(g, data, mLineData, x, y, width, anchor, firstLine, linesToDraw);
        return mLineData;
    }

    public void drawFastString(Graphics g, char[] data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        y += this.getFontHeight();
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        boolean textWidth = false;
        for (int i = firstLine; i < maxLines; ++i) {
            textWidth = false;
            if (mLineData[i][2] != 0) {
                this.drawFastString(g, data, x, y, anchor, mLineData[i]);
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
    }

    private void drawFastString(Graphics g, char[] text, int x, int y, int anchor, short[] lineData) {
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        for (int i = lineData[0]; i < lineData[1] + 1; ++i) {
            x = x + this.drawChar(g, text[i], x, y) + this.getCharSpacing();
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getCharSpacing() {
        return this.charSpacing;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getSpaceSize() {
        return this.spaceSize;
    }
}

