/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

import java.util.Random;

public class SSMath {
    public static final int PI = 3217;
    public static Random rand = new Random(System.currentTimeMillis());

    public static long degree2rad(int angle) {
        long angle1024 = angle << 10;
        return angle1024 * 3217L / 184320L;
    }

    public static long rad2degree(long angle1024) {
        return angle1024 * 180L / 3217L;
    }

    public static long atan(long x, long y) {
        long angle;
        long coeff_1 = 804L;
        long coeff_2 = 3L * coeff_1;
        long abs_y = Math.abs(y);
        if (x >= 0L) {
            long r = (x - abs_y) / (x + abs_y);
            angle = coeff_1 - coeff_1 * r;
        } else {
            long r = (x + abs_y) / (abs_y - x);
            angle = coeff_2 - coeff_1 * r;
        }
        return y < 0L ? -angle : angle;
    }

    public static long getCRC32(byte[] buf) {
        int c;
        int off = 0;
        int len = buf.length;
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    public static long getCRC32(String text) {
        return SSMath.getCRC32(text.getBytes());
    }

    public static int sum(int[] v) {
        int sum = 0;
        for (int i = 0; i < v.length; ++i) {
            sum += v[i];
        }
        return sum;
    }

    public static int maxValue(int[] v) {
        int max = v[0];
        for (int i = 0; i < v.length; ++i) {
            if (max >= v[i]) continue;
            max = v[i];
        }
        return max;
    }

    public static int maxValueIndex(int[] v) {
        int maxIndex = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[maxIndex] >= v[i]) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int factorial(int num) {
        if (num <= 0) {
            return 1;
        }
        int fac = 0;
        for (int i = 1; i <= num; ++i) {
            fac += i;
        }
        return fac;
    }

    public static void sort(int[] arraya) {
        int n = arraya.length;
        for (int i = 1; i < n; ++i) {
            int key = arraya[i];
            for (int index = i - 1; index >= 0 && arraya[index] > key; --index) {
                arraya[index + 1] = arraya[index];
            }
            arraya[index + 1] = key;
        }
    }

    public static int rand(int min, int max) {
        return Math.abs(min + rand.nextInt() % (max - min + 1));
    }

    public static int[] shuffle(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            int index = SSMath.rand(0, array.length - 1);
            int value = array[i];
            array[i] = array[index];
            array[index] = value;
        }
        return array;
    }
}

