/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameCanvas;
import com.inode.pictorama.GameEngine;
import javax.microedition.lcdui.Graphics;

public class MenuInfo {
    public GameEngine ge;
    public static final int STATE_MENU_FIXED = 0;
    public static final int STATE_TRANSITION_IN = 1;
    public static final int STATE_TRANSITION_OUT = 2;
    public int menuState = 0;
    public static final int STATE_ITEM_OFF = 0;
    public static final int STATE_ITEM_ON = 1;
    public int menuFrames = 0;
    public long nowTime = System.currentTimeMillis();
    public long[] itemAnimateTime = null;
    public int[] itemPosXfixed = null;
    public int[] itemPosYfixed = null;
    public int[] itemPosX = null;
    public int[] itemPosY = null;
    public int[] itemPosXfinal = null;
    public int[] itemPosYfinal = null;
    public int textWidthFixed = 0;
    public int textHeightFixed = 0;
    public int textWidth = 0;
    public int textHeight = 0;
    public int textWidthFinal = 0;
    public int textHeightFinal = 0;
    public String textParagraph = null;
    public int textLine = 0;

    public MenuInfo(GameEngine _ge) {
        this.ge = _ge;
        System.out.println("MenuInfo()");
        this.itemAnimateTime = new long[2];
        this.itemPosXfixed = new int[2];
        this.itemPosYfixed = new int[2];
        this.itemPosX = new int[2];
        this.itemPosY = new int[2];
        this.itemPosXfinal = new int[2];
        this.itemPosYfinal = new int[2];
        this.textWidthFixed = 200;
        this.textHeightFixed = 130;
        this.itemPosXfixed[0] = 20;
        this.itemPosYfixed[0] = 82;
        this.itemPosXfixed[1] = this.itemPosXfixed[0];
        this.itemPosYfixed[1] = this.itemPosYfixed[0] + this.textHeightFixed + 2;
    }

    public void unload() {
        this.itemAnimateTime = null;
        this.itemPosXfixed = null;
        this.itemPosYfixed = null;
        this.itemPosX = null;
        this.itemPosY = null;
        this.itemPosXfinal = null;
        this.itemPosYfinal = null;
    }

    public void runTransitionIn() {
        System.out.println("MenuInfo:runTransitionIn()");
        this.menuFrames = 0;
        this.menuState = 1;
        this.textWidth = 0;
        this.textWidthFinal = this.textWidthFixed;
        this.textHeight = 0;
        this.textHeightFinal = this.textHeightFixed;
        this.itemPosX[0] = 120;
        this.itemPosXfinal[0] = this.itemPosXfixed[0];
        this.itemPosY[0] = 160;
        this.itemPosYfinal[0] = this.itemPosYfixed[0];
        this.itemPosX[1] = this.itemPosXfixed[1];
        this.itemPosXfinal[1] = this.itemPosXfixed[1];
        this.itemPosY[1] = 320;
        this.itemPosYfinal[1] = this.itemPosYfixed[1];
    }

    public void runTransitionOut() {
        System.out.println("MenuClassic:runTransitionOut()");
        this.menuFrames = 0;
        this.menuState = 2;
        this.textHeightFinal = 0;
        this.itemPosXfinal[0] = this.itemPosXfixed[0];
        this.itemPosYfinal[0] = 0;
        this.itemPosXfinal[1] = 240;
        this.itemPosYfinal[1] = 320;
    }

    public void setText(String text) {
        this.textLine = 0;
        this.textParagraph = text;
    }

    public void paint(Graphics _g) {
        switch (this.menuState) {
            case 0: {
                this.paintFixed(_g);
                break;
            }
            case 1: 
            case 2: {
                this.paintTransition(_g);
            }
        }
        ++this.menuFrames;
    }

    private void paintFixed(Graphics _g) {
        _g.setClip(0, 0, 240, 320);
        this.nowTime = System.currentTimeMillis();
        this.ge.gc.paintItem(_g, this.itemPosX[0], this.itemPosY[0], this.textWidth, this.textHeight);
        if (this.menuState == 0) {
            this.ge.gc.resetClip(_g);
            _g.setColor(16163641);
            GameCanvas cfr_ignored_0 = this.ge.gc;
            _g.fillRect(this.itemPosX[0] + 6, this.itemPosY[0] + 6, this.textWidth - 13, GameCanvas.resFonts[1].getFontHeight() + 2);
            switch (this.ge.menuActive) {
                case 5: {
                    GameCanvas cfr_ignored_1 = this.ge.gc;
                    GameCanvas.resFonts[1].drawString(_g, this.ge.lang[14].toCharArray(), 120, this.itemPosY[0] + 6, 17);
                    break;
                }
                case 7: {
                    GameCanvas cfr_ignored_2 = this.ge.gc;
                    GameCanvas.resFonts[1].drawString(_g, this.ge.lang[16].toCharArray(), 120, this.itemPosY[0] + 6, 17);
                    break;
                }
                case 11: {
                    GameCanvas cfr_ignored_3 = this.ge.gc;
                    GameCanvas.resFonts[1].drawString(_g, this.ge.lang[26].toCharArray(), 120, this.itemPosY[0] + 6, 17);
                }
            }
            GameCanvas cfr_ignored_4 = this.ge.gc;
            GameCanvas.resFonts[2].setCurrentPalette(0);
            GameCanvas cfr_ignored_5 = this.ge.gc;
            this.textLine = GameCanvas.resFonts[2].drawString(_g, this.textParagraph.toCharArray(), this.itemPosX[0] + 6, this.itemPosY[0] + 19, this.textWidth - 12, this.textHeight - 32, 20, this.textLine, 8, 16163641);
        }
    }

    private void paintTransition(Graphics _g) {
        boolean isComplete = true;
        boolean isOnScreen = false;
        int step = 1;
        int diffX = 0;
        int diffY = 0;
        int diffW = 0;
        int diffH = 0;
        diffX = this.itemPosXfinal[0] - this.itemPosX[0];
        if (diffX != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffX / this.ge.menu.speedX));
            if (Math.abs(diffX) < step) {
                this.itemPosX[0] = this.itemPosXfinal[0];
            } else if (diffX > 0) {
                this.itemPosX[0] = this.itemPosX[0] + step;
                if (this.itemPosX[0] < 240) {
                    isOnScreen = true;
                }
            } else if (diffX < 0) {
                this.itemPosX[0] = this.itemPosX[0] - step;
                if (this.itemPosX[0] > -200) {
                    isOnScreen = true;
                }
            }
        }
        if ((diffY = this.itemPosYfinal[0] - this.itemPosY[0]) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[0] = this.itemPosYfinal[0];
            } else if (diffY > 0) {
                this.itemPosY[0] = this.itemPosY[0] + step;
                if (this.itemPosY[0] < 320) {
                    isOnScreen = true;
                }
            } else if (diffY < 0) {
                this.itemPosY[0] = this.itemPosY[0] - step;
                if (this.itemPosY[0] > -26) {
                    isOnScreen = true;
                }
            }
        }
        if ((diffW = this.textWidthFinal - this.textWidth) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffW / this.ge.menu.speedX));
            if (Math.abs(diffW) < step) {
                this.textWidth = this.textWidthFinal;
            } else if (diffW > 0) {
                this.textWidth += step;
            } else if (diffW < 0) {
                this.textWidth -= step;
            }
        }
        if ((diffH = this.textHeightFinal - this.textHeight) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffH / this.ge.menu.speedY));
            if (Math.abs(diffH) < step) {
                this.textHeight = this.textHeightFinal;
            } else if (diffH > 0) {
                this.textHeight += step;
            } else if (diffH < 0) {
                this.textHeight -= step;
            }
        }
        if ((diffY = this.itemPosYfinal[1] - this.itemPosY[1]) != 0) {
            isComplete = false;
            step = Math.max(this.ge.menu.minStep, Math.abs(diffY / this.ge.menu.speedY));
            if (Math.abs(diffY) < step) {
                this.itemPosY[1] = this.itemPosYfinal[1];
            } else if (diffY > 0) {
                this.itemPosY[1] = this.itemPosY[1] + step;
                if (this.itemPosY[1] < 320) {
                    isOnScreen = true;
                }
            } else if (diffY < 0) {
                this.itemPosY[1] = this.itemPosY[1] - step;
                if (this.itemPosY[1] > -26) {
                    isOnScreen = true;
                }
            }
        }
        this.paintFixed(_g);
        if (!isOnScreen) {
            isComplete = true;
        }
        if (isComplete) {
            this.menuState = 0;
        }
    }
}

