/*
 * Decompiled with CFR 0.152.
 */
package com.inode.utils;

import com.inode.utils.SSFont;
import javax.microedition.lcdui.Graphics;

public class SSTextBox {
    public static final long WAITING_TIME = 1000L;
    public int width = 0;
    public int height = 0;
    public int borderSize = 2;
    public int colorBorder = 0;
    public int colorBackground = 0xFFFFFF;
    public SSFont font = null;
    public StringBuffer text = null;
    public long lastKeyPressed = 0L;
    public int posLetter = 0;
    public int indexLast = 0;
    public char[][] letters = null;

    public SSTextBox(SSFont _font, int maxChars) {
        this.font = _font;
        this.text = new StringBuffer(maxChars);
        this.width = maxChars * this.font.getFontHeight();
        this.height = this.font.getFontHeight() + 4 * this.borderSize;
        this.setAlphabet(" 0+()[]", "1.,@!?", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9");
    }

    public void setAlphabet(String _key0, String _key1, String _key2, String _key3, String _key4, String _key5, String _key6, String _key7, String _key8, String _key9) {
        this.letters = new char[10][];
        this.letters[0] = _key0.toCharArray();
        this.letters[1] = _key1.toCharArray();
        this.letters[2] = _key2.toCharArray();
        this.letters[3] = _key3.toCharArray();
        this.letters[4] = _key4.toCharArray();
        this.letters[5] = _key5.toCharArray();
        this.letters[6] = _key6.toCharArray();
        this.letters[7] = _key7.toCharArray();
        this.letters[8] = _key8.toCharArray();
        this.letters[9] = _key9.toCharArray();
    }

    public void setSize(int _width, int _height, int _borderSize) {
        this.width = _width;
        this.height = _height;
        this.borderSize = _borderSize;
    }

    public void setColor(int _colorBackground, int _colorBorder) {
        this.colorBackground = _colorBackground;
        this.colorBorder = _colorBorder;
    }

    public String getText() {
        return this.text.toString();
    }

    public void keyPressed(char key) {
        if (key >= '0' && key <= '9' && this.text.length() < this.text.capacity()) {
            int index = key - 48;
            if (System.currentTimeMillis() < this.lastKeyPressed + 1000L && index == this.indexLast) {
                this.posLetter = (this.posLetter + 1) % this.letters[index].length;
                this.text.setCharAt(this.text.length() - 1, this.letters[index][this.posLetter]);
            } else {
                this.indexLast = index;
                this.posLetter = 0;
                this.text.append(this.letters[index][this.posLetter]);
            }
            this.lastKeyPressed = System.currentTimeMillis();
        } else if (key == '\u0003') {
            if (this.text.length() > 0) {
                this.text.deleteCharAt(this.text.length() - 1);
            }
        } else if (key == '\u0004') {
            this.lastKeyPressed = 0L;
        }
    }

    public void paint(Graphics g, int x, int y) {
        g.setClip(x, y, this.width + 1, this.height + 1);
        g.setColor(this.colorBorder);
        g.fillRect(x, y, this.width, this.height);
        g.setColor(this.colorBackground);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.width - 2 * this.borderSize, this.height - 2 * this.borderSize);
        if (System.currentTimeMillis() / 500L % 2L == 0L) {
            g.setColor(this.colorBorder);
            g.fillRect(x + this.font.getLineWidth(this.text.toString().toCharArray()) + 3 * this.borderSize, y + 2 * this.borderSize, this.borderSize, this.height - 4 * this.borderSize);
        }
        this.font.drawString(g, this.text.toString().toCharArray(), x + 2 * this.borderSize, y + 2 * this.borderSize, 20);
    }
}

