/*
 * Decompiled with CFR 0.152.
 */
package com.inode.pictorama;

import com.inode.pictorama.GameEngine;
import com.inode.utils.SSAnimation;
import com.inode.utils.SSFont;
import com.inode.utils.SSResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas {
    public GameEngine ge;
    public static final int TPICTOCROSS_MOBILE = 0;
    public static final int TSOUND_QUESTION = 1;
    public static final int TYES = 2;
    public static final int TNO = 3;
    public static final int TLOADING = 4;
    public static final int TSELECT = 5;
    public static final int TCONTINUE = 6;
    public static final int TWELCOME = 7;
    public static final int TPLAY_GAME = 8;
    public static final int TPLAY_GAME_DESC = 9;
    public static final int TPROGRESS = 10;
    public static final int TPROGRESS_DESC = 11;
    public static final int TSETTINGS = 12;
    public static final int TSETTINGS_DESC = 13;
    public static final int THELP = 14;
    public static final int THELP_DESC = 15;
    public static final int TCREDITS = 16;
    public static final int TCREDITS_DESC = 17;
    public static final int TEXIT = 18;
    public static final int TEXIT_DESC = 19;
    public static final int TCLASSIC_MODE = 20;
    public static final int TCLASSIC_MODE_DESC = 21;
    public static final int TQUEST_MODE = 22;
    public static final int TQUEST_MODE_DESC = 23;
    public static final int TBONUS_TREASURES = 24;
    public static final int TBONUS_TREASURES_DESC = 25;
    public static final int TTUTORIAL = 26;
    public static final int TTUTORIAL_DESC = 27;
    public static final int TBACK = 28;
    public static final int TRETURN_PREV_MENU = 29;
    public static final int TCHOOSE_A_PUZZLE = 30;
    public static final int TBEST_TIME = 31;
    public static final int TPLAY_LEVEL = 32;
    public static final int TLEVEL_LOCKED = 33;
    public static final int TGET_PICTOCUBES = 34;
    public static final int TLOCKED = 35;
    public static final int TSECRET_MAP = 36;
    public static final int TSECRET_PIC = 37;
    public static final int TSOUND = 38;
    public static final int TSOUND_DESC = 39;
    public static final int TVIBRATE = 40;
    public static final int TVIBRATE_DESC = 41;
    public static final int TON = 42;
    public static final int TOFF = 43;
    public static final int THELP_TEXT = 44;
    public static final int TCREDITS_TEXT = 45;
    public static final int TARE_YOU_READY = 46;
    public static final int TPRESS_ANY_KEY = 47;
    public static final int TZOOM = 48;
    public static final int TMENU = 49;
    public static final int TPAUSE_MENU = 50;
    public static final int TRESUME = 51;
    public static final int TPUZZLE_COMPLETED = 52;
    public static final int TNEW_RECORD = 53;
    public static final int TLEVEL_RESULT = 54;
    public static final int TTIME_LIMIT = 55;
    public static final int TTIME_CONSUMED = 56;
    public static final int TMISTAKES = 57;
    public static final int TSCORE = 58;
    public static final int TPICTOCUBES_OBTAINED = 59;
    public static final int TDONT_USE = 60;
    public static final int TSHOW_ROW = 61;
    public static final int TSHOW_COLUM = 62;
    public static final int TMORE_TIME = 63;
    public static final int TJOKER = 64;
    public static final int TSHOW_SQUARE = 65;
    public static final int TBLOCK_1 = 66;
    public static final int TBLOCK_2 = 67;
    public static final int TBLOCK_3 = 68;
    public static final int TBLOCK_4 = 69;
    public static final int TBLOCK_5 = 70;
    public static final int TBLOCK_6 = 71;
    public static final int TBLOCK_7 = 72;
    public static final int TBLOCK_8 = 73;
    public static final int TBLOCK_9 = 74;
    public static final int TBLOCK_10 = 75;
    public static final int TBLOCK_11 = 76;
    public static final int TBLOCK_12 = 77;
    public static final int TBLOCK_13 = 78;
    public static final int TBLOCK_14 = 79;
    public static final int TBLOCK_15 = 80;
    public static final int TLEVEL_STILL_LOCKED = 81;
    public static final int TCOMPLETE_THIS_LEVEL = 82;
    public static final int TLEVEL = 83;
    public static final int TPOINTS = 84;
    public static final int TGAME_OVER = 85;
    public static final int TSELECT_HELP_ITEM = 86;
    public static final int TYOUR_PROGRESS = 87;
    public static final int TGAME_PROGRESSION = 88;
    public static final int TCOMPLETED = 89;
    public static final int TGLOBAL_SCORE = 90;
    public static final int TLEVELS_COMPLETED = 91;
    public static final int TPICTOCUBES_UNLOCKED = 92;
    public static final int TBONUS_UNLOCKED = 93;
    public static final int TPICTOCUBES = 94;
    public static final int TTUTORIAL_TEXT = 95;
    public static final int TINCOMPLETED = 96;
    public static final int TTIME_LEFT = 97;
    public static final int TBLOCK_COMPLETED = 98;
    public static final int TCONTINUE_PLAYING = 99;
    public static final int TEXIT_GAME = 100;
    public static final int TMORE_GAMES = 101;
    public static final int TMORE_GAMES_DESC = 102;
    public static final int TWELL_DONE = 103;
    public static final int TUNLOCKED = 104;
    public static final int TSELECT_ITEM = 105;
    public static final int TRECORD = 106;
    public static final int ALPHA_SIZE = 16;
    public static final int RES_LQA = 0;
    public static final int RES_PNG = 1;
    public static final int RES_SSF = 2;
    public static final int RES_LQA_ROBOT = 0;
    public static final int RES_LQA_ROBOT_GLASS = 1;
    public static final int RES_LQA_SHINE = 2;
    public static final int RES_LQA_SELECTOR = 3;
    public static final int RES_LQA_LOADING = 4;
    public static final int RES_LQA_MARK_CELL = 5;
    public static final int RES_LQA_CROSS_CELL = 6;
    public static final int RES_LQA_TIME_BONUS = 7;
    public static final int RES_LQA_HOLOCUBE = 8;
    public static final int RES_LQA_LEVEL_PREVIEW = 9;
    public static final int RES_LQA_MAX = 10;
    public SSAnimation[] resAnimations = new SSAnimation[10];
    public static final int RES_PNG_SPLASH = 0;
    public static final int RES_PNG_COVER = 1;
    public static final int RES_PNG_BACKGROUND = 2;
    public static final int RES_PNG_TITLE = 3;
    public static final int RES_PNG_ALPHA = 4;
    public static final int RES_PNG_ITEM_TILES = 5;
    public static final int RES_PNG_LOADING = 6;
    public static final int RES_PNG_CLASSIC_TITLE = 7;
    public static final int RES_PNG_CLASSIC_LOCKED = 8;
    public static final int RES_PNG_CLASSIC_UNLOCKED = 9;
    public static final int RES_PNG_CLASSIC_UNKNOW = 10;
    public static final int RES_PNG_CLASSIC_ARROW_L = 11;
    public static final int RES_PNG_CLASSIC_ARROW_R = 12;
    public static final int RES_PNG_DAILY_MODE = 13;
    public static final int RES_PNG_QUEST_TITLE = 14;
    public static final int RES_PNG_QUEST_BLANK = 15;
    public static final int RES_PNG_QUEST_LOCKED = 16;
    public static final int RES_PNG_QUEST_QUESTION = 17;
    public static final int RES_PNG_QUEST_SELECT = 18;
    public static final int RES_PNG_QUEST_ICONS = 19;
    public static final int RES_PNG_QUEST_ITEMS = 20;
    public static final int RES_PNG_QUEST_GRAYBAR = 21;
    public static final int RES_PNG_QUEST_HOLOCUBE = 22;
    public static final int RES_PNG_QUEST_CELL_A = 23;
    public static final int RES_PNG_QUEST_CELL_B = 24;
    public static final int RES_PNG_BONUS_TITLE = 25;
    public static final int RES_PNG_BOARD_SCOREBOARD = 26;
    public static final int RES_PNG_ICON_LOCK = 27;
    public static final int RES_PNG_BONUS_PIC_1 = 28;
    public static final int RES_PNG_BONUS_PIC_2 = 29;
    public static final int RES_PNG_BONUS_PIC_3 = 30;
    public static final int RES_PNG_MAX = 31;
    public Image[] resImages = new Image[31];
    public static final int RES_SSF_CRONO = 0;
    public static final int RES_SSF_MENU = 1;
    public static final int RES_SSF_SMALL = 2;
    public static final int RES_SSF_MAX = 3;
    public static SSFont[] resFonts = new SSFont[3];
    public static final int SIZE_WIDTH_ITEM = 200;
    public static final int SIZE_HEIGHT_ITEM = 26;
    public static final int SIZE_HEIGHT_TITLE = 36;
    public static final int SIZE_HEIGHT_CLASSIC_TITLE = 31;
    public static final int SIZE_HEIGHT_QUEST_GRAYBAR = 48;
    public int[] shineX = null;
    public int[] shineY = null;
    public long[] shineTime = null;
    public static final int LOADING_ROBOT_X = 40;
    public static final int LOADING_ROBOT_Y = 102;
    public static final int LOADING_EYES_X = 52;
    public static final int LOADING_EYES_Y = 32;
    public static final int LOADING_BAR_X = 7;
    public static final int LOADING_BAR_Y = 95;
    public static final int LOADING_BAR_WIDTH = 145;
    public static final int LOADING_BAR_HEIGHT = 16;
    public int loading_step = 0;
    public int loading_steps_total = 1;
    int posX = 0;
    int posY = 0;
    int iniX = 0;
    int iniY = 0;
    int finX = 0;
    int finY = 0;
    int pointerX = 0;
    int pointerY = 0;
    public SSResourceManager resManager = null;

    public GameCanvas(GameEngine _ge) {
        this.ge = _ge;
        this.resManager = new SSResourceManager();
        this.resLoad(1, 2);
        this.resLoad(2, 1);
        this.resLoad(6, 1);
        this.resLoad(3, 1);
        this.resLoad(25, 1);
        this.resLoad(3, 0);
        this.resLoad(7, 1);
        this.resLoad(14, 1);
        this.resLoad(0, 2);
        this.resLoad(2, 2);
        this.resLoad(4, 0);
        this.resLoad(5, 1);
        this.resLoad(8, 0);
        this.resLoad(4, 1);
        this.ge.soundMusic = this.ge.sound.loadSound(this.resManager.getResource("sound_music.mid"), 0);
        this.ge.soundWin = this.ge.sound.loadSound(this.resManager.getResource("sound_win.mid"), 0);
        this.ge.soundLose = this.ge.sound.loadSound(this.resManager.getResource("sound_lose.mid"), 0);
        this.ge.soundStart = this.ge.sound.loadSound(this.resManager.getResource("sound_start.mid"), 0);
        this.ge.sfxMark = this.ge.sound.loadSound(this.resManager.getResource("sfx_mark.wav"), 3);
        this.ge.sfxBlank = this.ge.sound.loadSound(this.resManager.getResource("sfx_blank.wav"), 3);
        this.ge.sfxError = this.ge.sound.loadSound(this.resManager.getResource("sfx_error.wav"), 3);
        this.shineTime = new long[6];
        this.shineX = new int[6];
        this.shineY = new int[6];
    }

    public void resLoad(int res, int type) {
        System.out.println("   Load resource res=" + res + " type=" + type);
        block0 : switch (type) {
            case 0: {
                if (this.resAnimations[res] != null) {
                    System.out.println("     RES_CACHE: LQA resource number " + res + " already loaded");
                    res = -1;
                }
                switch (res) {
                    case 0: {
                        this.resAnimations[0] = new SSAnimation(this.resManager.getResourceAsStream("robot.lqa"));
                        break block0;
                    }
                    case 1: {
                        this.resAnimations[1] = new SSAnimation(this.resManager.getResourceAsStream("robot_glasses.lqa"));
                        break block0;
                    }
                    case 2: {
                        this.resAnimations[2] = new SSAnimation(this.resManager.getResourceAsStream("shine.lqa"));
                        break block0;
                    }
                    case 3: {
                        this.resAnimations[3] = new SSAnimation(this.resManager.getResourceAsStream("item_animations.lqa"));
                        break block0;
                    }
                    case 4: {
                        this.resAnimations[4] = new SSAnimation(this.resManager.getResourceAsStream("loading.lqa"));
                        break block0;
                    }
                    case 5: {
                        this.resAnimations[5] = new SSAnimation(this.resManager.getResourceAsStream("cell_mark.lqa"));
                        break block0;
                    }
                    case 6: {
                        this.resAnimations[6] = new SSAnimation(this.resManager.getResourceAsStream("cell_cross.lqa"));
                        break block0;
                    }
                    case 7: {
                        this.resAnimations[7] = new SSAnimation(this.resManager.getResourceAsStream("time_bonus.lqa"));
                        break block0;
                    }
                    case 8: {
                        this.resAnimations[8] = new SSAnimation(this.resManager.getResourceAsStream("holocube.lqa"));
                        break block0;
                    }
                    case 9: {
                        this.resAnimations[9] = new SSAnimation(this.resManager.getResourceAsStream("level_preview.lqa"));
                        break block0;
                    }
                    case -1: {
                        break block0;
                    }
                }
                System.out.println("ERRROR: Can't load LQA resource number " + res);
                break;
            }
            case 1: {
                if (this.resImages[res] != null) {
                    System.out.println("      RES_CACHE: PNG resource number " + res + " already loaded");
                    res = -1;
                }
                switch (res) {
                    case 0: {
                        this.resImages[0] = this.resManager.getImage("splash.png");
                        break block0;
                    }
                    case 1: {
                        this.resImages[1] = this.resManager.getImage("cover.png");
                        break block0;
                    }
                    case 4: {
                        this.resImages[4] = this.resManager.getImage("alpha.png");
                        break block0;
                    }
                    case 5: {
                        this.resImages[5] = this.resManager.getImage("item_tiles.png");
                        break block0;
                    }
                    case 6: {
                        this.resImages[6] = this.resManager.getImage("loading.png");
                        break block0;
                    }
                    case 2: {
                        this.resImages[2] = this.resManager.getImage("background.png");
                        break block0;
                    }
                    case 3: {
                        this.resImages[3] = this.resManager.getImage("title.png");
                        break block0;
                    }
                    case 7: {
                        this.resImages[7] = this.resManager.getImage("classic_title.png");
                        break block0;
                    }
                    case 8: {
                        this.resImages[8] = this.resManager.getImage("classic_locked.png");
                        break block0;
                    }
                    case 9: {
                        this.resImages[9] = this.resManager.getImage("classic_unlocked.png");
                        break block0;
                    }
                    case 10: {
                        this.resImages[10] = this.resManager.getImage("classic_unknown.png");
                        break block0;
                    }
                    case 11: {
                        this.resImages[11] = this.resManager.getImage("classic_arrow_l.png");
                        break block0;
                    }
                    case 12: {
                        this.resImages[12] = this.resManager.getImage("classic_arrow_r.png");
                        break block0;
                    }
                    case 13: {
                        this.resImages[13] = this.resManager.getImage("dailypictocross.png");
                        break block0;
                    }
                    case 14: {
                        this.resImages[14] = this.resManager.getImage("quest_title.png");
                        break block0;
                    }
                    case 15: {
                        this.resImages[15] = this.resManager.getImage("quest_block_blank.png");
                        break block0;
                    }
                    case 16: {
                        this.resImages[16] = this.resManager.getImage("quest_block_locked.png");
                        break block0;
                    }
                    case 17: {
                        this.resImages[17] = this.resManager.getImage("quest_block_question.png");
                        break block0;
                    }
                    case 18: {
                        this.resImages[18] = this.resManager.getImage("quest_block_select.png");
                        break block0;
                    }
                    case 19: {
                        this.resImages[19] = this.resManager.getImage("quest_icons.png");
                        break block0;
                    }
                    case 20: {
                        this.resImages[20] = this.resManager.getImage("quest_items.png");
                        break block0;
                    }
                    case 21: {
                        this.resImages[21] = this.resManager.getImage("quest_graybar.png");
                        break block0;
                    }
                    case 22: {
                        this.resImages[22] = this.resManager.getImage("quest_holocube.png");
                        break block0;
                    }
                    case 23: {
                        this.resImages[23] = this.resManager.getImage("quest_cell_a.png");
                        break block0;
                    }
                    case 24: {
                        this.resImages[24] = this.resManager.getImage("quest_cell_b.png");
                        break block0;
                    }
                    case 25: {
                        this.resImages[25] = this.resManager.getImage("bonus_title.png");
                        break block0;
                    }
                    case 26: {
                        this.resImages[26] = this.resManager.getImage("board_scoreboard.png");
                        break block0;
                    }
                    case 27: {
                        this.resImages[27] = this.resManager.getImage("icon_lock.png");
                        break block0;
                    }
                    case 28: {
                        this.resImages[28] = this.resManager.getImage("bonus_robot1.png");
                        break block0;
                    }
                    case 29: {
                        this.resImages[29] = this.resManager.getImage("bonus_robot2.png");
                        break block0;
                    }
                    case 30: {
                        this.resImages[30] = this.resManager.getImage("bonus_robot3.png");
                        break block0;
                    }
                    case -1: {
                        break block0;
                    }
                }
                System.out.println("ERRROR: Can't load PNG resource number " + res);
                break;
            }
            case 2: {
                if (resFonts[res] != null) {
                    System.out.println("      RES_CACHE: SSF resource number " + res + " already loaded");
                    res = -1;
                }
                switch (res) {
                    case 0: {
                        GameCanvas.resFonts[0] = new SSFont(this.resManager.getResourceAsStream("fontCrono.ssf"), null);
                        break block0;
                    }
                    case 1: {
                        GameCanvas.resFonts[1] = new SSFont(this.resManager.getResourceAsStream("fontMenu.ssf"), null);
                        break block0;
                    }
                    case 2: {
                        GameCanvas.resFonts[2] = new SSFont(this.resManager.getResourceAsStream("fontSmall.ssf"), new int[][]{{0xFEFEFE}, {16306995}, {11551244}});
                        break block0;
                    }
                    case -1: {
                        break block0;
                    }
                }
                System.out.println("ERRROR: Can't load SSF resource number " + res);
            }
        }
    }

    public void resUnload(int res, int type) {
        switch (type) {
            case 0: {
                this.resAnimations[res] = null;
                break;
            }
            case 1: {
                this.resImages[res] = null;
                break;
            }
            case 2: {
                GameCanvas.resFonts[res] = null;
            }
        }
    }

    public void resetClip(Graphics g) {
        g.setClip(0, 0, 240, 320);
    }

    public void paintBackground(Graphics g) {
        g.drawImage(this.resImages[2], 0, 0, 20);
    }

    public void paintAlpha(Graphics g, int x, int y, int width, int height) {
        g.setClip(x, y, width, height);
        for (int row = 0; row < height / 32 + 1; ++row) {
            for (int col = 0; col < width / 32 + 1; ++col) {
                g.drawImage(this.resImages[4], x + col * 32, y + row * 32, 20);
            }
        }
    }

    public void paintImageTiled(Graphics g, Image img, int x, int y, int width, int height) {
        g.setClip(x, y, width, height);
        for (int row = 0; row < height / img.getHeight() + 1; ++row) {
            for (int col = 0; col < width / img.getWidth() + 1; ++col) {
                g.drawImage(img, x + col * img.getWidth(), y + row * img.getHeight(), 20);
            }
        }
    }

    public void paintItem(Graphics g, int x, int y, int width, int height) {
        int i;
        g.setClip(x, y, width, height);
        g.drawImage(this.resImages[5], x, y, 20);
        g.drawImage(this.resImages[5], x + width, y, 24);
        g.drawImage(this.resImages[5], x, y + height, 36);
        g.drawImage(this.resImages[5], x + width, y + height, 40);
        for (i = 0; i < (width - 12) / 16; ++i) {
            g.setClip(x + 6 + i * 16, y, 16, 4);
            g.drawImage(this.resImages[5], x + i * 16, y, 20);
            g.setClip(x + 6 + i * 16, y + height - 6, 16, 6);
            g.drawImage(this.resImages[5], x + i * 16, y + height, 36);
        }
        for (i = 0; i < (height - 12) / 16; ++i) {
            g.setClip(x, y + 6 + i * 16, 2, 16);
            g.drawImage(this.resImages[5], x, y + i * 16, 20);
            g.setClip(x + width - 3, y + 6 + i * 16, 3, 16);
            g.drawImage(this.resImages[5], x + width, y + i * 16, 24);
        }
        g.setClip(x + 2, y + 4, width - 5, height - 10);
        g.setColor(16173175);
        g.fillRect(x + 2, y + 4, width - 5, height - 10);
    }

    public void paintMenuMain(Graphics g) {
        this.resetClip(g);
        this.paintBackground(g);
        if (!this.ge.configIsLowPerformance) {
            for (int i = 0; i < 4; ++i) {
                this.resAnimations[2].drawAnimation(g, i, System.currentTimeMillis() - this.shineTime[i], this.shineX[i], this.shineY[i], false);
            }
        }
        this.ge.menu.paint(g);
        this.ge.robot.paint(g);
        int plusy = 0;
        resFonts[1].drawString(g, this.ge.lang[5].toCharArray(), 2, 318 + plusy, 68, 120);
        if (this.ge.menuActive == 1) {
            resFonts[1].drawString(g, this.ge.lang[28].toCharArray(), 238, 318 + plusy, 72);
        }
        if (this.ge.godMode) {
            resFonts[1].drawString(g, ".".toCharArray(), 120, 318, 65);
        }
    }

    public void paintMenuInfo(Graphics g) {
        this.resetClip(g);
        this.paintBackground(g);
        for (int i = 0; i < 4; ++i) {
            this.resAnimations[2].drawAnimation(g, i, System.currentTimeMillis() - this.shineTime[i], this.shineX[i], this.shineY[i], false);
        }
        this.ge.menuInfo.paint(g);
        this.resetClip(g);
        g.drawImage(this.resImages[3], 120, 16, 17);
        this.ge.robot.paint(g);
        int plusy = 0;
        resFonts[1].drawString(g, this.ge.lang[28].toCharArray(), 2, 318 + plusy, 68);
    }

    public void paintMenuProgress(Graphics g) {
        this.resetClip(g);
        this.paintBackground(g);
        for (int i = 0; i < 4; ++i) {
            this.resAnimations[2].drawAnimation(g, i, System.currentTimeMillis() - this.shineTime[i], this.shineX[i], this.shineY[i], false);
        }
        this.ge.menuProgress.paint(g);
        this.resetClip(g);
        g.drawImage(this.resImages[3], 120, 16, 17);
        this.ge.robot.paint(g);
        int plusy = 0;
        resFonts[1].drawString(g, this.ge.lang[28].toCharArray(), 2, 318 + plusy, 68);
    }

    public void paintMenuClassic(Graphics g) {
        this.resetClip(g);
        this.paintBackground(g);
        for (int i = 0; i < 4; ++i) {
            this.resAnimations[2].drawAnimation(g, i, System.currentTimeMillis() - this.shineTime[i], this.shineX[i], this.shineY[i], false);
        }
        this.ge.menuClassic.paint(g);
        this.ge.robot.paint(g);
        int plusy = 0;
        resFonts[1].drawString(g, this.ge.lang[5].toCharArray(), 2, 318 + plusy, 68, 120);
        resFonts[1].drawString(g, this.ge.lang[28].toCharArray(), 238, 318 + plusy, 72);
    }

    public void paintMenuQuest(Graphics g) {
        this.resetClip(g);
        this.paintBackground(g);
        for (int i = 0; i < 4; ++i) {
            this.resAnimations[2].drawAnimation(g, i, System.currentTimeMillis() - this.shineTime[i], this.shineX[i], this.shineY[i], false);
        }
        this.ge.menuQuest.paint(g);
    }

    public void paintMenuBonus(Graphics g) {
        this.resetClip(g);
        if (this.ge.menuBonus.menuState == 4 || this.ge.menuBonus.menuState == 5 || this.ge.menuBonus.menuState == 6) {
            this.ge.menuBonus.paint(g);
            int plusy = 0;
            resFonts[1].drawString(g, this.ge.lang[28].toCharArray(), 2, 318 + plusy, 68);
        } else {
            this.paintBackground(g);
            for (int i = 0; i < 4; ++i) {
                this.resAnimations[2].drawAnimation(g, i, System.currentTimeMillis() - this.shineTime[i], this.shineX[i], this.shineY[i], false);
            }
            this.ge.menuBonus.paint(g);
            this.ge.robot.paint(g);
            int plusy = 0;
            resFonts[1].drawString(g, this.ge.lang[5].toCharArray(), 2, 318 + plusy, 68, 120);
            resFonts[1].drawString(g, this.ge.lang[28].toCharArray(), 238, 318 + plusy, 72);
        }
    }

    public void paintBoard(Graphics g) {
        this.ge.board.paint(g);
    }

    public void paintLoading(Graphics g) {
        System.out.println(100 * this.loading_step / this.loading_steps_total + "%");
        this.resetClip(g);
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        this.loading_step = Math.min(this.ge.gameFramesAux, this.loading_steps_total);
        g.setColor(15167284);
        g.fillRect(47, 197, this.loading_step * 145 / this.loading_steps_total, 16);
        resFonts[1].drawString(g, (100 * this.loading_step / this.loading_steps_total + "%").toCharArray(), 120, 199, 17);
        this.resetClip(g);
        g.drawImage(this.resImages[6], 40, 102, 20);
        this.resetClip(g);
        this.resAnimations[4].drawFrame(g, Math.min(4 * this.loading_step / this.loading_steps_total, 4), 92, 134);
        resFonts[1].drawString(g, this.ge.lang[4].toCharArray(), 120, 221, 17);
    }

    public void paintSplash(Graphics g) {
        this.resetClip(g);
        g.setColor(7342641);
        g.fillRect(0, 0, 240, 320);
        g.drawImage(this.resImages[0], 120, 160, 3);
    }

    public void paintSoundQuestion(Graphics g) {
        this.resetClip(g);
        g.setColor(7342641);
        g.fillRect(0, 0, 240, 320);
        resFonts[1].drawString(g, this.ge.lang[1].toCharArray(), 120, 160, 3);
        int plusy = 0;
        resFonts[1].drawString(g, this.ge.lang[2].toCharArray(), 2, 318 + plusy, 68);
        resFonts[1].drawString(g, this.ge.lang[3].toCharArray(), 238, 318 + plusy, 72);
    }

    public void paintCover(Graphics g) {
        this.resetClip(g);
        this.paintBackground(g);
        g.drawImage(this.resImages[1], 120, 160, 3);
    }

    public void paintTransition(Graphics g) {
        this.resetClip(g);
        g.setColor(0);
        int stepW = 240 / 20;
        int stepH = 320 / 20;
        if (this.ge.state == 1) {
            switch (this.ge.getStateNext()) {
                case 4: {
                    this.paintSplash(g);
                    break;
                }
                case 5: {
                    this.paintSoundQuestion(g);
                    break;
                }
                case 6: {
                    this.paintCover(g);
                    break;
                }
                case 7: {
                    switch (this.ge.menuActive) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            this.paintMenuMain(g);
                            break;
                        }
                        case 5: 
                        case 7: 
                        case 11: {
                            this.paintMenuInfo(g);
                            break;
                        }
                        case 8: {
                            this.paintMenuClassic(g);
                            break;
                        }
                        case 9: {
                            this.paintMenuQuest(g);
                            break;
                        }
                        case 10: {
                            this.paintMenuBonus(g);
                        }
                    }
                    break;
                }
                case 8: {
                    this.paintBoard(g);
                    break;
                }
            }
            this.paintBlackStripesIn(g);
        } else if (this.ge.state == 2) {
            this.paintBlackStripesOut(g);
        }
    }

    public void paintBlackStripesIn(Graphics g) {
        int col;
        int row;
        int stepW = 240 / 20;
        int stepH = 320 / 20;
        this.resetClip(g);
        g.setColor(0);
        int squareHorizontal = 15;
        int squareVertical = 20;
        if (240 % squareHorizontal != 0) {
            ++squareHorizontal;
        }
        if (320 % squareVertical != 0) {
            ++squareVertical;
        }
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                this.ge.squaresNew[row][col] = false;
            }
        }
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                if (this.ge.squares[row][col] != 16 && !this.ge.squaresNew[row][col]) {
                    if (row + 1 < squareVertical && this.ge.squares[row + 1][col] > 0 && squareVertical / 2 <= row) {
                        if (this.ge.squares[row + 1][col] == 16) {
                            this.ge.squaresNew[row + 1][col] = true;
                        }
                        this.ge.squares[row + 1][col] = this.ge.squares[row][col] + 2;
                    }
                    if (row - 1 >= 0 && this.ge.squares[row - 1][col] > 0 && squareVertical / 2 > row) {
                        if (this.ge.squares[row - 1][col] == 16) {
                            this.ge.squaresNew[row - 1][col] = true;
                        }
                        this.ge.squares[row - 1][col] = this.ge.squares[row][col];
                    }
                    if (col + 1 < squareHorizontal && this.ge.squares[row][col + 1] > 0 && squareHorizontal / 2 <= col) {
                        if (this.ge.squares[row][col + 1] == 16) {
                            this.ge.squaresNew[row][col + 1] = true;
                        }
                        this.ge.squares[row][col + 1] = this.ge.squares[row][col] + 2;
                    }
                    if (col - 1 >= 0 && this.ge.squares[row][col - 1] > 0 && squareHorizontal / 2 >= col) {
                        if (this.ge.squares[row][col - 1] == 0) {
                            this.ge.squaresNew[row][col - 1] = true;
                        }
                        this.ge.squares[row][col - 1] = this.ge.squares[row][col];
                    }
                    if (this.ge.squares[row][col] < 16) {
                        int[] nArray = this.ge.squares[row];
                        int n = col;
                        nArray[n] = nArray[n] - 2;
                    }
                }
                g.fillRect(col * 16 + 8 - this.ge.squares[row][col] / 2, row * 16 + 8 - this.ge.squares[row][col] / 2, this.ge.squares[row][col], this.ge.squares[row][col]);
            }
        }
    }

    public void paintBlackStripesOut(Graphics g) {
        int col;
        int row;
        int stepW = 240 / 20;
        int stepH = 320 / 20;
        this.resetClip(g);
        g.setColor(0);
        int squareHorizontal = 15;
        int squareVertical = 20;
        if (240 % squareHorizontal != 0) {
            ++squareHorizontal;
        }
        if (320 % squareVertical != 0) {
            ++squareVertical;
        }
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                this.ge.squaresNew[row][col] = false;
            }
        }
        for (row = 0; row < squareVertical; ++row) {
            for (col = 0; col < squareHorizontal; ++col) {
                if (this.ge.squares[row][col] == 0 || this.ge.squaresNew[row][col]) continue;
                if (row + 1 < squareVertical && this.ge.squares[row + 1][col] < 16 && squareVertical / 2 <= row) {
                    if (this.ge.squares[row + 1][col] == 0) {
                        this.ge.squaresNew[row + 1][col] = true;
                    }
                    this.ge.squares[row + 1][col] = this.ge.squares[row][col] - 2;
                }
                if (row - 1 >= 0 && this.ge.squares[row - 1][col] < 16 && squareVertical / 2 > row) {
                    if (this.ge.squares[row - 1][col] == 0) {
                        this.ge.squaresNew[row - 1][col] = true;
                    }
                    this.ge.squares[row - 1][col] = this.ge.squares[row][col];
                }
                if (col + 1 < squareHorizontal && this.ge.squares[row][col + 1] < 16 && squareHorizontal / 2 <= col) {
                    if (this.ge.squares[row][col + 1] == 0) {
                        this.ge.squaresNew[row][col + 1] = true;
                    }
                    this.ge.squares[row][col + 1] = this.ge.squares[row][col] - 2;
                }
                if (col - 1 >= 0 && this.ge.squares[row][col - 1] < 16 && squareHorizontal / 2 >= col) {
                    if (this.ge.squares[row][col - 1] == 0) {
                        this.ge.squaresNew[row][col - 1] = true;
                    }
                    this.ge.squares[row][col - 1] = this.ge.squares[row][col];
                }
                if (this.ge.squares[row][col] < 16) {
                    int[] nArray = this.ge.squares[row];
                    int n = col;
                    nArray[n] = nArray[n] + 2;
                }
                g.fillRect(col * 16 + 8 - this.ge.squares[row][col] / 2, row * 16 + 8 - this.ge.squares[row][col] / 2, this.ge.squares[row][col], this.ge.squares[row][col]);
            }
        }
    }

    public void paintLandscape(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.ge.getWidth(), this.ge.getHeight());
        g.drawImage(this.resImages[3], this.ge.getWidth() >> 1, this.ge.getHeight() >> 1, 3);
        resFonts[1].drawString(g, "SLIDE THE KEYPAD OPEN".toCharArray(), this.ge.getWidth() >> 1, this.ge.getHeight() + this.resImages[3].getHeight() + 10 >> 1, 17);
    }
}

