/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.util.Hashtable;

class CustomFont
extends Font {
    public static final int COLOR_CACHE_SIZE = 20;
    public Hashtable colorCache = new Hashtable();
    public String charsets;
    public int color;
    Image cache;
    int[] cutOffsets;
    int[] charWidth;
    public int imageWidth;
    public int imageHeight;
    public Object imageArrayRef;

    private int[] getImageArray() {
        int[] a2;
        if (this.imageArrayRef != null && (a2 = (int[])Display.getInstance().extractHardRef(this.imageArrayRef)) != null) {
            return a2;
        }
        a2 = this.cache.getRGBCached();
        this.imageArrayRef = Display.getInstance().createSoftWeakRef(a2);
        return a2;
    }

    public CustomFont(Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        this.cutOffsets = cutOffsets;
        this.charWidth = charWidth;
        this.charsets = charsets;
        this.imageWidth = bitmap.getWidth();
        this.imageHeight = bitmap.getHeight();
        int[] imageArray = new int[this.imageWidth * this.imageHeight];
        bitmap.getRGB(imageArray, 0, 0, 0, this.imageWidth, this.imageHeight);
        for (int iter = 0; iter < imageArray.length; ++iter) {
            imageArray[iter] = (imageArray[iter] & 0xFF0000) << 8;
        }
        this.cache = Image.createImage(imageArray, this.imageWidth, this.imageHeight);
        this.imageArrayRef = Display.getInstance().createSoftWeakRef(imageArray);
    }

    public int charWidth(char ch) {
        int i = this.charsets.indexOf(ch);
        if (i < 0) {
            return 0;
        }
        return this.charWidth[i];
    }

    public int getHeight() {
        return this.imageHeight;
    }

    private boolean checkCacheCurrentColor(int newColor) {
        Integer currentColor = new Integer(this.color);
        Integer newColorKey = new Integer(newColor);
        if (this.colorCache.get(currentColor) == null) {
            this.colorCache.put(currentColor, Display.getInstance().createSoftWeakRef(this.cache));
        }
        this.color = newColor;
        Object newCache = Display.getInstance().extractHardRef(this.colorCache.get(newColorKey));
        if (newCache != null) {
            Image i = (Image)newCache;
            if (i != null) {
                this.cache = i;
                if (this.colorCache.size() > 20) {
                    this.colorCache.remove(this.colorCache.keys().nextElement());
                }
                return true;
            }
            this.colorCache.remove(newColorKey);
        }
        if (this.colorCache.size() > 20) {
            this.colorCache.remove(this.colorCache.keys().nextElement());
        }
        return false;
    }

    private void initColor(Graphics g) {
        int newColor = g.getColor();
        if (newColor != this.color && !this.checkCacheCurrentColor(newColor)) {
            this.color = newColor & 0xFFFFFF;
            int[] imageArray = this.getImageArray();
            for (int iter = 0; iter < imageArray.length; ++iter) {
                imageArray[iter] = this.color | imageArray[iter] & 0xFF000000;
            }
            this.cache = Image.createImage(imageArray, this.imageWidth, this.imageHeight);
        }
    }

    void drawChar(Graphics g, char character, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int i = this.charsets.indexOf(character);
        if (i > -1) {
            this.initColor(g);
            g.clipRect(x, y, this.charWidth[i], this.imageHeight);
            g.drawImage(this.cache, x - this.cutOffsets[i], y);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void addContrast(byte value) {
        int[] imageArray = this.getImageArray();
        for (int iter = 0; iter < imageArray.length; ++iter) {
            int alpha = imageArray[iter] >> 24 & 0xFF;
            if (alpha == 0) continue;
            alpha = Math.min(alpha + value, 255);
            imageArray[iter] = alpha << 24 & 0xFF000000 | this.color;
        }
    }

    void drawChars(Graphics g, char[] data, int offset, int length, int x, int y) {
        if (Display.getInstance().isBidiAlgorithm()) {
            for (int i = offset; i < length; ++i) {
                if (!Display.getInstance().isRTL(data[i])) continue;
                String s = Display.getInstance().convertBidiLogicalToVisual(new String(data, offset, length));
                data = s.toCharArray();
                offset = 0;
                length = s.length();
                break;
            }
        }
        this.initColor(g);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (clipY <= y + this.getHeight() && clipY + clipHeight >= y) {
            for (int i = 0; i < length; ++i) {
                char c = data[offset + i];
                int position = this.charsets.indexOf(c);
                if (position < 0) continue;
                g.clipRect(x, y, this.charWidth[position], this.imageHeight);
                if (g.getClipWidth() > 0 && g.getClipHeight() > 0) {
                    g.drawImage(this.cache, x - this.cutOffsets[position], y);
                }
                x += this.charWidth[position];
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        }
    }

    public String getCharset() {
        return this.charsets;
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int retVal = 0;
        for (int i = 0; i < length; ++i) {
            retVal += this.charWidth(ch[i + offset]);
        }
        return retVal;
    }

    public int substringWidth(String str, int offset, int len) {
        return this.charsWidth(str.toCharArray(), offset, len);
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return this.substringWidth(str, 0, str.length());
    }

    public int getFace() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public int getStyle() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            CustomFont f = (CustomFont)o;
            if (this.charsets.equals(f.charsets)) {
                for (int iter = 0; iter < this.cutOffsets.length; ++iter) {
                    if (this.cutOffsets[iter] == f.cutOffsets[iter]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

