/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class MenuBar
extends Container
implements ActionListener {
    public Command selectCommand;
    public Command defaultCommand;
    public Command backCommand;
    public Command clearCommand;
    static int leftSK;
    static int rightSK;
    static int rightSK2;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    public Command menuCommand;
    public Vector commands = new Vector();
    public Button[] soft;
    public Command[] softCommand;
    public Button left;
    public Button right;
    public Button main;
    public ListCellRenderer menuCellRenderer;
    public Transition transitionIn;
    public Transition transitionOut;
    public Component commandList;
    public Style menuStyle;
    public Command selectMenuItem;
    public Command cancelMenuItem;
    public Form parent;
    public int softkeyCount;
    public boolean thirdSoftButton;

    protected void initMenuBar(Form parent) {
        this.parent = parent;
        this.selectMenuItem = this.createMenuSelectCommand();
        this.cancelMenuItem = this.createMenuCancelCommand();
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
        this.setUIID("SoftButton");
        this.menuCommand = new Command(UIManager.getInstance().localize("menu", "Menu"), lf.getMenuIcons()[2]);
        if (lf.getDefaultMenuTransitionIn() != null || lf.getDefaultMenuTransitionOut() != null) {
            this.transitionIn = lf.getDefaultMenuTransitionIn();
            this.transitionOut = lf.getDefaultMenuTransitionOut();
        } else {
            this.transitionIn = CommonTransitions.createSlide(1, true, 300, true);
            this.transitionOut = CommonTransitions.createSlide(1, false, 300, true);
        }
        this.menuCellRenderer = lf.getMenuRenderer();
        this.softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
        this.thirdSoftButton = Display.getInstance().isThirdSoftButton();
        int commandBehavior = this.getCommandBehavior();
        if (this.softkeyCount > 1 && commandBehavior < 4) {
            Button b;
            if (this.thirdSoftButton) {
                this.setLayout(new GridLayout(1, 3));
                this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[1];
                this.right = this.soft[2];
                if (parent.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.main);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.main);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    b = this.soft[1];
                    this.soft[1] = this.soft[2];
                    this.soft[2] = b;
                }
            } else {
                this.setLayout(new GridLayout(1, 2));
                this.soft = new Button[]{this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[0];
                this.right = this.soft[1];
                if (parent.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    b = this.soft[0];
                    this.soft[0] = this.soft[1];
                    this.soft[1] = b;
                }
            }
            for (int iter = 0; iter < this.soft.length; ++iter) {
                this.soft[iter].setEndsWith3Points(false);
            }
        } else if (this.thirdSoftButton) {
            this.setLayout(new GridLayout(1, 3));
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
            this.main = this.soft[0];
            this.left = this.soft[1];
            this.right = this.soft[2];
            this.addComponent(this.left);
            this.addComponent(this.main);
            this.addComponent(this.right);
            if (this.isReverseSoftButtons()) {
                Button b = this.soft[1];
                this.soft[1] = this.soft[2];
                this.soft[2] = b;
            }
        } else {
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter")};
        }
        this.softCommand = new Command[this.soft.length];
    }

    private int getCommandBehavior() {
        int i = Display.getInstance().getCommandBehavior();
        if (Display.getInstance().getImplementation().getSoftkeyCount() == 0) {
            if (i != 4 && i != 5 && i != 6) {
                return 5;
            }
            return i;
        }
        if (i == 1) {
            if (Display.getInstance().isTouchScreenDevice()) {
                return 3;
            }
            return 2;
        }
        return i;
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public Command getDefaultCommand() {
        if (this.selectCommand != null) {
            return this.selectCommand;
        }
        return this.defaultCommand;
    }

    public void setClearCommand(Command clearCommand) {
        this.clearCommand = clearCommand;
    }

    public Command getClearCommand() {
        return this.clearCommand;
    }

    private Button findCommandComponent(Command c) {
        Button b = this.findCommandComponent(c, this);
        if (b == null) {
            return this.findCommandComponent(c, this.parent.getTitleArea());
        }
        return b;
    }

    private Button findCommandComponent(Command c, Container cnt) {
        int count = cnt.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component current = cnt.getComponentAt(iter);
            if (current instanceof Button) {
                Button b = (Button)current;
                if (b.getCommand() != c) continue;
                return b;
            }
            if (!(current instanceof Container)) continue;
            this.findCommandComponent(c, (Container)current);
        }
        return null;
    }

    private void moveCommandToTitle(Container title, Command c) {
        Button b = this.findCommandComponent(c);
        if (b != null) {
            b.getParent().removeComponent(b);
        } else {
            b = new Button(c);
        }
        b.setUIID("TitleCommand");
        title.addComponent(b);
    }

    private void adaptTitleLayoutBackCommandStructure() {
        Container t = this.parent.getTitleArea();
        if (t.getComponentCount() == 3) {
            return;
        }
        BorderLayout titleLayout = (BorderLayout)t.getLayout();
        titleLayout.setCenterBehavior(2);
        t.removeAll();
        t.addComponent("Center", (Component)this.parent.getTitleComponent());
        Container leftContainer = new Container(new BoxLayout(1));
        Container rightContainer = new Container(new BoxLayout(1));
        t.addComponent("East", (Component)rightContainer);
        t.addComponent("West", (Component)leftContainer);
    }

    private Container findLeftTitleContainer() {
        return (Container)((BorderLayout)this.parent.getTitleArea().getLayout()).getWest();
    }

    private Container findRightTitleContainer() {
        return (Container)((BorderLayout)this.parent.getTitleArea().getLayout()).getEast();
    }

    private void updateTitleCommandPlacement() {
        int commandBehavior = this.getCommandBehavior();
        Container t = this.parent.getTitleArea();
        BorderLayout titleLayout = (BorderLayout)t.getLayout();
        if (this.getParent() == null) {
            this.installMenuBar();
        } else if (this.getParent() == this.parent.getTitleArea() && commandBehavior != 6) {
            this.getParent().removeComponent(this);
            this.installMenuBar();
        }
        if (!(this.parent instanceof Dialog)) {
            if (commandBehavior == 5 && this.parent.getTitle() != null && this.parent.getTitle().length() > 0) {
                this.synchronizeCommandsWithButtonsInBackbutton();
                return;
            }
            if (commandBehavior == 6 || commandBehavior == 5) {
                if (this.getParent() != null) {
                    if (this.getParent() == this.parent.getTitleArea()) {
                        return;
                    }
                    this.getParent().removeComponent(this);
                }
                this.parent.getTitleArea().addComponent("East", (Component)this);
                return;
            }
        }
        if (t.getComponentCount() > 1) {
            titleLayout.setCenterBehavior(0);
            Label l = this.parent.getTitleComponent();
            t.removeAll();
            t.addComponent("Center", (Component)l);
        }
    }

    public void setBackCommand(Command backCommand) {
        int i;
        this.backCommand = backCommand;
        if (this.getCommandBehavior() == 5 && (i = this.commands.indexOf(backCommand)) > -1) {
            this.commands.removeElementAt(i);
        }
        this.updateTitleCommandPlacement();
    }

    public Command getBackCommand() {
        return this.backCommand;
    }

    public Command getSelectCommand() {
        return this.selectCommand;
    }

    public void setSelectCommand(Command selectCommand) {
        this.selectCommand = selectCommand;
    }

    private void updateCommands() {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior == 10) {
            Display.getInstance().getImplementation().setNativeCommands(this.commands);
            return;
        }
        if (commandBehavior >= 4) {
            return;
        }
        if (this.soft.length > 1) {
            this.soft[0].setText("");
            this.soft[1].setText("");
            this.soft[0].setIcon(null);
            this.soft[1].setIcon(null);
            int commandSize = this.getCommandCount();
            if (this.soft.length > 2) {
                this.soft[2].setText("");
                if (commandSize > 2) {
                    this.softCommand[2] = commandSize > 3 ? this.menuCommand : this.getCommand(this.getCommandCount() - 3);
                    this.soft[2].setText(this.softCommand[2].getCommandName());
                    this.soft[2].setIcon(this.softCommand[2].getIcon());
                } else {
                    this.softCommand[2] = null;
                }
            }
            if (commandSize > 0) {
                this.softCommand[0] = this.getCommand(this.getCommandCount() - 1);
                this.soft[0].setText(this.softCommand[0].getCommandName());
                this.soft[0].setIcon(this.softCommand[0].getIcon());
                if (commandSize > 1) {
                    this.softCommand[1] = this.soft.length == 2 && commandSize > 2 ? this.menuCommand : this.getCommand(this.getCommandCount() - 2);
                    this.soft[1].setText(this.softCommand[1].getCommandName());
                    this.soft[1].setIcon(this.softCommand[1].getIcon());
                } else {
                    this.softCommand[1] = null;
                }
            } else {
                this.softCommand[0] = null;
                this.softCommand[1] = null;
            }
            if (commandSize == 1 && this.parent.isVisible()) {
                this.parent.revalidate();
            }
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        Object src = evt.getSource();
        if (this.commandList == null) {
            Button source = (Button)src;
            for (int iter = 0; iter < this.soft.length; ++iter) {
                if (source != this.soft[iter]) continue;
                if (this.softCommand[iter] == this.menuCommand) {
                    this.showMenu();
                    return;
                }
                if (this.softCommand[iter] != null) {
                    ActionEvent e = new ActionEvent(this.softCommand[iter]);
                    this.softCommand[iter].actionPerformed(e);
                    if (!e.isConsumed()) {
                        this.parent.actionCommandImpl(this.softCommand[iter]);
                    }
                }
                return;
            }
        } else {
            Command c;
            if (src instanceof Button) {
                for (int iter = 0; iter < this.soft.length; ++iter) {
                    if (src != this.soft[iter]) continue;
                    for (Container parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof Dialog)) continue;
                        ((Dialog)parent).actionCommand(this.softCommand[iter]);
                        return;
                    }
                }
            }
            if (!(c = this.getComponentSelectedCommand(this.commandList)).isEnabled()) {
                return;
            }
            for (Container p = this.commandList.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof Dialog)) continue;
                ((Dialog)p).actionCommand(c);
                return;
            }
        }
    }

    protected Button createSoftButton(String uiid) {
        Button b = new Button();
        b.setUIID(uiid);
        b.addActionListener(this);
        b.setFocusable(false);
        b.setTactileTouch(true);
        this.updateSoftButtonStyle(b);
        return b;
    }

    private void updateSoftButtonStyle(Button b) {
        if (this.softkeyCount < 2) {
            b.getStyle().setMargin(0, 0, 0, 0);
            b.getStyle().setPadding(0, 0, 0, 0);
        }
    }

    public void setUnselectedStyle(Style style) {
        style.setMargin(0, 0, true);
        style.setMargin(2, 0, true);
        super.setUnselectedStyle(style);
        if (this.soft != null) {
            for (int iter = 0; iter < this.soft.length; ++iter) {
                this.updateSoftButtonStyle(this.soft[iter]);
            }
        }
    }

    protected Dimension calcPreferredSize() {
        if (this.soft.length > 1) {
            Dimension d = super.calcPreferredSize();
            if (!(this.soft[0].getText() != null && !this.soft[0].getText().equals("") || this.soft[1].getText() != null && !this.soft[1].getText().equals("") || this.soft[0].getIcon() != null || this.soft[1].getIcon() != null || this.soft.length >= 3 && (this.soft[2].getText() != null && !this.soft[2].getText().equals("") || this.soft[2].getIcon() != null))) {
                d.setHeight(0);
            }
            return d;
        }
        return super.calcPreferredSize();
    }

    public void setTransitions(Transition transitionIn, Transition transitionOut) {
        this.transitionIn = transitionIn;
        this.transitionOut = transitionOut;
    }

    public void showMenu() {
        Form upcoming;
        Command result;
        Dialog d = new Dialog("Menu", "");
        d.setDisposeWhenPointerOutOfBounds(true);
        d.setMenu(true);
        d.setTransitionInAnimator(this.transitionIn);
        d.setTransitionOutAnimator(this.transitionOut);
        d.setLayout(new BorderLayout());
        d.setScrollable(false);
        d.getMenuBar().commandList = this.createCommandComponent(this.commands);
        if (this.menuCellRenderer != null && d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).setListCellRenderer(this.menuCellRenderer);
        }
        d.getContentPane().getStyle().setMargin(0, 0, 0, 0);
        d.addComponent("Center", d.getMenuBar().commandList);
        if (this.thirdSoftButton) {
            d.addCommand(this.selectMenuItem);
            d.addCommand(this.cancelMenuItem);
        } else {
            d.addCommand(this.cancelMenuItem);
            if (this.soft.length > 1) {
                d.addCommand(this.selectMenuItem);
            }
        }
        d.setClearCommand(this.cancelMenuItem);
        d.setBackCommand(this.cancelMenuItem);
        if (d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).addActionListener(d.getMenuBar());
        }
        if ((result = this.showMenuDialog(d)) != this.cancelMenuItem) {
            Command c = null;
            if (result == this.selectMenuItem) {
                c = this.getComponentSelectedCommand(d.getMenuBar().commandList);
                if (c != null) {
                    ActionEvent e = new ActionEvent(c);
                    c.actionPerformed(e);
                }
            } else {
                c = result;
                if (!UIManager.getInstance().getLookAndFeel().isTouchMenus() && (c = result) != null) {
                    ActionEvent e = new ActionEvent(c);
                    c.actionPerformed(e);
                }
            }
            if (c != null) {
                this.parent.actionCommandImpl(c);
            }
        }
        if (d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).removeActionListener(d.getMenuBar());
        }
        if ((upcoming = Display.getInstance().getCurrentUpcoming()) == this.parent) {
            d.disposeImpl();
        } else {
            this.parent.tint = upcoming instanceof Dialog;
        }
    }

    Button[] getSoftButtons() {
        return this.soft;
    }

    private void addTwoTitleButtons(Container leftContainer, Container rightContainer) {
        this.ensureCommandsInContainer(this.getCommand(0), null, rightContainer, "TitleCommand", null);
        if (this.parent.getBackCommand() != null) {
            this.ensureCommandsInContainer(this.parent.getBackCommand(), null, leftContainer, "BackCommand", null);
            this.updateGridCommands(1);
        } else {
            this.ensureCommandsInContainer(this.getCommand(1), null, leftContainer, "TitleCommand", null);
            this.updateGridCommands(2);
        }
    }

    private void updateGridCommands(int startOffset) {
        int cmdCount = this.getCommandCount() - startOffset;
        if (cmdCount <= 0) {
            return;
        }
        this.setLayout(new GridLayout(1, cmdCount));
        while (cmdCount < this.getComponentCount()) {
            this.removeComponent(this.getComponentAt(this.getComponentCount() - 1));
        }
        int off = startOffset;
        while (this.getComponentCount() < cmdCount) {
            Button btn = new Button(this.getCommand(off));
            btn.setUIID("TouchCommand");
            ++off;
            this.addComponent(btn);
        }
        for (int iter = 0; iter < cmdCount; ++iter) {
            Button btn = (Button)this.getComponentAt(iter);
            if (btn.getCommand() == this.getCommand(iter + startOffset)) continue;
            btn.setCommand(this.getCommand(iter + startOffset));
        }
    }

    private void synchronizeCommandsWithButtonsInBackbutton() {
        this.adaptTitleLayoutBackCommandStructure();
        Container leftContainer = this.findLeftTitleContainer();
        Container rightContainer = this.findRightTitleContainer();
        int componentCount = this.getCommandCount();
        if (this.parent.getBackCommand() != null) {
            if (leftContainer.getComponentCount() == 0) {
                Button back = new Button(this.parent.getBackCommand());
                leftContainer.addComponent(back);
                back.setUIID("BackCommand");
            } else {
                Button b = (Button)leftContainer.getComponentAt(0);
                if (b.getCommand() != this.parent.getBackCommand()) {
                    b.setCommand(this.parent.getBackCommand());
                    b.setUIID("BackCommand");
                }
            }
            ++componentCount;
        }
        switch (componentCount) {
            case 0: {
                leftContainer.removeAll();
                rightContainer.removeAll();
                this.removeAll();
                break;
            }
            case 1: {
                if (this.parent.getBackCommand() != null) {
                    rightContainer.removeAll();
                    this.ensureCommandsInContainer(this.parent.getBackCommand(), null, leftContainer, "BackCommand", null);
                } else {
                    leftContainer.removeAll();
                    this.ensureCommandsInContainer(this.getCommand(0), null, rightContainer, "TitleCommand", null);
                }
                this.removeAll();
                break;
            }
            case 2: {
                this.addTwoTitleButtons(leftContainer, rightContainer);
                break;
            }
            case 3: {
                if (Display.getInstance().isTablet()) {
                    this.ensureCommandsInContainer(this.getCommand(0), this.getCommand(2), rightContainer, "TitleCommand", "TitleCommand");
                    if (this.parent.getBackCommand() != null) {
                        this.ensureCommandsInContainer(this.parent.getBackCommand(), null, leftContainer, "BackCommand", null);
                    } else {
                        this.ensureCommandsInContainer(this.getCommand(1), null, leftContainer, "TitleCommand", null);
                    }
                    this.removeAll();
                    break;
                }
                this.addTwoTitleButtons(leftContainer, rightContainer);
                break;
            }
            default: {
                if (Display.getInstance().isTablet()) {
                    this.ensureCommandsInContainer(this.getCommand(0), this.getCommand(2), rightContainer, "TitleCommand", "TitleCommand");
                    if (this.parent.getBackCommand() != null) {
                        this.ensureCommandsInContainer(this.parent.getBackCommand(), this.getCommand(1), leftContainer, "BackCommand", "TitleCommand");
                        this.updateGridCommands(3);
                        break;
                    }
                    this.ensureCommandsInContainer(this.getCommand(1), this.getCommand(3), leftContainer, "TitleCommand", "TitleCommand");
                    this.updateGridCommands(4);
                    break;
                }
                this.addTwoTitleButtons(leftContainer, rightContainer);
            }
        }
    }

    private void ensureCommandsInContainer(Command a2, Command b, Container c, String styleA, String styleB) {
        if (c.getComponentCount() == 0) {
            Button btn = new Button(a2);
            btn.setUIID(styleA);
            c.addComponent(btn);
            if (b != null) {
                btn = new Button(b);
                btn.setUIID(styleB);
                c.addComponent(btn);
            }
            return;
        }
        if (c.getComponentCount() == 1) {
            Button btn = (Button)c.getComponentAt(0);
            btn.setUIID(styleA);
            if (btn.getCommand() != a2) {
                btn.setCommand(a2);
            }
            if (b != null) {
                btn = new Button(b);
                btn.setUIID(styleB);
                c.addComponent(btn);
            }
            return;
        }
        if (c.getComponentCount() == 2) {
            Button btn = (Button)c.getComponentAt(0);
            btn.setUIID(styleA);
            if (btn.getCommand() != a2) {
                btn.setCommand(a2);
            }
            if (b != null) {
                btn = (Button)c.getComponentAt(1);
                btn.setUIID(styleB);
                if (btn.getCommand() != b) {
                    btn.setCommand(b);
                }
            } else {
                c.removeComponent(c.getComponentAt(1));
            }
            return;
        }
    }

    public void addCommand(Command cmd) {
        int behavior;
        if (this.commands.contains(cmd)) {
            return;
        }
        if (this.soft.length > 2 && cmd == this.parent.getDefaultCommand()) {
            this.commands.addElement(cmd);
        } else {
            this.commands.insertElementAt(cmd, 0);
        }
        if (!(this.parent instanceof Dialog || (behavior = this.getCommandBehavior()) != 4 && behavior != 5 && behavior != 6)) {
            if (behavior == 5 && (cmd == this.parent.getBackCommand() || this.findCommandComponent(cmd) != null)) {
                return;
            }
            if (this.parent.getBackCommand() != cmd) {
                if (behavior == 5 && this.parent.getTitle() != null && this.parent.getTitle().length() > 0) {
                    this.synchronizeCommandsWithButtonsInBackbutton();
                    return;
                }
                this.setLayout(new GridLayout(1, this.getCommandCount()));
                this.addComponent(this.createTouchCommandButton(cmd));
            } else {
                this.commands.removeElement(cmd);
            }
            return;
        }
        this.updateCommands();
    }

    public Command getCommand(int index) {
        return (Command)this.commands.elementAt(index);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    protected void addCommand(Command cmd, int index) {
        int behavior;
        if (this.getCommandCount() == 0 && this.parent != null) {
            this.installMenuBar();
        }
        if (this.commands.contains(cmd)) {
            return;
        }
        this.commands.insertElementAt(cmd, index);
        if (!(this.parent instanceof Dialog || (behavior = this.getCommandBehavior()) != 4 && behavior != 5 && behavior != 6)) {
            if (behavior == 5 && cmd == this.parent.getBackCommand()) {
                return;
            }
            if (behavior == 5 && this.parent.getTitle() != null && this.parent.getTitle().length() > 0) {
                this.synchronizeCommandsWithButtonsInBackbutton();
                return;
            }
            if (this.parent.getBackCommand() != cmd) {
                this.setLayout(new GridLayout(1, this.getCommandCount()));
                this.addComponent(index, (Component)this.createTouchCommandButton(cmd));
                this.revalidate();
            } else {
                this.commands.removeElement(cmd);
            }
            return;
        }
        this.updateCommands();
    }

    protected void installMenuBar() {
        if (this.getParent() == null) {
            int type = Display.getInstance().getCommandBehavior();
            if (type == 6) {
                this.parent.getTitleArea().addComponent("East", (Component)this);
                return;
            }
            if (this.softkeyCount > 1 || type == 4 || type == 5) {
                this.parent.addComponentToForm("South", this);
            }
        }
    }

    protected void unInstallMenuBar() {
        this.parent.removeComponentFromForm(this);
        Container t = this.parent.getTitleArea();
        BorderLayout titleLayout = (BorderLayout)t.getLayout();
        titleLayout.setCenterBehavior(0);
        Label l = this.parent.getTitleComponent();
        t.removeAll();
        if (l.getParent() != null) {
            l.getParent().removeComponent(l);
        }
        t.addComponent("Center", (Component)l);
    }

    protected void removeAllCommands() {
        this.commands.removeAllElements();
        int behavior = this.getCommandBehavior();
        if (behavior == 4 || behavior == 5 || behavior == 6) {
            this.parent.getTitleArea().removeAll();
            this.parent.getTitleArea().addComponent("Center", (Component)this.parent.getTitleComponent());
            this.removeAll();
            return;
        }
        this.updateCommands();
    }

    protected void removeCommand(Command cmd) {
        int behavior = this.getCommandBehavior();
        if (behavior == 4 || behavior == 5 || behavior == 6) {
            int i = this.commands.indexOf(cmd);
            if (i > -1) {
                this.commands.removeElementAt(i);
                Button b = this.findCommandComponent(cmd);
                if (b != null) {
                    this.removeComponent(b);
                }
                if (this.getCommandCount() > 0) {
                    this.setLayout(new GridLayout(1, this.getCommandCount()));
                }
            }
            return;
        }
        this.commands.removeElement(cmd);
        this.updateCommands();
    }

    void addSelectCommand(String selectText) {
        if (this.thirdSoftButton) {
            if (this.selectCommand == null) {
                this.selectCommand = this.createSelectCommand();
            }
            this.selectCommand.setCommandName(selectText);
            this.addCommand(this.selectCommand);
        }
    }

    void removeSelectCommand() {
        if (this.thirdSoftButton) {
            this.removeCommand(this.selectCommand);
        }
    }

    protected Command createSelectCommand() {
        return new Command(UIManager.getInstance().localize("select", "Select"));
    }

    protected Command createMenuSelectCommand() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("select", "Select"), lf.getMenuIcons()[0]);
    }

    protected Command createMenuCancelCommand() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("cancel", "Cancel"), lf.getMenuIcons()[1]);
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuCellRenderer = menuCellRenderer;
    }

    public Style getMenuStyle() {
        return this.menuStyle;
    }

    static boolean isLSK(int keyCode) {
        return keyCode == leftSK;
    }

    static boolean isRSK(int keyCode) {
        return keyCode == rightSK || keyCode == rightSK2;
    }

    public boolean handlesKeycode(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        return keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK && this.clearCommand != null || keyCode == backspaceSK && this.clearCommand != null || this.thirdSoftButton && game == 8;
    }

    public void keyPressed(int keyCode) {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior >= 4) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (keyCode == leftSK) {
                if (this.left != null) {
                    this.left.pressed();
                }
            } else if (keyCode == rightSK || keyCode == rightSK2) {
                if (this.right != null) {
                    this.right.pressed();
                }
            } else if (Display.getInstance().getGameAction(keyCode) == 8) {
                this.main.pressed();
            }
        }
    }

    public void keyReleased(int keyCode) {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior >= 4 && keyCode != backSK && keyCode != clearSK && keyCode != backspaceSK) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (this.softkeyCount < 2 && keyCode == leftSK) {
                if (this.commandList != null) {
                    for (Container parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof Dialog) || !((Dialog)parent).isMenu()) continue;
                        return;
                    }
                }
                this.showMenu();
                return;
            }
            if (keyCode == leftSK) {
                if (this.left != null) {
                    this.left.released();
                }
                return;
            }
            if (keyCode == rightSK || keyCode == rightSK2) {
                if (this.right != null) {
                    this.right.released();
                }
                return;
            }
            if (Display.getInstance().getGameAction(keyCode) == 8) {
                this.main.released();
                return;
            }
        }
        Command c = null;
        if (keyCode == backSK) {
            c = this.parent.getBackCommand();
        } else if (keyCode == clearSK || keyCode == backspaceSK) {
            c = this.getClearCommand();
        }
        if (c != null) {
            ActionEvent ev = new ActionEvent(c, keyCode);
            c.actionPerformed(ev);
            if (!ev.isConsumed()) {
                this.parent.actionCommandImpl(c);
            }
        }
    }

    public void refreshTheme() {
        super.refreshTheme();
        if (this.menuStyle.isModified()) {
            this.menuStyle.merge(UIManager.getInstance().getComponentStyle("Menu"));
        } else {
            this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
        }
        if (this.menuCellRenderer != null) {
            List tmp = new List();
            tmp.setListCellRenderer(this.menuCellRenderer);
            tmp.refreshTheme();
        }
        for (int iter = 0; iter < this.soft.length; ++iter) {
            this.updateSoftButtonStyle(this.soft[iter]);
        }
        this.revalidate();
    }

    protected Command showMenuDialog(Dialog menu) {
        int height;
        int marginLeft;
        boolean pref = UIManager.getInstance().isThemeConstant("menuPrefSizeBool", false);
        int marginRight = 0;
        if (pref) {
            Container dialogContentPane = menu.getDialogComponent();
            marginLeft = this.parent.getWidth() - (dialogContentPane.getPreferredW() + menu.getStyle().getPadding(1) + menu.getStyle().getPadding(3));
            marginLeft = Math.max(0, marginLeft);
            height = this.parent.getSoftButtonCount() > 1 ? this.parent.getHeight() - this.parent.getSoftButton(0).getParent().getPreferredH() - dialogContentPane.getPreferredH() : this.parent.getHeight() - dialogContentPane.getPreferredH();
            height = Math.max(0, height);
        } else {
            float menuWidthPercent = 1.0f - Float.parseFloat(UIManager.getInstance().getThemeConstant("menuWidthPercent", "75")) / 100.0f;
            float menuHeightPercent = 1.0f - Float.parseFloat(UIManager.getInstance().getThemeConstant("menuHeightPercent", "50")) / 100.0f;
            height = (int)((float)this.parent.getHeight() * menuHeightPercent);
            marginLeft = (int)((float)this.parent.getWidth() * menuWidthPercent);
        }
        if (this.isReverseSoftButtons()) {
            marginRight = marginLeft;
            marginLeft = 0;
        }
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus() && UIManager.getInstance().isThemeConstant("PackTouchMenuBool", true)) {
            return menu.showPacked("South", true);
        }
        return menu.show(height, 0, marginLeft, marginRight, true);
    }

    protected boolean isReverseSoftButtons() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        if (this.isRTL()) {
            return !lf.isReverseSoftButtons();
        }
        return lf.isReverseSoftButtons();
    }

    protected int calculateTouchCommandGridColumns(Container grid) {
        int count = grid.getComponentCount();
        int maxWidth = 0;
        for (int iter = 0; iter < count; ++iter) {
            Component c = grid.getComponentAt(iter);
            Style s = c.getUnselectedStyle();
            maxWidth = Math.max(maxWidth, c.getPreferredW() + s.getMargin(false, 1) + s.getMargin(false, 3));
        }
        return Math.max(2, Display.getInstance().getDisplayWidth() / maxWidth);
    }

    protected Button createTouchCommandButton(Command c) {
        Button b = new Button(c);
        if (b.getIcon() == null) {
            b.setIcon(UIManager.getInstance().getThemeImageConstant("defaultCommandImage"));
        }
        b.setTactileTouch(true);
        b.setTextPosition(2);
        b.setEndsWith3Points(false);
        b.setUIID("TouchCommand");
        return b;
    }

    protected Component createCommandComponent(Vector commands) {
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus()) {
            Container menu = new Container();
            menu.setScrollableY(true);
            for (int iter = 0; iter < commands.size(); ++iter) {
                Command c = (Command)commands.elementAt(iter);
                menu.addComponent(this.createTouchCommandButton(c));
            }
            if (!UIManager.getInstance().isThemeConstant("touchCommandFlowBool", false)) {
                int rows;
                int cols = this.calculateTouchCommandGridColumns(menu);
                if (cols > this.getCommandCount()) {
                    cols = this.getCommandCount();
                }
                if ((rows = Math.max(1, this.getCommandCount() / cols + (this.getCommandCount() % cols != 0 ? 1 : 0))) > 1) {
                    int remainingColumns = rows * cols % this.getCommandCount();
                    int newCols = cols;
                    int newRows = rows;
                    while (remainingColumns != 0 && remainingColumns > 1 && newCols >= 2 && (newRows = Math.max(1, this.getCommandCount() / --newCols + (this.getCommandCount() % newCols != 0 ? 1 : 0))) == rows) {
                        remainingColumns = newRows * newCols % this.getCommandCount();
                    }
                    if (newRows == rows) {
                        cols = newCols;
                        rows = newRows;
                    }
                }
                GridLayout g = new GridLayout(rows, cols);
                g.setFillLastRow(UIManager.getInstance().isThemeConstant("touchCommandFillBool", true));
                menu.setLayout(g);
            } else {
                ((FlowLayout)menu.getLayout()).setFillRows(true);
            }
            menu.setPreferredW(Display.getInstance().getDisplayWidth());
            return menu;
        }
        return this.createCommandList(commands);
    }

    protected Vector getCommands() {
        return this.commands;
    }

    protected List createCommandList(Vector commands) {
        List l = new List(commands);
        l.setUIID("CommandList");
        Component c = (Component)((Object)l.getRenderer());
        c.setUIID("Command");
        c = l.getRenderer().getListFocusComponent(l);
        c.setUIID("CommandFocus");
        l.setFixedSelection(1);
        if (UIManager.getInstance().isThemeConstant("menuPrefSizeBool", false)) {
            l.setListSizeCalculationSampleCount(50);
        }
        return l;
    }

    Command getComponentSelectedCommand(Component cmp) {
        if (cmp instanceof List) {
            List l = (List)cmp;
            return (Command)l.getSelectedItem();
        }
        if ((cmp = cmp.getComponentForm().getFocused()) instanceof Button) {
            return ((Button)cmp).getCommand();
        }
        return null;
    }

    protected Command getSelectMenuItem() {
        return this.selectMenuItem;
    }

    protected Command getCancelMenuItem() {
        return this.cancelMenuItem;
    }

    static {
        if (Display.getInstance() == null || Display.getInstance().getImplementation() == null) {
            leftSK = -6;
            rightSK = -7;
            rightSK2 = -7;
            backSK = -11;
            clearSK = -8;
            backspaceSK = -8;
        }
    }
}

