/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

public class Motion {
    static final int LINEAR = 0;
    static final int SPLINE = 1;
    int motionType;
    public static final int FRICTION = 2;
    public int sourceValue;
    public int destinationValue;
    public int duration;
    public long startTime;
    public float initVelocity;
    public float friction;
    public int lastReturnedValue;
    public long currentMotionTime = -1L;

    protected Motion(int sourceValue, int destinationValue, int duration) {
        this.sourceValue = sourceValue;
        this.destinationValue = destinationValue;
        this.duration = duration;
        this.lastReturnedValue = sourceValue;
    }

    protected Motion(int sourceValue, float initVelocity, float friction) {
        this.sourceValue = sourceValue;
        this.initVelocity = initVelocity;
        this.friction = friction;
        this.duration = (int)(Math.abs(initVelocity) / friction);
    }

    public static Motion createLinearMotion(int sourceValue, int destinationValue, int duration) {
        Motion l = new Motion(sourceValue, destinationValue, duration);
        l.motionType = 0;
        return l;
    }

    public static Motion createSplineMotion(int sourceValue, int destinationValue, int duration) {
        Motion spline = new Motion(sourceValue, destinationValue, duration);
        spline.motionType = 1;
        return spline;
    }

    public static Motion createFrictionMotion(int sourceValue, int maxValue, float initVelocity, float friction) {
        Motion frictionMotion = new Motion(sourceValue, initVelocity, friction);
        frictionMotion.destinationValue = maxValue;
        frictionMotion.motionType = 2;
        return frictionMotion;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long getCurrentMotionTime() {
        if (this.currentMotionTime < 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.currentMotionTime;
    }

    public void setCurrentMotionTime(long currentMotionTime) {
        this.currentMotionTime = currentMotionTime;
        if (this.lastReturnedValue == this.destinationValue) {
            this.lastReturnedValue = this.sourceValue;
        }
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public boolean isFinished() {
        if (this.currentMotionTime < 0L) {
            return this.getCurrentMotionTime() > (long)this.duration || this.destinationValue == this.lastReturnedValue;
        }
        return this.getCurrentMotionTime() > (long)this.duration || this.destinationValue == this.lastReturnedValue;
    }

    private int getSplineValue() {
        if (this.isFinished()) {
            return this.destinationValue;
        }
        float totalTime = this.duration;
        float currentTime = (int)this.getCurrentMotionTime();
        if (this.currentMotionTime > -1L) {
            currentTime -= (float)this.startTime;
            totalTime -= (float)this.startTime;
        }
        currentTime = Math.min(currentTime, totalTime);
        int p = Math.abs(this.destinationValue - this.sourceValue);
        float centerTime = totalTime / 2.0f;
        float l = (float)p / (centerTime * centerTime);
        int x = this.sourceValue < this.destinationValue ? (currentTime > centerTime ? this.sourceValue + (int)(l * (-centerTime * centerTime + 2.0f * centerTime * currentTime - currentTime * currentTime / 2.0f)) : this.sourceValue + (int)(l * currentTime * currentTime / 2.0f)) : ((currentTime = totalTime - currentTime) > centerTime ? this.destinationValue + (int)(l * (-centerTime * centerTime + 2.0f * centerTime * currentTime - currentTime * currentTime / 2.0f)) : this.destinationValue + (int)(l * currentTime * currentTime / 2.0f));
        return x;
    }

    public int getValue() {
        if (this.currentMotionTime > -1L && this.startTime > this.getCurrentMotionTime()) {
            return this.sourceValue;
        }
        switch (this.motionType) {
            case 1: {
                this.lastReturnedValue = this.getSplineValue();
                break;
            }
            case 2: {
                this.lastReturnedValue = this.getFriction();
                break;
            }
            default: {
                this.lastReturnedValue = this.getLinear();
            }
        }
        return this.lastReturnedValue;
    }

    private int getLinear() {
        if (this.isFinished()) {
            return this.destinationValue;
        }
        float totalTime = this.duration;
        float currentTime = (int)this.getCurrentMotionTime();
        if (this.currentMotionTime > -1L) {
            currentTime -= (float)this.startTime;
            totalTime -= (float)this.startTime;
        }
        int dis = this.destinationValue - this.sourceValue;
        int val = (int)((float)this.sourceValue + currentTime / totalTime * (float)dis);
        if (this.destinationValue < this.sourceValue) {
            return Math.max(this.destinationValue, val);
        }
        return Math.min(this.destinationValue, val);
    }

    private int getFriction() {
        int time = (int)this.getCurrentMotionTime();
        int retVal = 0;
        retVal = (int)(Math.abs(this.initVelocity) * (float)time - this.friction * ((float)time * (float)time / 2.0f));
        if (this.initVelocity < 0.0f) {
            retVal *= -1;
        }
        retVal += this.sourceValue;
        if (this.destinationValue > this.sourceValue) {
            return Math.min(retVal, this.destinationValue);
        }
        return Math.max(retVal, this.destinationValue);
    }

    public int getSourceValue() {
        return this.sourceValue;
    }

    public int getDestinationValue() {
        return this.destinationValue;
    }

    public void setSourceValue(int sourceValue) {
        this.sourceValue = sourceValue;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    public int getDuration() {
        return this.duration;
    }
}

