/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public abstract class LookAndFeel {
    public Component verticalScroll;
    public Component horizontalScroll;
    public Component verticalScrollThumb;
    public Component horizontalScrollThumb;
    public boolean rtl;
    public long tickerSpeed = 50L;
    public int defaultFormTintColor = 0x77000000;
    public int disableColor = 0xCCCCCC;
    public Transition defaultFormTransitionIn;
    public Transition defaultFormTransitionOut;
    public Transition defaultMenuTransitionIn;
    public Transition defaultMenuTransitionOut;
    public Transition defaultDialogTransitionIn;
    public Transition defaultDialogTransitionOut;
    public boolean defaultSmoothScrolling = true;
    public boolean focusScrolling;
    public int defaultSmoothScrollingSpeed = 150;
    public boolean fadeScrollEdge;
    public boolean fadeScrollBar;
    public int fadeScrollEdgeLength = 15;
    public Image fadeScrollTop;
    public Image fadeScrollBottom;
    public Image fadeScrollRight;
    public Image fadeScrollLeft;
    public int fadeScrollEdgeStartAlpha = 0x999999;
    public int fadeScrollEdgeEndAlpha = 0;
    public int textFieldCursorColor;
    public boolean reverseSoftButtons;
    public ListCellRenderer menuRenderer;
    public Image[] menuIcons = new Image[3];
    public int tactileTouchDuration = 0;
    public boolean defaultEndsWith3Points = true;
    public boolean defaultTensileDrag = true;
    public boolean defaultTensileHighlight = false;
    public Class menuBar = class$com$sun$lwuit$MenuBar == null ? (class$com$sun$lwuit$MenuBar = LookAndFeel.class$("com.sun.lwuit.MenuBar")) : class$com$sun$lwuit$MenuBar;
    public boolean defaultSnapToGrid;
    public boolean defaultAlwaysTensile;
    public Image tensileHighlightTopImage;
    public Image tensileHighlightBottomImage;
    static /* synthetic */ Class class$com$sun$lwuit$MenuBar;

    public void bind(Component cmp) {
    }

    public void uninstall() {
    }

    public abstract void drawButton(Graphics var1, Button var2);

    public abstract void drawCheckBox(Graphics var1, Button var2);

    public abstract void drawComboBox(Graphics var1, List var2);

    public abstract void drawLabel(Graphics var1, Label var2);

    public abstract void drawList(Graphics var1, List var2);

    public abstract void drawRadioButton(Graphics var1, Button var2);

    public abstract void drawTextArea(Graphics var1, TextArea var2);

    public abstract void drawTextField(Graphics var1, TextArea var2);

    public abstract void drawTextFieldCursor(Graphics var1, TextArea var2);

    public abstract void drawTabbedPane(Graphics var1, TabbedPane var2);

    public abstract Dimension getButtonPreferredSize(Button var1);

    public abstract Dimension getCheckBoxPreferredSize(Button var1);

    public abstract Dimension getLabelPreferredSize(Label var1);

    public abstract Dimension getListPreferredSize(List var1);

    public abstract Dimension getRadioButtonPreferredSize(Button var1);

    public abstract Dimension getTextAreaSize(TextArea var1, boolean var2);

    public abstract Dimension getTextFieldPreferredSize(TextArea var1);

    public abstract Dimension getComboBoxPreferredSize(List var1);

    public void drawVerticalScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio) {
        if (this.verticalScroll == null) {
            this.initScroll();
        }
        int borderW = 0;
        if (c.getStyle().getBorder() != null) {
            borderW = c.getStyle().getBorder().getThickness();
        }
        int x = c.getX();
        x = !c.isRTL() ? (x += c.getWidth() - this.getVerticalScrollWidth() - borderW) : (x += borderW);
        int y = c.getY();
        int height = c.getHeight();
        int width = this.getVerticalScrollWidth();
        this.drawScroll(g, c, offsetRatio, blockSizeRatio, true, x, y, width, height, this.verticalScroll, this.verticalScrollThumb);
        if (this.fadeScrollEdge) {
            if (offsetRatio > 0.0f) {
                if (this.fadeScrollTop == null || Display.getInstance().getDisplayWidth() != this.fadeScrollTop.getWidth()) {
                    this.fadeScrollTop = this.generateFadeImage(this.fadeScrollEdgeStartAlpha, this.fadeScrollEdgeEndAlpha, c.getStyle().getBgColor(), false, Display.getInstance().getDisplayWidth(), this.fadeScrollEdgeLength);
                }
                g.drawImage(this.fadeScrollTop, c.getX(), c.getY());
            }
            if (offsetRatio < 1.0f - blockSizeRatio) {
                int totalScroll;
                int l = c.getScrollY() + c.getHeight() + c.getStyle().getMargin(0) + c.getStyle().getMargin(2) + c.getStyle().getPadding(0) + c.getStyle().getPadding(2);
                if (l >= (totalScroll = c.getScrollDimension().getHeight())) {
                    return;
                }
                if (this.fadeScrollBottom == null || Display.getInstance().getDisplayWidth() != this.fadeScrollBottom.getWidth()) {
                    this.fadeScrollBottom = this.generateFadeImage(this.fadeScrollEdgeEndAlpha, this.fadeScrollEdgeStartAlpha, c.getStyle().getBgColor(), false, Display.getInstance().getDisplayWidth(), this.fadeScrollEdgeLength);
                }
                g.drawImage(this.fadeScrollBottom, c.getX(), c.getY() + c.getHeight() - this.fadeScrollBottom.getHeight());
            }
        }
    }

    private Image generateFadeImage(int startColor, int endColor, int bgColor, boolean horizontal, int width, int height) {
        Image mute = Image.createImage(width, height);
        mute.getGraphics().fillLinearGradient(startColor, endColor, 0, 0, width, height, horizontal);
        Object mask = mute.createMask();
        mute = Image.createImage(width, height);
        Graphics gr = mute.getGraphics();
        gr.setColor(bgColor);
        gr.fillRect(0, 0, width, height);
        return mute.applyMask(mask);
    }

    public void drawHorizontalScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio) {
        if (this.horizontalScroll == null) {
            this.initScroll();
        }
        int borderH = 0;
        if (c.getStyle().getBorder() != null) {
            borderH = c.getStyle().getBorder().getThickness();
        }
        int x = c.getX();
        int y = c.getY() + c.getHeight() - this.getHorizontalScrollHeight() - borderH;
        int width = c.getWidth();
        int height = this.getHorizontalScrollHeight();
        this.drawScroll(g, c, offsetRatio, blockSizeRatio, false, x, y, width, height, this.horizontalScroll, this.horizontalScrollThumb);
        if (this.fadeScrollEdge) {
            if (offsetRatio > 0.0f) {
                if (this.fadeScrollLeft == null || Display.getInstance().getDisplayHeight() != this.fadeScrollLeft.getHeight()) {
                    this.fadeScrollLeft = this.generateFadeImage(this.fadeScrollEdgeStartAlpha, this.fadeScrollEdgeEndAlpha, c.getStyle().getBgColor(), true, this.fadeScrollEdgeLength, Display.getInstance().getDisplayHeight());
                }
                g.drawImage(this.fadeScrollLeft, c.getX(), c.getY());
            }
            if (offsetRatio < 1.0f - blockSizeRatio) {
                int totalScroll;
                int l = c.getScrollX() + c.getWidth() + c.getStyle().getMargin(1) + c.getStyle().getMargin(3) + c.getStyle().getPadding(1) + c.getStyle().getPadding(3);
                if (l >= (totalScroll = c.getScrollDimension().getWidth())) {
                    return;
                }
                if (this.fadeScrollRight == null || Display.getInstance().getDisplayHeight() != this.fadeScrollRight.getHeight()) {
                    this.fadeScrollRight = this.generateFadeImage(this.fadeScrollEdgeEndAlpha, this.fadeScrollEdgeStartAlpha, c.getStyle().getBgColor(), true, this.fadeScrollEdgeLength, Display.getInstance().getDisplayHeight());
                }
                g.drawImage(this.fadeScrollRight, c.getX() + c.getWidth() - this.fadeScrollRight.getWidth(), c.getY());
            }
        }
    }

    private void drawScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio, boolean isVertical, int x, int y, int width, int height, Component scroll, Component scrollThumb) {
        int offset;
        int blockSize;
        Style scrollStyle = scroll.getUnselectedStyle();
        Style scrollThumbStyle = scrollThumb.getUnselectedStyle();
        int alpha = scrollStyle.getBgTransparency() & 0xFF;
        int thumbAlpha = scrollThumbStyle.getBgTransparency() & 0xFF;
        int originalAlpha = g.getAlpha();
        if (this.fadeScrollBar) {
            scrollStyle.setBgTransparency(c.getScrollOpacity(), true);
            scrollThumbStyle.setBgTransparency(c.getScrollOpacity(), true);
            g.setAlpha(c.getScrollOpacity());
        }
        int marginLeft = scrollStyle.getMargin(c.isRTL(), 1);
        int marginTop = scrollStyle.getMargin(false, 0);
        scroll.setX(x += marginLeft);
        scroll.setY(y += marginTop);
        scroll.setWidth(width -= marginLeft + scrollStyle.getMargin(c.isRTL(), 3));
        scroll.setHeight(height -= marginTop + scrollStyle.getMargin(false, 2));
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        scroll.paintComponent(g);
        marginLeft = scrollThumbStyle.getMargin(c.isRTL(), 1);
        marginTop = scrollThumbStyle.getMargin(false, 0);
        x += marginLeft;
        width -= marginLeft + scrollThumbStyle.getMargin(c.isRTL(), 3);
        y += marginTop;
        height -= marginTop + scrollThumbStyle.getMargin(false, 2);
        if (isVertical) {
            blockSize = (int)((float)c.getHeight() * blockSizeRatio) + 2;
            offset = (int)((float)c.getHeight() * offsetRatio);
        } else {
            blockSize = (int)((float)c.getWidth() * blockSizeRatio) + 2;
            offset = (int)((float)c.getWidth() * offsetRatio);
        }
        if (isVertical) {
            scrollThumb.setX(x);
            scrollThumb.setY(y + offset);
            scrollThumb.setWidth(width);
            scrollThumb.setHeight(blockSize);
        } else {
            scrollThumb.setX(x + offset);
            scrollThumb.setY(y);
            scrollThumb.setWidth(blockSize);
            scrollThumb.setHeight(height);
        }
        g.setClip(cx, cy, cw, ch);
        scrollThumb.paintComponent(g);
        g.setClip(cx, cy, cw, ch);
        if (this.fadeScrollBar) {
            scrollStyle.setBgTransparency(alpha, true);
            scrollThumbStyle.setBgTransparency(thumbAlpha, true);
            g.setAlpha(originalAlpha);
        }
    }

    public void setFG(Graphics g, Component c) {
        Style s = c.getStyle();
        g.setFont(s.getFont());
        g.setColor(s.getFgColor());
    }

    public int getVerticalScrollWidth() {
        if (this.verticalScroll == null) {
            this.initScroll();
        }
        Style scrollStyle = this.verticalScroll.getStyle();
        return scrollStyle.getMargin(false, 1) + scrollStyle.getMargin(false, 3) + scrollStyle.getPadding(false, 1) + scrollStyle.getPadding(false, 3);
    }

    public int getHorizontalScrollHeight() {
        if (this.horizontalScroll == null) {
            this.initScroll();
        }
        Style scrollStyle = this.horizontalScroll.getStyle();
        return scrollStyle.getMargin(false, 0) + scrollStyle.getMargin(false, 2) + scrollStyle.getPadding(false, 0) + scrollStyle.getPadding(false, 2);
    }

    void drawBorder(Graphics g, Component c, int color, int borderWidth) {
        this.drawBorder(g, c, color, color, borderWidth);
    }

    void drawBorder(Graphics g, Component c, int topAndRightColor, int bottomAndLeftColor, int borderWidth) {
        g.setColor(topAndRightColor);
        g.fillRect(c.getX(), c.getY(), c.getWidth(), borderWidth);
        g.fillRect(c.getX(), c.getY(), borderWidth, c.getHeight());
        g.setColor(bottomAndLeftColor);
        g.fillRect(c.getX(), c.getY() + c.getHeight() - borderWidth, c.getWidth(), borderWidth);
        g.fillRect(c.getX() + c.getWidth() - borderWidth, c.getY(), borderWidth, c.getHeight());
    }

    public abstract Component getTabbedPaneCell(TabbedPane var1, String var2, Image var3, boolean var4, boolean var5, Style var6, Style var7, Style var8, int var9, int var10, Dimension var11, Dimension var12);

    public abstract void drawTabbedPaneContentPane(TabbedPane var1, Graphics var2, Rectangle var3, Dimension var4, int var5, int var6, Dimension var7, int var8, int var9);

    public Transition getDefaultFormTransitionIn() {
        return this.defaultFormTransitionIn;
    }

    public void setDefaultFormTransitionIn(Transition defaultFormTransitionIn) {
        this.defaultFormTransitionIn = defaultFormTransitionIn;
    }

    public Transition getDefaultFormTransitionOut() {
        return this.defaultFormTransitionOut;
    }

    public void setDefaultFormTransitionOut(Transition defaultFormTransitionOut) {
        this.defaultFormTransitionOut = defaultFormTransitionOut;
    }

    public Transition getDefaultMenuTransitionIn() {
        return this.defaultMenuTransitionIn;
    }

    public void setDefaultMenuTransitionIn(Transition defaultMenuTransitionIn) {
        this.defaultMenuTransitionIn = defaultMenuTransitionIn;
    }

    public Transition getDefaultMenuTransitionOut() {
        return this.defaultMenuTransitionOut;
    }

    public void setDefaultMenuTransitionOut(Transition defaultMenuTransitionOut) {
        this.defaultMenuTransitionOut = defaultMenuTransitionOut;
    }

    public Transition getDefaultDialogTransitionIn() {
        return this.defaultDialogTransitionIn;
    }

    public void setDefaultDialogTransitionIn(Transition defaultDialogTransitionIn) {
        this.defaultDialogTransitionIn = defaultDialogTransitionIn;
    }

    public Transition getDefaultDialogTransitionOut() {
        return this.defaultDialogTransitionOut;
    }

    public void setDefaultDialogTransitionOut(Transition defaultDialogTransitionOut) {
        this.defaultDialogTransitionOut = defaultDialogTransitionOut;
    }

    public int getDefaultFormTintColor() {
        return this.defaultFormTintColor;
    }

    public void setDefaultFormTintColor(int defaultFormTintColor) {
        this.defaultFormTintColor = defaultFormTintColor;
    }

    public int getDisableColor() {
        return this.disableColor;
    }

    public void setDisableColor(int disableColor) {
        this.disableColor = disableColor;
    }

    public boolean isDefaultSmoothScrolling() {
        return this.defaultSmoothScrolling;
    }

    public void setDefaultSmoothScrolling(boolean defaultSmoothScrolling) {
        this.defaultSmoothScrolling = defaultSmoothScrolling;
    }

    public int getDefaultSmoothScrollingSpeed() {
        return this.defaultSmoothScrollingSpeed;
    }

    public void setDefaultSmoothScrollingSpeed(int defaultSmoothScrollingSpeed) {
        this.defaultSmoothScrollingSpeed = defaultSmoothScrollingSpeed;
    }

    public boolean isReverseSoftButtons() {
        return this.reverseSoftButtons;
    }

    public void setReverseSoftButtons(boolean reverseSoftButtons) {
        this.reverseSoftButtons = reverseSoftButtons;
    }

    public Class getMenuBarClass() {
        return this.menuBar;
    }

    public void setMenuBarClass(Class menuBar) {
        this.menuBar = menuBar;
    }

    public ListCellRenderer getMenuRenderer() {
        return this.menuRenderer;
    }

    public void setMenuRenderer(ListCellRenderer menuRenderer) {
        this.menuRenderer = menuRenderer;
    }

    public void setMenuIcons(Image select, Image cancel, Image menu) {
        this.menuIcons[0] = select;
        this.menuIcons[1] = cancel;
        this.menuIcons[2] = menu;
    }

    public Image[] getMenuIcons() {
        return this.menuIcons;
    }

    public long getTickerSpeed() {
        return this.tickerSpeed;
    }

    public void setTickerSpeed(long tickerSpeed) {
        this.tickerSpeed = tickerSpeed;
    }

    private void initScroll() {
        this.verticalScroll = new Label();
        this.verticalScroll.setUIID("Scroll");
        this.horizontalScroll = new Label();
        this.horizontalScroll.setUIID("HorizontalScroll");
        this.verticalScrollThumb = new Label();
        this.verticalScrollThumb.setUIID("ScrollThumb");
        this.horizontalScrollThumb = new Label();
        this.horizontalScrollThumb.setUIID("HorizontalScrollThumb");
    }

    public void refreshTheme() {
        this.fadeScrollTop = null;
        this.fadeScrollBottom = null;
        this.fadeScrollRight = null;
        this.fadeScrollLeft = null;
        this.initScroll();
        if (this.menuRenderer != null && this.menuRenderer instanceof Component) {
            ((Component)((Object)this.menuRenderer)).refreshTheme();
        }
        UIManager m = UIManager.getInstance();
        boolean isTouch = Display.getInstance().isTouchScreenDevice();
        this.fadeScrollEdge = m.isThemeConstant("fadeScrollEdgeBool", false);
        this.fadeScrollEdgeLength = m.getThemeConstant("fadeScrollEdgeInt", this.fadeScrollEdgeLength);
        this.fadeScrollBar = m.isThemeConstant("fadeScrollBarBool", false);
        try {
            this.tickerSpeed = Long.parseLong(m.getThemeConstant("tickerSpeedInt", "" + this.tickerSpeed));
            if (this.tickerSpeed < 1L) {
                Label.setDefaultTickerEnabled(false);
            } else {
                Label.setDefaultTickerEnabled(true);
            }
        }
        catch (NumberFormatException err) {
            err.printStackTrace();
        }
        this.defaultFormTintColor = (int)Long.parseLong(m.getThemeConstant("tintColor", Integer.toHexString(this.defaultFormTintColor)), 16);
        this.disableColor = Integer.parseInt(m.getThemeConstant("disabledColor", Integer.toHexString(this.disableColor)), 16);
        Dialog.setDefaultDialogPosition(m.getThemeConstant("dialogPosition", Dialog.getDefaultDialogPosition()));
        Dialog.setCommandsAsButtons(m.isThemeConstant("dialogButtonCommandsBool", Dialog.isCommandsAsButtons()));
        List.setDefaultIgnoreFocusComponentWhenUnfocused(m.isThemeConstant("ignorListFocusBool", List.isDefaultIgnoreFocusComponentWhenUnfocused()));
        if (isTouch) {
            Display.getInstance().setPureTouch(m.isThemeConstant("pureTouchBool", Display.getInstance().isPureTouch()));
        }
        int defaultTransitionSpeed = Integer.parseInt(m.getThemeConstant("transitionSpeedInt", "300"));
        String slideDir = m.getThemeConstant("slideDirection", "horizontal");
        String dialogSlideDir = m.getThemeConstant("dlgSlideDirection", "vertical");
        String menuSlideDir = m.getThemeConstant("menuSlideDirection", dialogSlideDir);
        boolean outdir = m.isThemeConstant("slideOutDirBool", false);
        boolean indir = m.isThemeConstant("slideInDirBool", true);
        boolean dialogOutdir = m.isThemeConstant("dlgSlideOutDirBool", false);
        boolean dialogIndir = m.isThemeConstant("dlgSlideInDirBool", true);
        boolean menuOutdir = m.isThemeConstant("menuSlideOutDirBool", false);
        boolean menuIndir = m.isThemeConstant("menuSlideInDirBool", true);
        this.defaultFormTransitionIn = this.getTransitionConstant(this.defaultFormTransitionIn, "formTransitionIn", slideDir, defaultTransitionSpeed, indir);
        this.defaultFormTransitionOut = this.getTransitionConstant(this.defaultFormTransitionOut, "formTransitionOut", slideDir, defaultTransitionSpeed, outdir);
        this.defaultMenuTransitionIn = this.getTransitionConstant(this.defaultMenuTransitionIn, "menuTransitionIn", menuSlideDir, defaultTransitionSpeed, menuIndir);
        this.defaultMenuTransitionOut = this.getTransitionConstant(this.defaultMenuTransitionOut, "menuTransitionOut", menuSlideDir, defaultTransitionSpeed, menuOutdir);
        this.defaultDialogTransitionIn = this.getTransitionConstant(this.defaultDialogTransitionIn, "dialogTransitionIn", dialogSlideDir, defaultTransitionSpeed, dialogIndir);
        this.defaultDialogTransitionOut = this.getTransitionConstant(this.defaultDialogTransitionOut, "dialogTransitionOut", dialogSlideDir, defaultTransitionSpeed, dialogOutdir);
        this.initCommandBehaviorConstant(m.getThemeConstant("commandBehavior", null));
        this.reverseSoftButtons = m.isThemeConstant("reverseSoftButtonsBool", this.reverseSoftButtons);
        this.textFieldCursorColor = m.getThemeConstant("textFieldCursorColorInt", 0);
        TextArea.setDefaultValign(m.getThemeConstant("textCmpVAlignInt", TextArea.getDefaultValign()));
        this.defaultSnapToGrid = m.isThemeConstant("snapGridBool", false);
        this.defaultAlwaysTensile = m.isThemeConstant("alwaysTensileBool", false);
        this.defaultTensileDrag = m.isThemeConstant("tensileDragBool", true);
        this.defaultTensileHighlight = m.isThemeConstant("tensileHighlightBool", false);
        this.tensileHighlightBottomImage = null;
        this.tensileHighlightTopImage = null;
        if (this.defaultTensileHighlight) {
            this.tensileHighlightBottomImage = m.getThemeImageConstant("tensileHighlightBottomImage");
            this.tensileHighlightTopImage = m.getThemeImageConstant("tensileHighlightTopImage");
            if (this.tensileHighlightBottomImage != null && this.tensileHighlightTopImage != null) {
                this.defaultTensileDrag = true;
                this.defaultAlwaysTensile = false;
            } else {
                this.defaultTensileHighlight = false;
            }
        }
    }

    private void initCommandBehaviorConstant(String c) {
        if (c != null) {
            if (c.equalsIgnoreCase("SoftKey")) {
                Display.getInstance().setCommandBehavior(2);
            }
            if (c.equalsIgnoreCase("Touch")) {
                Display.getInstance().setCommandBehavior(3);
            }
            if (c.equalsIgnoreCase("Bar")) {
                Display.getInstance().setCommandBehavior(4);
            }
            if (c.equalsIgnoreCase("Title")) {
                Display.getInstance().setCommandBehavior(5);
            }
            if (c.equalsIgnoreCase("Right")) {
                Display.getInstance().setCommandBehavior(6);
            }
            if (c.equalsIgnoreCase("Native")) {
                Display.getInstance().setCommandBehavior(10);
            }
        } else {
            Display.getInstance().setCommandBehavior(1);
        }
    }

    private Transition getTransitionConstant(Transition t, String constant, String slideDir, int speed, boolean forward) {
        Image img = UIManager.getInstance().getThemeImageConstant(constant + "Image");
        if (img != null) {
            return CommonTransitions.createTimeline(img);
        }
        String val = UIManager.getInstance().getThemeConstant(constant, null);
        if (val == null) {
            return t;
        }
        if (val.equalsIgnoreCase("slide")) {
            if (slideDir.equalsIgnoreCase("horizontal")) {
                return CommonTransitions.createSlide(0, forward, speed);
            }
            return CommonTransitions.createSlide(1, forward, speed);
        }
        if (val.equalsIgnoreCase("fslide")) {
            if (slideDir.equalsIgnoreCase("horizontal")) {
                return CommonTransitions.createFastSlide(0, forward, speed);
            }
            return CommonTransitions.createFastSlide(1, forward, speed);
        }
        if (val.equalsIgnoreCase("fade")) {
            return CommonTransitions.createFade(speed);
        }
        if (val.equalsIgnoreCase("slidefade")) {
            return CommonTransitions.createSlideFadeTitle(forward, speed);
        }
        if (val.equalsIgnoreCase("pulse")) {
            return CommonTransitions.createDialogPulsate();
        }
        return t;
    }

    public boolean isTouchMenus() {
        int t = Display.getInstance().getCommandBehavior();
        return t == 3 || t == 1 && Display.getInstance().isTouchScreenDevice();
    }

    public void setTouchMenus(boolean touchMenus) {
        if (touchMenus) {
            Display.getInstance().setCommandBehavior(3);
        } else {
            Display.getInstance().setCommandBehavior(2);
        }
    }

    public void setRTL(boolean rtl) {
        if (UIManager.localeAccessible) {
            this.rtl = rtl;
            if (rtl) {
                Display.getInstance().setBidiAlgorithm(true);
            }
        }
    }

    public boolean isRTL() {
        return this.rtl;
    }

    public int getTactileTouchDuration() {
        return this.tactileTouchDuration;
    }

    public void setTactileTouchDuration(int tactileTouchDuration) {
        this.tactileTouchDuration = tactileTouchDuration;
    }

    public boolean isDefaultEndsWith3Points() {
        return this.defaultEndsWith3Points;
    }

    public void setDefaultEndsWith3Points(boolean defaultEndsWith3Points) {
        this.defaultEndsWith3Points = defaultEndsWith3Points;
    }

    public boolean isDefaultTensileDrag() {
        return this.defaultTensileDrag;
    }

    public void setDefaultTensileDrag(boolean defaultTensileDrag) {
        this.defaultTensileDrag = defaultTensileDrag;
    }

    public boolean isFocusScrolling() {
        return this.focusScrolling;
    }

    public void setFocusScrolling(boolean focusScrolling) {
        this.focusScrolling = focusScrolling;
    }

    public boolean isFadeScrollEdge() {
        return this.fadeScrollEdge;
    }

    public void setFadeScrollEdge(boolean fadeScrollEdge) {
        this.fadeScrollEdge = fadeScrollEdge;
    }

    public boolean isFadeScrollBar() {
        return this.fadeScrollBar;
    }

    public void setFadeScrollBar(boolean fadeScrollBar) {
        this.fadeScrollBar = fadeScrollBar;
    }

    public int getFadeScrollEdgeLength() {
        return this.fadeScrollEdgeLength;
    }

    public void setFadeScrollEdgeLength(int fadeScrollEdgeLength) {
        this.fadeScrollEdgeLength = fadeScrollEdgeLength;
    }

    public int getTextFieldCursorColor() {
        return this.textFieldCursorColor;
    }

    public void setTextFieldCursorColor(int textFieldCursorColor) {
        this.textFieldCursorColor = textFieldCursorColor;
    }

    public boolean isDefaultSnapToGrid() {
        return this.defaultSnapToGrid;
    }

    public void setDefaultSnapToGrid(boolean defaultSnapToGrid) {
        this.defaultSnapToGrid = defaultSnapToGrid;
    }

    public boolean isDefaultAlwaysTensile() {
        return this.defaultAlwaysTensile;
    }

    public void setDefaultAlwaysTensile(boolean defaultAlwaysTensile) {
        this.defaultAlwaysTensile = defaultAlwaysTensile;
    }

    public boolean isDefaultTensileHighlight() {
        return this.defaultTensileHighlight;
    }

    public void paintTensileHighlight(Graphics g, boolean top, int opacity) {
        if (opacity > 0 && this.tensileHighlightTopImage != null && this.tensileHighlightBottomImage != null) {
            int a2 = g.getAlpha();
            g.setAlpha(opacity);
            if (top) {
                g.drawImage(this.tensileHighlightTopImage, 0, 0, Display.getInstance().getDisplayWidth(), this.tensileHighlightTopImage.getHeight());
            } else {
                g.drawImage(this.tensileHighlightBottomImage, 0, Display.getInstance().getDisplayHeight() - this.tensileHighlightBottomImage.getHeight(), Display.getInstance().getDisplayWidth(), this.tensileHighlightBottomImage.getHeight());
            }
            g.setAlpha(a2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

