/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.RGBImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncodedImage
extends Image {
    public byte[] imageData;
    public int width = -1;
    public int height = -1;
    public boolean opaqueChecked = false;
    public boolean opaque = false;
    public Object cache;
    public Image hardCache;
    public boolean locked;
    static /* synthetic */ Class class$com$sun$lwuit$EncodedImage;

    private EncodedImage(byte[] imageData) {
        super(null);
        this.imageData = imageData;
    }

    protected EncodedImage(int width, int height) {
        super(null);
        this.width = width;
        this.height = height;
    }

    protected void resetCache() {
        this.cache = null;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public static EncodedImage create(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        return new EncodedImage(data);
    }

    public static EncodedImage create(InputStream i) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int size = i.read(buffer);
        while (size > -1) {
            bo.write(buffer, 0, size);
            size = i.read(buffer);
        }
        bo.close();
        return new EncodedImage(bo.toByteArray());
    }

    private Image getInternalImpl() {
        if (this.hardCache != null) {
            return this.hardCache;
        }
        Image i = this.getInternal();
        if (this.locked) {
            this.hardCache = i;
        }
        return i;
    }

    protected Image getInternal() {
        Image i;
        if (this.cache != null && (i = (Image)Display.getInstance().extractHardRef(this.cache)) != null) {
            return i;
        }
        try {
            byte[] b = this.getImageData();
            i = Image.createImage(b, 0, b.length);
        }
        catch (Exception err) {
            err.printStackTrace();
            i = Image.createImage(5, 5);
        }
        this.cache = Display.getInstance().createSoftWeakRef(i);
        return i;
    }

    public void lock() {
        this.locked = true;
        if (this.cache != null) {
            this.hardCache = (Image)Display.getInstance().extractHardRef(this.cache);
        }
    }

    public void unlock() {
        if (this.hardCache != null && (this.cache == null || Display.getInstance().extractHardRef(this.cache) == null)) {
            this.cache = Display.getInstance().createSoftWeakRef(this.hardCache);
        }
        this.locked = false;
    }

    public static EncodedImage create(String i) throws IOException {
        return EncodedImage.create(Display.getInstance().getResourceAsStream(class$com$sun$lwuit$EncodedImage == null ? (class$com$sun$lwuit$EncodedImage = EncodedImage.class$("com.sun.lwuit.EncodedImage")) : class$com$sun$lwuit$EncodedImage, i));
    }

    public Image subImage(int x, int y, int width, int height, boolean processAlpha) {
        return this.getInternalImpl().subImage(x, y, width, height, processAlpha);
    }

    public Image rotate(int degrees) {
        return this.getInternalImpl().rotate(degrees);
    }

    public Image modifyAlpha(byte alpha) {
        return this.getInternalImpl().modifyAlpha(alpha);
    }

    public Image modifyAlpha(byte alpha, int removeColor) {
        return this.getInternalImpl().modifyAlpha(alpha, removeColor);
    }

    public Graphics getGraphics() {
        return null;
    }

    public int getWidth() {
        if (this.width > -1) {
            return this.width;
        }
        this.width = this.getInternalImpl().getWidth();
        return this.width;
    }

    public int getHeight() {
        if (this.height > -1) {
            return this.height;
        }
        this.height = this.getInternalImpl().getHeight();
        return this.height;
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y) {
        this.getInternalImpl().drawImage(g, nativeGraphics, x, y);
    }

    protected void drawImage(Graphics g, Object nativeGraphics, int x, int y, int w, int h) {
        this.getInternalImpl().drawImage(g, nativeGraphics, x, y, w, h);
    }

    void getRGB(int[] rgbData, int offset, int x, int y, int width, int height) {
        this.getInternalImpl().getRGB(rgbData, offset, x, y, width, height);
    }

    public void toRGB(RGBImage image, int destX, int destY, int x, int y, int width, int height) {
        this.getInternalImpl().toRGB(image, destX, destY, x, y, width, height);
    }

    public Image scaledWidth(int width) {
        return this.getInternalImpl().scaledWidth(width);
    }

    public Image scaledHeight(int height) {
        return this.getInternalImpl().scaledHeight(height);
    }

    public Image scaledSmallerRatio(int width, int height) {
        return this.getInternalImpl().scaledSmallerRatio(width, height);
    }

    public Image scaled(int width, int height) {
        return this.getInternalImpl().scaled(width, height);
    }

    public void scale(int width, int height) {
        this.getInternalImpl().scale(width, height);
    }

    public boolean isAnimation() {
        return false;
    }

    public boolean isOpaque() {
        if (this.opaqueChecked) {
            return this.opaque;
        }
        this.opaque = this.getInternalImpl().isOpaque();
        return this.opaque;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

