/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class HTMLEventsListener
implements ActionListener,
FocusListener {
    Hashtable comps = new Hashtable();
    Hashtable listeners = new Hashtable();
    HTMLComponent htmlC;

    public HTMLEventsListener(HTMLComponent htmlC) {
        this.htmlC = htmlC;
    }

    void registerComponent(Component cmp, final HTMLElement element) {
        this.comps.put(cmp, element);
        cmp.addFocusListener(this);
        if (cmp instanceof Button) {
            ((Button)cmp).addActionListener(this);
        } else if (cmp instanceof List) {
            final List list = (List)cmp;
            list.addActionListener(this);
            SelectionListener sl = new SelectionListener(){

                public void selectionChanged(int oldSelected, int newSelected) {
                    if (HTMLEventsListener.this.htmlC.getHTMLCallback() != null) {
                        HTMLEventsListener.this.htmlC.getHTMLCallback().selectionChanged(oldSelected, newSelected, HTMLEventsListener.this.htmlC, list, element);
                    }
                }
            };
            list.addSelectionListener(sl);
            this.listeners.put(cmp, sl);
        } else if (cmp instanceof TextArea) {
            ((TextArea)cmp).addActionListener(this);
            if (cmp instanceof TextField) {
                final TextField tf = (TextField)cmp;
                DataChangedListener dcl = new DataChangedListener(){

                    public void dataChanged(int type, int index) {
                        element.setAttributeById(38, tf.getText());
                        if (HTMLEventsListener.this.htmlC.getHTMLCallback() != null) {
                            HTMLEventsListener.this.htmlC.getHTMLCallback().dataChanged(type, index, HTMLEventsListener.this.htmlC, tf, element);
                        }
                    }
                };
                tf.addDataChangeListener(dcl);
                this.listeners.put(cmp, dcl);
            }
        }
    }

    void deregisterAll() {
        Enumeration e = this.comps.keys();
        while (e.hasMoreElements()) {
            Component cmp = (Component)e.nextElement();
            cmp.removeFocusListener(this);
            if (cmp instanceof Button) {
                ((Button)cmp).removeActionListener(this);
                continue;
            }
            if (cmp instanceof List) {
                ((List)cmp).removeSelectionListener((SelectionListener)this.listeners.get(cmp));
                continue;
            }
            if (!(cmp instanceof TextArea)) continue;
            ((TextArea)cmp).removeActionListener(this);
            if (!(cmp instanceof TextField)) continue;
            ((TextField)cmp).removeDataChangeListener((DataChangedListener)this.listeners.get(cmp));
        }
        this.comps = new Hashtable();
        this.listeners = new Hashtable();
    }

    private void toggleChecked(HTMLElement element, boolean checked) {
        if (checked) {
            element.setAttributeById(32, "checked");
        } else {
            element.removeAttributeById(32);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        HTMLElement element = (HTMLElement)this.comps.get(evt.getSource());
        if (src instanceof CheckBox) {
            this.toggleChecked(element, ((CheckBox)src).isSelected());
        } else if (src instanceof RadioButton) {
            String name;
            String curDomState = element.getAttributeById(32);
            if (!(curDomState != null && curDomState.equals("checked") || (name = element.getAttributeById(37)) == null)) {
                Enumeration e = this.comps.keys();
                while (e.hasMoreElements()) {
                    HTMLElement rbElem;
                    String rbName;
                    Component cmp = (Component)e.nextElement();
                    if (!(cmp instanceof RadioButton) || (rbName = (rbElem = (HTMLElement)this.comps.get(cmp)).getAttributeById(37)) == null || !rbName.equals(name)) continue;
                    rbElem.removeAttributeById(32);
                }
            }
            this.toggleChecked(element, ((RadioButton)src).isSelected());
        } else if (src instanceof TextArea) {
            String text = ((TextArea)src).getText();
            if (element.getNumChildren() == 0) {
                HTMLElement textElem = new HTMLElement(text, true);
                element.addChild(textElem);
            } else {
                HTMLElement textElem = (HTMLElement)element.getChildAt(0);
                if (textElem.isTextElement()) {
                    textElem.setText(text);
                } else {
                    System.out.println("Malformed HTML - Found a non-text element under TEXTAREA tag - ignoring");
                }
            }
        } else if (src instanceof List) {
            String item = ((List)src).getSelectedItem().toString();
            Vector v = element.getDescendantsByTagId(39);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                HTMLElement option = (HTMLElement)e.nextElement();
                if (option.getNumChildren() == 1) {
                    HTMLElement textElem = (HTMLElement)option.getChildAt(0);
                    if (textElem.isTextElement()) {
                        if (textElem.getText().equalsIgnoreCase(item)) {
                            option.setAttributeById(42, "selected");
                            continue;
                        }
                        option.removeAttributeById(42);
                        continue;
                    }
                    System.out.println("Malformed HTML - Found a non-text element under OPTION tag - ignoring");
                    continue;
                }
                System.out.println("Malformed HTML - Found illegal tags as children of the OPTION tag - ignoring");
            }
        }
        if (this.htmlC.getHTMLCallback() != null) {
            this.htmlC.getHTMLCallback().actionPerformed(evt, this.htmlC, element);
        }
    }

    public void focusGained(Component cmp) {
        if (this.htmlC.getHTMLCallback() != null) {
            this.htmlC.getHTMLCallback().focusGained(cmp, this.htmlC, (HTMLElement)this.comps.get(cmp));
        }
    }

    public void focusLost(Component cmp) {
        if (this.htmlC.getHTMLCallback() != null) {
            this.htmlC.getHTMLCallback().focusLost(cmp, this.htmlC, (HTMLElement)this.comps.get(cmp));
        }
    }
}

