/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class BoxLayout
extends Layout {
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public int axis;

    public BoxLayout(int axis) {
        this.axis = axis;
    }

    public void layoutContainer(Container parent) {
        int width = parent.getLayoutWidth() - parent.getSideGap() - parent.getStyle().getPadding(false, 3) - parent.getStyle().getPadding(false, 1);
        int height = parent.getLayoutHeight() - parent.getBottomGap() - parent.getStyle().getPadding(false, 2) - parent.getStyle().getPadding(false, 0);
        int x = parent.getStyle().getPadding(parent.isRTL(), 1);
        int y = parent.getStyle().getPadding(false, 0);
        int numOfcomponents = parent.getComponentCount();
        boolean rtl = parent.isRTL();
        if (rtl) {
            x += parent.getSideGap();
        }
        int initX = x;
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            Style stl = cmp.getStyle();
            if (this.axis == 2) {
                int cmpBottom = height;
                int cmpH = cmp.getPreferredH();
                if ((y += stl.getMargin(false, 0)) >= cmpBottom) {
                    cmpH = 0;
                } else if (y + cmpH - parent.getStyle().getPadding(false, 0) > cmpBottom) {
                    cmpH = cmpBottom - y - stl.getMargin(false, 2);
                }
                cmp.setWidth(width - stl.getMargin(parent.isRTL(), 1) - stl.getMargin(parent.isRTL(), 3));
                cmp.setHeight(cmpH);
                cmp.setX(x + stl.getMargin(parent.isRTL(), 1));
                cmp.setY(y);
                y += cmp.getHeight() + stl.getMargin(false, 2);
                continue;
            }
            int cmpRight = width;
            int cmpW = cmp.getPreferredW();
            if ((x += stl.getMargin(false, 1)) >= cmpRight) {
                cmpW = 0;
            } else if (x + cmpW - parent.getStyle().getPadding(false, 1) > cmpRight) {
                cmpW = cmpRight - x - stl.getMargin(false, 3);
            }
            cmp.setWidth(cmpW);
            cmp.setHeight(height - stl.getMargin(false, 0) - stl.getMargin(false, 2));
            if (rtl) {
                cmp.setX(width + initX - (x - initX) - cmpW);
            } else {
                cmp.setX(x);
            }
            cmp.setY(y + stl.getMargin(false, 0));
            x += cmp.getWidth() + stl.getMargin(false, 3);
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int width = 0;
        int height = 0;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            Style stl = cmp.getStyle();
            if (this.axis == 2) {
                int cmpH = cmp.getPreferredH() + stl.getMargin(false, 0) + stl.getMargin(false, 2);
                height += cmpH;
                width = Math.max(width, cmp.getPreferredW() + stl.getMargin(false, 1) + stl.getMargin(false, 3));
                continue;
            }
            int cmpW = cmp.getPreferredW() + stl.getMargin(false, 1) + stl.getMargin(false, 3);
            width += cmpW;
            height = Math.max(height, cmp.getPreferredH() + stl.getMargin(false, 0) + stl.getMargin(false, 2));
        }
        Dimension d = new Dimension(width + parent.getStyle().getPadding(false, 1) + parent.getStyle().getPadding(false, 3), height + parent.getStyle().getPadding(false, 0) + parent.getStyle().getPadding(false, 2));
        return d;
    }

    public int getAxis() {
        return this.axis;
    }

    public String toString() {
        if (this.axis == 1) {
            return "BoxLayout X";
        }
        return "BoxLayout Y";
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.axis == ((BoxLayout)o).axis;
    }
}

