/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;

public class LayeredLayout
extends Layout {
    public void layoutContainer(Container parent) {
        int numOfcomponents = parent.getComponentCount();
        Style s = parent.getStyle();
        int x = s.getPadding(parent.isRTL(), 1);
        int y = s.getPadding(false, 0);
        int w = parent.getWidth() - x - s.getPadding(parent.isRTL(), 3);
        int h = parent.getHeight() - y - s.getPadding(false, 2);
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            cmp.setX(x);
            cmp.setY(y);
            cmp.setWidth(w);
            cmp.setHeight(h);
        }
    }

    public Dimension getPreferredSize(Container parent) {
        int maxWidth = 0;
        int maxHeight = 0;
        int numOfcomponents = parent.getComponentCount();
        for (int i = 0; i < numOfcomponents; ++i) {
            Component cmp = parent.getComponentAt(i);
            maxHeight = Math.max(maxHeight, cmp.getPreferredH());
            maxWidth = Math.max(maxWidth, cmp.getPreferredW());
        }
        Style s = parent.getStyle();
        Dimension d = new Dimension(maxWidth + s.getPadding(false, 1) + s.getPadding(false, 3), maxHeight + s.getPadding(false, 0) + s.getPadding(false, 2));
        return d;
    }

    public String toString() {
        return "LayeredLayout";
    }

    public boolean isOverlapSupported() {
        return true;
    }
}

