/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.spinner;

import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.util.EventDispatcher;

class SpinnerNumberModel
implements ListModel {
    public EventDispatcher dataListener = new EventDispatcher();
    public EventDispatcher selectionListener = new EventDispatcher();
    public double min;
    public double max;
    public double currentValue;
    public double step;
    boolean realValues;

    void setValue(Object value) {
        this.currentValue = value instanceof Integer ? ((Integer)value).doubleValue() : ((Double)value).doubleValue();
    }

    Object getValue() {
        if (this.realValues) {
            return new Double(this.currentValue);
        }
        return new Integer((int)this.currentValue);
    }

    public SpinnerNumberModel(int min, int max, int currentValue, int step) {
        this.max = max;
        this.min = min;
        this.currentValue = currentValue;
        this.step = step;
    }

    public SpinnerNumberModel(double min, double max, double currentValue, double step) {
        this.max = max;
        this.min = min;
        this.currentValue = currentValue;
        this.step = step;
        this.realValues = true;
    }

    public Object getItemAt(int index) {
        if (this.realValues) {
            return new Double(this.min + this.step * (double)index);
        }
        return new Integer((int)(this.min + this.step * (double)index));
    }

    public int getSize() {
        return (int)((this.max - this.min) / this.step);
    }

    public int getSelectedIndex() {
        double d = Math.floor((this.max - this.currentValue) / this.step + 0.5);
        int v = this.getSize() - (int)d;
        return v;
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.getSelectedIndex();
        this.currentValue = this.min + (double)index * this.step;
        int newIndex = this.getSelectedIndex();
        this.selectionListener.fireSelectionEvent(oldIndex, newIndex);
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.dataListener.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListener.removeListener(l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.addListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.removeListener(l);
    }

    public void addItem(Object item) {
    }

    public void removeItem(int index) {
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

