/*
 * Decompiled with CFR 0.152.
 */
package trybuylocalization;

import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class StringTools {
    private static char[] map1;

    public static String replace(String stringToReplace, String replacement, String source) {
        StringBuffer result = new StringBuffer();
        int index = source.indexOf(stringToReplace);
        if (index == 0) {
            result.append(replacement);
            result.append(source.substring(stringToReplace.length()));
            return StringTools.replace(stringToReplace, replacement, result.toString());
        }
        if (index > 0) {
            result.append(source.substring(0, index));
            result.append(replacement);
            result.append(source.substring(index + stringToReplace.length()));
            return StringTools.replace(stringToReplace, replacement, result.toString());
        }
        return source;
    }

    public static String encode(String s2, String key) {
        return new String(StringTools.xorWithKey(s2.getBytes(), key.getBytes()));
    }

    public static String decode(String s2, String key) {
        return new String(StringTools.xorWithKey(s2.getBytes(), key.getBytes()));
    }

    private static byte[] xorWithKey(byte[] a2, byte[] key) {
        byte[] out = new byte[a2.length];
        for (int i2 = 0; i2 < a2.length; ++i2) {
            out[i2] = (byte)(a2[i2] ^ key[i2 % key.length]);
        }
        return out;
    }

    public static String[] split(String original, String separator) {
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        nodes.addElement(original);
        int elementCount = nodes.size();
        String[] result = new String[elementCount];
        if (elementCount > 0) {
            for (int i2 = 0; i2 < elementCount; ++i2) {
                result[i2] = (String)nodes.elementAt(i2);
            }
        }
        return result;
    }

    public static String randomString(int length) {
        char[] chars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        for (int i2 = 0; i2 < 20; ++i2) {
            char c2 = chars[random.nextInt(chars.length)];
            sb.append(c2);
        }
        Date date = new Date();
        sb.append(date.getTime());
        return sb.toString();
    }

    public static final String base64Encode(byte[] in) {
        int iLen = in.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n2 = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n2;
            ++op;
        }
        return new String(out);
    }

    public static final Enumeration sort(Enumeration e2) {
        Vector<String> v2 = new Vector<String>();
        while (e2.hasMoreElements()) {
            String s2 = (String)e2.nextElement();
            int i2 = 0;
            for (i2 = 0; i2 < v2.size(); ++i2) {
                int c2 = s2.compareTo((String)v2.elementAt(i2));
                if (c2 < 0) {
                    v2.insertElementAt(s2, i2);
                    break;
                }
                if (c2 == 0) break;
            }
            if (i2 < v2.size()) continue;
            v2.addElement(s2);
        }
        return v2.elements();
    }

    public static String fill(int length, String with) {
        StringBuffer sb = new StringBuffer(length);
        while (sb.length() < length) {
            sb.append(with);
        }
        return sb.toString();
    }

    static {
        int c2;
        map1 = new char[64];
        int i2 = 0;
        for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
            StringTools.map1[i2++] = c2;
        }
        for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
            StringTools.map1[i2++] = c2;
        }
        for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
            StringTools.map1[i2++] = c2;
        }
        StringTools.map1[i2++] = 43;
        StringTools.map1[i2++] = 47;
    }
}

