/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.game.Bonus;
import sk.inlogic.game.Logger;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game {
    private Rectangle[][] rectBoard;
    private Rectangle rectBoardWhole;
    private Rectangle rectBonusLeft;
    private Rectangle rectBonusMiddle;
    private Rectangle rectBonusRight;
    public static final int BONUS_LEFT = -97;
    public static final int BONUS_MIDDLE = -98;
    public static final int BONUS_RIGHT = -99;
    private byte[][] board;
    private ScreenMain mainScreen;
    public int gameType;
    private int iCellW;
    private int iCellH;
    private int iBoardX;
    private int iBoardY;
    private int iBoardW;
    private int iBoardH;
    private int iBoardLinePartW;
    private int iBoardLinePartH;
    private int iLineW;
    private boolean bSelected;
    private int selectorPos;
    private boolean bAminStartBoard;
    private int iAminStartDiff;
    private int[][] fallAnimations;
    private boolean bFallAnimInProgress;
    public int iScore;
    public int iTime;
    private int iMoves;
    private boolean bCalculateTime;
    public boolean bGameOver;
    private String strRightTop;
    private String strLeftTop;
    private int iLeftTopX;
    private int iRightTopX;
    private int iLeftTopY;
    private int iRightTopY;
    private int iTopTextY;
    private int defaultStartAnimStep;
    public static final byte SLCTR_ROW = 0;
    public static final byte SLCTR_COL = 1;
    private static final int ANIM_ROW = 0;
    private static final int ANIM_COL = 1;
    private static final int ANIM_TARGET_POS = 2;
    private static final int ANIM_STATE = 3;
    private int[] selectedDots;
    private int bonusItemW;
    private int bonusItemH;
    private int bottomH;
    private int bonusY;
    private boolean bDeleteDot;
    private boolean bDeleteColor;
    private boolean bRectangle = false;
    long lCounter = 0L;
    int selectedAnimStep = 0;
    int iAnimBonusesOff;
    int iAnimTopBarOff;
    boolean bQuitAnim;

    public Game(ScreenMain mainScreen) {
        this.mainScreen = mainScreen;
    }

    public void initGameGraphics() {
    }

    public void initGameVarsOnFirstStart() {
        this.iCellW = ScreenMain.sprDots.getWidth();
        this.iCellH = ScreenMain.sprDots.getHeight();
        this.iBoardX = (MainCanvas.WIDTH >> 1) - 3 * this.iCellW;
        this.iBoardW = 6 * this.iCellW;
        this.iBoardY = (MainCanvas.HEIGHT >> 1) - 3 * this.iCellH;
        this.iBoardH = 6 * this.iCellH;
        this.iBoardLinePartW = this.iBoardW / 12;
        this.iBoardLinePartH = ScreenMain.sprDots.getHeight() >> 4;
        this.iLineW = ScreenMain.sprDots.getWidth() >> 4;
        this.board = new byte[6][6];
        this.rectBoard = new Rectangle[6][6];
        this.rectBoardWhole = new Rectangle(this.iBoardX, this.iBoardY, this.iBoardW, this.iBoardH);
        this.bonusItemW = ScreenMain.sprMenuIcons.getWidth();
        this.bonusItemH = ScreenMain.sprMenuIcons.getHeight();
        this.bottomH = MainCanvas.HEIGHT - (this.iBoardY + this.iBoardH + ScreenMain.sprBorder.getHeight());
        this.bonusY = this.iBoardY + this.iBoardH + ScreenMain.sprBorder.getHeight() + (this.bottomH - ScreenMain.sprMenuIcons.getHeight() >> 1);
        int topH = this.iBoardY - ScreenMain.sprBorder.getHeight();
        this.iLeftTopX = this.iBoardX >> 1;
        this.iLeftTopY = (topH >> 1) - (ScreenMain.sprGameIcons.getHeight() >> 1);
        this.iRightTopX = MainCanvas.WIDTH - ScreenMain.sprGameIcons.getWidth() - this.iLeftTopX;
        this.iRightTopY = this.iLeftTopY;
        this.iTopTextY = this.iLeftTopY + (ScreenMain.sprBorder.getHeight() >> 1);
        this.fallAnimations = new int[100][4];
        this.iAminStartDiff = 6 * this.iCellH;
        this.selectedDots = new int[40];
    }

    public void initGameVarsOnRestart() {
        Logger.l("RESTART");
        this.bGameOver = false;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.board[i][j] = (byte)RandomNum.getRandomUInt(5);
                this.rectBoard[i][j] = new Rectangle(this.iBoardX + j * this.iCellW, this.iBoardY + i * this.iCellH, this.iCellW, this.iCellH);
            }
        }
        this.fallAnimations = new int[100][4];
        this.defaultStartAnimStep = this.iCellH >> 3;
        this.iAminStartDiff = 6 * this.iCellH;
        this.iAnimBonusesOff = MainCanvas.HEIGHT - this.bonusY;
        this.iAnimTopBarOff = this.iRightTopY + ScreenMain.sprGameIcons.getHeight();
        this.bAminStartBoard = true;
        this.bQuitAnim = false;
        this.bSelected = false;
        this.bCalculateTime = false;
        this.bFallAnimInProgress = false;
        this.selectorPos = 42;
        this.resetSelectedDots();
        switch (this.gameType) {
            case 0: {
                this.iScore = 0;
                this.iMoves = 30;
                this.iTime = -1;
                this.strRightTop = "" + this.iScore;
                this.strLeftTop = "30";
                this.rectBonusMiddle = new Rectangle((MainCanvas.WIDTH >> 1) - (this.bonusItemW >> 1), this.bonusY, this.bonusItemW, this.bonusItemH);
                this.rectBonusLeft = new Rectangle(this.iBoardX, this.bonusY, this.bonusItemW, this.bonusItemH);
                this.rectBonusRight = new Rectangle(this.iBoardX + this.iBoardW - this.bonusItemW, this.bonusY, this.bonusItemW, this.bonusItemH);
                break;
            }
            case 1: {
                this.iScore = 0;
                this.iMoves = -1;
                this.iTime = 60000;
                this.strRightTop = "" + this.iScore;
                this.strLeftTop = this.convertTimeToString(60);
                this.rectBonusMiddle = new Rectangle((MainCanvas.WIDTH >> 1) - (this.bonusItemW >> 1), this.bonusY, this.bonusItemW, this.bonusItemH);
                this.rectBonusLeft = new Rectangle(this.iBoardX, this.bonusY, this.bonusItemW, this.bonusItemH);
                this.rectBonusRight = new Rectangle(this.iBoardX + this.iBoardW - this.bonusItemW, this.bonusY, this.bonusItemW, this.bonusItemH);
                break;
            }
            case 2: {
                this.iScore = 0;
                this.iMoves = -1;
                this.iTime = 0;
                this.strRightTop = "" + this.iScore;
                this.strLeftTop = this.convertTimeToString(0);
                this.rectBonusLeft = new Rectangle(0, 0, 0, 0);
                this.rectBonusMiddle = new Rectangle((MainCanvas.WIDTH >> 1) - (this.bonusItemW >> 2) - this.bonusItemW, this.bonusY, this.bonusItemW, this.bonusItemH);
                this.rectBonusRight = new Rectangle((MainCanvas.WIDTH >> 1) + (this.bonusItemW >> 2), this.bonusY, this.bonusItemW, this.bonusItemH);
                break;
            }
        }
    }

    public void start(int gameType) {
        Logger.l("START");
        this.gameType = gameType;
        this.initGameVarsOnRestart();
    }

    public void paint(Graphics g) {
        this.paintBoard(g);
        this.paintShadows(g);
        this.paintBoardLines(g);
        this.paintSelectedDots(g);
        this.paintTopBar(g);
        this.paintBonusItems(g);
        this.paintControls(g);
        this.paintSelector(g);
        this.paintMessage(g);
    }

    private void paintMessage(Graphics g) {
        if (this.bDeleteDot) {
            this.mainScreen.fontSmall.drawString(g, Resources.resTexts[0].getHashedString(46).toCharArray(), MainCanvas.WIDTH >> 1, this.iBoardY - ScreenMain.sprBorder.getHeight() - this.mainScreen.fontSmall.getHeight(), 17);
            return;
        }
        if (this.bDeleteColor) {
            this.mainScreen.fontSmall.drawString(g, Resources.resTexts[0].getHashedString(47).toCharArray(), MainCanvas.WIDTH >> 1, this.iBoardY - ScreenMain.sprBorder.getHeight() - this.mainScreen.fontSmall.getHeight(), 17);
            return;
        }
    }

    private void paintControls(Graphics g) {
        g.drawImage(ScreenMain.imgPause, MainCanvas.WIDTH - ScreenMain.imgPause.getWidth(), MainCanvas.HEIGHT - ScreenMain.imgPause.getHeight(), 20);
    }

    private void paintShadows(Graphics g) {
        ScreenMain.sprBorder.setFrame(0);
        ScreenMain.sprBorder.setTransform(0);
        ScreenMain.sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (ScreenMain.sprBorder.getWidth() >> 1), this.iBoardY - ScreenMain.sprBorder.getHeight());
        ScreenMain.sprBorder.paint(g);
        ScreenMain.sprBorder.setTransform(3);
        ScreenMain.sprBorder.setPosition((MainCanvas.WIDTH >> 1) - (ScreenMain.sprBorder.getWidth() >> 1), this.iBoardY + this.iBoardH);
        ScreenMain.sprBorder.paint(g);
    }

    private void paintBonusItems(Graphics g) {
        int iNumberOff = 0;
        iNumberOff = MainCanvas.HEIGHT < 320 ? 0 : this.mainScreen.fontSmall.getHeight() >> 1;
        if (this.gameType == 0) {
            this.mainScreen.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(1)).toCharArray(), this.rectBonusLeft.x + this.rectBonusLeft.width, this.rectBonusLeft.y + iNumberOff + this.iAnimBonusesOff, 24);
            ScreenMain.sprMenuIcons.setFrame(7);
            ScreenMain.sprMenuIcons.setPosition(this.rectBonusLeft.x, this.rectBonusLeft.y + this.iAnimBonusesOff);
            ScreenMain.sprMenuIcons.paint(g);
        } else if (this.gameType == 1) {
            this.mainScreen.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(0)).toCharArray(), this.rectBonusLeft.x + this.rectBonusLeft.width, this.rectBonusLeft.y + iNumberOff + this.iAnimBonusesOff, 24);
            ScreenMain.sprMenuIcons.setFrame(6);
            ScreenMain.sprMenuIcons.setPosition(this.rectBonusLeft.x, this.rectBonusLeft.y + this.iAnimBonusesOff);
            ScreenMain.sprMenuIcons.paint(g);
        }
        ScreenMain.sprMenuIcons.setFrame(8);
        ScreenMain.sprMenuIcons.setPosition(this.rectBonusMiddle.x, this.rectBonusMiddle.y + this.iAnimBonusesOff);
        ScreenMain.sprMenuIcons.paint(g);
        this.mainScreen.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(2)).toCharArray(), this.rectBonusMiddle.x + this.rectBonusMiddle.width, this.rectBonusMiddle.y + iNumberOff + this.iAnimBonusesOff, 24);
        ScreenMain.sprMenuIcons.setFrame(5);
        ScreenMain.sprMenuIcons.setPosition(this.rectBonusRight.x, this.rectBonusRight.y + this.iAnimBonusesOff);
        ScreenMain.sprMenuIcons.paint(g);
        this.mainScreen.fontSmall.drawString(g, ("" + Bonus.getInstance().getValue(3)).toCharArray(), this.rectBonusRight.x + this.rectBonusRight.width, this.rectBonusRight.y + iNumberOff + this.iAnimBonusesOff, 24);
    }

    private void paintTopBar(Graphics g) {
        if (this.gameType == 0) {
            ScreenMain.sprGameIcons.setFrame(0);
        } else {
            ScreenMain.sprGameIcons.setFrame(1);
        }
        ScreenMain.sprGameIcons.setPosition(this.iLeftTopX, this.iLeftTopY - this.iAnimTopBarOff);
        ScreenMain.sprGameIcons.paint(g);
        ScreenMain.sprGameIcons.setFrame(2);
        ScreenMain.sprGameIcons.setPosition(this.iRightTopX, this.iRightTopY - this.iAnimTopBarOff);
        ScreenMain.sprGameIcons.paint(g);
        this.mainScreen.fontMain.drawString(g, this.strLeftTop.toCharArray(), this.iLeftTopX + ScreenMain.sprGameIcons.getWidth() + (ScreenMain.sprGameIcons.getWidth() >> 2), this.iTopTextY - this.iAnimTopBarOff, 20);
        this.mainScreen.fontMain.drawString(g, this.strRightTop.toCharArray(), this.iRightTopX - (ScreenMain.sprGameIcons.getWidth() >> 2), this.iTopTextY - this.iAnimTopBarOff, 24);
    }

    private void paintBoardLines(Graphics g) {
        if (!this.bQuitAnim && this.bSelected) {
            int num = this.getSelectedSize();
            g.setColor(this.getColorOfDot(this.board[this.selectedDots[0] % 10][this.selectedDots[0] / 10]));
            g.setClip(this.iBoardX - ScreenMain.sprBorder.getHeight(), this.iBoardY - ScreenMain.sprBorder.getHeight(), this.iBoardW + (ScreenMain.sprBorder.getHeight() << 1), this.iBoardH + (ScreenMain.sprBorder.getHeight() << 1));
            if (this.bRectangle) {
                g.fillRect(this.iBoardX - ScreenMain.sprBorder.getHeight(), this.iBoardY - ScreenMain.sprBorder.getHeight(), this.iBoardW + (ScreenMain.sprBorder.getHeight() << 1), this.iBoardLinePartH);
                g.fillRect(this.iBoardX - ScreenMain.sprBorder.getHeight(), this.iBoardY + this.iBoardH + ScreenMain.sprBorder.getHeight() - this.iBoardLinePartH, this.iBoardW + (ScreenMain.sprBorder.getHeight() << 1), this.iBoardLinePartH);
                g.fillRect(this.iBoardX - ScreenMain.sprBorder.getHeight(), this.iBoardY - ScreenMain.sprBorder.getHeight(), this.iBoardLinePartH, this.iBoardH + (ScreenMain.sprBorder.getHeight() << 1));
                g.fillRect(this.iBoardX + this.iBoardW + ScreenMain.sprBorder.getHeight() - this.iBoardLinePartH, this.iBoardY - ScreenMain.sprBorder.getHeight(), this.iBoardLinePartH, this.iBoardH + (ScreenMain.sprBorder.getHeight() << 1));
            } else {
                g.fillRect((MainCanvas.WIDTH >> 1) - num * (this.iBoardLinePartW >> 1), this.iBoardY - ScreenMain.sprBorder.getHeight(), this.iBoardLinePartW * num, this.iBoardLinePartH);
                g.fillRect((MainCanvas.WIDTH >> 1) - num * (this.iBoardLinePartW >> 1), this.iBoardY + this.iBoardH + ScreenMain.sprBorder.getHeight() - this.iBoardLinePartH, this.iBoardLinePartW * num, this.iBoardLinePartH);
            }
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        }
    }

    private void paintBoard(Graphics g) {
        g.setClip(this.iBoardX, this.iBoardY, this.iBoardW, this.iBoardH);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this.bDeleteDot) {
                    ScreenMain.sprDots.setFrame(this.board[i][j] + 5);
                } else if (this.bDeleteColor) {
                    ScreenMain.sprDots.setFrame(this.board[i][j] + 10);
                } else {
                    ScreenMain.sprDots.setFrame((int)this.board[i][j]);
                }
                if (this.iAminStartDiff != 0) {
                    if (this.bQuitAnim) {
                        ScreenMain.sprDots.setPosition(this.rectBoard[i][j].x, this.rectBoard[i][j].y + this.iAminStartDiff);
                    } else {
                        ScreenMain.sprDots.setPosition(this.rectBoard[i][j].x, this.rectBoard[i][j].y - this.iAminStartDiff);
                    }
                } else {
                    ScreenMain.sprDots.setPosition(this.rectBoard[i][j].x, this.rectBoard[i][j].y);
                }
                ScreenMain.sprDots.paint(g);
            }
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    private void paintSelector(Graphics g) {
        if (this.selectorPos < 0) {
            g.setColor(10987948);
            if (this.selectorPos == -97) {
                g.drawRect(this.rectBonusLeft.x - 1, this.rectBonusLeft.y - 1, this.rectBonusLeft.width + 2, this.rectBonusLeft.height + 2);
            } else if (this.selectorPos == -98) {
                g.drawRect(this.rectBonusMiddle.x - 1, this.rectBonusMiddle.y - 1, this.rectBonusMiddle.width + 2, this.rectBonusMiddle.height + 2);
            } else if (this.selectorPos == -99) {
                g.drawRect(this.rectBonusRight.x - 1, this.rectBonusRight.y - 1, this.rectBonusRight.width + 2, this.rectBonusRight.height + 2);
            }
            return;
        }
        if (!this.bAminStartBoard && !this.bQuitAnim) {
            if (!this.bSelected) {
                g.setColor(10987948);
            } else {
                g.setColor(0x111111);
            }
            g.drawRect(this.iBoardX + this.iCellW * (this.selectorPos / 10) - 1, this.iBoardY + this.iCellH * (this.selectorPos % 10) - 1, this.iCellW + 2, this.iCellH + 2);
        }
    }

    private void paintSelectedDots(Graphics g) {
        if (!this.bQuitAnim) {
            int k;
            for (k = 0; k < this.getSelectedSize(); ++k) {
                ScreenMain.sprDots.setFrame(this.board[this.selectedDots[k] % 10][this.selectedDots[k] / 10] + this.selectedAnimStep);
                ScreenMain.sprDots.setPosition(this.rectBoard[this.selectedDots[k] % 10][this.selectedDots[k] / 10].x, this.rectBoard[this.selectedDots[k] % 10][this.selectedDots[k] / 10].y);
                ScreenMain.sprDots.paint(g);
            }
            for (k = 0; k < this.getSelectedSize(); ++k) {
                g.setColor(this.getColorOfDot(this.board[this.selectedDots[k] % 10][this.selectedDots[k] / 10]));
                if (this.selectedDots[k + 1] == -99) continue;
                if (this.selectedDots[k] - 1 == this.selectedDots[k + 1]) {
                    g.fillRect(this.rectBoard[this.selectedDots[k + 1] % 10][this.selectedDots[k + 1] / 10].x + (this.iCellW >> 1) - (this.iLineW >> 1), this.rectBoard[this.selectedDots[k + 1] % 10][this.selectedDots[k + 1] / 10].y + (this.iCellH >> 1), this.iLineW, this.iCellH);
                    continue;
                }
                if (this.selectedDots[k] + 1 == this.selectedDots[k + 1]) {
                    g.fillRect(this.rectBoard[this.selectedDots[k] % 10][this.selectedDots[k] / 10].x + (this.iCellW >> 1) - (this.iLineW >> 1), this.rectBoard[this.selectedDots[k] % 10][this.selectedDots[k] / 10].y + (this.iCellH >> 1), this.iLineW, this.iCellH);
                    continue;
                }
                if (this.selectedDots[k] + 10 == this.selectedDots[k + 1]) {
                    g.fillRect(this.rectBoard[this.selectedDots[k] % 10][this.selectedDots[k] / 10].x + (this.iCellW >> 1), this.rectBoard[this.selectedDots[k] % 10][this.selectedDots[k] / 10].y + (this.iCellH >> 1) - (this.iLineW >> 1), this.iCellW, this.iLineW);
                    continue;
                }
                if (this.selectedDots[k] - 10 != this.selectedDots[k + 1]) continue;
                g.fillRect(this.rectBoard[this.selectedDots[k + 1] % 10][this.selectedDots[k + 1] / 10].x + (this.iCellW >> 1), this.rectBoard[this.selectedDots[k + 1] % 10][this.selectedDots[k + 1] / 10].y + (this.iCellH >> 1) - (this.iLineW >> 1), this.iCellW, this.iLineW);
            }
        }
    }

    private void resetSelectedDots() {
        for (int i = 0; i < this.selectedDots.length; ++i) {
            this.selectedDots[i] = -99;
        }
    }

    private int getColorOfDot(byte dot) {
        switch (dot) {
            case 2: {
                return 3496396;
            }
            case 0: {
                return 5153291;
            }
            case 4: {
                return 3454939;
            }
            case 3: {
                return 14434598;
            }
            case 1: {
                return 16757782;
            }
        }
        return 0;
    }

    private void handleClickOnBonusItem(int item) {
        switch (item) {
            case -97: {
                if (this.gameType == 1) {
                    if (Bonus.getInstance().getValue(0) > 0) {
                        this.iTime += 5000;
                        Bonus.getInstance().subtractBonus(0, 1);
                        break;
                    }
                    this.mainScreen.playMusic(Sounds.MUSIC_MENU, -1);
                    this.mainScreen.getClass();
                    this.mainScreen.getClass();
                    this.mainScreen.nextScreen(1, 5, 0);
                    break;
                }
                if (this.gameType != 0) break;
                if (Bonus.getInstance().getValue(1) > 0) {
                    this.iMoves += 5;
                    this.strLeftTop = "" + this.iMoves;
                    Bonus.getInstance().subtractBonus(1, 1);
                    break;
                }
                this.mainScreen.playMusic(Sounds.MUSIC_MENU, -1);
                this.mainScreen.getClass();
                this.mainScreen.getClass();
                this.mainScreen.nextScreen(1, 5, 0);
                break;
            }
            case -98: {
                if (Bonus.getInstance().getValue(2) > 0) {
                    if (!this.bDeleteDot) {
                        this.bDeleteDot = true;
                        break;
                    }
                    this.bDeleteDot = false;
                    break;
                }
                this.mainScreen.playMusic(Sounds.MUSIC_MENU, -1);
                this.mainScreen.getClass();
                this.mainScreen.getClass();
                this.mainScreen.nextScreen(1, 5, 0);
                break;
            }
            case -99: {
                if (Bonus.getInstance().getValue(3) > 0) {
                    if (!this.bDeleteColor) {
                        this.bDeleteColor = true;
                        break;
                    }
                    this.bDeleteColor = false;
                    break;
                }
                this.mainScreen.playMusic(Sounds.MUSIC_MENU, -1);
                this.mainScreen.getClass();
                this.mainScreen.getClass();
                this.mainScreen.nextScreen(1, 5, 0);
                break;
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (!(this.bFallAnimInProgress || this.bAminStartBoard || this.bGameOver)) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                this.handleKeyDirection(0);
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                this.handleKeyDirection(1);
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.handleKeyDirection(2);
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                this.handleKeyDirection(3);
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (this.selectorPos >= 0) {
                    if (!this.bSelected) {
                        if (this.bDeleteDot) {
                            this.removeDotFromBonus();
                            this.orderBoard();
                            return;
                        }
                        if (this.bDeleteColor) {
                            this.removeColorFromBonus();
                            this.orderBoard();
                            return;
                        }
                        this.resetSelectedDots();
                        this.addDotToSelected(this.selectorPos);
                    } else {
                        if (this.getSelectedSize() > 1) {
                            this.deleteSelectedDots();
                            this.orderBoard();
                        }
                        this.resetSelectedDots();
                    }
                    this.bSelected = !this.bSelected;
                    this.bRectangle = false;
                } else {
                    this.handleClickOnBonusItem(this.selectorPos);
                }
            }
            if (Keys.isKeyPressed(48)) {
                if (!this.bSelected) {
                    this.handleClickOnBonusItem(-98);
                }
            } else if (Keys.isKeyPressed(42)) {
                if (!this.bSelected) {
                    this.handleClickOnBonusItem(-99);
                }
            } else if (Keys.isKeyPressed(35)) {
                this.handleClickOnBonusItem(-97);
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.bFallAnimInProgress && !this.bAminStartBoard && !this.bGameOver && this.rectBoardWhole.contains(x, y)) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (!this.rectBoard[i][j].contains(x, y)) continue;
                    this.selectorPos = j * 10 + i;
                    this.bSelected = true;
                    this.resetSelectedDots();
                    this.addDotToSelected(this.selectorPos);
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!(this.bDeleteColor || this.bDeleteDot || this.bFallAnimInProgress || this.bAminStartBoard || this.bGameOver || !this.bSelected || !this.rectBoardWhole.contains(x, y))) {
            int lastPosRow = this.selectedDots[this.getNextSelectedPointer() - 1] % 10;
            int lastPosCol = this.selectedDots[this.getNextSelectedPointer() - 1] / 10;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (!this.rectBoard[i][j].contains(x, y)) continue;
                    if (i != lastPosRow && j != lastPosCol) {
                        return;
                    }
                    if (i != lastPosRow) {
                        if (i > lastPosRow) {
                            this.handleKeyDirection(3);
                            continue;
                        }
                        this.handleKeyDirection(2);
                        continue;
                    }
                    if (j == lastPosCol) continue;
                    if (j > lastPosCol) {
                        this.handleKeyDirection(1);
                        continue;
                    }
                    this.handleKeyDirection(0);
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (!(this.bFallAnimInProgress || this.bAminStartBoard || this.bGameOver)) {
            if (this.getSelectedSize() > 1) {
                this.deleteSelectedDots();
                this.orderBoard();
            }
            this.resetSelectedDots();
            this.bSelected = false;
            this.bRectangle = false;
        }
        if (this.rectBonusLeft.contains(x, y)) {
            this.handleClickOnBonusItem(-97);
            return;
        }
        if (this.rectBonusMiddle.contains(x, y)) {
            this.handleClickOnBonusItem(-98);
            return;
        }
        if (this.rectBonusRight.contains(x, y)) {
            this.handleClickOnBonusItem(-99);
            return;
        }
        if (!this.bSelected) {
            if (this.bDeleteDot) {
                this.removeDotFromBonus();
                this.orderBoard();
                return;
            }
            if (this.bDeleteColor) {
                this.removeColorFromBonus();
                this.orderBoard();
                return;
            }
        }
    }

    private void orderBoard() {
        for (int j = 0; j < 6; ++j) {
            for (int i = 5; i >= 0; --i) {
                if (this.board[i][j] != -99) continue;
                this.moveDotsDown(i, j);
            }
        }
    }

    private void moveDotsDown(int targRow, int targCol) {
        while (this.board[targRow][targCol] == -99) {
            for (int i = targRow; i > 0; --i) {
                this.board[i][targCol] = this.board[i - 1][targCol];
                this.animateFall(targRow - i, targCol, 1);
            }
            this.animateFall(targRow, targCol, 1);
            this.spawnNewDot(targCol);
        }
    }

    private void spawnNewDot(int col) {
        Logger.l("spawn new dot");
        this.board[0][col] = (byte)RandomNum.getRandomUInt(5);
        this.animateFall(0, col, 1);
    }

    private void animateFall(int targRow, int targCol, int diff) {
        int slot = this.getNextFreeAnimSlot();
        if (slot != -1) {
            this.fallAnimations[slot][0] = targRow;
            this.fallAnimations[slot][1] = targCol;
            this.fallAnimations[slot][2] = this.rectBoard[targRow][targCol].y;
            this.fallAnimations[slot][3] = 1;
            this.rectBoard[targRow][targCol].y -= diff * this.iCellH;
        }
    }

    private int getNextFreeAnimSlot() {
        for (int i = 0; i < this.fallAnimations.length; ++i) {
            if (this.fallAnimations[i][3] != 0) continue;
            return i;
        }
        return -1;
    }

    private void handleKeyDirection(int direction) {
        if (!this.bSelected) {
            this.moveSelector(direction);
        } else if (this.getDotValue(this.selectorPos) == this.getNearDotValue(this.selectorPos, direction)) {
            int oldPos = this.selectorPos;
            this.moveSelector(direction);
            if (!this.isInSelected(this.selectorPos)) {
                this.addDotToSelected(this.selectorPos);
            } else if (this.selectedDots[this.getNextSelectedPointer() - 2] == this.selectorPos) {
                this.removeDotFromSelected(oldPos);
            } else if (!this.bRectangle) {
                this.addDotToSelected(this.selectorPos);
                this.bRectangle = true;
            } else {
                this.selectorPos = oldPos;
            }
        }
    }

    private void deleteSelectedDots() {
        int i;
        byte color = this.board[this.selectedDots[0] % 10][this.selectedDots[0] / 10];
        this.addScore(this.getSelectedSize(), this.bRectangle);
        if (this.gameType == 0) {
            --this.iMoves;
            this.strLeftTop = "" + this.iMoves;
            if (this.iMoves == 0) {
                this.gameOver();
            }
        }
        for (i = 0; i < this.selectedDots.length; ++i) {
            if (this.selectedDots[i] == -99) continue;
            this.board[this.selectedDots[i] % 10][this.selectedDots[i] / 10] = -99;
        }
        if (this.bRectangle) {
            for (i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.board[i][j] != color) continue;
                    this.board[i][j] = -99;
                }
            }
        }
    }

    private int getSelectedSize() {
        int count = 0;
        for (int i = 0; i < this.selectedDots.length; ++i) {
            if (this.selectedDots[i] != -99) {
                ++count;
                continue;
            }
            return count;
        }
        return count;
    }

    private void moveBonuses(int direction) {
        switch (direction) {
            case 0: {
                if (this.bDeleteColor || this.bDeleteDot) break;
                if (this.gameType != 2) {
                    if (this.selectorPos < -97) {
                        ++this.selectorPos;
                        break;
                    }
                    this.selectorPos = -99;
                    break;
                }
                if (this.selectorPos == -98) {
                    this.selectorPos = -99;
                    break;
                }
                this.selectorPos = -98;
                break;
            }
            case 1: {
                if (this.bDeleteColor || this.bDeleteDot) break;
                if (this.selectorPos > -99) {
                    --this.selectorPos;
                    break;
                }
                if (this.gameType != 2) {
                    this.selectorPos = -97;
                    break;
                }
                this.selectorPos = -98;
                break;
            }
            case 2: {
                if (this.selectorPos == -97) {
                    this.selectorPos = 5;
                    break;
                }
                if (this.selectorPos == -98) {
                    this.selectorPos = 25;
                    break;
                }
                if (this.selectorPos != -99) break;
                this.selectorPos = 45;
                break;
            }
            case 3: {
                if (this.selectorPos >= 0) {
                    if (!this.bDeleteColor && !this.bDeleteDot) {
                        if (this.gameType != 2) {
                            if (this.selectorPos < 20) {
                                this.selectorPos = -97;
                                break;
                            }
                            if (this.selectorPos < 40) {
                                this.selectorPos = -98;
                                break;
                            }
                            if (this.selectorPos >= 60) break;
                            this.selectorPos = -99;
                            break;
                        }
                        if (this.selectorPos < 30) {
                            this.selectorPos = -98;
                            break;
                        }
                        if (this.selectorPos >= 60) break;
                        this.selectorPos = -99;
                        break;
                    }
                    if (this.bDeleteColor) {
                        this.selectorPos = -99;
                        break;
                    }
                    if (!this.bDeleteDot) break;
                    this.selectorPos = -98;
                    break;
                }
                if (this.selectorPos == -97) {
                    this.selectorPos = 0;
                    break;
                }
                if (this.selectorPos == -98) {
                    this.selectorPos = 20;
                    break;
                }
                if (this.selectorPos != -99) break;
                this.selectorPos = 40;
                break;
            }
        }
    }

    public void moveSelector(int direction) {
        switch (direction) {
            case 0: {
                if (this.selectorPos >= 0) {
                    if (this.selectorPos > 9) {
                        this.selectorPos -= 10;
                        break;
                    }
                    this.selectorPos += 50;
                    break;
                }
                this.moveBonuses(0);
                break;
            }
            case 1: {
                if (this.selectorPos >= 0) {
                    if (this.selectorPos < 50) {
                        this.selectorPos += 10;
                        break;
                    }
                    this.selectorPos %= 10;
                    break;
                }
                this.moveBonuses(1);
                break;
            }
            case 2: {
                if (this.selectorPos >= 0) {
                    if (this.selectorPos % 10 > 0) {
                        --this.selectorPos;
                        break;
                    }
                    int tmp = this.selectorPos / 10;
                    this.selectorPos = 10 * tmp + 6 - 1;
                    break;
                }
                this.moveBonuses(2);
                break;
            }
            case 3: {
                if (this.selectorPos % 10 < 5 && this.selectorPos >= 0) {
                    ++this.selectorPos;
                    break;
                }
                this.moveBonuses(3);
                break;
            }
        }
        Logger.l("slctr pos: " + this.selectorPos);
    }

    private void addDotToSelected(int dotPos) {
        if (this.getSelectedSize() == 0) {
            this.selectedAnimStep = 0;
        }
        this.selectedDots[this.getNextSelectedPointer()] = dotPos;
    }

    private void removeDotFromBonus() {
        this.board[this.selectorPos % 10][this.selectorPos / 10] = -99;
        this.bDeleteDot = false;
        Bonus.getInstance().subtractBonus(2, 1);
    }

    private void removeColorFromBonus() {
        byte color = this.board[this.selectorPos % 10][this.selectorPos / 10];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this.board[i][j] != color) continue;
                this.board[i][j] = -99;
            }
        }
        this.orderBoard();
        this.bDeleteColor = false;
        Bonus.getInstance().subtractBonus(3, 1);
    }

    private void removeDotFromSelected(int dotPos) {
        for (int i = this.selectedDots.length - 1; i >= 0; --i) {
            if (this.selectedDots[i] != dotPos) continue;
            this.selectedDots[i] = -99;
            this.bRectangle = this.checkDublicates();
            return;
        }
    }

    public boolean checkDublicates() {
        for (int i = 0; i < this.selectedDots.length; ++i) {
            for (int j = 0; j < this.selectedDots.length; ++j) {
                if (this.selectedDots[i] != this.selectedDots[j] || i == j || this.selectedDots[i] == -99) continue;
                return true;
            }
        }
        return false;
    }

    private int getSelectedDotIndex(int dotpos) {
        for (int i = 0; i < this.selectedDots.length; ++i) {
            if (this.selectedDots[i] != dotpos) continue;
            return i;
        }
        return -1;
    }

    private int getNextSelectedPointer() {
        for (int i = 0; i < this.selectedDots.length; ++i) {
            if (this.selectedDots[i] != -99) continue;
            return i;
        }
        return 0;
    }

    private byte getDotValue(int dotPos) {
        return this.board[dotPos % 10][dotPos / 10];
    }

    private boolean isInSelected(int dotPos) {
        for (int i = 0; i < this.selectedDots.length; ++i) {
            if (this.selectedDots[i] != dotPos) continue;
            return true;
        }
        return false;
    }

    private void addScore(int count, boolean rectangle) {
        Logger.l("count " + count);
        this.iScore = !rectangle ? (this.iScore += count) : (--count == 4 ? (this.iScore += 10) : (this.iScore += 10 + (count - 4) * 4));
        this.strRightTop = "" + this.iScore;
    }

    private int getNearDotValue(int currentDotPos, int direction) {
        switch (direction) {
            case 0: {
                int row = this.selectorPos % 10;
                int col = this.selectorPos / 10 - 1;
                if (col >= 0) {
                    return this.board[row][col];
                }
                return -99;
            }
            case 1: {
                int row = this.selectorPos % 10;
                int col = this.selectorPos / 10 + 1;
                if (col < 6) {
                    return this.board[row][col];
                }
                return -99;
            }
            case 2: {
                int row = this.selectorPos % 10 - 1;
                int col = this.selectorPos / 10;
                if (row >= 0) {
                    return this.board[row][col];
                }
                return -99;
            }
            case 3: {
                int row = this.selectorPos % 10 + 1;
                int col = this.selectorPos / 10;
                if (row < 6) {
                    return this.board[row][col];
                }
                return -99;
            }
        }
        return -99;
    }

    private void gameOver() {
        this.bGameOver = true;
        this.bQuitAnim = true;
        this.defaultStartAnimStep = this.iCellH >> 3;
    }

    private void gameOverToScreen() {
        this.changeTotalScoreAndSave(this.iScore);
        this.mainScreen.playMusic(Sounds.MUSIC_MENU, -1);
        this.mainScreen.getClass();
        this.mainScreen.nextScreen(2, 1, 0);
    }

    public void update(long dt) {
        this.updateStartBoardAnim(dt);
        this.updateFallAnim(dt);
        this.updateTopBarValues(dt);
        this.updateSelectedAnimation(dt);
        this.updateEndBoardAnim(dt);
    }

    private void updateSelectedAnimation(long dt) {
        if (this.getSelectedSize() > 0) {
            this.lCounter += dt;
            if (this.lCounter >= 100L) {
                this.selectedAnimStep = this.selectedAnimStep < 20 ? (this.selectedAnimStep += 5) : (this.selectedAnimStep -= 20);
                this.lCounter = 0L;
            }
        }
    }

    private void updateStartBoardAnim(long dt) {
        if (this.bAminStartBoard) {
            if (this.iAnimBonusesOff > 0) {
                this.iAnimBonusesOff -= this.defaultStartAnimStep;
                ++this.defaultStartAnimStep;
                if (this.iAnimBonusesOff < 0) {
                    this.iAnimBonusesOff = 0;
                }
            }
            if (this.iAnimTopBarOff > 0) {
                this.iAnimTopBarOff -= this.defaultStartAnimStep;
                ++this.defaultStartAnimStep;
                if (this.iAnimTopBarOff < 0) {
                    this.iAnimTopBarOff = 0;
                    this.defaultStartAnimStep = this.iCellH >> 3;
                }
                return;
            }
            if (this.iAminStartDiff > 0) {
                this.iAminStartDiff -= this.defaultStartAnimStep;
                ++this.defaultStartAnimStep;
                if (this.iAminStartDiff <= 0) {
                    this.iAminStartDiff = 0;
                }
            } else {
                this.iAminStartDiff = 0;
                this.bAminStartBoard = false;
                this.bCalculateTime = true;
            }
        }
    }

    private void updateEndBoardAnim(long dt) {
        if (this.bQuitAnim) {
            if (this.iAnimBonusesOff < MainCanvas.HEIGHT - this.bonusY) {
                this.iAnimBonusesOff += this.defaultStartAnimStep;
                ++this.defaultStartAnimStep;
                if (this.iAnimBonusesOff > MainCanvas.HEIGHT - this.bonusY) {
                    this.iAnimBonusesOff = MainCanvas.HEIGHT - this.bonusY;
                }
            }
            if (this.iAnimTopBarOff < this.iTopTextY + ScreenMain.sprGameIcons.getHeight()) {
                this.iAnimTopBarOff += this.defaultStartAnimStep;
                ++this.defaultStartAnimStep;
                if (this.iAnimTopBarOff > this.iTopTextY + ScreenMain.sprGameIcons.getHeight()) {
                    this.iAnimTopBarOff = this.iTopTextY + ScreenMain.sprGameIcons.getHeight();
                    this.defaultStartAnimStep = this.iCellH >> 3;
                }
                return;
            }
            if (this.iAminStartDiff < 6 * this.iCellH) {
                this.iAminStartDiff += this.defaultStartAnimStep;
                ++this.defaultStartAnimStep;
                if (this.iAminStartDiff >= 6 * this.iCellH) {
                    this.iAminStartDiff = 6 * this.iCellH;
                }
            } else {
                this.bQuitAnim = false;
                this.gameOverToScreen();
            }
        }
    }

    private void updateFallAnim(long dt) {
        for (int i = 0; i < this.fallAnimations.length; ++i) {
            if (this.fallAnimations[i][3] != 1) continue;
            this.bFallAnimInProgress = true;
            if (this.rectBoard[this.fallAnimations[i][0]][this.fallAnimations[i][1]].y < this.fallAnimations[i][2]) {
                if (this.rectBoard[this.fallAnimations[i][0]][this.fallAnimations[i][1]].y >= this.fallAnimations[i][2]) {
                    this.rectBoard[this.fallAnimations[i][0]][this.fallAnimations[i][1]].y = this.fallAnimations[i][2];
                    this.fallAnimations[i][3] = 0;
                    Logger.l("nastavujem MULU +-+-+-++++++++++++");
                    continue;
                }
                this.rectBoard[this.fallAnimations[i][0]][this.fallAnimations[i][1]].y += this.iCellH >> 2;
                continue;
            }
            this.rectBoard[this.fallAnimations[i][0]][this.fallAnimations[i][1]].y = this.fallAnimations[i][2];
            this.fallAnimations[i][3] = 0;
        }
        this.bFallAnimInProgress = false;
    }

    public String convertTimeToString(int num) {
        int hlp = num / 60;
        int hlp2 = num % 60;
        String retStr = "";
        if (hlp > 0) {
            retStr = hlp < 10 ? retStr + "0" + hlp + ":" : retStr + hlp + ":";
            retStr = hlp2 < 10 ? retStr + "0" + hlp2 : retStr + "" + hlp2;
        } else {
            retStr = hlp2 < 10 ? retStr + "00:0" + hlp2 : retStr + "00:" + hlp2;
        }
        return retStr;
    }

    private void calculateTime(long dt) {
        if (this.bCalculateTime) {
            if (this.gameType == 1) {
                this.iTime = (int)((long)this.iTime - dt);
                this.strLeftTop = this.convertTimeToString(this.iTime / 1000);
                if (this.iTime <= 0) {
                    this.bCalculateTime = false;
                    this.gameOver();
                }
            } else if (this.gameType == 2) {
                this.iTime = (int)((long)this.iTime + dt);
                this.strLeftTop = this.convertTimeToString(this.iTime / 1000);
            }
        }
    }

    private void updateTopBarValues(long dt) {
        if (this.gameType != 0) {
            this.calculateTime(dt);
        }
    }

    public void changeTotalScoreAndSave(int count) {
        Profile.load();
        Profile.iTotalScore += count;
        Profile.save();
    }
}

