/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.diamonds.models;

import com.rocktasticgames.diamonds.graphics.Missile;
import com.rocktasticgames.diamonds.graphics.Particle;
import com.rocktasticgames.diamonds.graphics.Tile;
import com.rocktasticgames.diamonds.main.MainActivity;
import com.rocktasticgames.diamonds.parameters.Levels;
import com.rocktasticgames.diamonds.parameters.Levels1;
import com.rocktasticgames.diamonds.parameters.Levels10;
import com.rocktasticgames.diamonds.parameters.Levels11;
import com.rocktasticgames.diamonds.parameters.Levels12;
import com.rocktasticgames.diamonds.parameters.Levels2;
import com.rocktasticgames.diamonds.parameters.Levels3;
import com.rocktasticgames.diamonds.parameters.Levels4;
import com.rocktasticgames.diamonds.parameters.Levels5;
import com.rocktasticgames.diamonds.parameters.Levels6;
import com.rocktasticgames.diamonds.parameters.Levels7;
import com.rocktasticgames.diamonds.parameters.Levels8;
import com.rocktasticgames.diamonds.parameters.Levels9;
import com.rocktasticgames.diamonds.parameters.Params;
import com.rocktasticgames.diamonds.utils.List;
import com.rocktasticgames.diamonds.utils.XMath;

public class GameModel {
    private MainActivity activity;
    private long start_time;
    private long pause_time;
    private boolean ispaused = true;
    private long last_time;
    private float sim_factor = 1.0f;
    private long duration = 0L;
    private int moves = 0;
    private int moves_made = 0;
    private int level;
    private int gemtype1 = -1;
    private int gemtype2 = -1;
    private int gemnum1 = 0;
    private int gemnum2 = 0;
    private int gemmatched1 = 0;
    private int gemmatched2 = 0;
    private int score = 0;
    private boolean generate_new = true;
    private Tile[][] gems;
    private Tile[][] tiles;
    private Tile[][] bases;
    private List dead_tiles;
    private List dead_gems;
    private List cleared_gems;
    private int tiles_matched = 0;
    private int crates_matched = 0;
    private int numtiles = 0;
    private int numcrates = 0;
    private boolean bringback = false;
    private int back1row = -1;
    private int back1col = -1;
    private int back2row = -1;
    private int back2col = -1;
    private boolean matching = false;
    private boolean moving = true;
    private int combo = 0;
    private float top = 0.0f;
    private float bottom = 0.0f;
    private boolean already_won;
    private boolean already_lost = false;
    private long end_time = 0L;
    private List tile_particles;
    private List gem_particles;
    private List missiles;
    private Tile[][] gem_save;
    private Tile[][] tile_save;
    private long idle_time = 0L;
    private int[] hint;
    private List swaps_delayed;
    private List points;
    private float utility_charge = 0.0f;
    private long utility_time = -10000L;
    private boolean destroyed = false;

    public GameModel(MainActivity mainActivity, int n) {
        int n2;
        this.activity = mainActivity;
        this.level = n;
        this.start_time = 2L;
        this.pause_time = 0L;
        this.last_time = this.start_time;
        this.duration = Levels.LIMIT_TIME[this.level] * 1000 * 2;
        this.moves = Levels.LIMIT_MOVE[this.level];
        int n3 = 8;
        int n4 = 8;
        this.gems = new Tile[n3][n4];
        this.tiles = new Tile[n3][n4];
        this.bases = new Tile[n3][n4];
        this.gem_save = new Tile[n3][n4];
        this.tile_save = new Tile[n3][n4];
        this.dead_tiles = new List();
        this.dead_gems = new List();
        this.cleared_gems = new List();
        this.tile_particles = new List();
        this.gem_particles = new List();
        this.missiles = new List();
        this.swaps_delayed = new List();
        this.points = new List();
        if (Levels.WIN_CONDITION[this.level] == 3) {
            for (n2 = 0; n2 < Levels.WIN_GEMS[this.level].length; ++n2) {
                if (Levels.WIN_GEMS[this.level][n2] <= 0) continue;
                if (this.gemtype1 == -1) {
                    this.gemtype1 = n2;
                    this.gemnum1 = Levels.WIN_GEMS[this.level][n2];
                    continue;
                }
                this.gemtype2 = n2;
                this.gemnum2 = Levels.WIN_GEMS[this.level][n2];
            }
        } else if (Levels.WIN_CONDITION[this.level] == 2) {
            this.generate_new = false;
        }
        for (n2 = 0; n2 < this.tiles.length; ++n2) {
            for (int i = 0; i < this.tiles[n2].length; ++i) {
                boolean bl = false;
                int n5 = 120;
                int n6 = this.level % 10;
                switch (this.level / 10 + 1) {
                    case 1: {
                        bl = Levels1.BASE_TILE[n6][n2][i];
                        n5 = Levels1.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 2: {
                        bl = Levels2.BASE_TILE[n6][n2][i];
                        n5 = Levels2.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 3: {
                        bl = Levels3.BASE_TILE[n6][n2][i];
                        n5 = Levels3.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 4: {
                        bl = Levels4.BASE_TILE[n6][n2][i];
                        n5 = Levels4.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 5: {
                        bl = Levels5.BASE_TILE[n6][n2][i];
                        n5 = Levels5.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 6: {
                        bl = Levels6.BASE_TILE[n6][n2][i];
                        n5 = Levels6.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 7: {
                        bl = Levels7.BASE_TILE[n6][n2][i];
                        n5 = Levels7.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 8: {
                        bl = Levels8.BASE_TILE[n6][n2][i];
                        n5 = Levels8.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 9: {
                        bl = Levels9.BASE_TILE[n6][n2][i];
                        n5 = Levels9.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 10: {
                        bl = Levels10.BASE_TILE[n6][n2][i];
                        n5 = Levels10.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 11: {
                        bl = Levels11.BASE_TILE[n6][n2][i];
                        n5 = Levels11.TILE_TYPE[n6][n2][i];
                        break;
                    }
                    case 12: {
                        bl = Levels12.BASE_TILE[n6][n2][i];
                        n5 = Levels12.TILE_TYPE[n6][n2][i];
                    }
                }
                if (bl) {
                    this.tiles[n2][i] = new Tile(this.activity, "basetile", n2, i, 0.0f);
                    ++this.numtiles;
                }
                if (n5 != 120) continue;
                this.bases[n2][i] = (n2 + i) % 2 == 0 ? new Tile(this.activity, "stonetile", n2, i, 0.0f) : new Tile(this.activity, "stonetile", n2, i, 0.0f);
            }
        }
        this.generateMatrix();
    }

    public void destroy() {
        int n;
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        for (n = 0; n < this.bases.length; ++n) {
            for (int i = 0; i < this.bases[0].length; ++i) {
                if (this.bases[n][i] != null) {
                    this.bases[n][i].unload();
                }
                if (this.tiles[n][i] != null) {
                    this.tiles[n][i].unload();
                }
                if (this.gems[n][i] == null) continue;
                this.gems[n][i].unload();
            }
        }
        for (n = 0; n < this.dead_tiles.size(); ++n) {
            ((Tile)this.dead_tiles.get(n)).unload();
        }
        for (n = 0; n < this.dead_gems.size(); ++n) {
            ((Tile)this.dead_gems.get(n)).unload();
        }
        for (n = 0; n < this.cleared_gems.size(); ++n) {
            ((Tile)this.cleared_gems.get(n)).unload();
        }
        for (n = 0; n < this.tile_particles.size(); ++n) {
            ((Particle)this.tile_particles.get(n)).unload();
        }
        for (n = 0; n < this.gem_particles.size(); ++n) {
            ((Particle)this.gem_particles.get(n)).unload();
        }
        for (n = 0; n < this.missiles.size(); ++n) {
            ((Missile)this.missiles.get(n)).unload();
        }
    }

    public MainActivity getActivity() {
        return this.activity;
    }

    public int[] getHint() {
        return this.hint;
    }

    public long getIdleTime() {
        return this.idle_time;
    }

    public float getTopBound() {
        if (this.ispaused && this.last_time > 500L) {
            return -79.44444f * XMath.max(0.0f, (1.0f - (float)(System.currentTimeMillis() - this.pause_time)) / 2.0f * 2.0f);
        }
        return this.top;
    }

    public float getBotBound() {
        if (this.ispaused && this.last_time > 500L) {
            return 79.44444f * XMath.max(0.0f, (1.0f - (float)(System.currentTimeMillis() - this.pause_time)) / 2.0f * 2.0f);
        }
        return this.bottom;
    }

    public Tile[][] getTiles() {
        return this.tiles;
    }

    public Tile[][] getGems() {
        return this.gems;
    }

    public Tile[][] getBases() {
        return this.bases;
    }

    public List getDeadTiles() {
        return this.dead_tiles;
    }

    public List getDeadGems() {
        return this.dead_gems;
    }

    public List getTileParticles() {
        return this.tile_particles;
    }

    public List getGemParticles() {
        return this.gem_particles;
    }

    public List getMissiles() {
        return this.missiles;
    }

    public int getLevel() {
        return this.level;
    }

    public long getWinTime(long l) {
        if (this.already_won && this.end_time != 0L) {
            return l - this.end_time;
        }
        return 0L;
    }

    public long getLoseTime(long l) {
        if (this.already_lost && this.end_time != 0L) {
            return l - this.end_time;
        }
        return 0L;
    }

    public boolean swapHorizontal(int n, int n2, int n3) {
        if (n3 >= this.gems[0].length || n3 < 0 || n2 >= this.gems[0].length || n2 < 0 || n >= this.gems.length || n < 0 || this.bringback || this.matching || this.last_time <= 0L || this.already_won || this.moves > 0 && this.moves_made == this.moves) {
            return false;
        }
        if (this.gems[n][n2] == null || this.gems[n][n3] == null || this.gems[n][n2].isLocked() || this.gems[n][n3].isLocked() || !this.gems[n][n2].isInPlace() || !this.gems[n][n3].isInPlace() || this.gems[n][n2].isMatched() || this.gems[n][n3].isMatched()) {
            return false;
        }
        if (this.matching || this.bringback) {
            this.swaps_delayed.add(new int[]{0, n, n2, n3});
            return false;
        }
        Tile tile = this.gems[n][n2];
        this.gems[n][n2] = this.gems[n][n3];
        this.gems[n][n3] = tile;
        this.gems[n][n2].setDestXSwap(this.gems[n][n3].getPosition());
        this.gems[n][n3].setDestXSwap(this.gems[n][n2].getPosition());
        this.back1row = n;
        this.back2row = n;
        this.back1col = n2;
        this.back2col = n3;
        if (!this.hasMatch() && this.gems[n][n2].getType() != 'm' && this.gems[n][n3].getType() != 'm') {
            this.bringback = true;
            return false;
        }
        this.matching = true;
        ++this.moves_made;
        return true;
    }

    public boolean swapVertical(int n, int n2, int n3) {
        if (n2 >= this.gems.length || n2 < 0 || n >= this.gems.length || n < 0 || n3 >= this.gems[0].length || n3 < 0 || this.bringback || this.matching || this.last_time <= 0L || this.already_won || this.moves > 0 && this.moves_made == this.moves) {
            return false;
        }
        if (this.gems[n][n3] == null || this.gems[n2][n3] == null || this.gems[n][n3].isLocked() || this.gems[n2][n3].isLocked() || !this.gems[n][n3].isInPlace() || !this.gems[n2][n3].isInPlace() || this.gems[n][n3].isMatched() || this.gems[n2][n3].isMatched()) {
            return false;
        }
        if (this.matching || this.bringback) {
            this.swaps_delayed.add(new int[]{1, n, n2, n3});
            return false;
        }
        this.gems[n][n3].setDestYSwap(this.gems[n2][n3].getHeight());
        this.gems[n2][n3].setDestYSwap(this.gems[n][n3].getHeight());
        Tile tile = this.gems[n][n3];
        this.gems[n][n3] = this.gems[n2][n3];
        this.gems[n2][n3] = tile;
        this.back1row = n;
        this.back2row = n2;
        this.back1col = n3;
        this.back2col = n3;
        if (!this.hasMatch() && this.gems[n][n3].getType() != 'm' && this.gems[n2][n3].getType() != 'm') {
            this.bringback = true;
            return false;
        }
        this.matching = true;
        ++this.moves_made;
        return true;
    }

    private boolean hasMatch() {
        List list = this.findMatches();
        if (this.back1row == -1) {
            return list.size() > 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < ((int[][])list.get(i)).length; ++j) {
                if (((int[][])list.get(i))[j][0] == this.back1row && ((int[][])list.get(i))[j][1] == this.back1col) {
                    return true;
                }
                if (((int[][])list.get(i))[j][0] != this.back2row || ((int[][])list.get(i))[j][1] != this.back2col) continue;
                return true;
            }
        }
        return false;
    }

    public void replaceGrid() {
        int n;
        int n2;
        List list = new List();
        for (n2 = 0; n2 < this.gems.length; ++n2) {
            for (n = 0; n < this.gems[n2].length; ++n) {
                if (this.gems[n2][n] == null || this.gems[n2][n].isLocked()) continue;
                this.cleared_gems.add(this.gems[n2][n]);
                list.add(this.gems[n2][n]);
            }
        }
        do {
            List list2 = list;
            list = new List();
            for (n2 = 0; n2 < this.gems.length; ++n2) {
                for (n = 0; n < this.gems[n2].length; ++n) {
                    if (this.gems[n2][n] == null || this.gems[n2][n].isLocked()) continue;
                    this.gems[n2][n] = (Tile)list2.remove((int)(XMath.random() * (float)list2.size()));
                    this.gems[n2][n].accelerateTo(((float)n - 3.5f) * 19.86111f, ((float)n2 - 3.5f) * 19.86111f, this.last_time);
                    list.add(this.gems[n2][n]);
                }
            }
        } while (this.hasMatch() || !GameModel.hasAvailableMatch(this.gems));
    }

    public List getPointMarkers() {
        return this.points;
    }

    public List findMatches() {
        int n;
        int n2;
        int n3;
        List list = new List();
        List list2 = new List();
        List list3 = new List();
        List list4 = new List();
        List list5 = new List();
        for (n3 = 0; n3 < this.tiles.length; ++n3) {
            n2 = -1;
            list3 = new List();
            list4 = new List();
            list5 = new List();
            for (int i = 0; i < this.gems[0].length; ++i) {
                if (this.gems[n3][i] != null && this.gems[n3][i].getColor() == n2 && n2 != -1) {
                    list3.add(this.gems[n3][i]);
                    list4.add(new Integer(n3));
                    list5.add(new Integer(i));
                    continue;
                }
                if (list3.size() >= 3) {
                    int[][] nArray = new int[list3.size()][2];
                    for (n = 0; n < list3.size(); ++n) {
                        nArray[n][0] = ((Tile)list3.get(n)).getRow();
                        nArray[n][1] = ((Tile)list3.get(n)).getColumn();
                    }
                    list.add(nArray);
                }
                n2 = this.gems[n3][i] != null ? this.gems[n3][i].getColor() : -1;
                list3 = new List();
                list4 = new List();
                list5 = new List();
                if (this.gems[n3][i] != null) {
                    list3.add(this.gems[n3][i]);
                }
                list4.add(new Integer(n3));
                list5.add(new Integer(i));
            }
            if (list3.size() < 3) continue;
            int[][] nArray = new int[list3.size()][2];
            for (int i = 0; i < list3.size(); ++i) {
                nArray[i][0] = ((Tile)list3.get(i)).getRow();
                nArray[i][1] = ((Tile)list3.get(i)).getColumn();
            }
            list.add(nArray);
        }
        for (n3 = 0; n3 < this.gems[0].length; ++n3) {
            n2 = -1;
            list3 = new List();
            for (int i = 0; i < this.gems.length; ++i) {
                if (this.gems[i][n3] != null && this.gems[i][n3].getColor() == n2 && n2 != -1) {
                    list3.add(this.gems[i][n3]);
                    continue;
                }
                if (list3.size() >= 3) {
                    int[][] nArray = new int[list3.size()][2];
                    for (n = 0; n < list3.size(); ++n) {
                        nArray[n][0] = ((Tile)list3.get(n)).getRow();
                        nArray[n][1] = ((Tile)list3.get(n)).getColumn();
                    }
                    list2.add(nArray);
                }
                n2 = this.gems[i][n3] != null ? this.gems[i][n3].getColor() : -1;
                list3 = new List();
                if (this.gems[i][n3] == null) continue;
                list3.add(this.gems[i][n3]);
            }
            if (list3.size() < 3) continue;
            int[][] nArray = new int[list3.size()][2];
            for (int i = 0; i < list3.size(); ++i) {
                nArray[i][0] = ((Tile)list3.get(i)).getRow();
                nArray[i][1] = ((Tile)list3.get(i)).getColumn();
            }
            list2.add(nArray);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            for (int i = 0; i < list2.size(); ++i) {
                int n4;
                int n5;
                n3 = 0;
                for (n5 = 0; n5 < ((int[][])list.get(n2)).length; ++n5) {
                    int[] nArray = ((int[][])list.get(n2))[n5];
                    for (n4 = 0; n4 < ((int[][])list2.get(i)).length; ++n4) {
                        int[] nArray2 = ((int[][])list2.get(i))[n4];
                        if (nArray[0] != nArray2[0] || nArray[1] != nArray2[1]) continue;
                        n3 = 1;
                        break;
                    }
                    if (n3 != 0) break;
                }
                if (n3 == 0) continue;
                for (n5 = 0; n5 < ((int[][])list2.get(i)).length; ++n5) {
                    boolean bl = false;
                    for (n4 = 0; n4 < ((int[][])list.get(n2)).length; ++n4) {
                        if (((int[][])list.get(n2))[n4][0] != ((int[][])list2.get(i))[n5][0] || ((int[][])list.get(n2))[n4][1] != ((int[][])list2.get(i))[n5][1]) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    int[][] nArray = (int[][])list.get(n2);
                    list.set(n2, new int[nArray.length + 1][2]);
                    for (int j = 0; j < nArray.length; ++j) {
                        ((int[][])list.get((int)n2))[j] = nArray[j];
                    }
                    ((int[][])list.get((int)n2))[nArray.length] = ((int[][])list2.get(i))[n5];
                }
                list2.remove(i);
                --i;
            }
        }
        list.addAll(list2);
        return list;
    }

    public static boolean hasAvailableMatch(Tile[][] tileArray) {
        return GameModel.findAvailableMatch(tileArray) != null;
    }

    public static int[] findAvailableMatch(Tile[][] tileArray) {
        for (int i = 0; i < tileArray.length; ++i) {
            for (int j = 0; j < tileArray[0].length; ++j) {
                boolean bl;
                int n;
                if (tileArray[i][j] == null || tileArray[i][j].isLocked()) continue;
                if (tileArray[i][j].getType() == 'm') {
                    if (i > 0 && tileArray[i - 1][j] != null) {
                        return new int[]{i, j, i - 1, j};
                    }
                    if (j > 0 && tileArray[i][j - 1] != null) {
                        return new int[]{i, j, i, j - 1};
                    }
                    if (i < tileArray.length - 1 && tileArray[i + 1][j] != null) {
                        return new int[]{i, j, i + 1, j};
                    }
                    if (j < tileArray[i].length - 1 && tileArray[i][j + 1] != null) {
                        return new int[]{i, j, i, j + 1};
                    }
                }
                if (i > 0 && tileArray[i - 1][j] != null && !tileArray[i - 1][j].isLocked()) {
                    n = tileArray[i - 1][j].getColor();
                    bl = false;
                    if (i + 2 < tileArray.length && tileArray[i + 1][j] != null && tileArray[i + 2][j] != null && tileArray[i + 1][j].getColor() == n && tileArray[i + 2][j].getColor() == n) {
                        return new int[]{i, j, i - 1, j};
                    }
                    if (j > 0 && tileArray[i][j - 1] != null && tileArray[i][j - 1].getColor() == n) {
                        bl = true;
                        if (j > 1 && tileArray[i][j - 2] != null && tileArray[i][j - 2].getColor() == n) {
                            return new int[]{i, j, i - 1, j};
                        }
                    }
                    if (j + 1 < tileArray[i].length && tileArray[i][j + 1] != null && tileArray[i][j + 1].getColor() == n) {
                        if (bl) {
                            return new int[]{i, j, i - 1, j};
                        }
                        if (j + 2 < tileArray[i].length && tileArray[i][j + 2] != null && tileArray[i][j + 2].getColor() == n) {
                            return new int[]{i, j, i - 1, j};
                        }
                    }
                }
                if (i + 1 < tileArray.length && tileArray[i + 1][j] != null && !tileArray[i + 1][j].isLocked()) {
                    n = tileArray[i + 1][j].getColor();
                    bl = false;
                    if (i > 1 && tileArray[i - 1][j] != null && tileArray[i - 2][j] != null && tileArray[i - 1][j].getColor() == n && tileArray[i - 2][j].getColor() == n) {
                        return new int[]{i, j, i + 1, j};
                    }
                    if (j > 0 && tileArray[i][j - 1] != null && tileArray[i][j - 1].getColor() == n) {
                        bl = true;
                        if (j > 1 && tileArray[i][j - 2] != null && tileArray[i][j - 2].getColor() == n) {
                            return new int[]{i, j, i + 1, j};
                        }
                    }
                    if (j + 1 < tileArray[i].length && tileArray[i][j + 1] != null && tileArray[i][j + 1].getColor() == n) {
                        if (bl) {
                            return new int[]{i, j, i + 1, j};
                        }
                        if (j + 2 < tileArray[i].length && tileArray[i][j + 2] != null && tileArray[i][j + 2].getColor() == n) {
                            return new int[]{i, j, i + 1, j};
                        }
                    }
                }
                if (j > 0 && tileArray[i][j - 1] != null && !tileArray[i][j - 1].isLocked()) {
                    n = tileArray[i][j - 1].getColor();
                    bl = false;
                    if (j + 2 < tileArray.length && tileArray[i][j + 1] != null && tileArray[i][j + 2] != null && tileArray[i][j + 1].getColor() == n && tileArray[i][j + 2].getColor() == n) {
                        return new int[]{i, j, i, j - 1};
                    }
                    if (i > 0 && tileArray[i - 1][j] != null && tileArray[i - 1][j].getColor() == n) {
                        bl = true;
                        if (i > 1 && tileArray[i - 2][j] != null && tileArray[i - 2][j].getColor() == n) {
                            return new int[]{i, j, i, j - 1};
                        }
                    }
                    if (i + 1 < tileArray.length && tileArray[i + 1][j] != null && tileArray[i + 1][j].getColor() == n) {
                        if (bl) {
                            return new int[]{i, j, i, j - 1};
                        }
                        if (i + 2 < tileArray.length && tileArray[i + 2][j] != null && tileArray[i + 2][j].getColor() == n) {
                            return new int[]{i, j, i, j - 1};
                        }
                    }
                }
                if (j + 1 >= tileArray[i].length || tileArray[i][j + 1] == null || tileArray[i][j + 1].isLocked()) continue;
                n = tileArray[i][j + 1].getColor();
                bl = false;
                if (j > 1 && tileArray[i][j - 1] != null && tileArray[i][j - 2] != null && tileArray[i][j - 1].getColor() == n && tileArray[i][j - 2].getColor() == n) {
                    return new int[]{i, j, i, j + 1};
                }
                if (i > 0 && tileArray[i - 1][j] != null && tileArray[i - 1][j].getColor() == n) {
                    bl = true;
                    if (i > 1 && tileArray[i - 2][j] != null && tileArray[i - 2][j].getColor() == n) {
                        return new int[]{i, j, i, j + 1};
                    }
                }
                if (i + 1 >= tileArray.length || tileArray[i + 1][j] == null || tileArray[i + 1][j].getColor() != n) continue;
                if (bl) {
                    return new int[]{i, j, i, j + 1};
                }
                if (i + 2 >= tileArray.length || tileArray[i + 2][j] == null || tileArray[i + 2][j].getColor() != n) continue;
                return new int[]{i, j, i, j + 1};
            }
        }
        return null;
    }

    public boolean showCursor() {
        return !this.already_won && !this.already_lost;
    }

    public void generateMatrix() {
        do {
            this.numcrates = 0;
            for (int i = 0; i < this.gems.length; ++i) {
                block22: for (int j = 0; j < this.gems[0].length; ++j) {
                    if (this.gems[i][j] != null) {
                        this.gems[i][j].unload();
                    }
                    int n = (int)(XMath.random() * (float)Params.GEM_IMG.length);
                    char c = 'x';
                    int n2 = this.level % 10;
                    switch (this.level / 10 + 1) {
                        case 1: {
                            c = Levels1.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 2: {
                            c = Levels2.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 3: {
                            c = Levels3.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 4: {
                            c = Levels4.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 5: {
                            c = Levels5.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 6: {
                            c = Levels6.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 7: {
                            c = Levels7.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 8: {
                            c = Levels8.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 9: {
                            c = Levels9.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 10: {
                            c = Levels10.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 11: {
                            c = Levels11.TILE_TYPE[n2][i][j];
                            break;
                        }
                        case 12: {
                            c = Levels12.TILE_TYPE[n2][i][j];
                        }
                    }
                    switch (c) {
                        case 'r': {
                            this.gems[i][j] = new Tile(this.activity, Params.GEM_IMG[n], i, j, (float)this.gems.length, c, n, 0L);
                            continue block22;
                        }
                        case 'd': 
                        case 's': {
                            this.gems[i][j] = new Tile(this.activity, Params.GEM_IMG[n], i, j, 0.0f, c, n, -100000L);
                            continue block22;
                        }
                        case 'c': {
                            this.gems[i][j] = new Tile(this.activity, Params.CRATE_INGAME[this.level / 40], i, j, 0.0f, 'c', -1, -100000L);
                            ++this.numcrates;
                            continue block22;
                        }
                        case 'f': {
                            this.gems[i][j] = new Tile(this.activity, Params.FROZENGEM_IMG[n], i, j, 0.0f, 'f', n, -100000L);
                            continue block22;
                        }
                        default: {
                            this.gems[i][j] = null;
                        }
                    }
                }
            }
        } while (this.hasMatch() || !GameModel.hasAvailableMatch(this.gems));
    }

    public void setSimSpeed(float f) {
        this.start_time = this.ispaused ? (this.start_time += (long)((float)(this.pause_time - this.start_time) * (1.0f - this.sim_factor / f))) : (this.start_time += (long)((float)(System.currentTimeMillis() - this.start_time) * (1.0f - this.sim_factor / f)));
        this.sim_factor = f;
    }

    public boolean checkVictory() {
        switch (Levels.WIN_CONDITION[this.level]) {
            default: {
                return this.tiles_matched == this.numtiles;
            }
            case 4: {
                return this.crates_matched == this.numcrates;
            }
            case 3: {
                if (this.gemmatched2 < this.gemnum2) {
                    return false;
                }
                return this.gemmatched1 >= this.gemnum1;
            }
            case 1: 
        }
        return this.score >= Levels.WIN_SCORE[this.level];
    }

    public boolean isMoveLimited() {
        return this.duration == 0L;
    }

    public int movesRemaining() {
        return this.moves - this.moves_made;
    }

    public float timeRemaining() {
        return XMath.max(0.0f, (float)(this.duration - this.last_time) / (float)this.duration);
    }

    public int winCondition() {
        return Levels.WIN_CONDITION[this.level];
    }

    public int victoryGem1() {
        return this.gemtype1;
    }

    public int victoryGem2() {
        return this.gemtype2;
    }

    public String gemProg1() {
        switch (this.winCondition()) {
            case 4: {
                return this.crates_matched + "/" + this.numcrates;
            }
            case 2: {
                return this.tiles_matched + "/" + this.numtiles;
            }
            case 1: {
                return this.score + "/" + Levels.WIN_SCORE[this.level];
            }
        }
        return Math.min(this.gemmatched1, this.gemnum1) + "/" + this.gemnum1;
    }

    public String gemProg2() {
        return Math.min(this.gemmatched2, this.gemnum2) + "/" + this.gemnum2;
    }

    public String gemTarget1() {
        switch (this.winCondition()) {
            case 4: {
                return "X" + this.numcrates;
            }
            case 2: {
                return "X" + this.numtiles;
            }
            case 1: {
                return "";
            }
        }
        return "X" + this.gemnum1;
    }

    public String gemTarget2() {
        return "X" + this.gemnum2;
    }

    public boolean isDoubleMatchWin() {
        return Levels.WIN_CONDITION[this.level] == 3 && this.gemtype2 >= 0;
    }

    public boolean isPaused() {
        return this.ispaused;
    }

    public void start() {
        if (!this.ispaused) {
            return;
        }
        this.start_time += System.currentTimeMillis() - this.pause_time;
        if (this.pause_time > 0L && this.last_time > 500L) {
            this.pause_time = System.currentTimeMillis();
        }
        this.ispaused = false;
    }

    public void pause() {
        if (this.ispaused) {
            return;
        }
        this.pause_time = System.currentTimeMillis();
        if (this.last_time < 500L) {
            this.pause_time -= 2L;
            this.start_time -= 2L;
        }
        this.ispaused = true;
    }

    public void togglePause() {
        if (this.ispaused) {
            this.start();
        } else {
            this.pause();
        }
    }

    public float getUtilityCharge() {
        return this.utility_charge;
    }

    public float getUtilityProgress() {
        return (float)(this.last_time - this.utility_time) / 250.0f;
    }

    public boolean isUtilityActive() {
        return this.last_time - this.utility_time < 250L;
    }

    public boolean activateUtility(int n, int n2) {
        if (this.utility_charge < 1.0f || this.gems[n][n2] == null) {
            return false;
        }
        switch (this.getUtilityType()) {
            case 0: {
                for (int i = Math.max(0, n - 1); i < Math.min(this.gems.length, n + 2); ++i) {
                    for (int j = Math.max(0, n2 - 1); j < Math.min(this.gems[0].length, n2 + 2); ++j) {
                        if (this.gems[i][j] != null) {
                            this.gems[i][j].matchSpecial();
                        }
                        this.killGem(i, j, this.last_time + 250L, false);
                    }
                }
                break;
            }
            case 1: {
                if (this.gems[n][n2] != null) {
                    this.gems[n][n2].matchSpecial();
                }
                this.killGem(n, n2, this.last_time + 250L, false);
                break;
            }
            case 2: {
                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), 0.0f, -297.91666f, this.gems[n][n2].getHeight(), this.last_time + 250L));
                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), 0.0f, 297.91666f, this.gems[n][n2].getHeight(), this.last_time + 250L));
                for (int i = 0; i < this.gems[0].length; ++i) {
                    if (this.gems[n][i] != null) {
                        this.gems[n][i].matchSpecial();
                    }
                    this.killGem(n, i, this.last_time + 250L + (long)((float)(Math.abs(n2 - i) * 1000) / 8.0f), false);
                }
                break;
            }
        }
        ++this.combo;
        this.utility_time = this.last_time;
        this.utility_charge = 0.0f;
        this.moving = true;
        return true;
    }

    public int getUtilityType() {
        return Levels.UTILITY_TYPE[this.level];
    }

    public void clearTile(int n, int n2, long l) {
        if (!(this.tiles[n][n2] == null || this.gems[n][n2] != null && this.gems[n][n2].isLocked())) {
            int n3 = Params.MIN_PARTICLES[0] + (int)((float)(Params.MAX_PARTICLES[0] - Params.MIN_PARTICLES[0]) * XMath.random());
            for (int i = 0; i < n3; ++i) {
                this.tile_particles.add(new Particle(this.activity.getAssetLoader(), Params.PARTICLE_TILE, 0, this.tiles[n][n2].getPosition(), this.tiles[n][n2].getHeight(), l));
            }
            this.dead_tiles.add(this.tiles[n][n2]);
            this.tiles[n][n2].stampTime(l);
            ++this.tiles_matched;
        }
    }

    public void killGem(int n, int n2, long l, boolean bl) {
        int n3;
        int n4;
        if (this.gems[n][n2] == null || this.gems[n][n2].isMatched()) {
            return;
        }
        if (this.gems[n][n2] == null) {
            this.clearTile(n, n2, l);
        } else {
            int n5;
            int n6;
            String[] stringArray;
            n4 = this.gems[n][n2].getType();
            n3 = this.gems[n][n2].isNew(l);
            switch (n4) {
                case 100: 
                case 115: {
                    stringArray = Params.PARTICLE_CHAIN;
                    n6 = 1;
                    break;
                }
                case 99: {
                    stringArray = Params.PARTICLE_CRATE[this.level / 40];
                    if (!this.gems[n][n2].hasPendingHit()) {
                        ++this.crates_matched;
                    }
                    n6 = 2;
                    break;
                }
                case 102: {
                    stringArray = Params.PARTICLE_ICE;
                    n6 = 3;
                    break;
                }
                default: {
                    stringArray = Params.PARTICLE_GEM;
                    n6 = 4;
                }
            }
            int n7 = Params.MIN_PARTICLES[n6] + (int)((float)(Params.MAX_PARTICLES[n6] - Params.MIN_PARTICLES[n6]) * XMath.random());
            for (n5 = 0; n5 < n7; ++n5) {
                this.gem_particles.add(new Particle(this.activity.getAssetLoader(), stringArray, n6, this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), l));
            }
            if (this.gems[n][n2].hitDestroys(l)) {
                this.clearTile(n, n2, l);
                if (this.gems[n][n2].getColor() == this.gemtype1) {
                    ++this.gemmatched1;
                } else if (this.gems[n][n2].getColor() == this.gemtype2) {
                    ++this.gemmatched2;
                }
                this.dead_gems.add(this.gems[n][n2]);
                this.gems[n][n2].stampDestroyed(l, !bl);
            } else {
                this.gem_save[n][n2] = this.gems[n][n2];
            }
            if (n4 == 104 && n3 == 0) {
                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), 0.0f, -297.91666f, this.gems[n][n2].getHeight(), l));
                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), 0.0f, 297.91666f, this.gems[n][n2].getHeight(), l));
                for (n5 = 0; n5 < this.gems[0].length; ++n5) {
                    if (this.gems[n][n5] != null && !this.gems[n][n5].isMatched()) {
                        this.gems[n][n5].matchSpecial();
                    }
                    this.killGem(n, n5, l + (long)((float)(Math.abs(n2 - n5) * 1000) / 8.0f), false);
                }
                this.activity.getSounds().playEffect("rowcutgem_activate");
            } else if (n4 == 118 && n3 == 0) {
                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), 0.0f, this.gems[n][n2].getPosition(), -297.91666f, l));
                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n][n2].getPosition(), this.gems[n][n2].getHeight(), 0.0f, this.gems[n][n2].getPosition(), 297.91666f, l));
                for (n5 = 0; n5 < this.gems.length; ++n5) {
                    if (this.gems[n5][n2] != null && !this.gems[n5][n2].isMatched()) {
                        this.gems[n5][n2].matchSpecial();
                    }
                    this.killGem(n5, n2, l + (long)((float)(Math.abs(n - n5) * 1000) / 8.0f), false);
                }
                this.activity.getSounds().playEffect("rowcutgem_activate");
            } else if (n4 == 98 && n3 == 0) {
                for (n5 = Math.max(0, n - 1); n5 < Math.min(this.gems.length, n + 2); ++n5) {
                    for (int i = Math.max(0, n2 - 1); i < Math.min(this.gems[0].length, n2 + 2); ++i) {
                        if (this.gems[n5][i] != null && !this.gems[n5][i].isMatched()) {
                            this.gems[n5][i].matchSpecial();
                        }
                        this.killGem(n5, i, l + 300L, false);
                    }
                }
                this.activity.getSounds().playEffect("blastgem_activate");
            }
        }
        if (n > 0 && this.gems[n - 1][n2] != null && this.gems[n - 1][n2].getType() == 'c' && !this.gems[n - 1][n2].hasPendingHit()) {
            n4 = Params.MIN_PARTICLES[2] + (int)((float)(Params.MAX_PARTICLES[2] - Params.MIN_PARTICLES[2]) * XMath.random());
            for (n3 = 0; n3 < n4; ++n3) {
                this.gem_particles.add(new Particle(this.activity.getAssetLoader(), Params.PARTICLE_CRATE[this.level / 40], 2, this.gems[n - 1][n2].getPosition(), this.gems[n - 1][n2].getHeight(), l));
            }
            this.dead_tiles.add(this.gems[n - 1][n2]);
            this.gems[n - 1][n2].hitCrate(l);
            ++this.crates_matched;
            this.score += 20 * this.combo;
            this.points.add(new int[]{(int)this.gems[n - 1][n2].getPosition(), (int)this.gems[n - 1][n2].getHeight(), (int)l, 20 * this.combo, -1});
        }
        if (n < this.gems.length - 1 && this.gems[n + 1][n2] != null && this.gems[n + 1][n2].getType() == 'c' && !this.gems[n + 1][n2].hasPendingHit()) {
            n4 = Params.MIN_PARTICLES[2] + (int)((float)(Params.MAX_PARTICLES[2] - Params.MIN_PARTICLES[2]) * XMath.random());
            for (n3 = 0; n3 < n4; ++n3) {
                this.gem_particles.add(new Particle(this.activity.getAssetLoader(), Params.PARTICLE_CRATE[this.level / 40], 2, this.gems[n + 1][n2].getPosition(), this.gems[n + 1][n2].getHeight(), l));
            }
            this.dead_tiles.add(this.gems[n + 1][n2]);
            this.gems[n + 1][n2].hitCrate(l);
            ++this.crates_matched;
            this.score += 20 * this.combo;
            this.points.add(new int[]{(int)this.gems[n + 1][n2].getPosition(), (int)this.gems[n + 1][n2].getHeight(), (int)l, 20 * this.combo, -1});
        }
        if (n2 > 0 && this.gems[n][n2 - 1] != null && this.gems[n][n2 - 1].getType() == 'c' && !this.gems[n][n2 - 1].hasPendingHit()) {
            n4 = Params.MIN_PARTICLES[2] + (int)((float)(Params.MAX_PARTICLES[2] - Params.MIN_PARTICLES[2]) * XMath.random());
            for (n3 = 0; n3 < n4; ++n3) {
                this.gem_particles.add(new Particle(this.activity.getAssetLoader(), Params.PARTICLE_CRATE[this.level / 40], 2, this.gems[n][n2 - 1].getPosition(), this.gems[n][n2 - 1].getHeight(), l));
            }
            this.dead_tiles.add(this.gems[n][n2 - 1]);
            this.gems[n][n2 - 1].hitCrate(l);
            ++this.crates_matched;
            this.score += 20 * this.combo;
            this.points.add(new int[]{(int)this.gems[n][n2 - 1].getPosition(), (int)this.gems[n][n2 - 1].getHeight(), (int)l, 20 * this.combo, -1});
        }
        if (n2 < this.gems[0].length - 1 && this.gems[n][n2 + 1] != null && this.gems[n][n2 + 1].getType() == 'c' && !this.gems[n][n2 + 1].hasPendingHit()) {
            n4 = Params.MIN_PARTICLES[2] + (int)((float)(Params.MAX_PARTICLES[2] - Params.MIN_PARTICLES[2]) * XMath.random());
            for (n3 = 0; n3 < n4; ++n3) {
                this.gem_particles.add(new Particle(this.activity.getAssetLoader(), Params.PARTICLE_CRATE[this.level / 40], 2, this.gems[n][n2 + 1].getPosition(), this.gems[n][n2 + 1].getHeight(), l));
            }
            this.dead_tiles.add(this.gems[n][n2 + 1]);
            this.gems[n][n2 + 1].hitCrate(l);
            ++this.crates_matched;
            this.score += 20 * this.combo;
            this.points.add(new int[]{(int)this.gems[n][n2 + 1].getPosition(), (int)this.gems[n][n2 + 1].getHeight(), (int)l, 20 * this.combo, -1});
        }
    }

    public boolean refresh(long l) {
        Object object;
        float f = (float)(l - this.last_time) / 1000.0f;
        long l2 = this.end_time > 0L && this.end_time < l ? Math.max(this.end_time + 2000L - l, -2L) : (long)XMath.min((float)(System.currentTimeMillis() - this.pause_time) * 2.0f - 2.0f, l);
        this.top = -79.44444f * XMath.min(1.0f, (float)(2L + l2) / 2.0f);
        this.bottom = 79.44444f * XMath.min(1.0f, (float)(2L + l2) / 2.0f);
        if (!this.already_won && this.checkVictory()) {
            if (this.activity.getSharedPref().getInt("maxlevel", 0) == this.level) {
                this.activity.getPrefEditor().putInt("maxlevel", this.level + 1);
                this.activity.getPrefEditor().commit();
            }
            this.already_won = true;
        }
        if (!this.matching && this.swaps_delayed.size() > 0) {
            object = (int[])this.swaps_delayed.remove(0);
            if (object[0] == 0) {
                this.swapHorizontal(object[1], object[2], object[3]);
            } else {
                this.swapVertical(object[1], object[2], object[3]);
            }
        }
        this.hint = (int[])(l > this.idle_time + 7000L ? GameModel.findAvailableMatch(this.gems) : null);
        if (l >= 0L) {
            if (this.already_lost) {
                if (l > this.end_time + 2L + 2000L + 400L) {
                    this.activity.stopLevel();
                    this.activity.startPostgame(this.level, true);
                    return false;
                }
            } else {
                if (this.already_won && !this.moving) {
                    if (this.end_time == 0L) {
                        this.end_time = l + 500L;
                    } else if (l > this.end_time + 2L + 2000L + 400L) {
                        this.activity.getSounds().playEffect("level_victory");
                        this.activity.stopLevel();
                        if (this.level % 4 == 3 && this.activity.getSharedPref().getInt("maxlevel", 0) == this.level + 1) {
                            this.activity.startStainedGlass(true);
                        } else {
                            this.activity.startPostgame(this.level, false);
                        }
                        return false;
                    }
                    return true;
                }
                if (this.bringback) {
                    if (this.gems[this.back1row][this.back1col].isInPlace() && this.gems[this.back2row][this.back2col].isInPlace()) {
                        this.bringback = false;
                        if (this.back1row == this.back2row) {
                            this.gems[this.back1row][this.back1col].setDestXSwap(this.gems[this.back2row][this.back2col].getPosition());
                            this.gems[this.back2row][this.back2col].setDestXSwap(this.gems[this.back1row][this.back1col].getPosition());
                        } else {
                            this.gems[this.back1row][this.back1col].setDestYSwap(this.gems[this.back2row][this.back2col].getHeight());
                            this.gems[this.back2row][this.back2col].setDestYSwap(this.gems[this.back1row][this.back1col].getHeight());
                        }
                        object = this.gems[this.back1row][this.back1col];
                        this.gems[this.back1row][this.back1col] = this.gems[this.back2row][this.back2col];
                        this.gems[this.back2row][this.back2col] = object;
                        this.back2col = -1;
                        this.back2row = -1;
                        this.back1col = -1;
                        this.back1row = -1;
                    }
                } else if (this.matching || this.moving) {
                    int n;
                    int n2;
                    int[][] nArray;
                    int n3;
                    int n4;
                    int n5;
                    boolean bl = this.moving;
                    boolean bl2 = true;
                    boolean bl3 = false;
                    this.idle_time = l;
                    for (n5 = 0; n5 < this.gems.length; ++n5) {
                        for (n4 = 0; n4 < this.gems[n5].length; ++n4) {
                            if (this.gems[n5][n4] == null) continue;
                            if (!this.gems[n5][n4].isInPlace()) {
                                bl2 = false;
                                continue;
                            }
                            if (!this.gems[n5][n4].didJustClick()) continue;
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        this.activity.getSounds().playEffect("gemdrop");
                    }
                    if (this.getUtilityProgress() <= 1.0f) {
                        bl2 = false;
                    }
                    if (bl2) {
                        this.moving = false;
                    }
                    for (n5 = 0; n5 < this.gems.length; ++n5) {
                        for (n4 = 0; n4 < this.gems[n5].length; ++n4) {
                            this.gem_save[n5][n4] = this.gems[n5][n4];
                            if (this.gems[n5][n4] != null && this.gems[n5][n4].isMatched()) {
                                this.gems[n5][n4] = null;
                                this.moving = true;
                            }
                            this.tile_save[n5][n4] = this.tiles[n5][n4];
                            if (this.tiles[n5][n4] == null || !this.tiles[n5][n4].isMatched()) continue;
                            this.tiles[n5][n4] = null;
                            this.moving = true;
                        }
                    }
                    if (!bl2) {
                        // empty if block
                    }
                    n5 = -1;
                    n4 = -1;
                    int n6 = -1;
                    if (this.matching && this.gems[this.back1row][this.back1col] != null && this.gems[this.back1row][this.back1col].getType() == 'm' && this.gems[this.back1row][this.back1col].isInPlace()) {
                        n4 = this.back1row;
                        n6 = this.back1col;
                        n5 = this.gems[this.back2row][this.back2col].getColor();
                    } else if (this.matching && this.gems[this.back2row][this.back2col] != null && this.gems[this.back2row][this.back2col].getType() == 'm' && this.gems[this.back2row][this.back2col].isInPlace()) {
                        n4 = this.back2row;
                        n6 = this.back2col;
                        n5 = this.gems[this.back1row][this.back1col].getColor();
                    }
                    if (n5 != -1) {
                        ++this.combo;
                        for (int i = 0; i < this.gems.length; ++i) {
                            for (int j = 0; j < this.gems[i].length; ++j) {
                                if (this.gems[i][j] == null || this.gems[i][j].getColor() != n5 && (i != this.back1row || j != this.back1col) && (i != this.back2row || j != this.back2col)) continue;
                                this.missiles.add(new Missile(this.activity.getAssetLoader(), "effect_comettail", this.gems[n4][n6].getPosition(), this.gems[n4][n6].getHeight(), 0.0f, this.gems[i][j].getPosition(), this.gems[i][j].getHeight(), l));
                                if (this.gems[i][j] != null && !this.gems[i][j].isMatched()) {
                                    this.gems[i][j].matchSpecial();
                                }
                                this.killGem(i, j, l + (long)(XMath.sqrt((n4 - i) * (n4 - i) + (n6 - j) * (n6 - j)) * 1000.0f / 8.0f), false);
                            }
                        }
                        this.activity.getSounds().playEffect("colorclearer_activate");
                        this.moving = true;
                        bl2 = false;
                    }
                    List list = this.findMatches();
                    List list2 = new List();
                    for (n3 = 0; n3 < list.size(); ++n3) {
                        nArray = (int[][])list.get(n3);
                        n2 = 1;
                        for (n = 0; n < nArray.length; ++n) {
                            if (this.gems[nArray[n][0]][nArray[n][1]].isInPlace()) continue;
                            n2 = 0;
                        }
                        if (n2 == 0) continue;
                        list2.add(nArray);
                    }
                    if (list2.size() > 0) {
                        if (this.matching) {
                            this.activity.getSounds().playEffect("direct_gemmatch");
                        } else {
                            this.activity.getSounds().playEffect("indirect_gemmatch");
                        }
                        this.moving = true;
                        for (n3 = 0; n3 < list2.size(); ++n3) {
                            if (this.getUtilityType() != -1) {
                                this.utility_charge = this.matching ? XMath.min(1.0f, this.utility_charge + Params.DIRECT_MATCH_UTILITY_VALUE[this.getUtilityType()]) : XMath.min(1.0f, this.utility_charge + Params.INDIRECT_MATCH_UTILITY_VALUE[this.getUtilityType()]);
                            }
                            ++this.combo;
                            nArray = (int[][])list2.get(n3);
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                if (this.gems[nArray[n2][0]][nArray[n2][1]] == null) continue;
                                n = this.gems[nArray[n2][0]][nArray[n2][1]].getColor();
                                if (this.matching) {
                                    this.killGem(nArray[n2][0], nArray[n2][1], l, true);
                                } else {
                                    this.killGem(nArray[n2][0], nArray[n2][1], l, false);
                                }
                                if (nArray.length == 3) {
                                    if (n2 == 1) {
                                        this.score += 80 * this.combo;
                                        this.points.add(new int[]{(int)this.gems[nArray[n2][0]][nArray[n2][1]].getPosition(), (int)this.gems[nArray[n2][0]][nArray[n2][1]].getHeight(), (int)l, 80 * this.combo, this.gems[nArray[n2][0]][nArray[n2][1]].getColor()});
                                    }
                                    if (!this.gems[nArray[n2][0]][nArray[n2][1]].isMatched()) continue;
                                    this.gems[nArray[n2][0]][nArray[n2][1]].setScore(0);
                                    continue;
                                }
                                if (nArray.length == 4) {
                                    if (this.matching && (this.back1row == nArray[n2][0] && this.back1col == nArray[n2][1] || this.back2row == nArray[n2][0] && this.back2col == nArray[n2][1]) || !this.matching && n2 == 2) {
                                        if (this.matching && this.back1col == this.back2col || !this.matching && nArray[0][0] == nArray[1][0]) {
                                            this.gem_save[nArray[n2][0]][nArray[n2][1]].unload();
                                            this.gems[nArray[n2][0]][nArray[n2][1]] = new Tile(this.activity, Params.COLCUTTER_IMG[n], nArray[n2][0], nArray[n2][1], 0.0f, 'v', n, l);
                                            this.gem_save[nArray[n2][0]][nArray[n2][1]] = this.gems[nArray[n2][0]][nArray[n2][1]];
                                        } else {
                                            this.gem_save[nArray[n2][0]][nArray[n2][1]].unload();
                                            this.gems[nArray[n2][0]][nArray[n2][1]] = new Tile(this.activity, Params.ROWCUTTER_IMG[n], nArray[n2][0], nArray[n2][1], 0.0f, 'h', n, l);
                                            this.gem_save[nArray[n2][0]][nArray[n2][1]] = this.gems[nArray[n2][0]][nArray[n2][1]];
                                        }
                                        this.score += 160 * this.combo;
                                        this.points.add(new int[]{(int)this.gems[nArray[n2][0]][nArray[n2][1]].getPosition(), (int)this.gems[nArray[n2][0]][nArray[n2][1]].getHeight(), (int)l, 160 * this.combo, this.gems[nArray[n2][0]][nArray[n2][1]].getColor()});
                                        this.activity.getSounds().playEffect("rowcutgem_appear");
                                        continue;
                                    }
                                    if (!this.gems[nArray[n2][0]][nArray[n2][1]].isMatched()) continue;
                                    this.gems[nArray[n2][0]][nArray[n2][1]].setScore(0);
                                    continue;
                                }
                                if (nArray.length < 5) continue;
                                if (this.matching && (this.back1row == nArray[n2][0] && this.back1col == nArray[n2][1] || this.back2row == nArray[n2][0] && this.back2col == nArray[n2][1]) || !this.matching && n2 == 2) {
                                    if (nArray.length >= 6 || nArray.length == 5 && (nArray[0][0] == nArray[4][0] && nArray[0][0] == nArray[2][0] || nArray[0][1] == nArray[4][1] && nArray[0][1] == nArray[2][1])) {
                                        this.gem_save[nArray[n2][0]][nArray[n2][1]].unload();
                                        this.gems[nArray[n2][0]][nArray[n2][1]] = new Tile(this.activity, "diamond", nArray[n2][0], nArray[n2][1], 0.0f, 'm', -1, l);
                                        this.gem_save[nArray[n2][0]][nArray[n2][1]] = this.gems[nArray[n2][0]][nArray[n2][1]];
                                        this.score += (250 + 80 * (nArray.length - 5)) * this.combo;
                                        this.points.add(new int[]{(int)this.gems[nArray[n2][0]][nArray[n2][1]].getPosition(), (int)this.gems[nArray[n2][0]][nArray[n2][1]].getHeight(), (int)l, (250 + 80 * (nArray.length - 5)) * this.combo, this.gems[nArray[n2][0]][nArray[n2][1]].getColor()});
                                        this.activity.getSounds().playEffect("colorclearer_appear");
                                        continue;
                                    }
                                    this.gem_save[nArray[n2][0]][nArray[n2][1]].unload();
                                    this.gems[nArray[n2][0]][nArray[n2][1]] = new Tile(this.activity, Params.BLASTGEM_IMG[n], nArray[n2][0], nArray[n2][1], 0.0f, 'b', n, l);
                                    this.gem_save[nArray[n2][0]][nArray[n2][1]] = this.gems[nArray[n2][0]][nArray[n2][1]];
                                    this.score += 250 * this.combo;
                                    this.points.add(new int[]{(int)this.gems[nArray[n2][0]][nArray[n2][1]].getPosition(), (int)this.gems[nArray[n2][0]][nArray[n2][1]].getHeight(), (int)l, 250 * this.combo, this.gems[nArray[n2][0]][nArray[n2][1]].getColor()});
                                    this.activity.getSounds().playEffect("blastgem_appear");
                                    continue;
                                }
                                if (!this.gems[nArray[n2][0]][nArray[n2][1]].isMatched()) continue;
                                this.gems[nArray[n2][0]][nArray[n2][1]].setScore(0);
                            }
                        }
                    }
                    if (this.matching && (this.gems[this.back1row][this.back1col] == null || this.gems[this.back1row][this.back1col].isInPlace()) && (this.gems[this.back2row][this.back2col] == null || this.gems[this.back2row][this.back2col].isInPlace())) {
                        this.matching = false;
                        this.back2col = -1;
                        this.back2row = -1;
                        this.back1col = -1;
                        this.back1row = -1;
                    }
                    for (n5 = 0; n5 < this.gems.length; ++n5) {
                        for (n4 = 0; n4 < this.gems[n5].length; ++n4) {
                            this.gems[n5][n4] = this.gem_save[n5][n4];
                            if (this.gem_save[n5][n4] != null && this.gem_save[n5][n4].needsRemoving(l)) {
                                if (this.gems[n5][n4].wasMatchedBySpecial()) {
                                    this.activity.playSound("indirect_gemmatch");
                                }
                                if (this.gems[n5][n4].getScore() > 0) {
                                    this.score += this.gems[n5][n4].getScore() * this.combo;
                                    this.points.add(new int[]{(int)this.gems[n5][n4].getPosition(), (int)this.gems[n5][n4].getHeight(), (int)l, this.gems[n5][n4].getScore() * this.combo, this.gems[n5][n4].getColor()});
                                }
                                this.gems[n5][n4].unload();
                                this.gems[n5][n4] = null;
                                this.moving = true;
                            }
                            this.tiles[n5][n4] = this.tile_save[n5][n4];
                            if (this.tile_save[n5][n4] == null || !this.tile_save[n5][n4].needsRemoving(l)) continue;
                            this.activity.playSound("tile_cleared");
                            this.tiles[n5][n4].unload();
                            this.tiles[n5][n4] = null;
                            this.moving = true;
                        }
                    }
                    if (!bl2 || this.moving || bl) {
                        n5 = 0;
                        while (n5 == 0) {
                            n5 = 1;
                            for (n4 = 0; n4 < this.gems.length; ++n4) {
                                block14: for (n6 = 0; n6 < this.gems[n4].length; ++n6) {
                                    if (this.gems[n4][n6] != null || this.bases[n4][n6] != null) continue;
                                    int n7 = n6;
                                    for (int i = n4; !(i < 0 || this.gems[i][n7] != null && this.gems[i][n7].isLocked() || this.bases[i][n7] != null); --i) {
                                        if (this.gems[i][n7] == null) continue;
                                        this.gems[i][n7].setDestY(((float)n4 - 3.5f) * 19.86111f);
                                        this.gems[n4][n6] = this.gems[i][n7];
                                        this.gems[i][n7] = null;
                                        n5 = 0;
                                        continue block14;
                                    }
                                }
                            }
                        }
                        for (n4 = 0; n4 < this.gems[0].length; ++n4) {
                            n6 = -1;
                            for (int i = this.gems.length - 1; i >= 0; --i) {
                                if (n6 == -1 && this.gems[i][n4] == null && this.bases[i][n4] == null) {
                                    n6 = i;
                                    continue;
                                }
                                if (n6 < 0 || this.gems[i][n4] == null) continue;
                                n6 = -1;
                            }
                            if (n6 < 0) continue;
                            float f2 = n6 + 1;
                            if (n6 + 1 < this.gems.length && this.gems[n6 + 1][n4] != null) {
                                f2 = XMath.max(f2, this.gems[n6 + 1][n4].getHeight() / 19.86111f + 3.5f + 1.0f);
                            }
                            for (int i = n6; i >= 0 && this.bases[i][n4] == null; --i) {
                                n3 = (int)(XMath.random() * (float)Params.GEM_IMG.length);
                                this.gems[i][n4] = new Tile(this.activity, Params.GEM_IMG[n3], i, n4, f2, 'r', n3, l);
                                f2 += 1.0f;
                            }
                        }
                        n5 = 0;
                        while (n5 == 0) {
                            n5 = 1;
                            for (n4 = 1; n4 < this.gems.length; ++n4) {
                                for (n6 = 0; n6 < this.gems[n4].length; ++n6) {
                                    if (this.gems[n4][n6] != null || this.bases[n4][n6] != null || this.gems[n4 - 1][n6] != null && !this.gems[n4 - 1][n6].isLocked()) continue;
                                    if (n6 > 0 && this.gems[n4 - 1][n6 - 1] != null && !this.gems[n4 - 1][n6 - 1].isLocked() && this.gems[n4 - 1][n6 - 1].isInPlace()) {
                                        int n8;
                                        this.gems[n4][n6] = this.gems[n4 - 1][n6 - 1];
                                        this.gems[n4 - 1][n6 - 1] = null;
                                        this.gems[n4][n6].setDestY(((float)n4 - 3.5f) * 19.86111f);
                                        this.gems[n4][n6].setDestX(((float)n6 - 3.5f) * 19.86111f);
                                        for (n8 = n4 - 1; n8 > 0 && this.gems[n8 - 1][n6 - 1] != null && !this.gems[n8 - 1][n6 - 1].isLocked() && this.bases[n8 - 1][n6 - 1] == null; --n8) {
                                            this.gems[n8][n6 - 1] = this.gems[n8 - 1][n6 - 1];
                                            this.gems[n8 - 1][n6 - 1] = null;
                                            this.gems[n8][n6 - 1].setDestY(((float)n8 - 3.5f) * 19.86111f);
                                        }
                                        if (n8 == 0 && this.bases[0][n6 - 1] == null) {
                                            int n9 = (int)(XMath.random() * (float)Params.GEM_IMG.length);
                                            this.gems[0][n6 - 1] = new Tile(this.activity, Params.GEM_IMG[n9], 0, n6 - 1, 1.0f, 'r', n9, l);
                                        }
                                        n5 = 0;
                                        this.moving = true;
                                        continue;
                                    }
                                    if (n6 < this.gems[n4].length - 1 && this.gems[n4 - 1][n6 + 1] != null && !this.gems[n4 - 1][n6 + 1].isLocked() && this.gems[n4 - 1][n6 + 1].isInPlace()) {
                                        int n10;
                                        this.gems[n4][n6] = this.gems[n4 - 1][n6 + 1];
                                        this.gems[n4 - 1][n6 + 1] = null;
                                        this.gems[n4][n6].setDestY(((float)n4 - 3.5f) * 19.86111f);
                                        this.gems[n4][n6].setDestX(((float)n6 - 3.5f) * 19.86111f);
                                        for (n10 = n4 - 1; n10 > 0 && this.gems[n10 - 1][n6 + 1] != null && !this.gems[n10 - 1][n6 + 1].isLocked() && this.bases[n10 - 1][n6 + 1] == null; --n10) {
                                            this.gems[n10][n6 + 1] = this.gems[n10 - 1][n6 + 1];
                                            this.gems[n10 - 1][n6 + 1] = null;
                                            this.gems[n10][n6 + 1].setDestY(((float)n10 - 3.5f) * 19.86111f);
                                        }
                                        if (n10 == 0 && this.bases[0][n6 + 1] == null) {
                                            int n11 = (int)(XMath.random() * (float)Params.GEM_IMG.length);
                                            this.gems[0][n6 + 1] = new Tile(this.activity, Params.GEM_IMG[n11], 0, n6 + 1, 1.0f, 'r', n11, l);
                                        }
                                        n5 = 0;
                                        this.moving = true;
                                        continue;
                                    }
                                    if (n6 > 0 && this.gems[n4 - 1][n6 - 1] != null && !this.gems[n4 - 1][n6 - 1].isLocked() && !this.gems[n4 - 1][n6 - 1].isInPlace()) {
                                        this.moving = true;
                                        continue;
                                    }
                                    if (n6 >= this.gems[n4].length - 1 || this.gems[n4 - 1][n6 + 1] == null || this.gems[n4 - 1][n6 + 1].isLocked() || this.gems[n4 - 1][n6 + 1].isInPlace()) continue;
                                    this.moving = true;
                                }
                            }
                        }
                    }
                } else if (!this.already_won) {
                    this.combo = 0;
                    if (Levels.LIMIT_MOVE[this.level] > 0 && this.movesRemaining() <= 0) {
                        this.already_lost = true;
                        this.end_time = l + 500L;
                    } else if (Levels.LIMIT_TIME[this.level] > 0 && this.timeRemaining() <= 0.0f) {
                        this.already_lost = true;
                        this.end_time = l + 500L;
                    } else if (!GameModel.hasAvailableMatch(this.gems)) {
                        this.replaceGrid();
                    }
                }
            }
        }
        this.last_time = l;
        return true;
    }

    public long getTime() {
        if (this.ispaused) {
            return (long)((float)(this.pause_time - this.start_time) * this.sim_factor);
        }
        return (long)((float)(System.currentTimeMillis() - this.start_time) * this.sim_factor);
    }
}

