/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int _BUTTON_CLASSIC = 0;
    public static final int _BUTTON_ARCADE = 1;
    public static final int _BUTTON_ZEN = 2;
    public static final int _BUTTON_RUSH = 3;
    public static final int _BUTTON_OPTINOS = 4;
    public static final int _BUTTON_QUIT = 5;
    public static final int _BUTTON_INSTRUCTIONS = 6;
    public static final int _BUTTON_ABOUT = 7;
    public static final int _BUTTON_SOUND = 8;
    public static final int _BUTTON_ARROW_UP = 9;
    public static final int _BUTTON_ARROW_DOWN = 10;
    public static final int _BUTTON_BLANK_TOUCH = 12;
    public static final int _BUTTON_BACK = 11;
    private static final int _TOTAL_BUTTONS_IDS = 13;
    private Rectangle[] _RectButton = new Rectangle[13];
    private static final int _SCREEN_MAIN_MENU = 0;
    private static final int _SCREEN_MODE_CLASSIC = 1;
    private static final int _SCREEN_MODE_ARCADE = 2;
    private static final int _SCREEN_MODE_ZEN = 3;
    private static final int _SCREEN_MODE_RUSH = 4;
    private static final int _SCREEN_MODE_OPTIONS = 5;
    private static final int _SCREEN_MODE_INSTRUCTIONS = 6;
    private static final int _SCREEN_MODE_ABOUT = 7;
    private static final int _SCREEN_MODE_QUIT = 8;
    private int _ActualScreen = 0;
    private static PreparedText _buttonTitle;
    private static int _totalRowTiles;
    private static int _totalColTiles;
    private static int _totalRowTilesLong;
    private static int _totalColTilesLong;
    private static int _totalRowTilesArrow;
    private static int _totalColTilesArrow;
    private static int _totalRowTilesBackArrow;
    private static int _totalColTilesBackArrow;
    private int _offsetX = 0;
    private Rectangle rectText;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    PreparedText menuItem;
    PreparedText title;
    PreparedText instruction;
    PreparedText versionOfGame;
    PreparedText reallyQuit;
    private int textOffsetY;
    boolean check = false;
    int cycle = 10;
    int arrow = 0;
    private int musicControler = 0;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    int posX = 0;
    int posY = 0;

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem) {
        this.mainCanvas = mainCanvas;
        this.selectedCompId = selectedItem;
        this.selectorCompId = selectedItem;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{1, 3, 13, 14, 6, 4, 7, 5});
        Resources.loadSprites(new int[]{1, 0, 2, 5});
        Resources.loadGFont(0);
        Resources.loadText(0);
        this.calculatePositions();
        this.prepareTxt();
    }

    public void afterHide() {
        Resources.freeImages(new int[]{1, 3, 13, 14, 6, 4, 7, 5});
        Resources.freeSprites(new int[]{1, 0, 2, 5});
        Resources.freeGFont(0);
        Resources.freeText(0);
    }

    public void prepareTxt() {
        _buttonTitle = new PreparedText(Resources.resGFonts[0]);
        this.reallyQuit = new PreparedText(Resources.resGFonts[0]);
        this.reallyQuit.prepareText(Resources.resTexts[0].getHashedString(2), this.mainCanvas.getWidth());
        this.versionOfGame = new PreparedText(Resources.resGFonts[0]);
        this.versionOfGame.prepareText("INLOGIC SOFTWARE,\n" + X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ",\nV " + X.singleton.getAppProperty("MIDlet-Version"), this.mainCanvas.getWidth());
        this.instruction = new PreparedText(Resources.resGFonts[0]);
        String controls = Resources.resTexts[0].getHashedString(16);
        this.instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this.instruction.setLineHeightCorrection(-2);
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        int _buttonHeight = Resources.resImgs[13].getHeight();
        int _buttonWidth = this.mainCanvas.getWidth() >> 1;
        Sprite _buttonSprite = Resources.resSprs[1];
        int _posX = this._offsetX = _buttonWidth % _buttonSprite.getWidth();
        int _posY = this.mainCanvas.getHeight() - _buttonHeight * 3;
        this._RectButton[0] = new Rectangle(_posX, _posY, _buttonWidth - this._offsetX, _buttonHeight);
        this._RectButton[1] = new Rectangle(_posX += _buttonWidth - this._offsetX, _posY, _buttonWidth - this._offsetX, _buttonHeight);
        this._RectButton[2] = new Rectangle(_posX -= _buttonWidth - this._offsetX, _posY += _buttonHeight, _buttonWidth - this._offsetX, _buttonHeight);
        this._RectButton[3] = new Rectangle(_posX += _buttonWidth - this._offsetX, _posY, _buttonWidth - this._offsetX, _buttonHeight);
        this._RectButton[4] = new Rectangle(_posX -= _buttonWidth - this._offsetX, _posY += _buttonHeight, _buttonWidth - this._offsetX, _buttonHeight);
        this._RectButton[5] = new Rectangle(_posX += _buttonWidth - this._offsetX, _posY, _buttonWidth - this._offsetX, _buttonHeight);
        int _sptHight = _posX = Resources.resSprs[1].getHeight();
        int _widthLongButton = this.mainCanvas.getWidth() - (this._offsetX << 1);
        _posX = this._offsetX;
        _posY = (this.mainCanvas.getHeight() - (_sptHight << 1) >> 1) - (_sptHight << 1) - (_sptHight >> 1);
        this._RectButton[6] = new Rectangle(_posX, _posY, _widthLongButton, _sptHight << 1);
        this._RectButton[7] = new Rectangle(_posX, _posY += (_sptHight << 1) + (_sptHight >> 1), _widthLongButton, _sptHight << 1);
        this._RectButton[8] = new Rectangle(_posX, _posY += (_sptHight << 1) + (_sptHight >> 1), _widthLongButton, _sptHight << 1);
        this._RectButton[9] = new Rectangle((this.mainCanvas.getWidth() >> 1) - _sptHight, 0, _sptHight << 1, _sptHight << 1);
        this._RectButton[10] = new Rectangle((this.mainCanvas.getWidth() >> 1) - _sptHight, this.mainCanvas.getHeight() - (_sptHight << 1), _sptHight << 1, _sptHight << 1);
        this._RectButton[11] = new Rectangle(this.mainCanvas.getWidth() - _sptHight * 3, this.mainCanvas.getHeight() - (_sptHight << 1), _sptHight * 3, _sptHight << 1);
        _totalColTiles = this._RectButton[0].width / _buttonSprite.getWidth();
        _totalRowTiles = this._RectButton[0].height / _buttonSprite.getHeight();
        _totalColTilesLong = this._RectButton[6].width / _buttonSprite.getWidth();
        System.out.println("_totalColTilesLong: " + _totalColTilesLong);
        _totalRowTilesLong = this._RectButton[6].height / _buttonSprite.getHeight();
        this.rectText = new Rectangle(_buttonWidth >> 4, this._RectButton[9].height, this.mainCanvas.getWidth() - (_buttonWidth >> 4) * 2, this._RectButton[10].y - this._RectButton[9].height);
    }

    public void update(long lastRunLenght) {
        if (this._ActualScreen == 6) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
    }

    public void paint(Graphics g) {
        g.setColor(970808);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        switch (this._ActualScreen) {
            case 0: {
                this.paintMenuLogo(g);
                this.paintMenuButtons(g);
                break;
            }
            case 1: {
                this.paintMenuLogo(g);
                this.paintClassicButtons(g);
                break;
            }
            case 2: {
                this.paintMenuLogo(g);
                this.paintArcadeButtons(g);
                break;
            }
            case 3: {
                this.paintMenuLogo(g);
                this.paintZenButtons(g);
                break;
            }
            case 4: {
                this.paintMenuLogo(g);
                this.paintRushButtons(g);
                break;
            }
            case 5: {
                this.paintMoreButtons(g);
                break;
            }
            case 6: {
                this.paintInstructionsButtons(g);
                this.paintIntructionsTxt(g);
                break;
            }
            case 7: {
                this.paintMenuLogo(g);
                this.paintAbout(g);
                this.paintAbouButtons(g);
                break;
            }
            case 8: {
                this.paintMenuLogo(g);
                this.paintQuitTxt(g);
                this.paintQuitButtons(g);
            }
        }
    }

    private void paintMenuLogo(Graphics g) {
        g.drawImage(Resources.resImgs[3], this.mainCanvas.getWidth() >> 1, 0 + this._RectButton[0].y >> 1, 3);
    }

    private void paintMenuButtons(Graphics g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[2];
        if (this.selectedCompId == 0) {
            this.paintButtonBg(g, _buttonReleased, 0, false);
            this.paintMenuButtonsTitle(g, 0);
        } else {
            this.paintButtonBg(g, _buttonPressed, 0, false);
            this.paintMenuButtonsTitle(g, 0);
        }
        if (this.selectedCompId == 1) {
            this.paintButtonBg(g, _buttonReleased, 1, false);
            this.paintMenuButtonsTitle(g, 1);
        } else {
            this.paintButtonBg(g, _buttonPressed, 1, false);
            this.paintMenuButtonsTitle(g, 1);
        }
        if (this.selectedCompId == 2) {
            this.paintButtonBg(g, _buttonReleased, 2, false);
            this.paintMenuButtonsTitle(g, 2);
        } else {
            this.paintButtonBg(g, _buttonPressed, 2, false);
            this.paintMenuButtonsTitle(g, 2);
        }
        if (this.selectedCompId == 3) {
            this.paintButtonBg(g, _buttonReleased, 3, false);
            this.paintMenuButtonsTitle(g, 3);
        } else {
            this.paintButtonBg(g, _buttonPressed, 3, false);
            this.paintMenuButtonsTitle(g, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButtonBg(g, _buttonReleased, 4, false);
            this.paintMenuButtonsTitle(g, 4);
        } else {
            this.paintButtonBg(g, _buttonPressed, 4, false);
            this.paintMenuButtonsTitle(g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(g, _buttonReleased, 5, false);
            this.paintMenuButtonsTitle(g, 5);
        } else {
            this.paintButtonBg(g, _buttonPressed, 5, false);
            this.paintMenuButtonsTitle(g, 5);
        }
    }

    private void paintMenuButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 0: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(80), this._RectButton[0].width);
                _buttonTitle.drawText(_g, this._RectButton[0], 0, 3);
                break;
            }
            case 1: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(81), this._RectButton[1].width);
                _buttonTitle.drawText(_g, this._RectButton[1], 0, 3);
                break;
            }
            case 2: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(82), this._RectButton[2].width);
                _buttonTitle.drawText(_g, this._RectButton[2], 0, 3);
                break;
            }
            case 3: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(83), this._RectButton[3].width);
                _buttonTitle.drawText(_g, this._RectButton[3], 0, 3);
                break;
            }
            case 4: {
                Image _optionLogo = Resources.resImgs[5];
                _g.drawImage(_optionLogo, this._offsetX + (this._RectButton[4].width >> 1), this._RectButton[4].y + (this._RectButton[4].height >> 1), 3);
                break;
            }
            case 5: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintClassicButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 2) {
            this.paintButtonBg(_g, _buttonReleased, 2, false);
            this.paintClassicButtonsTitle(_g, 2);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 2, false);
            this.paintClassicButtonsTitle(_g, 2);
        }
        if (this.selectedCompId == 3) {
            this.paintButtonBg(_g, _buttonReleased, 3, false);
            this.paintClassicButtonsTitle(_g, 3);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 3, false);
            this.paintClassicButtonsTitle(_g, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButtonBg(_g, _buttonReleased, 4, false);
            this.paintClassicButtonsTitle(_g, 4);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 4, false);
            this.paintClassicButtonsTitle(_g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(_g, _buttonReleased, 5, false);
            this.paintClassicButtonsTitle(_g, 5);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 5, false);
            this.paintClassicButtonsTitle(_g, 5);
        }
    }

    private void paintClassicButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 2: {
                _buttonTitle.prepareText("25", this._RectButton[2].width);
                _buttonTitle.drawText(_g, this._RectButton[2], 0, 3);
                break;
            }
            case 3: {
                _buttonTitle.prepareText("50", this._RectButton[3].width);
                _buttonTitle.drawText(_g, this._RectButton[3], 0, 3);
                break;
            }
            case 4: {
                _buttonTitle.prepareText("PRO", this._RectButton[4].width);
                _buttonTitle.drawText(_g, this._RectButton[4], 0, 3);
                break;
            }
            case 5: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintArcadeButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 2) {
            this.paintButtonBg(_g, _buttonReleased, 2, false);
            this.paintArcadeButtonsTitle(_g, 2);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 2, false);
            this.paintArcadeButtonsTitle(_g, 2);
        }
        if (this.selectedCompId == 3) {
            this.paintButtonBg(_g, _buttonReleased, 3, false);
            this.paintArcadeButtonsTitle(_g, 3);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 3, false);
            this.paintArcadeButtonsTitle(_g, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButtonBg(_g, _buttonReleased, 4, false);
            this.paintArcadeButtonsTitle(_g, 4);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 4, false);
            this.paintArcadeButtonsTitle(_g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(_g, _buttonReleased, 5, false);
            this.paintArcadeButtonsTitle(_g, 5);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 5, false);
            this.paintArcadeButtonsTitle(_g, 5);
        }
    }

    private void paintArcadeButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 2: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(89), this._RectButton[2].width);
                _buttonTitle.drawText(_g, this._RectButton[2], 0, 3);
                break;
            }
            case 3: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(90), this._RectButton[3].width);
                _buttonTitle.drawText(_g, this._RectButton[3], 0, 3);
                break;
            }
            case 4: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(91), this._RectButton[4].width);
                _buttonTitle.drawText(_g, this._RectButton[4], 0, 3);
                break;
            }
            case 5: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintZenButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 2) {
            this.paintButtonBg(_g, _buttonReleased, 2, false);
            this.paintZenButtonsTitle(_g, 2);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 2, false);
            this.paintZenButtonsTitle(_g, 2);
        }
        if (this.selectedCompId == 3) {
            this.paintButtonBg(_g, _buttonReleased, 3, false);
            this.paintZenButtonsTitle(_g, 3);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 3, false);
            this.paintZenButtonsTitle(_g, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButtonBg(_g, _buttonReleased, 4, false);
            this.paintZenButtonsTitle(_g, 4);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 4, false);
            this.paintZenButtonsTitle(_g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(_g, _buttonReleased, 5, false);
            this.paintZenButtonsTitle(_g, 5);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 5, false);
            this.paintZenButtonsTitle(_g, 5);
        }
    }

    private void paintZenButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 2: {
                _buttonTitle.prepareText("15'", this._RectButton[2].width);
                _buttonTitle.drawText(_g, this._RectButton[2], 0, 3);
                break;
            }
            case 3: {
                _buttonTitle.prepareText("30'", this._RectButton[3].width);
                _buttonTitle.drawText(_g, this._RectButton[3], 0, 3);
                break;
            }
            case 4: {
                _buttonTitle.prepareText("PRO", this._RectButton[4].width);
                _buttonTitle.drawText(_g, this._RectButton[4], 0, 3);
                break;
            }
            case 5: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintRushButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 2) {
            this.paintButtonBg(_g, _buttonReleased, 2, false);
            this.paintRushButtonsTitle(_g, 2);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 2, false);
            this.paintRushButtonsTitle(_g, 2);
        }
        if (this.selectedCompId == 3) {
            this.paintButtonBg(_g, _buttonReleased, 3, false);
            this.paintRushButtonsTitle(_g, 3);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 3, false);
            this.paintRushButtonsTitle(_g, 3);
        }
        if (this.selectedCompId == 4) {
            this.paintButtonBg(_g, _buttonReleased, 4, false);
            this.paintRushButtonsTitle(_g, 4);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 4, false);
            this.paintRushButtonsTitle(_g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(_g, _buttonReleased, 5, false);
            this.paintRushButtonsTitle(_g, 5);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 5, false);
            this.paintRushButtonsTitle(_g, 5);
        }
    }

    private void paintRushButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 2: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(89), this._RectButton[2].width);
                _buttonTitle.drawText(_g, this._RectButton[2], 0, 3);
                break;
            }
            case 3: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(90), this._RectButton[3].width);
                _buttonTitle.drawText(_g, this._RectButton[3], 0, 3);
                break;
            }
            case 4: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(91), this._RectButton[4].width);
                _buttonTitle.drawText(_g, this._RectButton[4], 0, 3);
                break;
            }
            case 5: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintMoreButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 6) {
            this.paintButtonBg(_g, _buttonReleased, 6, true);
            this.paintMoreButtonsTitle(_g, 6);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 6, true);
            this.paintMoreButtonsTitle(_g, 6);
        }
        if (this.selectedCompId == 7) {
            this.paintButtonBg(_g, _buttonReleased, 7, true);
            this.paintMoreButtonsTitle(_g, 7);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 7, true);
            this.paintMoreButtonsTitle(_g, 7);
        }
        if (this.selectedCompId == 8) {
            this.paintButtonBg(_g, _buttonReleased, 8, true);
            this.paintMoreButtonsTitle(_g, 8);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 8, true);
            this.paintMoreButtonsTitle(_g, 8);
        }
        if (this.selectedCompId == 11) {
            this.paintButtonBgBack(_g, _buttonReleased, 11);
            this.paintInstructionsButtonsTitle(_g, 11);
        } else {
            this.paintButtonBgBack(_g, _buttonPressed, 11);
            this.paintInstructionsButtonsTitle(_g, 11);
        }
    }

    private void paintMoreButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 6: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(22), this._RectButton[6].width);
                _buttonTitle.drawText(_g, this._RectButton[6], 0, 3);
                break;
            }
            case 7: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(23), this._RectButton[7].width);
                _buttonTitle.drawText(_g, this._RectButton[7], 0, 3);
                break;
            }
            case 8: {
                _buttonTitle.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this._RectButton[8].width);
                _buttonTitle.drawText(_g, this._RectButton[8], 0, 3);
                break;
            }
            case 11: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintInstructionsButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        Sprite _buttonArrow = Resources.resSprs[5];
        if (this.selectedCompId == 11) {
            this.paintButtonBgBack(_g, _buttonReleased, 11);
            this.paintInstructionsButtonsTitle(_g, 11);
        } else {
            this.paintButtonBgBack(_g, _buttonPressed, 11);
            this.paintInstructionsButtonsTitle(_g, 11);
        }
        if (this.scrollDOWN) {
            if (this.arrow == 2) {
                this.paintButtonBgArrow(_g, _buttonReleased, 10);
            } else {
                this.paintButtonBgArrow(_g, _buttonPressed, 10);
            }
            _buttonArrow.setPosition((this.mainCanvas.getWidth() >> 1) - (_buttonArrow.getWidth() >> 1), this._RectButton[10].y + this._RectButton[10].height - (this._RectButton[10].height >> 1) - (_buttonArrow.getHeight() >> 1));
            _buttonArrow.setTransform(0);
            _buttonArrow.paint(_g);
        }
        if (this.scrollUP) {
            if (this.arrow == 1) {
                this.paintButtonBgArrow(_g, _buttonReleased, 9);
            } else {
                this.paintButtonBgArrow(_g, _buttonPressed, 9);
            }
            _buttonArrow.setPosition((this.mainCanvas.getWidth() >> 1) - (_buttonArrow.getWidth() >> 1), this._RectButton[9].y + this._RectButton[9].height - (this._RectButton[10].height >> 1) - (_buttonArrow.getHeight() >> 1));
            _buttonArrow.setTransform(1);
            _buttonArrow.paint(_g);
        }
    }

    private void paintInstructionsButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 11: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._RectButton[11].x + (this._RectButton[11].width >> 1), this._RectButton[11].y + (this._RectButton[11].height >> 1), 3);
            }
        }
    }

    private void paintIntructionsTxt(Graphics g) {
        this.instruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintAbouButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 11) {
            this.paintButtonBgBack(_g, _buttonReleased, 11);
            this.paintInstructionsButtonsTitle(_g, 11);
        } else {
            this.paintButtonBgBack(_g, _buttonPressed, 11);
            this.paintInstructionsButtonsTitle(_g, 11);
        }
    }

    private void paintAboutButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 5: {
                Image _backLogo = Resources.resImgs[6];
                _g.drawImage(_backLogo, this._offsetX + (this._RectButton[5].width + (this._RectButton[5].width >> 1)), this._RectButton[5].y + (this._RectButton[5].height >> 1), 3);
            }
        }
    }

    private void paintQuitTxt(Graphics _g) {
        Rectangle r = new Rectangle(this._RectButton[0].width >> 3, this._RectButton[0].y, this.mainCanvas.getWidth() - (this._RectButton[0].width >> 4) * 2, this._RectButton[0].height);
        this.reallyQuit.drawText(_g, r, 0, 17);
    }

    private void paintQuitButtons(Graphics _g) {
        Sprite _buttonPressed = Resources.resSprs[0];
        Sprite _buttonReleased = Resources.resSprs[1];
        if (this.selectedCompId == 4) {
            this.paintButtonBg(_g, _buttonReleased, 4, false);
            this.paintQuitButtonsTitle(_g, 4);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 4, false);
            this.paintQuitButtonsTitle(_g, 4);
        }
        if (this.selectedCompId == 5) {
            this.paintButtonBg(_g, _buttonReleased, 5, false);
            this.paintQuitButtonsTitle(_g, 5);
        } else {
            this.paintButtonBg(_g, _buttonPressed, 5, false);
            this.paintQuitButtonsTitle(_g, 5);
        }
    }

    private void paintQuitButtonsTitle(Graphics _g, int _button) {
        switch (_button) {
            case 4: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(6), this._RectButton[4].width);
                _buttonTitle.drawText(_g, this._RectButton[4], 0, 3);
                break;
            }
            case 5: {
                _buttonTitle.prepareText(Resources.resTexts[0].getHashedString(7), this._RectButton[5].width);
                _buttonTitle.drawText(_g, this._RectButton[5], 0, 3);
            }
        }
    }

    private void paintButtonBg(Graphics _g, Sprite _buttonSprite, int _buttonRect, boolean _longButton) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        for (int _x = this._RectButton[_buttonRect].x; _x < this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width; _x += _buttonSprite.getWidth()) {
            for (int _y = this._RectButton[_buttonRect].y; _y < this._RectButton[_buttonRect].y + this._RectButton[_buttonRect].height; _y += _buttonSprite.getHeight()) {
                if (_longButton) {
                    _buttonSprite.setFrame(this.getButtonTileSpriteLong(_actualTileX, _actualTileY));
                } else {
                    _buttonSprite.setFrame(this.getButtonTileSprite(_actualTileX, _actualTileY));
                }
                _buttonSprite.setPosition(_x, _y);
                _buttonSprite.paint(_g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintButtonBgArrow(Graphics _g, Sprite _buttonSprite, int _buttonRect) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        if (_buttonRect == 6) {
            System.out.println("kokot tu som ! konecne suradnice su : " + (this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width));
        }
        for (int _x = this._RectButton[_buttonRect].x; _x < this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width; _x += _buttonSprite.getWidth()) {
            for (int _y = this._RectButton[_buttonRect].y; _y < this._RectButton[_buttonRect].y + this._RectButton[_buttonRect].height; _y += _buttonSprite.getHeight()) {
                _buttonSprite.setFrame(this.getButtonTileSpriteArrow(_actualTileX, _actualTileY));
                _buttonSprite.setPosition(_x, _y);
                _buttonSprite.paint(_g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private void paintButtonBgBack(Graphics _g, Sprite _buttonSprite, int _buttonRect) {
        int _actualTileX = 0;
        int _actualTileY = 0;
        if (_buttonRect == 6) {
            System.out.println("kokot tu som ! konecne suradnice su : " + (this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width));
        }
        for (int _x = this._RectButton[_buttonRect].x; _x < this._RectButton[_buttonRect].x + this._RectButton[_buttonRect].width; _x += _buttonSprite.getWidth()) {
            for (int _y = this._RectButton[_buttonRect].y; _y < this._RectButton[_buttonRect].y + this._RectButton[_buttonRect].height; _y += _buttonSprite.getHeight()) {
                _buttonSprite.setFrame(this.getButtonTileSpriteBackArrow(_actualTileX, _actualTileY));
                _buttonSprite.setPosition(_x, _y);
                _buttonSprite.paint(_g);
                ++_actualTileY;
            }
            _actualTileY = 0;
            ++_actualTileX;
        }
    }

    private int getButtonTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < _totalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == _totalColTiles - 1) {
            return 2;
        }
        if (_y == _totalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < _totalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == _totalColTiles - 1 && _y < _totalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == _totalRowTiles - 1 && _x < _totalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == _totalRowTiles - 1 && _x == _totalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    private int getButtonTileSpriteLong(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < _totalColTilesLong - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == _totalColTilesLong - 1) {
            return 2;
        }
        if (_y == _totalRowTilesLong - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < _totalRowTilesLong - 1 && _y > 0) {
            return 3;
        }
        if (_x == _totalColTilesLong - 1 && _y < _totalRowTilesLong - 1 && _y > 0) {
            return 5;
        }
        if (_y == _totalRowTilesLong - 1 && _x < _totalColTilesLong - 1 && _x > 0) {
            return 7;
        }
        if (_y == _totalRowTilesLong - 1 && _x == _totalColTilesLong - 1) {
            return 8;
        }
        return 4;
    }

    private int getButtonTileSpriteArrow(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < _totalColTilesArrow - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == _totalColTilesArrow - 1) {
            return 2;
        }
        if (_y == _totalRowTilesArrow - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < _totalRowTilesArrow - 1 && _y > 0) {
            return 3;
        }
        if (_x == _totalColTilesArrow - 1 && _y < _totalRowTilesArrow - 1 && _y > 0) {
            return 5;
        }
        if (_y == _totalRowTilesArrow - 1 && _x < _totalColTilesArrow - 1 && _x > 0) {
            return 7;
        }
        if (_y == _totalRowTilesArrow - 1 && _x == _totalColTilesArrow - 1) {
            return 8;
        }
        return 4;
    }

    private int getButtonTileSpriteBackArrow(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < _totalColTilesBackArrow - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == _totalColTilesBackArrow - 1) {
            return 2;
        }
        if (_y == _totalRowTilesBackArrow - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < _totalRowTilesBackArrow - 1 && _y > 0) {
            return 3;
        }
        if (_x == _totalColTilesBackArrow - 1 && _y < _totalRowTilesBackArrow - 1 && _y > 0) {
            return 5;
        }
        if (_y == _totalRowTilesBackArrow - 1 && _x < _totalColTilesBackArrow - 1 && _x > 0) {
            return 7;
        }
        if (_y == _totalRowTilesBackArrow - 1 && _x == _totalColTilesBackArrow - 1) {
            return 8;
        }
        return 4;
    }

    public void paintAbout(Graphics _g) {
        this.paintAboutVersion(_g);
    }

    private void paintAboutVersion(Graphics _g) {
        Rectangle r = new Rectangle(this._RectButton[0].width >> 3, this._RectButton[0].y, this.mainCanvas.getWidth() - (this._RectButton[0].width >> 4) * 2, this._RectButton[0].height);
        this.versionOfGame.drawText(_g, r, 0, 17);
    }

    public void paintLogo(Graphics g) {
        g.drawImage(Resources.resImgs[1], this.mainCanvas.getWidth() / 2, this._RectButton[0].x >> 1, 17);
    }

    private boolean isButtonEnable(int _buttonID) {
        switch (this._ActualScreen) {
            case 0: {
                if (_buttonID == 0) {
                    return true;
                }
                if (_buttonID == 1) {
                    return true;
                }
                if (_buttonID == 2) {
                    return true;
                }
                if (_buttonID == 3) {
                    return true;
                }
                if (_buttonID == 4) {
                    return true;
                }
                if (_buttonID != 5) break;
                return true;
            }
            case 5: {
                if (_buttonID == 6) {
                    return true;
                }
                if (_buttonID == 7) {
                    return true;
                }
                if (_buttonID == 8) {
                    return true;
                }
                if (_buttonID != 11) break;
                return true;
            }
            case 7: {
                if (_buttonID != 11) break;
                return true;
            }
            case 6: {
                if (_buttonID == 9) {
                    return true;
                }
                if (_buttonID == 10) {
                    return true;
                }
                if (_buttonID != 11) break;
                return true;
            }
            case 8: {
                if (_buttonID == 4) {
                    return true;
                }
                if (_buttonID != 5) break;
                return true;
            }
            default: {
                if (_buttonID == 2) {
                    return true;
                }
                if (_buttonID == 3) {
                    return true;
                }
                if (_buttonID == 4) {
                    return true;
                }
                if (_buttonID != 5) break;
                return true;
            }
        }
        return false;
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            System.out.println("H: 1");
            this.interuption = 0;
            System.out.println("H: 2");
            this.afterInteruption();
            System.out.println("H: 3");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKRightCode(keyCode)) {
                switch (this._ActualScreen) {
                    case 1: {
                        this.selectedCompId = 0;
                        this._ActualScreen = 0;
                        break;
                    }
                    case 2: {
                        this.selectedCompId = 0;
                        this._ActualScreen = 0;
                        break;
                    }
                    case 4: {
                        this.selectedCompId = 0;
                        this._ActualScreen = 0;
                        break;
                    }
                    case 3: {
                        this.selectedCompId = 0;
                        this._ActualScreen = 0;
                        break;
                    }
                    case 0: {
                        this._ActualScreen = 8;
                        this.selectedCompId = 5;
                        break;
                    }
                    case 5: {
                        this.selectedCompId = 4;
                        this._ActualScreen = 0;
                        break;
                    }
                    case 6: {
                        this.selectedCompId = 6;
                        this._ActualScreen = 5;
                        break;
                    }
                    case 7: {
                        this.selectedCompId = 7;
                        this._ActualScreen = 5;
                        break;
                    }
                    case 8: {
                        this.selectedCompId = 5;
                        this._ActualScreen = 0;
                        System.out.println("selectedCompId: " + this.selectedCompId + " _BUTTON_QUIT: " + 5);
                        break;
                    }
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                if (this._ActualScreen == 8) {
                    X.quitApp();
                }
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    block11 : switch (this._ActualScreen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 2;
                                    this._ActualScreen = 1;
                                    break;
                                }
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 2;
                                    this._ActualScreen = 2;
                                    break;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 2;
                                    this._ActualScreen = 3;
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 2;
                                    this._ActualScreen = 4;
                                    break;
                                }
                                case 4: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 6;
                                    this._ActualScreen = 5;
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 5;
                                    this._ActualScreen = 8;
                                    break;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (this.selectedCompId) {
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 0, 0);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 0, 1);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 4: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 0, 2);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 0;
                                    this._ActualScreen = 0;
                                    break;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (this.selectedCompId) {
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 1, 0);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 1, 1);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 4: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 1, 2);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 1;
                                    this._ActualScreen = 0;
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (this.selectedCompId) {
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 2, 0);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 2, 1);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 4: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 2, 2);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 2;
                                    this._ActualScreen = 0;
                                    break;
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (this.selectedCompId) {
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 3, 0);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 3, 1);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 4: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    ScreenGame sg = new ScreenGame(this.mainCanvas, 3, 2);
                                    this.mainCanvas.changeLastActiveScreen(sg);
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 3;
                                    this._ActualScreen = 0;
                                    break;
                                }
                            }
                            break;
                        }
                        case 5: {
                            switch (this.selectedCompId) {
                                case 6: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 8;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 5;
                                    this._ActualScreen = 6;
                                    break;
                                }
                                case 7: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 6;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 8;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 5;
                                    this._ActualScreen = 7;
                                    break;
                                }
                                case 8: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 7;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 6;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    if (MainCanvas.soundManager.IsSoundOn()) {
                                        MainCanvas.soundManager.SetSoundOn(false);
                                        MainCanvas.soundManager.Stop();
                                        break;
                                    }
                                    MainCanvas.soundManager.SetSoundOn(true);
                                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 4;
                                    this._ActualScreen = 0;
                                    break;
                                }
                            }
                            break;
                        }
                        case 6: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this.dragUp();
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(2, keyCode)) break;
                            this.dragDown();
                            break;
                        }
                        case 7: {
                            switch (this.selectedCompId) {
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        this.selectedCompId = 7;
                                        this._ActualScreen = 5;
                                        break;
                                    }
                                    break block11;
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (this.selectedCompId) {
                                case 4: {
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        X.quitApp();
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 5;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    X.quitApp();
                                    break;
                                }
                                case 5: {
                                    if (Keys.isActionGeneratedByKey(5, keyCode)) {
                                        this.selectedCompId = 5;
                                        this._ActualScreen = 0;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 4;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.selectedCompId = 5;
                                    this._ActualScreen = 0;
                                }
                            }
                            break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        for (int i = 0; i < this._RectButton.length; ++i) {
            if (i == 12) {
                this.selectorCompId = this.selectedCompId = 12;
                this.mainCanvas.repaint();
                break;
            }
            System.out.println("i:  " + i);
            if (!this.isButtonEnable(i) || i == 12 || this._RectButton[i] == null || !this._RectButton[i].contains(x, y)) continue;
            this.sel = i <= 13 ? i : this.sel;
            this.selectedCompId = i;
            this.s = i;
            System.out.println("selectedCompId: " + this.selectedCompId);
            switch (this.selectedCompId) {
                case 4: {
                    if (this._ActualScreen == 8) {
                        X.quitApp();
                        break;
                    }
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
                case 5: {
                    Keys.keyPressed(-7);
                    this.mainCanvas.repaint();
                    break;
                }
                case 11: {
                    this.mainCanvas.repaint();
                    break;
                }
                case 10: {
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    System.out.println("Pandrlak selectedCompId: " + this.selectedCompId);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this._ActualScreen == 6) {
            System.out.println("SCROL");
            if (this.posY > y) {
                if (Resources.sysFont) {
                    this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY < 0) {
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY < y) {
                int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
                if (Resources.sysFont) {
                    this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY > maxOffsetY) {
                    this.textOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 5: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 11: {
                if (this._ActualScreen == 6) {
                    System.out.println("BACK 2");
                    this._ActualScreen = 5;
                    this.selectorCompId = this.selectedCompId = 12;
                    this.mainCanvas.repaint();
                    return;
                }
                if (this._ActualScreen == 7) {
                    System.out.println("BACK 3");
                    this._ActualScreen = 5;
                    this.selectorCompId = this.selectedCompId = 12;
                    this.mainCanvas.repaint();
                    return;
                }
                if (this._ActualScreen != 5) break;
                System.out.println("BACK 1");
                this._ActualScreen = 0;
                this.selectorCompId = this.selectedCompId = 12;
                this.mainCanvas.repaint();
                return;
            }
            case 10: {
                this.dragDown();
                this.arrow = 2;
                return;
            }
            case 9: {
                this.dragUp();
                this.arrow = 1;
                return;
            }
            case 4: {
                if (this._ActualScreen == 8) {
                    X.quitApp();
                } else {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                    this.selectorCompId = this.selectedCompId = 12;
                }
                if (this._ActualScreen != 8) break;
                X.quitApp();
                break;
            }
            default: {
                this.activeButton = true;
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
        this.arrow = 0;
        this.selectorCompId = this.selectedCompId = -1;
        this.mainCanvas.repaint();
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        System.out.println();
        int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
            this.arrow = 1;
            return;
        }
        if (Keys.isActionPressed(2)) {
            int maxOffsetY = this.instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
            this.arrow = 2;
            return;
        }
        this.arrow = 0;
    }

    static {
        _totalRowTiles = 0;
        _totalColTiles = 0;
        _totalRowTilesLong = 0;
        _totalColTilesLong = 0;
        _totalRowTilesArrow = 2;
        _totalColTilesArrow = 2;
        _totalRowTilesBackArrow = 2;
        _totalColTilesBackArrow = 3;
    }
}

