/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;

public class ScreenSplash
implements IScreen {
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_TIME = 3000;
    private MainCanvas mainCanvas;
    private int mode;
    private long modeDelay = 3000L;
    private int interuption = 0;

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        this.mode = 1;
        Resources.loadImages(new int[]{3});
    }

    public void afterHide() {
        Resources.freeImages(new int[]{3});
    }

    public void calculatePosition() {
    }

    public void beforeInteruption() {
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
        if (this.mode == 0) {
            MainCanvas.soundManager.Stop();
        }
    }

    public void update(long lastRunLenght) {
        this.modeDelay -= lastRunLenght;
        if (this.modeDelay < 0L) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
            this.mainCanvas.repaint();
            this.mainCanvas.serviceRepaints();
            Settings.musicOn = true;
            MainCanvas.music = true;
            MainCanvas.soundManager.SetSoundOn(true);
            if (MainCanvas.soundManager.IsSoundOn()) {
                MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
            }
        }
    }

    private void nextMode() {
        Resources.loadImage(0);
        this.modeDelay = 3000L;
        this.mainCanvas.repaint();
        this.mainCanvas.serviceRepaints();
        Settings.musicOn = true;
        MainCanvas.music = true;
        MainCanvas.soundManager.SetSoundOn(true);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(970808);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.drawImage(Resources.resImgs[3], MainCanvas.WIDTH / 2, MainCanvas.HEIGHT / 2, 3);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }
}

