/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.MainCanvas;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_SPLASH = 0;
    public static final int IMG_INLOGIC_LOGO = 1;
    public static final int IMG_RES_ROTATION = 2;
    public static final int _IMG_MENU_LOGO = 3;
    public static final int _IMG_BUTTON_MENU = 4;
    public static final int _IMG_BUTTON_OPTIONS = 5;
    public static final int _IMG_BUTTON_PLAY = 6;
    public static final int _IMG_BUTTON_RESTART = 7;
    public static final int _IMG_SKULL_LIGHT = 8;
    public static final int _IMG_SKULL_DARK = 9;
    public static final int _IMG_STAR_GREEN = 10;
    public static final int _IMG_STAR_RED = 11;
    public static final int _IMG_SWOOSH_GREEN = 12;
    public static final int _IMG_BUTTON_GREEN_LIGHT = 13;
    public static final int _IMG_BUTTON_GREEN_DARK = 14;
    public static final int _IMG_BUTTON_RED_LIGHT = 15;
    public static final int _IMG_BUTTON_RED_DARK = 16;
    public static final int _TOTAL_IMGS = 17;
    public static Image[] resImgs = new Image[17];
    public static final int _SPR_TILE_GREEN_LIGHT = 0;
    public static final int _SPR_TILE_GREEN_DARK = 1;
    public static final int _SPR_TILE_GREEN_DARK_MENU = 2;
    public static final int _SPR_TILE_RED_LIGHT = 3;
    public static final int _SPR_TILE_RED_DARK = 4;
    public static final int _SPR_ARROW = 5;
    public static final int _SPR_PARTICLES_GREEN = 6;
    public static final int _SPR_PARTICLES_RED = 7;
    public static final int _TOTAL_SPRS = 8;
    public static Sprite[] resSprs = new Sprite[8];
    public static final int GFONT_MAIN = 0;
    public static final int GFONT_WHITE = 1;
    public static final int TOTAL_GFONTS = 5;
    public static GFont[] resGFonts = new GFont[5];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 94;
    private static String langDir = "/";
    public static ResourceBundle[] resTexts = new ResourceBundle[94];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static final int TEXT_MODE_CLASSIC = 80;
    public static final int TEXT_MODE_ARCADE = 81;
    public static final int TEXT_MODE_ZEN = 82;
    public static final int TEXT_MODE_RUSH = 83;
    public static final int TEXT_MODE_BEST = 84;
    public static final int TEXT_MODE_CLASSIC_R = 85;
    public static final int TEXT_MODE_ARCADE_R = 86;
    public static final int TEXT_MODE_ZEN_R = 87;
    public static final int TEXT_MODE_RUSH_R = 88;
    public static final int TEXT_MODE_EASY = 89;
    public static final int TEXT_MODE_MEDIUM = 90;
    public static final int TEXT_MODE_HARD = 91;
    public static final int TEXT_CONTR_TITLE = 92;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 3: {
                if (!MainCanvas._frLang) {
                    imgPath = graphicsBaseDir + "title_01.png";
                    break;
                }
                imgPath = graphicsBaseDir + "title_01_fr.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "icon_02.png";
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "icon_03.png";
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "icon_04.png";
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "icon_01.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "skull_02.png";
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "skull_01.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "star_01.png";
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "star_02.png";
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "swoosh_01.png";
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "tile_01.png";
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "tile_02.png";
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "tile_03.png";
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "tile_04.png";
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "l.png";
                break;
            }
            case 0: {
                imgPath = graphicsDisplayDir + "s.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "rot.png";
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "tile_01.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "tile_02.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "tile_03.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "tile_04.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "tile_05.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "arrow_01.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "star_01.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "star_02.png";
                slicesX = 1;
                slicesY = 1;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMenu(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\'', '\"', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 13: {
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u011a', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 14: {
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', 'A', '\u00c4', 'A', '\u00c2', 'A', '\u00c7', '\u010c', '\u010e', '\u00c9', 'E', '\u00cb', 'E', '\u011a', '\u00cd', 'I', 'I', '\u00ce', '\u013d', '\u0147', 'N', '\u00d3', 'O', '\u00d6', '\u00d4', 'O', '\u00da', 'U', '\u00dc', 'U', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                fontCharsWidth = new short[]{8, 10, 5, 6, 6, 7, 6, 5, 6, 6, 2, 5, 6, 5, 8, 6, 6, 6, 5, 6, 6, 5, 6, 6, 8, 10, 6, 6, 7, 8, 8, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 6, 7, 5, 6, 6, 6, 6, 7, 4, 9, 4, 7, 8, 8, 9, 3, 4, 4, 4, 4, 3, 2, 7, 4, 4, 4, 6, 5, 6, 5, 4, 2, 2, 2, 2, 2, 3, 4, 2, 6, 2, 5, 6, 3, 5, 3, 5, 5, 6, 5, 5, 5, 5, 5};
                break;
            }
            case 16: {
                fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', 'A', '\u00c4', 'A', '\u00c2', 'A', '\u00c7', '\u010c', '\u010e', '\u00c9', 'E', '\u00cb', 'E', '\u011a', '\u00cd', 'I', 'I', '\u00ce', '\u013d', '\u0147', 'N', '\u00d3', 'O', '\u00d6', '\u00d4', 'O', '\u00da', 'U', '\u00dc', 'U', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '$', '#', '&', '@', '\\', '\u20ac', '(', ')', '%', '\u00b0', '+', '=', '\u00f7', '~', '^', '.', ',', ':', ';', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
                fontCharsWidth = new short[]{9, 12, 8, 8, 8, 11, 6, 6, 9, 8, 3, 5, 8, 7, 11, 9, 10, 10, 8, 10, 7, 7, 8, 9, 9, 13, 9, 8, 8, 9, 10, 9, 9, 9, 9, 8, 9, 9, 7, 7, 6, 6, 6, 4, 4, 6, 5, 3, 7, 8, 9, 10, 10, 10, 10, 10, 8, 8, 8, 8, 9, 7, 7, 7, 7, 8, 8, 8, 9, 7, 9, 8, 7, 7, 8, 7, 9, 6, 11, 6, 5, 8, 10, 5, 10, 4, 4, 5, 4, 4, 3, 2, 12, 5, 8, 8, 8, 9, 7, 9, 8, 3, 3, 3, 3, 4, 5, 5, 4, 6, 3, 5, 4, 6, 7, 5, 5, 7, 7, 8, 7, 8, 7, 8, 7, 7};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            case 24: {
                fontCharsWidth = new short[]{12, 17, 10, 12, 12, 14, 9, 9, 12, 11, 4, 7, 11, 9, 16, 12, 14, 14, 10, 15, 9, 10, 12, 12, 12, 18, 11, 11, 11, 13, 13, 13, 13, 13, 13, 12, 11, 12, 9, 9, 9, 9, 9, 5, 5, 8, 6, 4, 9, 11, 12, 14, 14, 14, 14, 14, 11, 12, 11, 11, 12, 10, 10, 11, 10, 11, 11, 11, 12, 10, 12, 11, 9, 10, 11, 10, 13, 9, 15, 6, 7, 11, 14, 8, 13, 5, 5, 6, 6, 5, 5, 3, 17, 6, 11, 10, 11, 11, 11, 11, 11, 4, 3, 4, 4, 4, 7, 7, 4, 8, 3, 8, 4, 7, 10, 6, 6, 10, 9, 11, 10, 11, 9, 10, 11, 10};
                break;
            }
            case 22: {
                fontCharsWidth = new short[]{13, 18, 11, 13, 12, 13, 11, 10, 14, 12, 4, 9, 12, 9, 14, 12, 14, 14, 11, 14, 13, 12, 12, 12, 14, 20, 13, 14, 11, 13, 13, 13, 13, 14, 14, 13, 12, 13, 11, 11, 11, 11, 12, 4, 5, 6, 6, 10, 11, 12, 14, 13, 14, 14, 14, 12, 12, 12, 11, 12, 13, 13, 13, 12, 12, 12, 12, 11, 10, 10, 11, 11, 12, 7, 18, 7, 11, 15, 15, 16, 5, 5, 7, 7, 6, 5, 3, 16, 6, 10, 10, 10, 10, 10, 11, 9, 3, 3, 4, 4, 3, 4, 6, 3, 10, 3, 10, 12, 6, 10, 6, 11, 10, 10, 10, 11, 10, 10, 10};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{17, 22, 14, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14};
                break;
            }
            case 27: {
                fontCharsWidth = new short[]{15, 13, 13, 15, 13, 13, 16, 16, 8, 11, 15, 13, 19, 16, 15, 13, 17, 15, 12, 13, 15, 15, 20, 16, 15, 11, 15, 15, 15, 15, 15, 15, 13, 13, 15, 14, 14, 13, 14, 14, 8, 7, 8, 8, 13, 16, 17, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 12, 12, 13, 12, 12, 11, 14, 15, 18, 7, 13, 7, 7, 19, 7, 12, 12, 12, 13, 12, 4, 4, 4, 4, 6, 9, 4, 10, 3, 10, 10, 6, 11, 8, 11, 10, 11, 11, 11, 10, 11, 11};
                break;
            }
            case 36: {
                fontCharsWidth = new short[]{19, 26, 15, 16, 18, 21, 13, 13, 19, 16, 5, 10, 16, 12, 23, 17, 20, 20, 15, 21, 15, 14, 17, 17, 19, 26, 17, 18, 16, 19, 19, 19, 18, 18, 18, 16, 16, 18, 13, 14, 14, 13, 13, 7, 7, 11, 9, 4, 13, 17, 18, 20, 21, 20, 21, 20, 17, 17, 17, 17, 17, 15, 15, 14, 14, 16, 17, 16, 19, 14, 18, 16, 13, 14, 15, 14, 19, 12, 21, 9, 9, 16, 20, 11, 18, 7, 7, 8, 8, 7, 7, 3, 25, 9, 15, 15, 15, 15, 16, 16, 14, 5, 4, 5, 4, 6, 9, 10, 6, 11, 4, 11, 4, 11, 14, 8, 8, 14, 13, 16, 13, 15, 13, 15, 15, 15};
                break;
            }
            default: {
                fontCharsWidth = new short[]{13, 18, 11, 13, 12, 13, 11, 10, 14, 12, 4, 9, 12, 9, 14, 12, 14, 14, 11, 14, 13, 12, 12, 12, 14, 20, 13, 14, 11, 13, 13, 13, 13, 14, 14, 13, 12, 13, 11, 11, 11, 11, 12, 4, 5, 6, 6, 10, 11, 12, 14, 13, 14, 14, 14, 12, 12, 12, 11, 12, 13, 13, 13, 12, 12, 12, 12, 11, 10, 10, 11, 11, 12, 7, 18, 7, 11, 15, 15, 16, 5, 6, 6, 7, 6, 5, 3, 16, 6, 10, 10, 10, 10, 10, 11, 9, 3, 3, 4, 4, 3, 4, 6, 3, 10, 3, 10, 12, 6, 10, 6, 11, 10, 10, 10, 11, 10, 10, 10};
            }
        }
        fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\"', '\"', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontMain(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\'', '\'', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 10: {
                fontCharsWidth = new short[]{4, 5, 4, 4, 4, 5, 3, 3, 4, 4, 1, 4, 4, 3, 5, 4, 4, 5, 4, 4, 4, 4, 3, 4, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 2, 2, 3, 3, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 5, 5, 5, 5, 5, 3, 5, 4, 4, 5, 5, 5, 5, 2, 2, 3, 3, 2, 2, 1, 5, 3, 3, 3, 5, 3, 5, 5, 3, 2, 1, 1, 1, 1, 4, 4, 2, 3, 1, 4, 1, 4, 2, 3, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 7, 5, 5, 5, 6, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 3, 2, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 4, 5, 5, 6, 5, 5, 5, 5, 5, 6, 5, 7, 4, 4, 4, 7, 7, 8, 2, 3, 3, 3, 3, 2, 1, 7, 3, 3, 3, 5, 5, 5, 4, 5, 2, 1, 2, 1, 2, 4, 4, 2, 4, 1, 5, 1, 5, 6, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5};
                break;
            }
            case 16: {
                fontCharsWidth = new short[]{9, 11, 7, 8, 8, 10, 6, 6, 9, 8, 3, 5, 8, 6, 10, 9, 10, 10, 7, 9, 7, 6, 7, 7, 8, 13, 7, 8, 8, 8, 8, 9, 8, 9, 9, 8, 7, 9, 6, 6, 6, 6, 6, 3, 3, 5, 4, 3, 6, 8, 9, 9, 10, 9, 10, 9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 7, 8, 8, 9, 6, 8, 7, 6, 6, 8, 7, 9, 6, 10, 4, 4, 8, 9, 5, 8, 3, 3, 3, 3, 3, 3, 2, 11, 5, 8, 7, 7, 7, 7, 7, 8, 3, 3, 3, 2, 3, 4, 5, 3, 5, 3, 5, 2, 5, 7, 4, 4, 7, 6, 7, 7, 7, 7, 7, 7, 7};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            default: {
                fontCharsWidth = new short[]{13, 18, 11, 13, 12, 13, 11, 10, 14, 12, 4, 9, 12, 9, 14, 12, 14, 14, 11, 14, 13, 12, 12, 12, 14, 20, 13, 14, 11, 13, 13, 13, 13, 14, 14, 13, 12, 13, 11, 11, 11, 11, 12, 4, 5, 6, 6, 10, 11, 12, 14, 13, 14, 14, 14, 12, 12, 12, 11, 12, 13, 13, 13, 12, 12, 12, 12, 11, 10, 10, 11, 11, 12, 7, 18, 7, 11, 15, 15, 16, 5, 6, 6, 7, 6, 5, 3, 16, 6, 10, 10, 10, 10, 10, 11, 9, 3, 3, 4, 4, 3, 4, 6, 3, 10, 3, 10, 12, 6, 10, 6, 11, 10, 10, 10, 11, 10, 10, 10};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontGame(Image gFontImg) {
        char[] fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 8: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{5, 4, 5, 5, 6, 5, 5, 5, 5, 5, 2, 4, 7, 5, 7};
                break;
            }
            case 11: {
                fontCharsWidth = new short[]{3, 2, 3, 4, 7, 4, 7, 7, 7, 6, 7, 6, 7, 6};
                break;
            }
            case 12: {
                fontCharsWidth = new short[]{3, 3, 3, 4, 8, 5, 7, 7, 8, 8, 7, 7, 7, 7};
                break;
            }
            case 13: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
                break;
            }
            case 17: {
                fontCharsWidth = new short[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
                break;
            }
            case 22: {
                fontCharsWidth = new short[]{15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15};
                break;
            }
            case 25: {
                fontCharsWidth = new short[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17};
                break;
            }
            case 34: {
                fontCharsWidth = new short[]{23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23};
                break;
            }
            case 37: {
                fontCharsWidth = new short[]{25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{15, 11, 14, 13, 15, 14, 14, 14, 15, 14, 5, 9, 16, 15, 18};
                break;
            }
            case 28: {
                fontCharsWidth = new short[]{19, 13, 17, 17, 19, 18, 18, 18, 18, 17, 5, 11, 20, 19, 22};
                break;
            }
            case 31: {
                fontCharsWidth = new short[]{20, 13, 18, 18, 19, 18, 18, 18, 19, 18, 6, 11, 21, 20, 24};
                break;
            }
            default: {
                fontCharsWidth = new short[]{7, 8, 8, 12, 18, 14, 19, 19, 20, 19, 18, 19, 18, 18};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontWhite(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', '\u00d8', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u011a', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u0130', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u010c', '\u011e', '\u015e', '\u00dd', '\u00df', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\'', '\'', '\u20ac', '\u00a9', '\u00ae', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '\u00f7', '~', '^', '\u2019', '.', ',', ':', ';', '/', '/', '`', '\u201c', '!', '?', '\u00a1', '\u00bf', '_', '-', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 16: {
                fontCharsWidth = new short[]{9, 12, 8, 8, 8, 11, 6, 6, 9, 8, 3, 5, 8, 7, 11, 9, 10, 10, 8, 10, 7, 7, 8, 9, 9, 13, 9, 8, 8, 9, 10, 9, 9, 9, 9, 8, 9, 9, 7, 7, 6, 6, 6, 4, 4, 6, 5, 3, 7, 8, 9, 10, 10, 10, 10, 10, 8, 8, 8, 8, 9, 7, 7, 7, 7, 8, 8, 8, 9, 7, 9, 8, 7, 7, 8, 7, 9, 6, 11, 6, 5, 8, 10, 5, 10, 4, 4, 5, 4, 4, 3, 2, 12, 5, 8, 8, 8, 9, 7, 9, 8, 3, 3, 3, 3, 4, 5, 5, 4, 6, 3, 5, 4, 6, 7, 5, 5, 7, 7, 8, 7, 8, 7, 8, 7, 7};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{11, 15, 9, 10, 11, 13, 8, 8, 11, 10, 3, 7, 10, 8, 13, 10, 12, 13, 9, 11, 8, 9, 9, 10, 10, 16, 10, 10, 10, 11, 11, 11, 10, 11, 11, 10, 10, 11, 8, 8, 8, 8, 8, 4, 4, 6, 5, 3, 8, 11, 10, 12, 12, 12, 12, 12, 10, 10, 10, 10, 10, 9, 9, 8, 8, 10, 9, 10, 11, 8, 10, 9, 8, 9, 8, 8, 11, 6, 12, 5, 5, 9, 11, 7, 11, 4, 4, 5, 4, 4, 4, 2, 15, 5, 9, 9, 10, 9, 9, 10, 9, 3, 3, 3, 3, 3, 5, 5, 3, 6, 3, 6, 3, 7, 9, 5, 5, 8, 8, 9, 8, 9, 8, 9, 8, 9};
                break;
            }
            case 24: {
                fontCharsWidth = new short[]{12, 17, 10, 12, 12, 14, 9, 9, 12, 11, 4, 7, 11, 9, 16, 12, 14, 14, 10, 15, 9, 10, 12, 12, 12, 18, 11, 11, 11, 13, 13, 13, 13, 13, 13, 12, 11, 12, 9, 9, 9, 9, 9, 5, 5, 8, 6, 4, 9, 11, 12, 14, 14, 14, 14, 14, 11, 12, 11, 11, 12, 10, 10, 11, 10, 11, 11, 11, 12, 10, 12, 11, 9, 10, 11, 10, 13, 9, 15, 6, 7, 11, 14, 8, 13, 5, 5, 6, 6, 5, 5, 3, 17, 6, 11, 10, 11, 11, 11, 11, 11, 4, 3, 4, 4, 4, 7, 7, 4, 8, 3, 8, 4, 7, 10, 6, 6, 10, 9, 11, 10, 11, 9, 10, 11, 10};
                break;
            }
            case 32: {
                fontCharsWidth = new short[]{17, 22, 14, 14, 16, 19, 12, 11, 17, 16, 4, 10, 15, 12, 21, 16, 18, 18, 13, 18, 14, 13, 15, 16, 17, 24, 16, 16, 15, 17, 16, 17, 17, 16, 17, 15, 15, 17, 12, 13, 12, 12, 12, 7, 7, 9, 9, 5, 11, 15, 17, 18, 18, 19, 18, 19, 15, 15, 16, 15, 16, 14, 14, 13, 13, 15, 15, 15, 17, 13, 16, 14, 12, 13, 15, 14, 17, 12, 19, 9, 9, 15, 18, 10, 17, 6, 6, 8, 7, 6, 6, 4, 22, 8, 14, 14, 15, 15, 15, 15, 14, 6, 5, 5, 5, 6, 9, 11, 5, 10, 5, 10, 4, 10, 15, 7, 8, 13, 13, 15, 13, 14, 13, 14, 13, 14};
                break;
            }
            case 36: {
                fontCharsWidth = new short[]{19, 26, 15, 16, 18, 21, 13, 13, 19, 16, 5, 10, 16, 12, 23, 17, 20, 20, 15, 21, 15, 14, 17, 17, 19, 26, 17, 18, 16, 19, 19, 19, 18, 18, 18, 16, 16, 18, 13, 14, 14, 13, 13, 7, 7, 11, 9, 4, 13, 17, 18, 20, 21, 20, 21, 20, 17, 17, 17, 17, 17, 15, 15, 14, 14, 16, 17, 16, 19, 14, 18, 16, 13, 14, 15, 14, 19, 12, 21, 9, 9, 16, 20, 11, 18, 7, 7, 8, 8, 7, 7, 3, 25, 9, 15, 15, 15, 15, 16, 16, 14, 5, 4, 5, 4, 6, 9, 10, 6, 11, 4, 11, 4, 11, 14, 8, 8, 14, 13, 16, 13, 15, 13, 15, 15, 15};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fntMnu.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
                break;
            }
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontWhite(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

