/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.controller;

import com.jarbull.efw.util.FP;

public class ResolutionHandler {
    private static final ResolutionHandler INSTANCE = new ResolutionHandler();
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    int orientation;
    int defaultWidth = 240;
    int defaultHeight = 320;
    int currentWidth;
    int currentHeight;
    int screenWidth;
    int screenHeight;
    int fpRatioLimit;
    int fpCurrentRatioX = FP.intToFP(1);
    int fpCurrentRatioY = FP.intToFP(1);

    public static ResolutionHandler getInstance() {
        return INSTANCE;
    }

    private ResolutionHandler() {
    }

    public void setDefaultSize(int width, int height) {
        this.defaultWidth = width;
        this.defaultHeight = height;
        this.updateCurrentRatio();
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setCurrentSize(int width, int height) {
        this.currentWidth = width;
        this.currentHeight = height;
        this.updateCurrentRatio();
    }

    public int getCurrentWidth() {
        return this.currentWidth;
    }

    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public void setScreenSize(int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public void setRatioLimit(int fpLimit) {
        this.fpRatioLimit = fpLimit;
    }

    public int getRatioLimit() {
        return this.fpRatioLimit;
    }

    public int getCurrentRatioX() {
        return this.fpCurrentRatioX;
    }

    private void updateCurrentRatio() {
        this.fpCurrentRatioX = FP.Div(FP.intToFP(this.currentWidth), FP.intToFP(this.defaultWidth));
        this.fpCurrentRatioY = FP.Div(FP.intToFP(this.currentHeight), FP.intToFP(this.defaultHeight));
    }

    public void setCurrentRatioXManually(int fpRatioX) {
        this.fpCurrentRatioX = fpRatioX;
    }

    public void setCurrentRatioYManually(int fpRatioY) {
        this.fpCurrentRatioY = fpRatioY;
    }

    public int getCurrentRatioY() {
        return this.fpCurrentRatioY;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int adaptY(int x, int y) {
        int tmpY = this.orientation == 1 ? x : y;
        if (this.fpCurrentRatioY != 1) {
            tmpY = FP.toInt(FP.round(FP.intToFP(tmpY * this.fpCurrentRatioY)));
        }
        return tmpY;
    }

    public int adaptX(int x, int y) {
        int tmpX = this.orientation == 1 ? this.screenWidth - y : x;
        if (this.fpCurrentRatioX != 1) {
            tmpX = FP.toInt(FP.round(FP.intToFP(tmpX * this.fpCurrentRatioX)));
        }
        return tmpX;
    }
}

