/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Vector;

public final class Sudoku {
    public int[][] m_iGrid;
    public int m_iGridId = 0;
    public int[][] m_iSolution;
    public int m_iSolCount = 0;
    public int m_iErrors = 0;
    public int m_iBlank;
    public int m_iMode = 1;
    public short[][] m_iCurrentGrid;
    public static int[] m_isRepeatedGrid = new int[]{0, 0, 0};
    public byte[] m_bRepeat_list = new byte[162];
    public int m_iRepeat_list_count;
    public byte[] m_bUpdate_list = new byte[81];
    public int m_iUpdate_list_count;
    static final int[] s_iTenTimes = new int[]{1, 10, 100, 1000};
    static boolean m_bInputFalse;
    protected int m_iDequeRemovals;
    private Header root = new Header(this);
    private Vector columns = new Vector();
    private Vector rows = new Vector();
    private Vector solStack = new Vector();
    private int stackPos;
    private int iterStack;
    private Node iterRow;
    private Node iterCol;
    private Header column;
    private Node row;
    private boolean more;
    int m_iSolveStep = 0;
    int timer = 0;
    byte m_bEasier = (byte)-1;
    byte m_bShort;

    public Sudoku() {
        System.gc();
        this.m_iGrid = new int[9][9];
        this.m_iSolution = new int[9][9];
        this.m_iCurrentGrid = new short[9][9];
        Sudoku.m_isRepeatedGrid[2] = 0;
        Sudoku.m_isRepeatedGrid[1] = 0;
        Sudoku.m_isRepeatedGrid[0] = 0;
    }

    static final void setRepeatedTag(int n, int n2, boolean bl) {
        int n3 = n2 * 9 + n;
        if (bl) {
            int n4 = n3 / 32;
            m_isRepeatedGrid[n4] = m_isRepeatedGrid[n4] | 1 << n3 % 32;
            return;
        }
        int n5 = n3 / 32;
        m_isRepeatedGrid[n5] = m_isRepeatedGrid[n5] & ~(1 << n3 % 32);
    }

    final short[][] readMatrix(int n, int n2) {
        try {
            short[][] sArray = new short[9][9];
            boolean bl = false;
            InputStream inputStream = n2 == 1 ? this.getClass().getResourceAsStream("/x.dat") : this.getClass().getResourceAsStream("/sol9.dat");
            byte[] byArray = new byte[81];
            inputStream.skip(n * 81);
            inputStream.read(byArray, 0, 81);
            inputStream.close();
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    sArray[j][i] = byArray[i * 9 + j];
                }
            }
            return sArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    final void generate(int n) {
        this.m_iMode = n;
        this.m_iBlank = 81;
        this.m_iErrors = 81;
        if (n >= 6) {
            return;
        }
        this.m_iGridId = 0;
        try {
            int n2;
            int n3;
            int n4;
            if (n == 4) {
                n4 = cGame.getRandomInt(50);
                this.m_iGridId = 648000 + n4;
            } else if (n == 5) {
                n4 = 500;
            } else {
                this.m_iGridId = cGame.getRandomInt(648000);
                n4 = this.m_iGridId % 500;
            }
            short[][] sArray = this.readMatrix(n4, n == 4 ? 1 : 0);
            this.m_iErrors = 0;
            this.m_iSolCount = 1;
            for (n3 = 0; n3 < 9; ++n3) {
                for (n2 = 0; n2 < 9; ++n2) {
                    this.m_iSolution[n2][n3] = sArray[n2][n3];
                    if (this.m_iSolution[n2][n3] >= 0) {
                        this.m_iGrid[n2][n3] = this.m_iSolution[n2][n3];
                        continue;
                    }
                    int[] nArray = this.m_iSolution[n2];
                    int n5 = n3;
                    nArray[n5] = nArray[n5] & 0x1F;
                    this.m_iGrid[n2][n3] = 0;
                    ++this.m_iErrors;
                }
            }
            if (n != 4 && n != 5) {
                this.switchGrid();
            }
            for (n3 = 0; n3 < 9; ++n3) {
                for (n2 = 0; n2 < 9; ++n2) {
                    this.m_iCurrentGrid[n2][n3] = (byte)this.m_iGrid[n2][n3];
                }
            }
            if (this.m_iMode == 0 || this.m_iMode == 1) {
                boolean bl = false;
                int n6 = (this.m_iMode == 1 ? 33 : 43) - (81 - this.m_iErrors) - cGame.getRandomInt(3);
                for (n2 = 0; n2 < n6; ++n2) {
                    while (this.m_iGrid[(n3 = cGame.getRandomInt(81)) / 9][n3 % 9] != 0) {
                    }
                    this.m_iGrid[n3 / 9][n3 % 9] = this.m_iSolution[n3 / 9][n3 % 9];
                    this.m_iCurrentGrid[n3 / 9][n3 % 9] = (byte)this.m_iGrid[n3 / 9][n3 % 9];
                }
                this.m_iErrors -= n6;
            }
            this.m_iBlank = this.m_iErrors;
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    protected final void switchGrid() {
        int n = this.m_iGridId / 500;
        int n2 = n % 6;
        this.switchRowGroup(0, n2 % 3);
        if (n2 / 2 == 1) {
            this.switchRowGroup(1, 2);
        }
        n2 = (n /= 6) % 6;
        this.switchColGroup(0, n2 % 3);
        if (n2 / 3 == 1) {
            this.switchColGroup(1, 2);
        }
        boolean bl = (n2 = (n /= 6) % 6) < 3;
        int n3 = n2 < 3 ? n2 : n2 - 3;
        n2 = (n /= 6) % 6;
        if (bl) {
            this.switchRow(n3 * 3 + 0, n3 * 3 + n2 % 3);
            if (n2 / 3 == 1) {
                this.switchRow(n3 * 3 + 1, n3 * 3 + 2);
                return;
            }
        } else {
            this.switchCol(n3 * 3 + 0, n3 * 3 + n2 % 3);
            if (n2 / 3 == 1) {
                this.switchCol(n3 * 3 + 1, n3 * 3 + 2);
            }
        }
    }

    protected final void switchRow(int n, int n2) {
        if (n == n2) {
            return;
        }
        int[] nArray = this.m_iGrid[n];
        this.m_iGrid[n] = this.m_iGrid[n2];
        this.m_iGrid[n2] = nArray;
        nArray = this.m_iSolution[n];
        this.m_iSolution[n] = this.m_iSolution[n2];
        this.m_iSolution[n2] = nArray;
    }

    protected final void switchCol(int n, int n2) {
        if (n == n2) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            int n3 = this.m_iGrid[i][n];
            this.m_iGrid[i][n] = this.m_iGrid[i][n2];
            this.m_iGrid[i][n2] = n3;
            n3 = this.m_iSolution[i][n];
            this.m_iSolution[i][n] = this.m_iSolution[i][n2];
            this.m_iSolution[i][n2] = n3;
        }
    }

    protected final void switchRowGroup(int n, int n2) {
        if (n == n2) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.switchRow(n * 3 + i, n2 * 3 + i);
        }
    }

    protected final void switchColGroup(int n, int n2) {
        if (n == n2) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.switchCol(n * 3 + i, n2 * 3 + i);
        }
    }

    public final byte[] getValid(int n, int n2) {
        int n3;
        byte[] byArray = new byte[10];
        for (n3 = 0; n3 < 10; ++n3) {
            byArray[n3] = 1;
        }
        int n4 = n / 3 * 3;
        int n5 = n2 / 3 * 3;
        for (n3 = 0; n3 < 9; ++n3) {
            if (this.m_iCurrentGrid[n3][n2] > 0 && n3 != n) {
                byArray[this.m_iCurrentGrid[n3][n2]] = 0;
            }
            if (this.m_iCurrentGrid[n][n3] > 0 && n3 != n2) {
                byArray[this.m_iCurrentGrid[n][n3]] = 0;
            }
            if (this.m_iCurrentGrid[n4 + n3 % 3][n5 + n3 / 3] > 0 && n4 + n3 % 3 != n && n5 + n3 / 3 != n2) {
                byArray[this.m_iCurrentGrid[n4 + n3 % 3][n5 + n3 / 3]] = 0;
            }
            if (this.m_iMode != 4) continue;
            if (this.m_iCurrentGrid[n3][n3] > 0 && n == n2 && n3 != n) {
                byArray[this.m_iCurrentGrid[n3][n3]] = 0;
                continue;
            }
            if (this.m_iCurrentGrid[8 - n3][n3] <= 0 || n != 8 - n2 || n == 8 - n3) continue;
            byArray[this.m_iCurrentGrid[8 - n3][n3]] = 0;
        }
        byArray[0] = 1;
        return byArray;
    }

    public final void setSplitGrid(int n, int n2, int n3, int n4) {
        int n5 = this.getSplitNum(n, n2, n4);
        if (this.m_iCurrentGrid[n][n2] > 0) {
            ++this.m_iBlank;
        }
        if (n5 != n3) {
            short[] sArray = this.m_iCurrentGrid[n];
            int n6 = n2;
            sArray[n6] = (short)(sArray[n6] + n5 * s_iTenTimes[n4]);
        }
        short[] sArray = this.m_iCurrentGrid[n];
        int n7 = n2;
        sArray[n7] = (short)(sArray[n7] - n3 * s_iTenTimes[n4]);
    }

    final int getSplitNum(int n, int n2, int n3) {
        int n4 = -this.m_iCurrentGrid[n][n2];
        if (n3 > 0) {
            n4 /= s_iTenTimes[n3];
        }
        return n4 % 10;
    }

    public final void SetGrid(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n3 == 0 && (this.m_iCurrentGrid[n][n2] < 0 || this.m_iGrid[n][n2] < 0)) {
            this.m_iCurrentGrid[n][n2] = 0;
            this.m_iGrid[n][n2] = 0;
            this.m_bUpdate_list[0] = (byte)(n2 * 9 + n);
            this.m_iUpdate_list_count = 1;
            return;
        }
        if (n3 == this.m_iCurrentGrid[n][n2]) {
            return;
        }
        if (n3 <= 0 || this.m_iCurrentGrid[n][n2] <= 0) {
            if (n3 == this.m_iSolution[n][n2]) {
                --this.m_iErrors;
            } else if (this.m_iCurrentGrid[n][n2] == this.m_iSolution[n][n2]) {
                ++this.m_iErrors;
            }
            if (n3 > 0 && this.m_iCurrentGrid[n][n2] <= 0) {
                --this.m_iBlank;
            } else if (n3 <= 0 && this.m_iCurrentGrid[n][n2] > 0) {
                ++this.m_iBlank;
            }
        } else {
            this.SetGrid(n, n2, 0);
            this.SetGrid(n, n2, n3);
            return;
        }
        boolean bl = n3 == 0;
        int n6 = n5 = n3 == 0 ? this.m_iCurrentGrid[n][n2] : n3;
        if (n3 == 0) {
            this.m_iCurrentGrid[n][n2] = 0;
        }
        boolean bl2 = false;
        for (n4 = 0; n4 < 9; ++n4) {
            int n7 = 3 * (n / 3) + n4 % 3;
            int n8 = 3 * (n2 / 3) + n4 / 3;
            if (this.m_iCurrentGrid[n4][n2] == n5) {
                this.updateRepeatList(n4, n2, bl);
                bl2 = true;
            }
            if (this.m_iCurrentGrid[n][n4] == n5) {
                this.updateRepeatList(n, n4, bl);
                bl2 = true;
            }
            if (this.m_iCurrentGrid[n7][n8] == n5 && n7 != n && n8 != n2) {
                this.updateRepeatList(n7, n8, bl);
                bl2 = true;
            }
            if (this.m_iMode != 4) continue;
            if (n == n2 && this.m_iCurrentGrid[n4][n4] == n5) {
                this.updateRepeatList(n4, n4, bl);
                bl2 = true;
            }
            if (8 - n != n2 || this.m_iCurrentGrid[8 - n4][n4] != n5) continue;
            this.updateRepeatList(8 - n4, n4, bl);
            bl2 = true;
        }
        this.m_iCurrentGrid[n][n2] = (byte)n3;
        if (bl2 && !bl) {
            m_bInputFalse = true;
            this.add2BlinkList(n, n2);
            Sudoku.setRepeatedTag(n, n2, true);
        } else {
            this.m_bUpdate_list[this.m_iUpdate_list_count++] = (byte)(n2 * 9 + n);
            m_bInputFalse = false;
        }
        if (bl) {
            Sudoku.setRepeatedTag(n, n2, false);
            for (n4 = 0; n4 < this.m_iRepeat_list_count; ++n4) {
                if (n2 * 9 + n != this.m_bRepeat_list[n4 * 2]) continue;
                this.removeBlink(n4);
            }
        }
    }

    protected final void updateRepeatList(int n, int n2, boolean bl) {
        if (bl) {
            int n3;
            for (n3 = 0; n3 < 9; ++n3) {
                int n4 = 3 * (n / 3) + n3 % 3;
                int n5 = 3 * (n2 / 3) + n3 / 3;
                if (this.m_iCurrentGrid[n3][n2] == this.m_iCurrentGrid[n][n2] && n != n3 || this.m_iCurrentGrid[n][n3] == this.m_iCurrentGrid[n][n2] && n2 != n3 || this.m_iCurrentGrid[n4][n5] == this.m_iCurrentGrid[n][n2] && n4 != n && n5 != n2 || this.m_iMode == 4 && (n == n2 && this.m_iCurrentGrid[n3][n3] == this.m_iCurrentGrid[n][n2] && n != n3 || n + n2 == 8 && this.m_iCurrentGrid[n3][8 - n3] == this.m_iCurrentGrid[n][n2] && n != n3)) break;
            }
            if (n3 == 9) {
                Sudoku.setRepeatedTag(n, n2, false);
            }
            this.m_bUpdate_list[this.m_iUpdate_list_count++] = (byte)(n2 * 9 + n);
            for (n3 = 0; n3 < this.m_iRepeat_list_count; ++n3) {
                if (n2 * 9 + n != this.m_bRepeat_list[n3 * 2]) continue;
                this.removeBlink(n3);
            }
        } else {
            Sudoku.setRepeatedTag(n, n2, true);
            this.add2BlinkList(n, n2);
        }
    }

    final void add2BlinkList(int n, int n2) {
        if (this.m_iRepeat_list_count <= 81) {
            int n3 = n2 * 9 + n;
            for (int i = 0; i < this.m_iRepeat_list_count; ++i) {
                if (this.m_bRepeat_list[i * 2] != n3) continue;
                this.m_bRepeat_list[i * 2 + 1] = 26;
                return;
            }
            this.m_bRepeat_list[this.m_iRepeat_list_count * 2] = (byte)n3;
            this.m_bRepeat_list[this.m_iRepeat_list_count * 2 + 1] = 26;
            ++this.m_iRepeat_list_count;
        }
    }

    final void removeBlink(int n) {
        --this.m_iRepeat_list_count;
        this.m_bRepeat_list[n * 2] = this.m_bRepeat_list[this.m_iRepeat_list_count * 2];
        this.m_bRepeat_list[n * 2 + 1] = this.m_bRepeat_list[this.m_iRepeat_list_count * 2 + 1];
    }

    public final void releaseData() {
        if (this.m_iGrid != null) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.m_iSolution[i][j] = 0;
                    this.m_iGrid[i][j] = 0;
                    this.m_iCurrentGrid[i][j] = 0;
                }
            }
        }
        Sudoku.m_isRepeatedGrid[2] = 0;
        Sudoku.m_isRepeatedGrid[1] = 0;
        Sudoku.m_isRepeatedGrid[0] = 0;
        this.m_iUpdate_list_count = 0;
        this.m_iRepeat_list_count = 0;
        this.m_iErrors = 0;
        this.m_iBlank = 0;
    }

    final void initialize() {
        int n;
        int n2;
        int n3;
        this.clearSolver();
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                this.addColumn(n3 * 9 + n2, true);
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                n = 81 + (n3 * 9 + n2) * 3;
                this.addColumn(n, true);
                this.addColumn(n + 1, true);
                this.addColumn(n + 2, true);
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            for (n2 = 0; n2 < 9; ++n2) {
                for (int i = 0; i < 9; ++i) {
                    this.row = null;
                    n = i * 9;
                    this.setColumn(n3 * 9 + n2);
                    this.setColumn(81 + (n + n3) * 3);
                    this.setColumn(81 + (n + n2) * 3 + 1);
                    this.setColumn(81 + (n + (n3 / 3 * 3 + n2 / 3)) * 3 + 2);
                }
            }
        }
    }

    final void clearSolver() {
        int n;
        int n2 = this.columns.size();
        for (n = 0; n < n2; ++n) {
            Header header = (Header)this.columns.elementAt(n);
            header.unplug();
        }
        n2 = this.rows.size();
        for (n = 0; n < n2; ++n) {
            Node node;
            Node node2 = (Node)this.rows.elementAt(n);
            ((Node)this.rows.elementAt(n)).left.right = null;
            do {
                node = node2.right;
                node2.unplug();
            } while ((node2 = node) != null);
        }
        this.iterCol = null;
        this.iterRow = null;
        this.row = null;
        this.column = null;
        this.root.unplug();
        this.root = new Header(this);
        this.columns.removeAllElements();
        this.rows.removeAllElements();
        this.solStack.removeAllElements();
    }

    public final void setCell2(int n, int n2, int n3) {
        int n4 = n * 9 * 9 + n2 * 9;
        this.m_iGrid[n][n2] = n3;
        for (int i = 0; i < 9; ++i) {
            if (n3 <= 0 || i == n3 - 1) {
                this.enableRow(n4 + i);
                continue;
            }
            this.disableRow(n4 + i);
        }
    }

    public final void setGrid(short[][] sArray) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (sArray[i][j] != this.m_iGrid[i][j]) {
                    this.setCell2(i, j, sArray[i][j]);
                }
                this.m_iSolution[i][j] = 0;
            }
        }
        this.m_iSolCount = 0;
    }

    protected final boolean record() {
        if (++this.m_iSolCount > 1) {
            return false;
        }
        int n = this.getSol();
        while (n != -1) {
            int n2 = -1;
            int n3 = -1;
            while (n != -1) {
                if (n >= 81) {
                    if ((n - 81) % 3 == 0) {
                        n2 = (n - 81) / 3 % 9;
                    }
                    if ((n - 81) % 3 == 1) {
                        n3 = (n - 81) / 3 % 9;
                    }
                    if (n2 >= 0 && n3 >= 0) {
                        this.m_iSolution[n2][n3] = (n - 81) / 3 / 9 + 1;
                    }
                }
                n = this.getSol();
            }
            n = this.getSol();
        }
        return true;
    }

    public final void addColumn(int n, boolean bl) {
        Header header = new Header(this);
        new Header(this).id = n;
        header.size = 0;
        if (bl) {
            header.right = this.root;
            header.left = this.root.left;
            this.root.left.right = header;
            this.root.left = header;
        }
        this.columns.addElement(header);
    }

    public final void setColumn(int n) {
        Header header = (Header)this.columns.elementAt(n);
        Node node = new Node(this);
        if (this.row == null) {
            this.row = node;
            this.rows.addElement(node);
        } else {
            node.left = this.row;
            node.right = this.row.right;
            this.row.right.left = node;
            this.row.right = node;
        }
        node.head = header;
        node.up = header;
        node.down = header.down;
        header.down.up = node;
        header.down = node;
        ++header.size;
    }

    public final void disableRow(int n) {
        Node node = (Node)this.rows.elementAt(n);
        if (node.up == node) {
            return;
        }
        Node node2 = node;
        do {
            node2.up.down = node2.down;
            node2.down.up = node2.up;
            node2.down = node2.up = node2;
            --node2.head.size;
        } while (node != (node2 = node2.right));
    }

    public final void enableRow(int n) {
        Node node = (Node)this.rows.elementAt(n);
        if (node.up != node) {
            return;
        }
        Node node2 = node;
        do {
            node2.up = node2.head;
            node2.down = node2.head.down;
            node2.up.down = node2;
            node2.down.up = node2;
            ++node2.head.size;
        } while (node != (node2 = node2.right));
    }

    public final boolean solve() {
        switch (this.m_iSolveStep) {
            case 0: {
                this.initialize();
                ++this.m_iSolveStep;
                return false;
            }
            case 1: {
                this.setGrid(this.m_iCurrentGrid);
                ++this.m_iSolveStep;
                return false;
            }
            case 2: {
                int n;
                int n2;
                if (this.m_iSolCount == 1) {
                    ++this.m_iSolveStep;
                    break;
                }
                this.more = true;
                this.solStack.setSize(this.columns.size());
                this.stackPos = 0;
                this.iterStack = 0;
                this.m_iDequeRemovals = 0;
                this.m_iSolCount = 0;
                this.iterCol = null;
                this.iterRow = null;
                this.column = null;
                this.search();
                if (this.m_iSolCount == 0 || this.m_iMode == 7) {
                    for (n2 = 0; n2 < 9; ++n2) {
                        for (n = 0; n < 9; ++n) {
                            this.m_iGrid[n2][n] = 0;
                        }
                    }
                }
                if (this.m_iMode == 7 && this.m_iSolCount == 1) {
                    for (n2 = 0; n2 < 9; ++n2) {
                        for (n = 0; n < 9; ++n) {
                            this.m_iGrid[n2][n] = this.m_iCurrentGrid[n2][n];
                        }
                    }
                    this.m_iErrors = this.m_iBlank;
                } else if (this.m_iMode == 6 && this.m_iSolCount > 0) {
                    for (n2 = 0; n2 < 9; ++n2) {
                        for (n = 0; n < 9; ++n) {
                            this.m_iCurrentGrid[n2][n] = (byte)this.m_iSolution[n2][n];
                        }
                    }
                }
                ++this.m_iSolveStep;
                return false;
            }
            case 3: {
                this.clearSolver();
                System.gc();
                ++this.m_iSolveStep;
                return true;
            }
        }
        return true;
    }

    protected final int getSol() {
        if (this.iterCol != null) {
            int n = this.iterCol.head.id;
            this.iterCol = this.iterCol.right;
            if (this.iterCol == this.iterRow) {
                this.iterCol = null;
            }
            return n;
        }
        if (++this.iterStack < this.stackPos) {
            this.iterCol = this.iterRow = (Node)this.solStack.elementAt(this.iterStack);
        }
        return -1;
    }

    private final void search() {
        ++this.timer;
        if (this.root.right == this.root) {
            this.iterStack = 0;
            this.iterRow = this.stackPos > 0 ? (Node)this.solStack.elementAt(0) : null;
            this.iterCol = this.iterRow;
            this.more = this.record();
            return;
        }
        this.choose();
        this.cover(this.column);
        this.row = this.column.down;
        while (this.row != this.column) {
            Node node = this.row.right;
            while (node != this.row) {
                this.cover(node.head);
                node = node.right;
            }
            this.solStack.setElementAt(this.row, this.stackPos++);
            this.search();
            this.row = (Node)this.solStack.elementAt(--this.stackPos);
            this.column = this.row.head;
            node = this.row.left;
            while (node != this.row) {
                this.uncover(node.head);
                node = node.left;
            }
            if (!this.more) break;
            this.row = this.row.down;
        }
        this.uncover(this.column);
    }

    private final void cover(Header header) {
        header.right.left = header.left;
        header.left.right = header.right;
        ++this.m_iDequeRemovals;
        Node node = header.down;
        while (node != header) {
            Node node2 = node.right;
            while (node2 != node) {
                node2.down.up = node2.up;
                node2.up.down = node2.down;
                --node2.head.size;
                ++this.m_iDequeRemovals;
                node2 = node2.right;
            }
            node = node.down;
        }
    }

    private final void uncover(Header header) {
        Node node = header.up;
        while (node != header) {
            Node node2 = node.left;
            while (node2 != node) {
                ++node2.head.size;
                node2.down.up = node2;
                node2.up.down = node2;
                node2 = node2.left;
            }
            node = node.up;
        }
        header.right.left = header;
        header.left.right = header;
    }

    private final void choose() {
        int n = Integer.MAX_VALUE;
        Header header = (Header)this.root.right;
        while (header != this.root) {
            if (header.size < n) {
                this.column = header;
                n = header.size;
            }
            header = (Header)header.right;
        }
    }

    public final void getAllClues() {
        byte[][] byArray = new byte[9][9];
        this.m_bEasier = (byte)-1;
        this.m_bShort = (byte)90;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.m_iCurrentGrid[i][j] == 0) {
                    byArray[i][j] = this.getCellClue(i, j);
                    if (byArray[i][j] >= this.m_bShort) continue;
                    this.m_bShort = byArray[i][j];
                    this.m_bEasier = (byte)(i * 9 + j);
                    continue;
                }
                byArray[i][j] = 90;
            }
        }
    }

    private final byte getCellClue(int n, int n2) {
        int n3;
        int n4 = 0;
        byte[] byArray = new byte[10];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = n / 3 * 3;
        int n9 = n2 / 3 * 3;
        for (n3 = 0; n3 < 9; ++n3) {
            if (this.m_iCurrentGrid[n3][n2] > 0 && n3 != n && !this.isRepeat(n3, n2)) {
                byArray[this.m_iCurrentGrid[n3][n2]] = 1;
                ++n5;
            }
            if (this.m_iCurrentGrid[n][n3] > 0 && n3 != n2 && !this.isRepeat(n, n3)) {
                byArray[this.m_iCurrentGrid[n][n3]] = 1;
                ++n6;
            }
            if (!(this.m_iCurrentGrid[n8 + n3 % 3][n9 + n3 / 3] <= 0 || n8 + n3 % 3 == n && n9 + n3 / 3 == n2 || this.isRepeat(n8 + n3 % 3, n9 + n3 / 3))) {
                byArray[this.m_iCurrentGrid[n8 + n3 % 3][n9 + n3 / 3]] = 1;
                ++n7;
            }
            if (this.m_iMode != 4) continue;
            if (this.m_iCurrentGrid[n3][n3] > 0 && n == n2 && n3 != n && !this.isRepeat(n3, n3)) {
                byArray[this.m_iCurrentGrid[n3][n3]] = 1;
                continue;
            }
            if (this.m_iCurrentGrid[8 - n3][n3] <= 0 || n != 8 - n2 || n == 8 - n3 || this.isRepeat(8 - n3, n3)) continue;
            byArray[this.m_iCurrentGrid[8 - n3][n3]] = 1;
        }
        n4 = 9;
        for (n3 = 1; n3 < 10; ++n3) {
            if (byArray[n3] != 0) continue;
            n4 = (byte)(n4 + 9);
        }
        if (n5 < n6) {
            n5 = n6;
        }
        if (n5 < n7) {
            n5 = n7;
        }
        byte by = (byte)(n4 - n5);
        n4 = by;
        return by;
    }

    final boolean isRepeat(int n, int n2) {
        int n3 = n2 * 9 + n;
        return (m_isRepeatedGrid[n3 / 32] & 1 << n3 % 32) != 0 && this.m_iGrid[n][n2] == 0;
    }

    private final class Header
    extends Node {
        public int size = 0;
        public int id = 0;

        public Header(Sudoku sudoku) {
            super(sudoku);
            this.head = this;
        }
    }

    private class Node {
        public Node left = this;
        public Node right = this;
        public Node up = this;
        public Node down = this;
        public Header head;

        private Node(Sudoku sudoku) {
        }

        public final void unplug() {
            this.head = null;
            this.down = null;
            this.up = null;
            this.right = null;
            this.left = null;
        }
    }
}

