/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Game;
import sk.inlogic.Resources;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class GameTile {
    private int _iX;
    private int _iY;
    private int _iPosX;
    private int _iPosY;
    private int _iType;
    private int _iOffsetX;
    private int _iOffsetY;
    private int _iOrder = 999;
    public int _iParentX;
    public int _iParentY;
    private int _iChildrenCount;
    private int _iAccX;
    private int _iAccY;
    private int _iVelX;
    private int _iVelY;
    private int _iDelataX;
    private int _iDelataY;
    private int _iSpeed;
    private int _iDownY;
    private int _iActualPositionX;
    private int _iActualPositionY;
    private int _iNewPositionX;
    private int _iNewPositionY;
    private boolean _bIsActive = false;
    private boolean _bIsSelected = false;
    private boolean _bIsAnimateToCenter = false;
    private boolean _bIsAnimateFall = false;
    private boolean _bIsChecked = false;
    private boolean _bIsFinding = false;
    private boolean _bPaint = true;
    private boolean _bRoot = false;
    private String _sName = "";
    private Rectangle _rectTile;
    private Rectangle _rectGameArea;
    private Sprite _sprGameTile;
    private Sprite _sprGameTileBg;
    private Sprite _sprGameTileSelected;
    private Game _gameController;
    private boolean _bUpdateDown = false;
    public final int NONE;
    public final int UP;
    public final int DOWN;
    public final int LEFT;
    public final int RIGHT;
    public int _iDirection;

    public GameTile(Game _game, Rectangle _rectGame) {
        this.NONE = 0;
        this.UP = 1;
        this.DOWN = 2;
        this.LEFT = 3;
        this.RIGHT = 4;
        this._rectGameArea = _rectGame;
        this._gameController = _game;
        this.init();
    }

    private void init() {
        this._sprGameTile = Resources.resSprs[14];
        this._sprGameTileSelected = Resources.resSprs[15];
        this._sprGameTileBg = Resources.resSprs[13];
        this._iOffsetX = this._sprGameTileBg.getWidth() - this._sprGameTile.getWidth() >> 1;
        this._iOffsetY = this._sprGameTileBg.getHeight() - this._sprGameTile.getHeight() >> 1;
    }

    public void create(int _ix, int _iy, int _itype) {
        this._sName = "Warrior_iX" + _ix + "_iY" + _iy + "_iType" + _itype;
        this._iX = _ix;
        this._iY = _iy;
        this._iType = _itype;
        if (this._iType < 0) {
            this._iType *= -1;
        }
        this._rectTile = new Rectangle(this._rectGameArea.x + this._iX * this._sprGameTileBg.getWidth(), this._rectGameArea.y + this._iY * this._sprGameTileBg.getWidth(), this._sprGameTileBg.getWidth(), this._sprGameTileBg.getHeight());
        this._iPosX = this._iX * this._sprGameTileBg.getWidth() + this._iOffsetX;
        this._iPosY = this._iY * this._sprGameTileBg.getWidth() + this._iOffsetY;
        this._bIsActive = true;
        this._bIsChecked = false;
        this._bPaint = true;
        this._iParentX = 999;
        this._iParentY = 999;
        this._iOrder = 999;
        this._iSpeed = this._sprGameTileBg.getWidth() >> 1;
        this._iDelataX = 0;
        this._iDelataY = 0;
    }

    public void Restart(int _ix, int _iy, int _itype) {
        System.out.println("call restart");
        this._iX = _ix;
        this._iY = _iy;
        this._iType = _itype;
        if (this._iType < 0) {
            this._iType *= -1;
        }
        this._iPosX = this._iX * this._sprGameTileBg.getWidth() + this._iOffsetX;
        this._iPosY = this._iY * this._sprGameTileBg.getWidth() + this._iOffsetY;
        this._bIsActive = true;
        this._bIsChecked = false;
        this._bPaint = true;
        this._iSpeed = this._sprGameTileBg.getWidth() >> 1;
        this._iDelataX = 0;
        this._iDelataY = 0;
    }

    public void update() {
        Particles.update();
    }

    public void moveToCenter() {
        if (this.IsRoot()) {
            return;
        }
        if (this._iDirection == 1) {
            if (this._iActualPositionY + (this._iSpeed >> 6) < this._iNewPositionY) {
                this._iActualPositionY += this._iSpeed >> 6;
                this._iDelataX = this._iNewPositionY - this._iActualPositionY;
                this.minimalOrder();
            } else {
                this._iActualPositionY = this._iNewPositionY;
                this._iDelataY = this._iNewPositionY - this._iActualPositionY;
                this._bIsAnimateToCenter = false;
                this._bPaint = false;
                this._bIsActive = false;
                this._bIsSelected = false;
            }
        } else if (this._iDirection == 2) {
            if (this._iActualPositionY - (this._iSpeed >> 6) > this._iNewPositionY) {
                this._iActualPositionY -= this._iSpeed >> 6;
                this._iDelataX = this._iActualPositionY - this._iNewPositionY;
                this.minimalOrder();
            } else {
                this._iActualPositionY = this._iNewPositionY;
                this._iDelataY = this._iNewPositionY - this._iActualPositionY;
                this._bIsAnimateToCenter = false;
                this._bPaint = false;
                this._bIsActive = false;
                this._bIsSelected = false;
            }
        } else if (this._iDirection == 3) {
            if (this._iActualPositionX + (this._iSpeed >> 6) < this._iNewPositionX) {
                this._iActualPositionX += this._iSpeed >> 6;
                this._iDelataX = this._iNewPositionX - this._iActualPositionX;
                this.minimalOrder();
            } else {
                this._iActualPositionX = this._iNewPositionX;
                this._iDelataX = this._iNewPositionX - this._iActualPositionX;
                this._bIsAnimateToCenter = false;
                this._bPaint = false;
                this._bIsActive = false;
                this._bIsSelected = false;
            }
        } else if (this._iDirection == 4) {
            if (this._iActualPositionX - (this._iSpeed >> 6) > this._iNewPositionX) {
                this._iActualPositionX -= this._iSpeed >> 6;
                this._iDelataX = this._iActualPositionX - this._iNewPositionX;
                this.minimalOrder();
            } else {
                this._iActualPositionX = this._iNewPositionX;
                this._iDelataX = this._iNewPositionX - this._iActualPositionX;
                this._bIsAnimateToCenter = false;
                this._bPaint = false;
                this._bIsActive = false;
                this._bIsSelected = false;
            }
        } else if (!this._bRoot) {
            System.out.println("TO si nieco posral");
        }
    }

    private void minimalOrder() {
        if (this.GetOrder() == 1) {
            this._iActualPositionX = this._iNewPositionX;
            this._iDelataX = this._iNewPositionX - this._iActualPositionX;
            this._bIsAnimateToCenter = false;
            this._bPaint = false;
            this._bIsActive = false;
            this._bIsSelected = false;
        }
    }

    public boolean updateFindDownPosition() {
        return this.updateMyPosition(this._iY);
    }

    private boolean updateMyPosition(int _iy) {
        if (_iy + 1 < 5) {
            if (!this._gameController.GetGameTiles()[this._iX][_iy + 1].IsEnable()) {
                System.out.println("update " + this._iType + " my position: _iY: " + this._iY + " ,iY2 " + (_iy + 1));
                this._gameController.SwichTiles(this._iX, this._iY, this._iX, _iy + 1);
                this.updateMyPosition(this._iY);
            }
        } else {
            return false;
        }
        return false;
    }

    public void hide() {
        this._bIsActive = false;
    }

    public void paint(Graphics g) {
        if (!this._bPaint) {
            return;
        }
        if (!this._bIsActive) {
            return;
        }
        if (this._bIsSelected) {
            this._sprGameTileSelected.setFrame(this._iType - 1);
            this._sprGameTileSelected.setPosition(this._rectGameArea.x + this._iPosX - (this._sprGameTileSelected.getWidth() - this._sprGameTile.getWidth() >> 1) + this._iDelataX, this._rectGameArea.y + this._iPosY - (this._sprGameTileSelected.getWidth() - this._sprGameTile.getWidth() >> 1) + this._iDelataY);
            this._sprGameTileSelected.paint(g);
            this._sprGameTile.setFrame(this._iType - 1);
            this._sprGameTile.setPosition(this._rectGameArea.x + this._iPosX + this._iDelataX, this._rectGameArea.y + this._iPosY + this._iDelataY);
            this._sprGameTile.paint(g);
        } else {
            this._sprGameTile.setFrame(this._iType - 1);
            this._sprGameTile.setPosition(this._rectGameArea.x + this._iPosX + this._iDelataX, this._rectGameArea.y + this._iPosY + this._iDelataY);
            this._sprGameTile.paint(g);
        }
    }

    public int GetX() {
        return this._iX;
    }

    public void SetX(int _ix) {
        this._iX = _ix;
        this._iPosX = this._iX * this._sprGameTileBg.getWidth() + this._iOffsetX;
    }

    public int GetY() {
        return this._iY;
    }

    public boolean IsUpdateDown() {
        return this._bUpdateDown;
    }

    public void updateDown() {
        if (this._iActualPositionY - (this._iSpeed >> 1) > this._iNewPositionY) {
            this._iActualPositionY -= this._iSpeed >> 1;
            this._iDelataX = this._iActualPositionY - this._iNewPositionY;
        } else {
            this._iActualPositionY = this._iNewPositionY;
            this._iDelataY = this._iNewPositionY - this._iActualPositionY;
            this._bUpdateDown = false;
        }
    }

    public void SetY(int _iy) {
        this._iY = _iy;
        this._iPosY = this._iY * this._sprGameTileBg.getWidth() + this._iOffsetY;
    }

    public int GetWarriorType() {
        return this._iType;
    }

    public void SetWarriorType() {
        ++this._iType;
        this._gameController.SetMaxTileValue(this._iType);
        this._bIsSelected = false;
        Particles.createParticle(this._rectGameArea.x + this._iPosX + this._iDelataX, this._rectGameArea.y + this._iPosY + this._iDelataY, 0, 50, RandomNum.getRandomInt(5, -5), 0, 3, 0xFFFFFF, RandomNum.getRandomUInt(10), 0);
    }

    public void Select() {
        this._bIsSelected = true;
    }

    public void Unselect() {
        this._bIsSelected = false;
        this.SetCheckedTile(false);
        this.SetOrder(999);
        this.SetRoot(false);
        this._iParentX = 999;
        this._iParentY = 999;
        this._iOrder = 999;
    }

    public boolean IsSelected() {
        return this._bIsSelected;
    }

    public boolean IsEnable() {
        return this._bPaint;
    }

    public boolean IsActive() {
        return this._bIsActive;
    }

    public void SetCheckedTile(boolean _bValue) {
        this._bIsChecked = _bValue;
    }

    public boolean IsChecked() {
        return this._bIsChecked;
    }

    public void SetFindingTile(boolean _bValue) {
        this._bIsFinding = _bValue;
    }

    public boolean IsFinding() {
        return this._bIsFinding;
    }

    public void SetParent(int _iX, int _iY) {
        if (this._iParentX >= 999) {
            this._iParentX = _iX;
            this._iParentY = _iY;
        } else if (this._iParentY >= 999) {
            this._iParentX = _iX;
            this._iParentY = _iY;
        } else if (this._gameController.GetGameTiles()[_iX][_iY] != null && this._gameController.GetGameTiles()[this._iParentX][this._iParentY] != null && this._gameController.GetGameTiles()[_iX][_iY].GetOrder() < this._gameController.GetGameTiles()[this._iParentX][this._iParentY].GetOrder()) {
            this._iParentX = _iX;
            this._iParentY = _iY;
        }
        this._gameController.AddCheckedTile();
    }

    public void SetFinalPositions() {
        this._iActualPositionX = this._rectGameArea.x + this._iPosX;
        this._iActualPositionY = this._rectGameArea.y + this._iPosY;
        this._iDelataX = 0;
        this._iDelataY = 0;
        if (!this._bRoot) {
            this._iNewPositionX = this._gameController.GetGameTiles()[this._iParentX][this._iParentY].GetPostionX();
            this._iNewPositionY = this._gameController.GetGameTiles()[this._iParentX][this._iParentY].GetPostionY();
            this.setDirection();
        } else {
            this._iNewPositionX = this._iActualPositionX;
            this._iNewPositionY = this._iActualPositionY;
        }
    }

    private void setDirection() {
        this._iDirection = 0;
        if (this._iX == this._iParentX) {
            this._iDirection = this._iY > this._iParentY ? 1 : 2;
        } else if (this._iY == this._iParentY) {
            this._iDirection = this._iX > this._iParentX ? 3 : 4;
        } else {
            System.out.println(this._iX + " != " + this._iParentX);
            System.out.println(this._iY + " != " + this._iParentY);
        }
    }

    public int GetPostionX() {
        return this._rectGameArea.x + this._iPosX;
    }

    public int GetPostionY() {
        return this._rectGameArea.y + this._iPosY;
    }

    public int GetCenterX() {
        return this._rectGameArea.x + this._iPosX + (this._sprGameTile.getWidth() >> 1);
    }

    public int GetCenterY() {
        return this._rectGameArea.y + this._iPosY + (this._sprGameTile.getWidth() >> 1);
    }

    public int GetWidth() {
        return this._sprGameTileBg.getWidth();
    }

    public int GetHeight() {
        return this._sprGameTileBg.getWidth();
    }

    public boolean SetOrder(int _iNumber) {
        System.out.println("_iNumber: " + _iNumber);
        System.out.println("_iNumber: " + _iNumber);
        if (this._iOrder > _iNumber) {
            this._iOrder = _iNumber;
            return true;
        }
        return false;
    }

    public Rectangle GetRect() {
        return this._rectTile;
    }

    public int GetOrder() {
        return this._iOrder;
    }

    public String GetName() {
        return this._sName;
    }

    public void SetRoot(boolean _bValue) {
        this._bRoot = _bValue;
    }

    public boolean IsRoot() {
        return this._bRoot;
    }

    public void StartMove() {
        this._bIsAnimateToCenter = true;
    }
}

