/*
 * Decompiled with CFR 0.152.
 */
package skb;

import cucumber.Keeper;
import cucumber.Q;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import skb.GameNotifier;
import skb.Level;
import skb.SkbSettings;
import skb.SkinLoader;
import skb.Xsb;

public class Board
extends Canvas
implements GameNotifier {
    public static Command cmdMenu = new Command("Menu", 4, 1);
    public static final int NONE = 0;
    public static final int PUSHES = 1;
    public static final int MOVES = 2;
    public static final int COMPLETESET = 4;
    public static final int GM = 1;
    public static final int LC = 2;
    public static final int NF = 3;
    public static final int TOPC = 17;
    private int dispMode;
    private boolean showStatus;
    private boolean pushHarder;
    private SkinLoader skn;
    private Xsb xsb;
    private Level l;
    private Level L;
    private SkbSettings sets;
    private int crtLev = 0;
    private int sz;
    private int xOrigin;
    private int yOrigin;
    private int records;
    private Display display;
    private Displayable d;
    private Font fontInfo;
    private int fontHeight;
    private Image screen;
    private Graphics gr;
    private int lcSz;
    private int lcSel;
    private int lcOsel;
    private int lcNi;
    private int lcNj;
    private int lcX0;
    private int lcY0;

    public int lcGetX(int n, int n2) {
        return this.lcX0 + n2 * this.lcSz;
    }

    public int lcGetY(int n, int n2) {
        return this.lcY0 + n * this.lcSz;
    }

    public void lcDrawSq(int n, int n2, boolean bl) {
        int n3;
        int n4 = n3 = this.lcSz - 1;
        int n5 = this.lcX0 + n2 * this.lcSz;
        int n6 = this.lcY0 + n * this.lcSz;
        int n7 = n * this.lcNj + n2;
        boolean bl2 = n7 == this.lcSel;
        boolean bl3 = this.xsb.getLevel((int)n7).numSolved != 0;
        boolean bl4 = n7 == this.crtLev;
        this.gr.setColor(32, 32, 32);
        this.gr.fillRect(n5 + 3, n6 + 3, n4 - 2, n3 - 2);
        int n8 = bl3 ? (bl4 ? Q.RGB(0, 200, 200) : Q.RGB(0, 200, 0)) : (bl4 ? Q.RGB(200, 0, 0) : Q.RGB(128, 128, 128));
        if (bl2) {
            n8 = Q.addRGB(n8, 55);
        }
        this.gr.setColor(n8);
        this.gr.fillRect(n5 + 1, n6 + 1, n4 - 2, n3 - 2);
        n8 = !bl2 ? Q.addRGB(n8, 55) : Q.RGB(255, 255, 255);
        this.gr.setColor(n8);
        this.gr.drawRect(n5 + 1, n6 + 1, n4 - 3, n3 - 3);
        if (bl) {
            this.repaint(this.lcGetX(n, n2), this.lcGetY(n, n2), this.lcSz, this.lcSz);
        }
    }

    public void lcConfigure() {
        this.lcNj = Q.min(10, this.xsb.count());
        this.lcNi = this.xsb.count() / this.lcNj;
        if (this.xsb.count() % 10 != 0) {
            ++this.lcNi;
        }
        this.lcSz = Q.min((this.getHeight() - this.fontHeight * 2) / this.lcNi, this.getWidth() / this.lcNj);
        this.lcX0 = this.getWidth() / 2 - this.lcSz * this.lcNj / 2;
        this.lcY0 = this.getHeight() / 2 - this.lcSz * this.lcNi / 2;
    }

    public void lcDrawInfo() {
        this.gr.setColor(0, 0, 0);
        this.gr.fillRect(0, 0, this.getWidth(), this.fontHeight);
        this.gr.fillRect(0, this.getHeight() - this.fontHeight, this.getWidth(), this.getHeight());
        this.gr.setColor(255, 255, 255);
        this.gr.setFont(this.fontInfo);
        Level level = this.xsb.getLevel(this.lcSel);
        this.gr.drawString("" + (this.lcSel + 1) + " of " + this.xsb.count(), 0, this.getHeight(), 36);
        if (level.title != "") {
            if (level.numSolved != 0) {
                this.gr.setColor(0, 255, 0);
            } else {
                this.gr.setColor(255, 255, 0);
            }
            this.gr.drawString(level.title, this.getWidth(), this.getHeight(), 40);
            this.gr.setColor(255, 255, 255);
        }
        if (level.numSolved != 0) {
            this.gr.drawString(level.numSolved + "x, " + level.bestMoves + "m, " + level.bestPushes + "p", this.getWidth() / 2, 0, 17);
        }
    }

    public void lcPaint() {
        for (int i = 0; i < this.lcNi; ++i) {
            for (int j = 0; j < this.lcNj; ++j) {
                if (i * this.lcNj + j >= this.xsb.count()) continue;
                this.lcDrawSq(i, j, false);
            }
        }
        this.lcDrawInfo();
    }

    protected void lcMoveSel(int n, int n2) {
        this.lcSel = n2 != 0 ? (this.lcSel += n2) : (this.lcSel += this.lcNj * n);
        if (this.lcSel < 0) {
            this.lcSel = 0;
        }
        if (this.lcSel >= this.xsb.count()) {
            this.lcSel = this.xsb.count() - 1;
        }
        this.lcDrawSq(this.lcOsel / this.lcNj, this.lcOsel % this.lcNj, false);
        this.lcDrawSq(this.lcSel / this.lcNj, this.lcSel % this.lcNj, false);
        this.lcDrawInfo();
        this.repaint();
        this.lcOsel = this.lcSel;
    }

    public void createScreenImage() {
        this.screen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.gr = this.screen.getGraphics();
    }

    public void createScreen() {
        this.gr.setColor(0);
        this.gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        switch (this.dispMode) {
            case 2: {
                this.lcConfigure();
                this.lcPaint();
                break;
            }
            case 1: {
                this.gmConfigure();
                this.gmPaint(this.gr);
                this.gmStatus();
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void setSkin(SkinLoader skinLoader) {
        this.skn = skinLoader;
        this.createScreen();
    }

    public void gmConfigure() {
        boolean bl = false;
        int n = this.getHeight() - (this.showStatus ? this.fontHeight : 0);
        this.sz = this.skn.getMinSize();
        while (this.l.width * this.sz <= this.getWidth() && this.l.height * this.sz <= n) {
            ++this.sz;
            bl = true;
        }
        if (bl) {
            --this.sz;
        }
        if (this.sz > this.skn.getMaxSize()) {
            this.sz = this.skn.getMaxSize();
        }
        this.skn.loadImages(this.sz);
        this.xOrigin = this.getWidth() / 2 - this.l.width * this.sz / 2;
        this.yOrigin = n / 2 - this.l.height * this.sz / 2;
    }

    public void loadLevel(int n, boolean bl) {
        if (this.xsb == null || this.xsb.count() == 0) {
            return;
        }
        if (n < 0) {
            n = this.xsb.count() - 1;
        }
        if (n >= this.xsb.count()) {
            n = 0;
        }
        this.dispMode = 1;
        this.pushHarder = false;
        this.showStatus = this.sets.showStatus;
        this.lcOsel = this.lcSel = n;
        this.crtLev = n;
        this.L = this.xsb.getLevel(n);
        this.l = this.L.copyOf();
        this.l.setNotifier(this);
        this.l.addReplayer(this.sets.undoLevels);
        if (bl) {
            this.createScreen();
        }
    }

    public void loadLevel(int n) {
        this.loadLevel(n, true);
    }

    public void loadGame() {
        this.statusMessage("PLEASE WAIT");
        try {
            if (this.xsb == null || this.xsb.count() == 0) {
                return;
            }
            Keeper keeper = Keeper.getKeeper("skbgame");
            InputStream inputStream = keeper.get("savegame");
            if (inputStream == null) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.sets.collection = Level.loadGetCollection(dataInputStream);
            this.xsb.load(this.sets.collection);
            this.loadLevel(Level.loadGetNum(dataInputStream) - 1, false);
            this.l.load(dataInputStream);
            dataInputStream.close();
            this.createScreen();
            keeper.close();
            keeper = null;
            this.sets.save();
            this.gmStatus();
        }
        catch (Exception exception) {
            this.gmStatus();
        }
    }

    public void saveGame() {
        this.statusMessage("PLEASE WAIT");
        try {
            ByteArrayOutputStream byteArrayOutputStream = Keeper.getStream("savegame");
            this.l.save(byteArrayOutputStream);
            Keeper keeper = Keeper.getKeeper("skbgame");
            keeper.save(byteArrayOutputStream);
            keeper.close();
            keeper = null;
            this.statusMessage("GAME SAVED");
            Q.wt(200);
            this.gmStatus();
        }
        catch (Exception exception) {
            this.gmStatus();
        }
    }

    protected void sizeChanged(int n, int n2) {
        this.createScreenImage();
        this.createScreen();
    }

    public Board(SkbSettings skbSettings, SkinLoader skinLoader, Xsb xsb, Displayable displayable, Display display, CommandListener commandListener) {
        this.setFullScreenMode(skbSettings.fullScreen);
        this.createScreenImage();
        this.display = display;
        this.d = displayable;
        this.fontInfo = Font.getFont((int)32, (int)0, (int)8);
        this.fontHeight = this.fontInfo.getHeight();
        this.xsb = xsb;
        this.skn = skinLoader;
        this.sets = skbSettings;
        this.lcSel = 0;
        this.lcOsel = 0;
        this.sz = 0;
        this.addCommand(cmdMenu);
        this.setCommandListener(commandListener);
        this.dispMode = 1;
        this.showStatus = this.sets.showStatus;
        this.loadLevel(this.xsb.getFirstUnsolved());
    }

    public void loadNextLevel() {
        switch (this.sets.levelAdvance) {
            case 0: {
                this.loadLevel(this.crtLev + 1);
                break;
            }
            case 1: {
                int n;
                for (n = 0; n < this.xsb.count() && this.xsb.getLevel((int)n).numSolved > 0; ++n) {
                }
                if (n < this.xsb.count()) {
                    this.loadLevel(n);
                    break;
                }
                this.loadLevel(this.crtLev + 1);
                break;
            }
            case 2: {
                int n;
                for (n = 0; n < this.xsb.count() && this.xsb.getLevel((int)this.crtLev).numSolved > 0; ++n) {
                    ++this.crtLev;
                    this.crtLev %= this.xsb.count();
                }
                if (n < this.xsb.count()) {
                    this.loadLevel(this.crtLev);
                    break;
                }
                this.loadLevel(this.crtLev + 1);
            }
        }
    }

    protected void nfKeyPressed(int n) {
        this.loadNextLevel();
    }

    protected void lcKeyPressed(int n) {
        if (n == 52 || this.getGameAction(n) == 2) {
            this.lcMoveSel(0, -1);
            this.serviceRepaints();
            return;
        }
        if (n == 54 || this.getGameAction(n) == 5) {
            this.lcMoveSel(0, 1);
            this.serviceRepaints();
            return;
        }
        if (n == 50 || this.getGameAction(n) == 1) {
            this.lcMoveSel(-1, 0);
            this.serviceRepaints();
            return;
        }
        if (n == 56 || this.getGameAction(n) == 6) {
            this.lcMoveSel(1, 0);
            this.serviceRepaints();
            return;
        }
        if (n == 53 || this.getGameAction(n) == 8) {
            this.loadLevel(this.lcSel);
            return;
        }
        this.dispMode = 1;
        this.createScreen();
    }

    protected void movePlayer(int n, int n2) {
        if (this.l.complete()) {
            return;
        }
        if (!this.pushHarder) {
            this.l.move(n, n2);
        } else if (this.l.nxt(n, n2) == 0) {
            while (this.l.nxt(n, n2) == 0 && !this.l.complete() && this.l.move(n, n2) != 0) {
                this.serviceRepaints();
                if ((this.l.nxt(n, n2) & 8) != 0) continue;
                Q.wt(25);
            }
        } else {
            while (!this.l.complete() && this.l.move(n, n2) != 0) {
                this.serviceRepaints();
                if ((this.l.nxt(n, n2) & 8) != 0) continue;
                Q.wt(25);
            }
        }
        this.pushHarder = false;
        this.serviceRepaints();
    }

    protected void gmKeyPressed(int n) {
        if (n == 52 || this.getGameAction(n) == 2) {
            this.movePlayer(0, -1);
            return;
        }
        if (n == 54 || this.getGameAction(n) == 5) {
            this.movePlayer(0, 1);
            this.serviceRepaints();
            return;
        }
        if (n == 50 || this.getGameAction(n) == 1) {
            this.movePlayer(-1, 0);
            this.serviceRepaints();
            return;
        }
        if (n == 56 || this.getGameAction(n) == 6) {
            this.movePlayer(1, 0);
            this.serviceRepaints();
            return;
        }
        if (n == 53 || this.getGameAction(n) == 8) {
            this.pushHarder = !this.pushHarder;
            return;
        }
        if (n == 49) {
            if (!this.pushHarder) {
                this.l.undo();
                this.serviceRepaints();
                return;
            }
            this.pushHarder = false;
            this.loadGame();
            return;
        }
        if (n == 51) {
            if (!this.pushHarder) {
                this.l.redo();
                this.serviceRepaints();
                return;
            }
            this.pushHarder = false;
            this.saveGame();
            return;
        }
        if (n == 55) {
            this.loadLevel(--this.crtLev);
            return;
        }
        if (n == 57) {
            this.loadLevel(++this.crtLev);
            return;
        }
        if (n == 48) {
            this.showStatus = !this.showStatus;
            this.createScreen();
            return;
        }
        if (n == 42) {
            this.loadLevel(this.crtLev);
            return;
        }
        if (n == 35) {
            this.dispMode = 2;
            this.createScreen();
            return;
        }
        this.display.setCurrent(this.d);
    }

    protected void keyPressed(int n) {
        switch (this.dispMode) {
            case 1: {
                this.gmKeyPressed(n);
                break;
            }
            case 2: {
                this.lcKeyPressed(n);
                break;
            }
            case 3: {
                this.nfKeyPressed(n);
            }
        }
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public int getCellLeft(int n, int n2) {
        return this.skn.getSize() * n2 + this.xOrigin;
    }

    public int getCellTop(int n, int n2) {
        return this.skn.getSize() * n + this.yOrigin;
    }

    public void gmPaintStatus(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, this.getHeight() - this.fontHeight, this.getWidth(), this.getHeight());
        graphics.setFont(this.fontInfo);
        if (this.l.moves + this.l.pushes != 0) {
            graphics.setColor(160, 160, 160);
            graphics.drawString(this.l.moves + "m, " + this.l.pushes + "p", this.getWidth(), this.getHeight(), 40);
        } else {
            if (this.l.numSolved != 0) {
                this.gr.setColor(0, 255, 0);
            } else {
                this.gr.setColor(255, 255, 0);
            }
            graphics.drawString(this.l.title, this.getWidth(), this.getHeight(), 40);
            graphics.setColor(255, 255, 255);
        }
        graphics.drawString(this.l.num + " of " + this.xsb.count(), 0, this.getHeight(), 36);
    }

    public void gmStatus() {
        if (!this.showStatus) {
            return;
        }
        this.gmPaintStatus(this.gr);
        this.repaint(0, this.getHeight() - this.fontHeight, this.getWidth(), this.fontHeight);
    }

    public void statusMessage(String string) {
        if (!this.showStatus) {
            return;
        }
        this.gr.setColor(0, 0, 0);
        this.gr.fillRect(0, this.getHeight() - this.fontHeight, this.getWidth(), this.getHeight());
        this.gr.setFont(this.fontInfo);
        this.gr.setColor(255, 255, 255);
        this.gr.drawString(string, this.getWidth() / 2, this.getHeight(), 33);
        this.repaint(0, this.getHeight() - this.fontHeight, this.getWidth(), this.fontHeight);
        this.serviceRepaints();
    }

    public void gmPaintCell(int n, int n2, Graphics graphics) {
        graphics.drawImage(this.skn.getCellImage(this.l.lv[n][n2]), this.getCellLeft(n, n2), this.getCellTop(n, n2), 20);
    }

    public void gmPaint(Graphics graphics) {
        for (int i = 0; i < this.l.height; ++i) {
            for (int j = 0; j < this.l.rw[i]; ++j) {
                this.gmPaintCell(i, j, graphics);
            }
        }
    }

    protected void paint(Graphics graphics) {
        graphics.drawRegion(this.screen, graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight(), 0, graphics.getClipX(), graphics.getClipY(), 20);
    }

    public void drawFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        while (n6 > 0) {
            graphics.setColor(n6);
            graphics.drawRect(n++, n2++, n3 -= 2, n4 -= 2);
            n6 = Q.addRGB(n6, -n5);
        }
        graphics.setColor(n7);
        graphics.fillRect(n, n2, n3 - 1, n4 - 1);
    }

    public void drawInfoScreen() {
        int n = this.getHeight() / 2 - this.fontHeight * 9 / 2;
        this.dispMode = 3;
        int n2 = Q.max(this.fontInfo.stringWidth("<<< COLLECTION COMPLETE >>>"), this.fontInfo.stringWidth("  " + this.l.title + "  "));
        this.gr.setFont(this.fontInfo);
        this.gr.setColor(32, 32, 32);
        this.drawFrame(this.gr, (this.getWidth() - n2) / 2, n, n2, this.fontHeight * 9, 60, Q.RGB(255, 255, 255), 0);
        if ((this.records & 4) != 0) {
            this.gr.setColor(255, 0, 255);
            this.gr.drawString("COLLECTION COMPLETE", this.getWidth() / 2, n += this.fontHeight, 17);
        } else {
            this.gr.setColor(0, 255, 0);
            this.gr.drawString("LEVEL COMPLETE", this.getWidth() / 2, n += this.fontHeight, 17);
        }
        this.gr.setColor(255, 255, 255);
        this.gr.drawString(this.l.num + "/" + this.xsb.count(), this.getWidth() / 2, n += this.fontHeight, 17);
        this.gr.setColor(255, 255, 0);
        this.gr.drawString(this.l.title, this.getWidth() / 2, n += this.fontHeight, 17);
        if (this.l.moves == this.l.bestMoves) {
            this.gr.setColor(255, 255, 255);
        } else if (this.l.moves > this.l.bestMoves && this.l.bestMoves != 0) {
            this.gr.setColor(255, 0, 0);
        } else {
            this.gr.setColor(0, 255, 0);
        }
        if (this.l.bestMoves != 0) {
            this.gr.drawString("Moves: " + this.l.moves + " (" + this.l.bestMoves + ")", this.getWidth() / 2, n += this.fontHeight * 2, 17);
        } else {
            this.gr.drawString("Moves: " + this.l.moves, this.getWidth() / 2, n += this.fontHeight * 2, 17);
        }
        if (this.l.pushes == this.l.bestPushes) {
            this.gr.setColor(255, 255, 255);
        } else if (this.l.pushes > this.l.bestPushes && this.l.bestPushes != 0) {
            this.gr.setColor(255, 0, 0);
        } else {
            this.gr.setColor(0, 255, 0);
        }
        if (this.l.bestPushes != 0) {
            this.gr.drawString("Pushes: " + this.l.pushes + " (" + this.l.bestPushes + ")", this.getWidth() / 2, n += this.fontHeight, 17);
        } else {
            this.gr.drawString("Pushes: " + this.l.pushes, this.getWidth() / 2, n += this.fontHeight, 17);
        }
        this.gr.setColor(0, 255, 0);
        this.gr.drawString("Solved: x" + this.L.numSolved, this.getWidth() / 2, n += this.fontHeight, 17);
    }

    public void levelComplete() {
        boolean bl = this.xsb.complete();
        ++this.L.numSolved;
        this.records = 0;
        if (this.xsb.complete() && !bl) {
            this.records |= 4;
        }
        if (this.L.bestMoves == 0 || this.l.moves < this.L.bestMoves) {
            this.L.bestMoves = this.l.moves;
            this.records |= 2;
        }
        if (this.L.bestPushes == 0 || this.l.pushes < this.L.bestPushes) {
            this.L.bestPushes = this.l.pushes;
            this.records |= 1;
        }
        this.xsb.updateStats();
        this.serviceRepaints();
        Q.wt(200);
        this.drawInfoScreen();
        this.repaint();
        this.serviceRepaints();
    }

    public void cellUpdated(int n, int n2) {
        this.gmPaintCell(n, n2, this.gr);
        this.repaint(this.getCellLeft(n, n2), this.getCellTop(n, n2), this.sz, this.sz);
    }

    public void statusUpdated() {
        this.gmStatus();
    }
}

