/*
 * Decompiled with CFR 0.152.
 */
package skb;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import skb.SkbSettings;

class OptionsDlg
extends Form
implements CommandListener {
    private TextField setUndoLevels;
    private ChoiceGroup setShowStatus;
    private ChoiceGroup setShowTitles;
    private ChoiceGroup setNextLevel;
    private ChoiceGroup setFullScreen;
    private SkbSettings skbset;
    private CommandListener clst;
    public static Command cmdOk = new Command("Ok", 4, 1);
    public static Command cmdCancel = new Command("Cancel", 2, 2);

    public OptionsDlg(SkbSettings skbSettings, CommandListener commandListener) {
        super("Options");
        this.skbset = skbSettings;
        this.clst = commandListener;
        this.addCommand(cmdOk);
        this.addCommand(cmdCancel);
        this.setCommandListener(this);
        this.setUndoLevels = new TextField("Undo levels (-1 for unlimited):", "-1", 5, 2);
        this.append((Item)this.setUndoLevels);
        this.setShowStatus = new ChoiceGroup("Status line:", 4, new String[]{"Show", "Hide"}, new Image[]{null, null});
        this.append((Item)this.setShowStatus);
        this.setFullScreen = new ChoiceGroup("Display:", 4, new String[]{"Normal", "Full screen"}, new Image[]{null, null});
        this.append((Item)this.setFullScreen);
        this.setShowTitles = new ChoiceGroup("Level titles:", 1, new String[]{"Shown", "Hidden"}, new Image[]{null, null});
        this.setNextLevel = new ChoiceGroup("Level advance:", 1, new String[]{"Next level", "First unsolved", "Next unsolved"}, new Image[]{null, null, null});
        this.append((Item)this.setNextLevel);
        this.reset();
    }

    public void reset() {
        this.setUndoLevels.setString(String.valueOf(this.skbset.undoLevels));
        this.setShowStatus.setSelectedIndex(this.skbset.showStatus ? 0 : 1, true);
        this.setFullScreen.setSelectedIndex(this.skbset.fullScreen ? 1 : 0, true);
        this.setNextLevel.setSelectedIndex(this.skbset.levelAdvance, true);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == cmdOk) {
            this.skbset.showStatus = this.setShowStatus.getSelectedIndex() == 0;
            this.skbset.levelAdvance = this.setNextLevel.getSelectedIndex();
            this.skbset.undoLevels = Integer.valueOf(this.setUndoLevels.getString());
            this.skbset.fullScreen = this.setFullScreen.getSelectedIndex() == 1;
            this.skbset.save();
        } else if (command == cmdCancel) {
            // empty if block
        }
        this.clst.commandAction(command, displayable);
    }
}

