/*
 * Decompiled with CFR 0.152.
 */
package skb;

import cucumber.BitInputStream;
import cucumber.BitOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import skb.Entry;
import skb.Level;

public class Replayer {
    public static final int UNLIMITED = -1;
    private Vector entries = new Vector();
    private int position = 0;
    private int capacity;
    private Level l;

    public Replayer(Level level) {
        this.l = level;
        this.capacity = -1;
    }

    public Replayer(Level level, int n) {
        this(level);
        this.capacity = n;
    }

    void undo() {
        Entry entry = this.undoMove();
        if (entry == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        switch (entry.cd) {
            case 32: {
                n = -1;
                n2 = 0;
                break;
            }
            case 16: {
                n = 1;
                n2 = 0;
                break;
            }
            case 64: {
                n = 0;
                n2 = 1;
                break;
            }
            case -128: {
                n = 0;
                n2 = -1;
            }
        }
        byte[] byArray = this.l.lv[this.l.posi - n];
        int n3 = this.l.posj - n2;
        byArray[n3] = (byte)(byArray[n3] | 1);
        byte[] byArray2 = this.l.lv[this.l.posi];
        int n4 = this.l.posj;
        byArray2[n4] = (byte)(byArray2[n4] & 0xFFFFFFFE);
        if (entry.cb) {
            byte[] byArray3 = this.l.lv[this.l.posi + n];
            int n5 = this.l.posj + n2;
            byArray3[n5] = (byte)(byArray3[n5] & 0xFFFFFFFD);
            this.l.gn.cellUpdated(this.l.posi + n, this.l.posj + n2);
            byte[] byArray4 = this.l.lv[this.l.posi];
            int n6 = this.l.posj;
            byArray4[n6] = (byte)(byArray4[n6] | 2);
        }
        this.l.gn.cellUpdated(this.l.posi - n, this.l.posj - n2);
        this.l.gn.cellUpdated(this.l.posi, this.l.posj);
        this.l.posi -= n;
        this.l.posj -= n2;
        --this.l.moves;
        this.l.pushes = this.l.pushes - (entry.cb ? 1 : 0);
        this.l.gn.statusUpdated();
    }

    void redo() {
        Entry entry = this.redoMove();
        if (entry == null) {
            return;
        }
        switch (entry.cd) {
            case 32: {
                this.l.mv(-1, 0);
                break;
            }
            case 16: {
                this.l.mv(1, 0);
                break;
            }
            case 64: {
                this.l.mv(0, 1);
                break;
            }
            case -128: {
                this.l.mv(0, -1);
            }
        }
    }

    public Entry undoMove() {
        if (this.position <= 0) {
            return null;
        }
        return this.get(--this.position);
    }

    public Entry redoMove() {
        if (this.position >= this.entries.size()) {
            return null;
        }
        return this.get(this.position++);
    }

    public void put(Entry entry) {
        this.entries.insertElementAt(entry, this.position);
        this.entries.setSize(++this.position);
        if (this.capacity != -1 && this.entries.size() > this.capacity) {
            this.entries.removeElementAt(0);
            --this.position;
        }
    }

    public Entry get(int n) {
        return (Entry)this.entries.elementAt(n);
    }

    public boolean save(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(this.position);
            dataOutputStream.writeInt(this.capacity);
            dataOutputStream.writeInt(this.entries.size());
            BitOutputStream bitOutputStream = new BitOutputStream(dataOutputStream);
            Enumeration enumeration = this.entries.elements();
            while (enumeration.hasMoreElements()) {
                Entry entry = (Entry)enumeration.nextElement();
                bitOutputStream.writeBoolean(entry.cb);
                switch (entry.cd) {
                    case 16: {
                        bitOutputStream.writeBit(0);
                        bitOutputStream.writeBit(0);
                        break;
                    }
                    case 32: {
                        bitOutputStream.writeBit(0);
                        bitOutputStream.writeBit(1);
                        break;
                    }
                    case 64: {
                        bitOutputStream.writeBit(1);
                        bitOutputStream.writeBit(0);
                        break;
                    }
                    case -128: {
                        bitOutputStream.writeBit(1);
                        bitOutputStream.writeBit(1);
                    }
                }
            }
            bitOutputStream.flushToByte();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean load(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.position = dataInputStream.readInt();
            this.capacity = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            BitInputStream bitInputStream = new BitInputStream(dataInputStream);
            for (int i = 1; i <= n; ++i) {
                Entry entry = new Entry();
                entry.cb = bitInputStream.readBoolean();
                int n2 = bitInputStream.readBit() * 2 + bitInputStream.readBit();
                switch (n2) {
                    case 0: {
                        entry.cd = (byte)16;
                        break;
                    }
                    case 1: {
                        entry.cd = (byte)32;
                        break;
                    }
                    case 2: {
                        entry.cd = (byte)64;
                        break;
                    }
                    case 3: {
                        entry.cd = (byte)-128;
                    }
                }
                this.entries.addElement(entry);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

