/*
 * Decompiled with CFR 0.152.
 */
package cucumber;

import cucumber.NameFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Keeper {
    protected RecordStore rs;
    protected NameFilter nf;

    public RecordStore getRS() {
        return this.rs;
    }

    public Keeper(RecordStore recordStore) {
        this.rs = recordStore;
        this.nf = new NameFilter();
    }

    public Keeper(String string) throws RecordStoreException {
        this(RecordStore.openRecordStore((String)string, (boolean)true));
    }

    public Keeper() throws RecordStoreException {
        this("default");
    }

    public static Keeper getKeeper(String string) {
        Keeper keeper;
        try {
            keeper = new Keeper(string);
        }
        catch (Exception exception) {
            return null;
        }
        return keeper;
    }

    public int getId(String string) throws RecordStoreException {
        this.nf.set(string);
        RecordEnumeration recordEnumeration = this.rs.enumerateRecords((RecordFilter)this.nf, null, false);
        int n = recordEnumeration.numRecords() == 0 ? -1 : recordEnumeration.nextRecordId();
        recordEnumeration.destroy();
        return n;
    }

    public int getId(byte[] byArray) throws RecordStoreException {
        this.nf.set(byArray);
        RecordEnumeration recordEnumeration = this.rs.enumerateRecords((RecordFilter)this.nf, null, false);
        int n = recordEnumeration.numRecords() == 0 ? -1 : recordEnumeration.nextRecordId();
        recordEnumeration.destroy();
        return n;
    }

    public void delete(String string) throws RecordStoreException {
        int n = this.getId(string);
        if (n == -1) {
            return;
        }
        this.rs.deleteRecord(n);
    }

    public void close() throws RecordStoreException {
        this.rs.closeRecordStore();
    }

    public InputStream get(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            int n = this.getId(string);
            if (n == -1) {
                return null;
            }
            byteArrayInputStream = new ByteArrayInputStream(this.rs.getRecord(n));
            int n2 = byteArrayInputStream.read();
            byteArrayInputStream.skip(n2);
        }
        catch (Exception exception) {
            byteArrayInputStream = null;
            return null;
        }
        return byteArrayInputStream;
    }

    public static ByteArrayOutputStream getStream(String string) {
        byte[] byArray = string.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((byte)byArray.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream;
    }

    public void save(ByteArrayOutputStream byteArrayOutputStream) throws RecordStoreException {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = this.getId(byArray);
        if (n == -1) {
            this.rs.addRecord(byArray, 0, byArray.length);
        } else {
            this.rs.setRecord(n, byArray, 0, byArray.length);
        }
    }
}

