/*
 * Decompiled with CFR 0.152.
 */
package skb;

import cucumber.Keeper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class SkbSettings {
    public static final int NEXTLEVEL = 0;
    public static final int FIRSTUNSOLVED = 1;
    public static final int NEXTUNSOLVED = 2;
    public static final int SHOWN = 0;
    public static final int HIDDEN = 1;
    public boolean showStatus = true;
    public int undoLevels = -1;
    public int levelAdvance = 1;
    public int collection = 1;
    public int skin = 1;
    public boolean fullScreen = true;
    private String rsname;

    public SkbSettings() {
        this.load();
    }

    public void load() {
        try {
            Keeper keeper = Keeper.getKeeper("skbgame");
            InputStream inputStream = keeper.get("settings");
            if (inputStream != null) {
                this.load(inputStream);
            }
            keeper.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = Keeper.getStream("settings");
            this.save(byteArrayOutputStream);
            Keeper keeper = Keeper.getKeeper("skbgame");
            keeper.save(byteArrayOutputStream);
            keeper.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeBoolean(this.showStatus);
            dataOutputStream.writeInt(this.undoLevels);
            dataOutputStream.writeInt(this.levelAdvance);
            dataOutputStream.writeInt(this.collection);
            dataOutputStream.writeInt(this.skin);
            dataOutputStream.writeBoolean(this.fullScreen);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.showStatus = dataInputStream.readBoolean();
            this.undoLevels = dataInputStream.readInt();
            this.levelAdvance = dataInputStream.readInt();
            this.collection = dataInputStream.readInt();
            this.skin = dataInputStream.readInt();
            this.fullScreen = dataInputStream.readBoolean();
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

