/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.StaticImage;

public class AnnimatedCow
extends GameLayer {
    StaticImage cowHead = new StaticImage(Game.getSprite(Game.SPRITE_SPLASH_COW_HEAD));
    StaticImage cowBody = new StaticImage(Game.getSprite(Game.SPRITE_SPLASH_COW_BODY));
    byte offset;
    byte maxOffset;
    byte dir;

    public AnnimatedCow() {
        this.cowBody.setTransform(2, true);
        this.offset = 0;
        this.maxOffset = (byte)(this.cowHead.getWidth() / 12);
        this.dir = 1;
    }

    void addNotify() {
        Game.layerManager.add(this.cowBody);
        Game.layerManager.add(this.cowHead);
    }

    void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.doLayout();
    }

    void doLayout() {
        this.cowBody.setPosition(this.x, this.y);
        this.cowHead.setPosition(this.x - this.cowHead.getWidth() / 2, this.y);
        this.offset = 0;
        this.dir = 1;
    }

    void animate() {
        this.cowHead.setPosition(this.x - this.cowHead.getWidth() / 2 + this.offset, this.y + Math.abs(this.offset));
        if (this.dir > 0) {
            this.offset = (byte)(this.offset + 1);
            if (this.offset == this.maxOffset) {
                this.dir = (byte)(this.dir * -1);
            }
        } else {
            this.offset = (byte)(this.offset - 1);
            if (this.offset == -this.maxOffset) {
                this.dir = (byte)(this.dir * -1);
            }
        }
    }

    void release() {
        super.release();
        this.cowHead = null;
        this.cowBody = null;
    }
}

