/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Border;
import de.softgames.pl.mylittlefarm.Button;
import de.softgames.pl.mylittlefarm.Event;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Label;
import java.util.Vector;

public class Menu
extends GameLayer {
    byte id;
    Vector items;
    int selected;
    Button highLight;
    Border border;
    Button up;
    Button down;

    public Menu(byte by) {
        this.id = by;
        this.x = 0;
        this.y = 0;
        this.width = Game.canvasWidth;
        this.height = Game.canvasHeight;
        Byte by2 = (Byte)Game.data.get("menu." + by + ".index");
        if (by2 != null) {
            this.selected = by2.byteValue();
        }
        this.items = new Vector(10);
        this.highLight = new Button(Game.getSprite(Game.SPRITE_MENU_ICON_HL), 0);
        this.border = new Border();
        this.up = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0, 5);
        this.down = new Button(Game.getSprite(Game.SPRITE_SCROLL_BUTTONS), 0, 7);
        this.up.setAnimation((byte)3);
        this.down.setAnimation((byte)4);
        this.up.setPointerPressedEvent(new Event(3));
        this.down.setPointerPressedEvent(new Event(4));
        this.up.setPointerReleasedEvent(new Event(10));
        this.down.setPointerReleasedEvent(new Event(11));
    }

    void add(Label label, Button button, Event event) {
        Object[] objectArray = new Object[2];
        if (event != null) {
            label.setEvent(event);
            button.setEvent(event);
        }
        objectArray[0] = button;
        objectArray[1] = label;
        this.items.addElement(objectArray);
        label.setAnchor(20);
        button.setPointerPressedEvent(new Event(43, new Object[]{this, new Event(16, button)}));
        label.setPointerPressedEvent(new Event(43, new Object[]{this, new Event(16, label)}));
    }

    void setVisible(boolean bl) {
        super.setVisible(bl);
        this.highLight.setVisible(bl);
        for (int i = 0; i < this.items.size(); ++i) {
            Object[] objectArray = (Object[])this.items.elementAt(i);
            Button button = (Button)objectArray[0];
            Label label = (Label)objectArray[1];
            button.setVisible(bl);
            label.setVisible(bl);
        }
        this.border.setVisible(bl);
        if (bl) {
            this.up.setVisible(this.selected > 0);
            this.down.setVisible(this.selected < this.items.size() - 1);
        } else {
            this.up.setVisible(bl);
            this.down.setVisible(bl);
        }
    }

    void addNotify() {
        Game.layerManager.add(this.border);
        Game.layerManager.add(this.highLight);
        this.highLight.setClipLayer(this);
        for (int i = 0; i < this.items.size(); ++i) {
            Object[] objectArray = (Object[])this.items.elementAt(i);
            Button button = (Button)objectArray[0];
            Label label = (Label)objectArray[1];
            Game.layerManager.add(button);
            Game.layerManager.add(label);
            button.setClipLayer(this);
            label.setClipLayer(this);
        }
        Game.layerManager.add(this.up);
        Game.layerManager.add(this.down);
    }

    void removeNotify() {
        Game.layerManager.remove(this.border);
        Game.layerManager.remove(this.highLight);
        for (int i = 0; i < this.items.size(); ++i) {
            Object[] objectArray = (Object[])this.items.elementAt(i);
            Button button = (Button)objectArray[0];
            Label label = (Label)objectArray[1];
            Game.layerManager.remove(button);
            Game.layerManager.remove(label);
        }
        Game.layerManager.remove(this.up);
        Game.layerManager.remove(this.down);
    }

    void setSelected(int n) {
        if (this.selected > this.items.size() - 1) {
            this.selected = this.items.size() - 1;
        }
        if (n > this.items.size() - 1) {
            n = this.items.size() - 1;
        }
        Object[] objectArray = (Object[])this.items.elementAt(this.selected);
        Object[] objectArray2 = (Object[])this.items.elementAt(n);
        Label label = (Label)objectArray[1];
        label.setFont(Game.FONT_DEFAULT);
        label = (Label)objectArray2[1];
        label.setFont(Game.FONT_HIGHLIGHT);
        Button button = (Button)objectArray2[0];
        this.highLight.setPosition(button.getX() + button.getWidth() / 2 - this.highLight.getWidth() / 2, button.getY() + button.getHeight() / 2 - this.highLight.getHeight() / 2);
        int n2 = this.highLight.getY();
        int n3 = this.highLight.getY() + this.highLight.getHeight();
        int n4 = this.y + this.height;
        if (n3 > n4) {
            int n5 = n3 - n4;
            for (int i = 0; i < this.items.size(); ++i) {
                Object[] objectArray3 = (Object[])this.items.elementAt(i);
                button = (Button)objectArray3[0];
                label = (Label)objectArray3[1];
                button.move(0, -n5);
                label.move(0, -n5);
            }
            button = (Button)objectArray2[0];
            this.highLight.setPosition(button.getX() + button.getWidth() / 2 - this.highLight.getWidth() / 2, button.getY() + button.getHeight() / 2 - this.highLight.getHeight() / 2);
        } else if (n2 < this.y) {
            int n6 = this.y - n2;
            for (int i = 0; i < this.items.size(); ++i) {
                Object[] objectArray4 = (Object[])this.items.elementAt(i);
                button = (Button)objectArray4[0];
                label = (Label)objectArray4[1];
                button.move(0, n6);
                label.move(0, n6);
            }
            button = (Button)objectArray2[0];
            this.highLight.setPosition(button.getX() + button.getWidth() / 2 - this.highLight.getWidth() / 2, button.getY() + button.getHeight() / 2 - this.highLight.getHeight() / 2);
        }
        this.selected = n;
        Game.data.put("menu." + this.id + ".index", new Byte((byte)this.selected));
        this.up.setVisible(this.visible && this.selected > 0);
        this.down.setVisible(this.visible && this.selected < this.items.size() - 1);
    }

    void shrink() {
        this.doLayout();
        Object[] objectArray = (Object[])this.items.elementAt(0);
        Object[] objectArray2 = (Object[])this.items.elementAt(this.items.size() - 1);
        Button button = (Button)objectArray[0];
        Label label = (Label)objectArray[1];
        Button button2 = (Button)objectArray2[0];
        Label label2 = (Label)objectArray2[1];
        int n = Math.max(button2.getY() + button2.getHeight(), label2.getY() + label2.getHeight()) - Math.min(button.getY(), label.getY()) + this.highLight.getWidth() - button.getHeight();
        if (n < this.height) {
            this.repaint();
            this.height = n;
            this.center();
            this.doLayout();
        }
    }

    void doLayout() {
        int n;
        Object[] objectArray = (Object[])this.items.elementAt(0);
        Button button = (Button)objectArray[0];
        Label label = (Label)objectArray[1];
        int n2 = (this.highLight.getWidth() - button.getHeight()) / 2;
        int n3 = this.x + n2;
        int n4 = this.y + n2;
        int n5 = this.x + this.highLight.getWidth() + 2;
        int n6 = button.getHeight();
        int n7 = this.width - (this.highLight.getWidth() + 2);
        for (n = 0; n < this.items.size(); ++n) {
            objectArray = (Object[])this.items.elementAt(n);
            label = (Label)objectArray[1];
            label.setWidth(n7);
        }
        for (n = 0; n < this.items.size(); ++n) {
            objectArray = (Object[])this.items.elementAt(n);
            button = (Button)objectArray[0];
            label = (Label)objectArray[1];
            if (button.getHeight() >= label.getHeight()) {
                button.setPosition(n3, n4);
                label.setPosition(n5, n4 + button.getHeight() / 2 - label.getHeight() / 2);
                n6 = button.getHeight();
            } else {
                button.setPosition(n3, n4 + label.getHeight() / 2 - button.getHeight() / 2);
                label.setPosition(n5, n4);
                n6 = label.getHeight();
            }
            n4 += n6;
            n4 += n2;
        }
        this.border.setPosition(this.x, this.y);
        this.border.setWidth(this.width);
        this.border.setHeight(this.height);
        this.up.setPosition(this.x + this.width / 2 - this.up.getWidth() / 2, this.y - this.up.getHeight());
        this.down.setPosition(this.up.getX(), this.y + this.height);
        this.setSelected(this.selected);
    }

    void keyUp() {
        if (this.selected > 0) {
            this.setSelected(this.selected - 1);
        }
    }

    void keyDown() {
        if (this.selected < this.items.size() - 1) {
            this.setSelected(this.selected + 1);
        }
    }

    void keySoft1() {
        this.keyFire();
    }

    void keyFire() {
        Object[] objectArray = (Object[])this.items.elementAt(this.selected);
        Button button = (Button)objectArray[0];
        button.keyFire();
    }

    void processEvent(Event event) {
        block0 : switch (event.id) {
            case 16: {
                GameLayer gameLayer = (GameLayer)event.data;
                for (int i = 0; i < this.items.size(); ++i) {
                    Object[] objectArray = (Object[])this.items.elementAt(i);
                    if (gameLayer != objectArray[0] && gameLayer != objectArray[1]) continue;
                    this.setSelected(i);
                    ((GameLayer)objectArray[0]).keyFire();
                    break block0;
                }
                break;
            }
        }
    }

    void release() {
        this.items = null;
    }
}

