/*
 * Decompiled with CFR 0.152.
 */
package de.softgames.pl.mylittlefarm;

import de.softgames.pl.mylittlefarm.Border;
import de.softgames.pl.mylittlefarm.Button;
import de.softgames.pl.mylittlefarm.ColorBackground;
import de.softgames.pl.mylittlefarm.Event;
import de.softgames.pl.mylittlefarm.Game;
import de.softgames.pl.mylittlefarm.GameLayer;
import de.softgames.pl.mylittlefarm.Label;
import de.softgames.pl.mylittlefarm.Menu;
import de.softgames.pl.mylittlefarm.Pawn;
import de.softgames.pl.mylittlefarm.ScaleBar;
import de.softgames.pl.mylittlefarm.Scroll;
import de.softgames.pl.mylittlefarm.StaticImage;
import de.softgames.pl.mylittlefarm.Text;
import javax.microedition.lcdui.game.Sprite;

public class MiniGame
extends GameLayer {
    static final byte STATE_MOVE_CURSOR = 0;
    static final byte STATE_MOVE_PAWN = 1;
    static final byte STATE_MOVE_PAWN_WAIT = 2;
    static final byte STATE_MOVE_PAWN_BACK_WAIT = 3;
    static final byte STATE_EXPLODE_WAIT = 4;
    static final byte STATE_FALL_WAIT = 5;
    static final byte STATE_TUTORIAL = 6;
    static final byte STATE_GOAL_SCREEN = 7;
    static final byte STATE_GAVEOVER_SCREEN = 8;
    static final byte COLOR = 0;
    static final byte LINE = 1;
    StaticImage bg;
    StaticImage boardBg;
    Border boardBorder;
    Button leftSoft;
    Button rightSoft;
    Scroll scroll;
    int cellSize;
    Pawn[][] board;
    ColorBackground cursor;
    byte cursorX;
    byte cursorY;
    byte moveCellX;
    byte moveCellY;
    int[] cursorColor = new int[]{0xFFFFFF, 16449389, 16765440, 16670216, 16670216, 16670216, 16765440, 16449389};
    byte cursorColorFrame;
    byte arrowsFrame;
    StaticImage cursorArrowL;
    StaticImage cursorArrowR;
    StaticImage cursorArrowU;
    StaticImage cursorArrowD;
    StaticImage avatar;
    byte emotion;
    byte emotionTimer;
    ScaleBar timeBar;
    StaticImage hourGlass;
    StaticImage[] miniorb;
    StaticImage[] miniorbExplosion;
    StaticImage[][] goalCounter;
    Label goalLabel;
    Border goalBorder;
    StaticImage goalBg;
    byte state;
    StaticImage hudBg;
    Pawn[] tmpPawns1 = new Pawn[8];
    Pawn[] tmpPawns2 = new Pawn[8];
    Menu menu;
    static boolean paused;
    long gameStartTime;
    long gameEndTime;
    int gameDurationTime;
    int gameTimeLeft;
    boolean drawJocker;
    short[][] pointsLine = new short[6][6];
    short[] pointsColor = new short[6];
    byte[][] goal;
    static boolean gameOver;
    boolean goalCompleted;

    public MiniGame() {
        int n;
        int n2;
        Sprite sprite = Game.getSprite(Game.SPRITE_ORBS);
        this.x = 0;
        this.y = 0;
        this.cellSize = sprite.getWidth();
        this.height = this.width = this.cellSize * 8;
        this.menu = new Menu(5);
        this.menu.add(new Label(Text.get(4)), new Button(Game.getSprite(Game.SPRITE_MENU_ICONS), 1), new Event(8));
        this.menu.add(new Label(Text.get(52)), new Button(Game.getSprite(Game.SPRITE_MENU_ICONS), 9), new Event(43, new Object[]{this, new Event(39)}));
        this.menu.add(new Label(Text.get(51)), new Button(Game.getSprite(Game.SPRITE_MENU_ICONS), 8), new Event(43, new Object[]{this, new Event(22)}));
        this.menu.setVisible(false);
        this.bg = new StaticImage(Game.getSprite(Game.SPRITE_BG_TILE), 0, 0, Game.canvasWidth, Game.canvasHeight);
        this.leftSoft = new Button(Game.getSprite(Game.SPRITE_SOFT_KEYS), 0);
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.leftSoft.setFrame(0, 0);
        this.rightSoft = new Button(Game.getSprite(Game.SPRITE_SOFT_KEYS), 2);
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
        this.avatar = new StaticImage(Game.getSprite(Game.SPRITE_AVATAR));
        this.hourGlass = new StaticImage(Game.getSprite(Game.SPRITE_HOURGLASS));
        this.goalCounter = new StaticImage[3][4];
        this.miniorb = new StaticImage[3];
        this.miniorbExplosion = new StaticImage[3];
        Sprite sprite2 = Game.getSprite(Game.SPRITE_MINIORBS);
        Sprite sprite3 = Game.getSprite(Game.SPRITE_MINIORB_FONT);
        for (int i = 2; i >= 0; --i) {
            this.goalCounter[i][0] = new StaticImage(sprite3);
            this.goalCounter[i][1] = new StaticImage(sprite3);
            this.goalCounter[i][2] = new StaticImage(sprite3);
            this.goalCounter[i][3] = new StaticImage(sprite3);
            this.miniorb[i] = new StaticImage(sprite2);
        }
        paused = true;
        gameOver = false;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[]{-1, -1, -1};
        byte[] byArray5 = new byte[]{0, 1, 2, 3, 4, 5};
        for (n2 = 0; n2 < 3; ++n2) {
            while (byArray4[n2] < 0) {
                byArray4[n2] = byArray5[Game.rand(6)];
                if (byArray4[n2] < 0) continue;
                byArray5[byArray4[n2]] = -1;
                if (byArray4[n2] == 3) {
                    byArray5[4] = -1;
                    continue;
                }
                if (byArray4[n2] != 4) continue;
                byArray5[3] = -1;
            }
        }
        switch (Game.level) {
            case 0: {
                byArray = new byte[]{0, 0, 0, 1};
                byArray2 = new byte[]{12, 12, 15, 15, 15, 18, 18};
                byArray3 = new byte[]{1, 1, 2};
                break;
            }
            case 1: {
                byArray = new byte[]{0, 0, 0, 1, 1};
                byArray2 = new byte[]{18, 18, 21, 21, 21, 24, 24};
                byArray3 = new byte[]{1, 1, 1, 2, 2};
                break;
            }
            case 2: {
                byArray = new byte[]{0, 0, 1, 1};
                byArray2 = new byte[]{24, 24, 27, 27, 27, 30, 30};
                byArray3 = new byte[]{1, 1, 2, 2};
                break;
            }
            case 3: {
                byArray = new byte[]{0, 0, 1, 1, 1};
                byArray2 = new byte[]{30, 30, 33, 33, 37, 37};
                byArray3 = new byte[]{1, 2, 2, 2, 3};
                break;
            }
            case 4: {
                byArray = new byte[]{0, 1, 1, 1};
                byArray2 = new byte[]{37, 40, 40, 43, 43, 46};
                byArray3 = new byte[]{2, 2, 3, 3};
            }
        }
        n2 = 1 + Game.level;
        if (Game.itemCategory == 0) {
            n2 += Game.rand(2);
            n = 0;
            while (n < byArray2.length) {
                int n3 = n++;
                byArray2[n3] = (byte)(byArray2[n3] + 3);
            }
        }
        if (Game.itemCategory == 2) {
            ++n2;
            n = 0;
            while (n < byArray2.length) {
                int n4 = n++;
                byArray2[n4] = (byte)(byArray2[n4] + 6);
            }
        }
        if (n2 > 3) {
            n2 = 3;
        }
        this.goal = new byte[n2][4];
        this.goal[0][0] = 0;
        for (n = 1; n < n2; ++n) {
            this.goal[n][0] = byArray[Game.rand(byArray.length)];
        }
        this.gameDurationTime = 0;
        for (n = 0; n < n2; ++n) {
            if (this.goal[n][0] == 0) {
                this.goal[n][1] = byArray2[Game.rand(byArray2.length)];
                this.goal[n][2] = byArray4[n];
                this.gameDurationTime += this.goal[n][1] * 3;
                continue;
            }
            this.goal[n][1] = byArray3[Game.rand(byArray3.length)];
            this.goal[n][2] = byArray4[n];
            this.goal[n][3] = 4;
            this.gameDurationTime += this.goal[n][1] * 36;
        }
        if (this.gameDurationTime < 90) {
            this.gameDurationTime = 90;
        }
        this.timeBar = new ScaleBar(0, 0, Game.getSprite(Game.SPRITE_TIMEBAR), 0, 1, 2, 3, 4, 5, 0, Game.canvasWidth, this.gameDurationTime, this.gameDurationTime, 0);
        this.leftSoft.setPointerPressedEvent(new Event(7));
        this.rightSoft.setPointerPressedEvent(new Event(8));
    }

    void addNotify() {
        Game.layerManager.addBefore(this, this.bg);
        this.createBoard();
        if (Game.miniGameTutorial) {
            this.scroll = new Scroll(Text.get(62), 1, 35);
            Game.layerManager.add(this.scroll);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            this.state = (byte)6;
        } else {
            this.showGoalScreen();
            this.state = (byte)7;
        }
        Game.layerManager.add(this.menu);
        Game.layerManager.add(this.leftSoft);
        Game.layerManager.setKeyFireListener(this);
        Game.layerManager.setKeySoft1Listener(this);
    }

    void createBoard() {
        int n;
        int n2;
        this.boardBg = new StaticImage(Game.getSprite(Game.SPRITE_BOARD_BG_TILE));
        Game.layerManager.add(this.boardBg);
        this.boardBorder = new Border(false);
        Game.layerManager.addBefore(this, this.boardBorder);
        this.hudBg = new StaticImage(Game.getSprite(Game.SPRITE_HUD_BG_TILE));
        Game.layerManager.add(this.hudBg);
        Game.layerManager.add(this.avatar);
        Game.layerManager.add(this.hourGlass);
        Game.layerManager.add(this.timeBar);
        Sprite sprite = Game.getSprite(Game.SPRITE_ORBS);
        this.board = new Pawn[8][8];
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                Pawn pawn = new Pawn(sprite, Game.rand(6));
                pawn.setPosition(this.x + n2 * this.cellSize, this.y + n * this.cellSize);
                pawn.setClipLayer(this);
                this.board[n2][n] = pawn;
                Game.layerManager.add(pawn);
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                while (this.is3H(n2, n) || this.is3V(n2, n)) {
                    this.board[n2][n].color = (byte)(this.board[n2][n].color + 1);
                    if (this.board[n2][n].color != 6) continue;
                    this.board[n2][n].color = 0;
                }
            }
        }
        n2 = 0;
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                if (!this.isMovePossible(n, i)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) break;
        }
        if (n2 == 0) {
            this.board[0][0].color = this.board[3][0].color;
            this.board[1][0].color = this.board[3][0].color;
            while (this.is3H(2, 0)) {
                this.board[2][0].color = (byte)(this.board[2][0].color + 1);
                if (this.board[2][0].color != 6) continue;
                this.board[2][0].color = 0;
            }
            for (n = 0; n < 3; ++n) {
                while (this.is3H(n, 1) || this.is3V(n, 1)) {
                    this.board[n][1].color = (byte)(this.board[n][1].color + 1);
                    if (this.board[n][1].color != 6) continue;
                    this.board[n][1].color = 0;
                }
            }
        }
        this.cursor = new ColorBackground(this.x, this.y, this.cellSize, this.cellSize, -1, 0xFFFFFF);
        Game.layerManager.add(this.cursor);
        Sprite sprite2 = Game.getSprite(Game.SPRITE_CURSOR_ARROWS);
        this.cursorArrowL = new StaticImage(sprite2, 0, 0);
        this.cursorArrowR = new StaticImage(sprite2, 0, 3);
        this.cursorArrowU = new StaticImage(sprite2, 0, 5);
        this.cursorArrowD = new StaticImage(sprite2, 0, 6);
        Game.layerManager.add(this.cursorArrowL);
        Game.layerManager.add(this.cursorArrowR);
        Game.layerManager.add(this.cursorArrowU);
        Game.layerManager.add(this.cursorArrowD);
        this.cursorArrowL.setVisible(false);
        this.cursorArrowR.setVisible(false);
        this.cursorArrowU.setVisible(false);
        this.cursorArrowD.setVisible(false);
        Pawn.moveCounter = 0;
        Pawn.explodeCounter = 0;
    }

    void showGoalScreen() {
        this.goalLabel = new Label(Text.get(56));
        int n = this.goalCounter[0][0].getHeight() * 3;
        int n2 = this.goalCounter[0][0].getWidth() * 7 - this.goalCounter[0][0].getWidth() / 2;
        int n3 = Math.max(this.goalLabel.getWidth(), n2);
        int n4 = n * this.goal.length + this.goalLabel.getHeight();
        int n5 = Game.canvasCenterX - n3 / 2;
        int n6 = Game.canvasCenterY - n4 / 2;
        this.goalBorder = new Border(false);
        this.goalBg = new StaticImage(Game.getSprite(Game.SPRITE_HUD_BG_TILE));
        this.goalBorder.setWidth(n3);
        this.goalBorder.setHeight(n4);
        this.goalBorder.setPosition(n5, n6);
        this.goalBg.setWidth(this.goalBorder.getWidth());
        this.goalBg.setHeight(this.goalBorder.getHeight());
        this.goalBg.setPosition(this.goalBorder.getX(), this.goalBorder.getY());
        Game.layerManager.add(this.goalBorder);
        Game.layerManager.add(this.goalBg);
        Game.layerManager.add(this.goalLabel);
        this.goalLabel.setPosition(this.goalBorder.getCenterX() - this.goalLabel.getWidth() / 2, this.goalBorder.getY());
        for (int i = 0; i < this.goal.length; ++i) {
            Game.layerManager.add(this.miniorb[i]);
            Game.layerManager.add(this.goalCounter[i][0]);
            Game.layerManager.add(this.goalCounter[i][1]);
            Game.layerManager.add(this.goalCounter[i][2]);
            Game.layerManager.add(this.goalCounter[i][3]);
        }
        this.positionGoalCounters();
        this.updateGoalCounters();
    }

    boolean is2H(int n, int n2) {
        return n <= 6 && this.board[n][n2].isSameColor(this.board[n + 1][n2]);
    }

    boolean is2V(int n, int n2) {
        return n2 <= 6 && this.board[n][n2].isSameColor(this.board[n][n2 + 1]);
    }

    boolean isMovePossible(int n, int n2) {
        if (this.is2H(n, n2)) {
            if (n - 2 >= 0 && this.board[n][n2].isSameColor(this.board[n - 2][n2]) && this.board[n + 1][n2].isSameColor(this.board[n - 2][n2])) {
                return true;
            }
            if (n - 1 >= 0 && n2 - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n - 1][n2 - 1]) && this.board[n + 1][n2].isSameColor(this.board[n - 1][n2 - 1])) {
                return true;
            }
            if (n - 1 >= 0 && n2 + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n - 1][n2 + 1]) && this.board[n + 1][n2].isSameColor(this.board[n - 1][n2 + 1])) {
                return true;
            }
            if (n + 3 <= 7 && this.board[n][n2].isSameColor(this.board[n + 3][n2]) && this.board[n + 1][n2].isSameColor(this.board[n + 3][n2])) {
                return true;
            }
            if (n + 2 <= 7 && n2 - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n + 2][n2 - 1]) && this.board[n + 1][n2].isSameColor(this.board[n + 2][n2 - 1])) {
                return true;
            }
            if (n + 2 <= 7 && n2 + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n + 2][n2 + 1]) && this.board[n + 1][n2].isSameColor(this.board[n + 2][n2 + 1])) {
                return true;
            }
        } else if (this.is2V(n, n2)) {
            if (n2 - 2 >= 0 && this.board[n][n2].isSameColor(this.board[n][n2 - 2]) && this.board[n][n2 + 1].isSameColor(this.board[n][n2 - 2])) {
                return true;
            }
            if (n2 - 1 >= 0 && n - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n - 1][n2 - 1]) && this.board[n][n2 + 1].isSameColor(this.board[n - 1][n2 - 1])) {
                return true;
            }
            if (n2 - 1 >= 0 && n + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n + 1][n2 - 1]) && this.board[n][n2 + 1].isSameColor(this.board[n + 1][n2 - 1])) {
                return true;
            }
            if (n2 + 3 <= 7 && this.board[n][n2].isSameColor(this.board[n][n2 + 3]) && this.board[n][n2 + 1].isSameColor(this.board[n][n2 + 3])) {
                return true;
            }
            if (n2 + 2 <= 7 && n - 1 >= 0 && this.board[n][n2].isSameColor(this.board[n - 1][n2 + 2]) && this.board[n][n2 + 1].isSameColor(this.board[n - 1][n2 + 2])) {
                return true;
            }
            if (n2 + 2 <= 7 && n + 1 <= 7 && this.board[n][n2].isSameColor(this.board[n + 1][n2 + 2]) && this.board[n][n2 + 1].isSameColor(this.board[n + 1][n2 + 2])) {
                return true;
            }
        }
        return false;
    }

    boolean is3H(int n, int n2) {
        int n3 = n - 1;
        int n4 = n + 1;
        return n3 >= 0 && n4 <= 7 && n2 >= 0 && n2 <= 7 && this.board[n][n2].isSameColor(this.board[n3][n2]) && this.board[n][n2].isSameColor(this.board[n4][n2]) && this.board[n3][n2].isSameColor(this.board[n4][n2]);
    }

    boolean is3V(int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n2 + 1;
        return n3 >= 0 && n4 <= 7 && n >= 0 && n <= 7 && this.board[n][n2].isSameColor(this.board[n][n3]) && this.board[n][n2].isSameColor(this.board[n][n4]) && this.board[n][n3].isSameColor(this.board[n][n4]);
    }

    void moveCursor(int n, int n2) {
        this.board[this.cursorX][this.cursorY].setState((byte)0);
        this.cursorX = (byte)(this.cursorX + n);
        if (this.cursorX < 0) {
            this.cursorX = 0;
        } else if (this.cursorX > 7) {
            this.cursorX = (byte)7;
        }
        this.cursorY = (byte)(this.cursorY + n2);
        if (this.cursorY < 0) {
            this.cursorY = 0;
        } else if (this.cursorY > 7) {
            this.cursorY = (byte)7;
        }
        this.board[this.cursorX][this.cursorY].setState((byte)1);
        this.showCursor();
    }

    void movePawn(int n, int n2) {
        this.moveCellX = (byte)(this.cursorX + n);
        this.moveCellY = (byte)(this.cursorY + n2);
        int n3 = this.x + this.cursorX * this.cellSize;
        int n4 = this.y + this.cursorY * this.cellSize;
        int n5 = this.x + this.moveCellX * this.cellSize;
        int n6 = this.y + this.moveCellY * this.cellSize;
        if (this.moveCellX >= 0 && this.moveCellX <= 7 && this.moveCellY >= 0 && this.moveCellY <= 7) {
            Pawn pawn = this.board[this.cursorX][this.cursorY];
            Pawn pawn2 = this.board[this.moveCellX][this.moveCellY];
            pawn.setState((byte)2);
            pawn.moveTo(n5, n6);
            pawn2.setState((byte)2);
            pawn2.moveTo(n3, n4);
            this.board[this.cursorX][this.cursorY] = pawn2;
            this.board[this.moveCellX][this.moveCellY] = pawn;
            this.state = (byte)2;
            this.showCursor();
        }
    }

    void movePawnBack() {
        int n = this.x + this.cursorX * this.cellSize;
        int n2 = this.y + this.cursorY * this.cellSize;
        int n3 = this.x + this.moveCellX * this.cellSize;
        int n4 = this.y + this.moveCellY * this.cellSize;
        Pawn pawn = this.board[this.cursorX][this.cursorY];
        Pawn pawn2 = this.board[this.moveCellX][this.moveCellY];
        pawn.setState((byte)2);
        pawn.moveTo(n3, n4);
        pawn2.setState((byte)2);
        pawn2.moveTo(n, n2);
        this.board[this.cursorX][this.cursorY] = pawn2;
        this.board[this.moveCellX][this.moveCellY] = pawn;
        this.state = (byte)3;
        this.showCursor();
    }

    void showCursor() {
        int n = this.x + this.cursorX * this.cellSize;
        int n2 = this.y + this.cursorY * this.cellSize;
        int n3 = this.cellSize / 2;
        this.cursor.setVisible(this.state == 0);
        this.cursor.setPosition(n, n2);
        this.cursorArrowL.setVisible(this.state == 1 && this.cursorX > 0);
        this.cursorArrowR.setVisible(this.state == 1 && this.cursorX < 7);
        this.cursorArrowU.setVisible(this.state == 1 && this.cursorY > 0);
        this.cursorArrowD.setVisible(this.state == 1 && this.cursorY < 7);
        this.cursorArrowL.setPosition(n - this.cursorArrowL.getWidth(), n2 + n3 - this.cursorArrowL.getHeight() / 2);
        this.cursorArrowR.setPosition(n + this.cellSize, this.cursorArrowL.getY());
        this.cursorArrowU.setPosition(n + n3 - this.cursorArrowU.getWidth() / 2, n2 - this.cursorArrowU.getHeight());
        this.cursorArrowD.setPosition(this.cursorArrowU.getX(), n2 + this.cellSize);
    }

    boolean removeLines() {
        boolean bl = false;
        this.drawJocker = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                if (!this.board[j][i].isJocker()) {
                    n12 = 1;
                    n11 = 1;
                    n10 = j;
                    n9 = j;
                    n8 = i;
                    n7 = i;
                    n6 = 0;
                    n5 = 0;
                    n4 = 1;
                    n3 = 1;
                    for (n2 = j - 1; n2 >= 0 && this.board[n2][i].isSameColor(this.board[j][i]); --n2) {
                        n10 = n2;
                        if (this.board[n2][i].isJocker()) {
                            this.tmpPawns1[n6++] = this.board[n2][i];
                        }
                        if (!this.board[n2][i].isExploding()) continue;
                        n4 = 0;
                    }
                    for (n2 = j + 1; n2 <= 7 && this.board[n2][i].isSameColor(this.board[j][i]); ++n2) {
                        n9 = n2;
                        if (this.board[n2][i].isJocker()) {
                            this.tmpPawns1[n6++] = this.board[n2][i];
                        }
                        if (!this.board[n2][i].isExploding()) continue;
                        n4 = 0;
                    }
                    for (n2 = i - 1; n2 >= 0 && this.board[j][n2].isSameColor(this.board[j][i]); --n2) {
                        n8 = n2;
                        if (this.board[j][n2].isJocker()) {
                            this.tmpPawns2[n5++] = this.board[j][n2];
                        }
                        if (!this.board[j][n2].isExploding()) continue;
                        n3 = 0;
                    }
                    for (n2 = i + 1; n2 <= 7 && this.board[j][n2].isSameColor(this.board[j][i]); ++n2) {
                        n7 = n2;
                        if (this.board[j][n2].isJocker()) {
                            this.tmpPawns2[n5++] = this.board[j][n2];
                        }
                        if (!this.board[j][n2].isExploding()) continue;
                        n3 = 0;
                    }
                    if ((n12 += n9 - n10) >= 4 || (n11 += n7 - n8) >= 4) {
                        this.drawJocker = true;
                    }
                    if (n12 > 3 || n11 > 3) {
                        this.board[j][i].setState((byte)4);
                        bl = true;
                        bl3 = true;
                    } else if (n12 == 3 || n11 == 3) {
                        this.board[j][i].setState((byte)3);
                        bl = true;
                        bl2 = true;
                    }
                    if (!this.board[j][i].isExploding()) continue;
                    if (n4 != 0) {
                        n2 = n12 - 3;
                        while (n2 >= 0) {
                            short[] sArray = this.pointsLine[this.board[j][i].color];
                            int n13 = n2--;
                            sArray[n13] = (short)(sArray[n13] + 1);
                        }
                        this.addGoalExplosion((byte)1, this.board[j][i].color, (byte)n12);
                    }
                    if (n3 != 0) {
                        n2 = n11 - 3;
                        while (n2 >= 0) {
                            short[] sArray = this.pointsLine[this.board[j][i].color];
                            int n14 = n2--;
                            sArray[n14] = (short)(sArray[n14] + 1);
                        }
                        this.addGoalExplosion((byte)1, this.board[j][i].color, (byte)n11);
                    }
                    n2 = 1;
                    for (n = 0; n < n6; ++n) {
                        n2 = this.tmpPawns1[n].multiplyPoints(n2);
                    }
                    for (n = 0; n < n5; ++n) {
                        n2 = this.tmpPawns2[n].multiplyPoints(n2);
                    }
                    byte by = this.board[j][i].color;
                    this.pointsColor[by] = (short)(this.pointsColor[by] + n2);
                    this.addGoalExplosion((byte)0, this.board[j][i].color, (byte)0);
                    continue;
                }
                n12 = this.board[j][i].color;
                n11 = this.board[j][i].multiplyPoints(1);
                for (n10 = 0; n10 < 6; ++n10) {
                    int n15;
                    this.board[j][i].color = (byte)n10;
                    n8 = 1;
                    n7 = 1;
                    n6 = j;
                    n5 = j;
                    n4 = i;
                    n3 = i;
                    n2 = 0;
                    n = 0;
                    int n16 = 0;
                    int n17 = 0;
                    for (n15 = j - 1; n15 >= 0 && this.board[n15][i].isSameColor(this.board[j][i]); --n15) {
                        n6 = n15;
                        if (this.board[n15][i].isJocker()) {
                            this.tmpPawns1[n2++] = this.board[n15][i];
                            continue;
                        }
                        ++n16;
                    }
                    for (n15 = j + 1; n15 <= 7 && this.board[n15][i].isSameColor(this.board[j][i]); ++n15) {
                        n5 = n15;
                        if (this.board[n15][i].isJocker()) {
                            this.tmpPawns1[n2++] = this.board[n15][i];
                            continue;
                        }
                        ++n16;
                    }
                    for (n15 = i - 1; n15 >= 0 && this.board[j][n15].isSameColor(this.board[j][i]); --n15) {
                        n4 = n15;
                        if (this.board[j][n15].isJocker()) {
                            this.tmpPawns2[n++] = this.board[j][n15];
                            continue;
                        }
                        ++n17;
                    }
                    for (n15 = i + 1; n15 <= 7 && this.board[j][n15].isSameColor(this.board[j][i]); ++n15) {
                        n3 = n15;
                        if (this.board[j][n15].isJocker()) {
                            this.tmpPawns2[n++] = this.board[j][n15];
                            continue;
                        }
                        ++n17;
                    }
                    if ((n8 += n5 - n6) > 3 || (n7 += n3 - n4) > 3) {
                        this.board[j][i].setState((byte)4);
                        bl = true;
                    } else if (n8 == 3 || n7 == 3) {
                        this.board[j][i].setState((byte)3);
                        bl = true;
                    }
                    if (n16 != 0 && n8 >= 3) {
                        n9 = n11;
                        for (n15 = 0; n15 < n2; ++n15) {
                            n9 = this.tmpPawns1[n15].multiplyPoints(n9);
                        }
                        byte by = this.board[j][i].color;
                        this.pointsColor[by] = (short)(this.pointsColor[by] + n9);
                    }
                    if (n17 == 0 || n7 < 3) continue;
                    n9 = n11;
                    for (n15 = 0; n15 < n; ++n15) {
                        n9 = this.tmpPawns2[n15].multiplyPoints(n9);
                    }
                    byte by = this.board[j][i].color;
                    this.pointsColor[by] = (short)(this.pointsColor[by] + n9);
                }
                this.board[j][i].color = n12;
            }
        }
        if (bl2 || bl3) {
            Game.mixer.playSound(bl3 ? 2 : 1, false);
            if (bl3) {
                this.emotion = (byte)3;
            } else if (this.emotion < 2) {
                this.emotion = (byte)2;
            }
            this.emotionTimer = 0;
        }
        this.testGoal();
        return bl;
    }

    void drawNextPawns() {
        int n;
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            for (n = 7; n >= 0; --n) {
                if (this.board[n2][n].state != 5) {
                    this.tmpPawns1[n4++] = this.board[n2][n];
                    continue;
                }
                this.tmpPawns2[n5++] = this.board[n2][n];
            }
            n = 7;
            for (n3 = 0; n3 < n4; ++n3) {
                this.board[n2][n] = this.tmpPawns1[n3];
                this.tmpPawns1[n3].setState((byte)2);
                this.tmpPawns1[n3].moveTo(this.tmpPawns1[n3].getX(), this.y + n * this.cellSize);
                --n;
            }
            int n6 = this.y - this.cellSize;
            for (n3 = 0; n3 < n5; ++n3) {
                this.tmpPawns2[n3].color = (byte)Game.rand(6);
                this.board[n2][n] = this.tmpPawns2[n3];
                this.tmpPawns2[n3].setPosition(this.tmpPawns2[n3].getX(), n6);
                this.tmpPawns2[n3].moveTo(this.tmpPawns2[n3].getX(), this.y + n * this.cellSize);
                --n;
                n6 -= this.cellSize;
            }
        }
        if (this.drawJocker) {
            n2 = Game.rand(8);
            while (this.drawJocker) {
                for (n = 7; n >= 0; --n) {
                    if (this.board[n2][n].state != 5) continue;
                    this.board[n2][n].color = (byte)(Game.rand(2) == 0 ? 6 : 7);
                    this.drawJocker = false;
                    break;
                }
                if (++n2 != 8) continue;
                n2 = 0;
            }
        }
        boolean bl = false;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                if (!this.isMovePossible(n2, n)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (!bl) {
            byte by;
            for (n2 = 0; n2 <= 5; ++n2) {
                if (this.board[n2][0].state != 5 || this.board[n2 + 1][0].state != 5 || this.board[n2 + 2][0].state != 5) continue;
                if (n2 == 0) {
                    this.board[n2][0].color = by = this.board[n2 + 3][0].color;
                    this.board[n2 + 1][0].color = by;
                    this.board[n2 + 2][0].color = (byte)Game.rand(6);
                } else {
                    by = this.board[n2 - 1][0].color;
                    this.board[n2][0].color = (byte)Game.rand(6);
                    this.board[n2 + 1][0].color = by;
                    this.board[n2 + 2][0].color = by;
                }
                bl = true;
                break;
            }
            if (!bl) {
                for (n2 = 0; n2 < 8; ++n2) {
                    if (this.board[n2][0].state != 5 || this.board[n2][1].state != 5 || this.board[n2][2].state != 5) continue;
                    this.board[n2][0].color = by = this.board[n2][3].color;
                    this.board[n2][1].color = by;
                    this.board[n2][2].color = (byte)Game.rand(6);
                    bl = true;
                    break;
                }
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                if (this.board[n2][n].state != 5) continue;
                this.board[n2][n].setState((byte)2);
            }
        }
    }

    void keyFire() {
        switch (this.state) {
            case 6: {
                Game.layerManager.remove(this.scroll);
                this.scroll.release();
                this.scroll = null;
                Game.layerManager.setKeyLeftListener(null);
                Game.layerManager.setKeyRightListener(null);
                this.leftSoft.setFrame(0, 0);
                Game.miniGameTutorial = false;
                this.state = (byte)7;
                this.showGoalScreen();
                break;
            }
            case 7: {
                Game.layerManager.remove(this.goalBorder);
                Game.layerManager.remove(this.goalBg);
                Game.layerManager.remove(this.goalLabel);
                this.goalBorder.release();
                this.goalBorder = null;
                this.goalBg.release();
                this.goalBg = null;
                this.goalLabel.release();
                this.goalLabel = null;
                this.leftSoft.setFrame(0, 0);
                Game.layerManager.remove(this.leftSoft);
                Game.layerManager.add(this.rightSoft);
                Game.layerManager.setKeyUpListener(this);
                Game.layerManager.setKeyDownListener(this);
                Game.layerManager.setKeyLeftListener(this);
                Game.layerManager.setKeyRightListener(this);
                Game.layerManager.setKeySoft2Listener(this);
                this.state = 0;
                this.positionGoalCounters();
                this.moveCursor(0, 0);
                paused = false;
                this.gameStartTime = System.currentTimeMillis();
                this.gameTimeLeft = this.gameDurationTime * 1000;
                this.gameEndTime = this.gameStartTime + (long)this.gameTimeLeft;
                break;
            }
            case 0: {
                this.state = 1;
                this.showCursor();
                break;
            }
            case 1: {
                this.state = 0;
                this.showCursor();
                break;
            }
            case 8: {
                if (this.goalCompleted) {
                    Game.currGameItem.state = (byte)2;
                    Game.updateLevel();
                    Game.event(new Event(38));
                    break;
                }
                Game.event(new Event(39));
            }
        }
    }

    void keySoft1() {
        this.keyFire();
    }

    void keySoft2() {
        if (this.menu.isVisible()) {
            this.menu.setVisible(false);
            Game.layerManager.remove(this.leftSoft);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            paused = false;
            this.gameEndTime = System.currentTimeMillis() + (long)this.gameTimeLeft;
        } else {
            Game.layerManager.moveToTop(this.menu);
            this.menu.setVisible(true);
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.setKeyFireListener(this.menu);
            Game.layerManager.setKeySoft1Listener(this.menu);
            Game.layerManager.setKeyUpListener(this.menu);
            Game.layerManager.setKeyDownListener(this.menu);
            Game.layerManager.setKeyLeftListener(null);
            Game.layerManager.setKeyRightListener(null);
            paused = true;
        }
    }

    void keyLeft() {
        switch (this.state) {
            case 0: {
                this.moveCursor(-1, 0);
                break;
            }
            case 1: {
                this.movePawn(-1, 0);
            }
        }
    }

    void keyRight() {
        switch (this.state) {
            case 0: {
                this.moveCursor(1, 0);
                break;
            }
            case 1: {
                this.movePawn(1, 0);
            }
        }
    }

    void keyUp() {
        switch (this.state) {
            case 0: {
                this.moveCursor(0, -1);
                break;
            }
            case 1: {
                this.movePawn(0, -1);
            }
        }
    }

    void keyDown() {
        switch (this.state) {
            case 0: {
                this.moveCursor(0, 1);
                break;
            }
            case 1: {
                this.movePawn(0, 1);
            }
        }
    }

    void testGoal() {
        int n = 0;
        for (int i = 0; i < this.goal.length; ++i) {
            if (this.goal[i][0] == 0 && this.pointsColor[this.goal[i][2]] >= this.goal[i][1]) {
                ++n;
                continue;
            }
            if (this.goal[i][0] != 1 || this.pointsLine[this.goal[i][2]][this.goal[i][3] - 3] < this.goal[i][1]) continue;
            ++n;
        }
        if (n == this.goal.length) {
            this.goalCompleted = true;
        }
        this.updateGoalCounters();
    }

    void addGoalExplosion(byte by, byte by2, byte by3) {
        for (int i = 0; i < this.goal.length; ++i) {
            if (by != this.goal[i][0] || by2 != this.goal[i][2] || this.miniorbExplosion[i] != null || by == 1 && by3 < this.goal[i][3]) continue;
            this.miniorbExplosion[i] = new StaticImage(Game.getSprite(Game.SPRITE_EXPLOSION));
            this.miniorbExplosion[i].setPosition(this.miniorb[i].getX() + this.miniorb[i].getWidth() / 2 - this.miniorbExplosion[i].getWidth() / 2, this.miniorb[i].getY() + this.miniorb[i].getHeight() / 2 - this.miniorbExplosion[i].getHeight() / 2);
            Game.layerManager.add(this.miniorbExplosion[i]);
        }
    }

    void updateGoalCounters() {
        for (int i = 0; i < this.goal.length; ++i) {
            int n;
            int n2;
            int n3;
            if (this.goal[i][0] == 0) {
                n3 = this.goal[i][1] - this.pointsColor[this.goal[i][2]];
                if (n3 < 0) {
                    n3 = 0;
                }
                n2 = n3 / 10;
                n = n3 % 10;
                if (n2 != 0) {
                    this.goalCounter[i][0].setVisible(true);
                    this.goalCounter[i][0].setFrame(n2);
                } else {
                    this.goalCounter[i][0].setVisible(false);
                }
                this.goalCounter[i][1].setVisible(true);
                this.goalCounter[i][1].setFrame(n);
                this.goalCounter[i][3].setVisible(false);
                this.miniorb[i].setFrame(this.goal[i][2]);
                continue;
            }
            if (this.goal[i][0] != 1) continue;
            n3 = this.goal[i][1] - this.pointsLine[this.goal[i][2]][this.goal[i][3] - 3];
            if (n3 < 0) {
                n3 = 0;
            }
            n2 = n3 / 10;
            n = n3 % 10;
            if (n2 != 0) {
                this.goalCounter[i][0].setVisible(true);
                this.goalCounter[i][0].setFrame(n2);
            } else {
                this.goalCounter[i][0].setVisible(false);
            }
            this.goalCounter[i][1].setVisible(true);
            this.goalCounter[i][1].setFrame(n);
            this.goalCounter[i][3].setVisible(true);
            this.goalCounter[i][3].setFrame(this.goal[i][3]);
            this.miniorb[i].setFrame(this.goal[i][2]);
        }
    }

    void processEvent(Event event) {
        switch (event.id) {
            case 22: 
            case 39: {
                this.menu.setVisible(false);
                this.scroll = new Scroll(Text.get(53), 1, -1);
                Game.layerManager.add(this.scroll);
                Game.layerManager.setKeyLeftListener(this.scroll);
                Game.layerManager.setKeyRightListener(this.scroll);
                this.leftSoft.setEvent(event);
                Game.layerManager.setKeySoft1Listener(this.leftSoft);
                this.rightSoft.setEvent(new Event(43, new Object[]{this, new Event(44)}));
                Game.layerManager.setKeySoft2Listener(this.rightSoft);
                Game.layerManager.setKeyFireListener(null);
                Game.layerManager.setKeyUpListener(null);
                Game.layerManager.setKeyDownListener(null);
                break;
            }
            case 44: {
                Game.layerManager.remove(this.scroll);
                this.scroll.release();
                this.scroll = null;
                this.menu.setVisible(true);
                this.leftSoft.setEvent(null);
                this.rightSoft.setEvent(null);
                Game.layerManager.setKeyFireListener(this.menu);
                Game.layerManager.setKeySoft1Listener(this.menu);
                Game.layerManager.setKeyUpListener(this.menu);
                Game.layerManager.setKeyDownListener(this.menu);
                Game.layerManager.setKeyLeftListener(null);
                Game.layerManager.setKeyRightListener(null);
                Game.layerManager.setKeySoft2Listener(this);
            }
        }
    }

    void animate() {
        if (paused) {
            return;
        }
        if (this.avatar.frame < this.emotion && this.avatar.frame < 2) {
            this.avatar.setFrame(this.avatar.frame + 1);
        } else if (this.avatar.frame > this.emotion && this.avatar.frame > 0) {
            this.avatar.setFrame(this.avatar.frame - 1);
        }
        if (this.emotion > 0) {
            this.emotionTimer = (byte)(this.emotionTimer + 1);
            if (this.emotionTimer == 60) {
                this.emotion = (byte)(this.emotion - 1);
                this.emotionTimer = 0;
            }
        }
        if (gameOver) {
            if (this.goalCompleted) {
                for (int i = 0; i < this.miniorbExplosion.length; ++i) {
                    int n;
                    int n2;
                    if (this.miniorbExplosion[i] == null) continue;
                    if (this.miniorbExplosion[i].isNextFrame() && this.miniorbExplosion[i].isVisible()) {
                        this.miniorbExplosion[i].setFrame(this.miniorbExplosion[i].frame + 1, Game.rand(8));
                        continue;
                    }
                    this.miniorbExplosion[i].setFrame(Game.rand(this.miniorbExplosion[i].getFrameCount()), Game.rand(8));
                    int n3 = Game.rand(4);
                    if (n3 == 0) {
                        n2 = this.scroll.getX() - this.miniorbExplosion[i].getWidth();
                        n = this.scroll.getY() + Game.rand(this.scroll.getHeight()) - this.miniorbExplosion[i].getHeight() / 2;
                    } else if (n3 == 1) {
                        n2 = this.scroll.getX() + Game.rand(this.scroll.getWidth()) - this.miniorbExplosion[i].getWidth() / 2;
                        n = this.scroll.getY() - this.miniorbExplosion[i].getHeight();
                    } else if (n3 == 2) {
                        n2 = this.scroll.getX() + this.scroll.getWidth();
                        n = this.scroll.getY() + Game.rand(this.scroll.getHeight()) - this.miniorbExplosion[i].getHeight() / 2;
                    } else {
                        n2 = this.scroll.getX() + Game.rand(this.scroll.getWidth()) - this.miniorbExplosion[i].getWidth() / 2;
                        n = this.scroll.getY() + this.scroll.getHeight();
                    }
                    this.miniorbExplosion[i].setPosition(n2, n);
                    if (this.miniorbExplosion[i].isVisible()) continue;
                    this.miniorbExplosion[i].setVisible(true);
                }
            }
            return;
        }
        for (int i = 0; i < this.goal.length; ++i) {
            if (this.miniorbExplosion[i] == null) continue;
            if (this.miniorbExplosion[i].frame < 7) {
                this.miniorbExplosion[i].setFrame(this.miniorbExplosion[i].frame + 1);
                continue;
            }
            Game.layerManager.remove(this.miniorbExplosion[i]);
            this.miniorbExplosion[i].release();
            this.miniorbExplosion[i] = null;
        }
        this.gameTimeLeft = (int)(this.gameEndTime - System.currentTimeMillis());
        if (this.gameTimeLeft < 0) {
            this.gameTimeLeft = 0;
        }
        if ((this.gameTimeLeft == 0 || this.goalCompleted) && Pawn.explodeCounter == 0) {
            int n;
            gameOver = true;
            String string = this.goalCompleted ? Text.get(55) : Text.get(54);
            this.scroll = new Scroll(string, 1, -1);
            Game.layerManager.add(this.scroll);
            Game.layerManager.remove(this.rightSoft);
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeySoft2Listener(null);
            for (n = 0; n < this.miniorbExplosion.length; ++n) {
                if (this.miniorbExplosion[n] == null) continue;
                Game.layerManager.remove(this.miniorbExplosion[n]);
                this.miniorbExplosion[n].release();
                this.miniorbExplosion[n] = null;
            }
            if (this.goalCompleted) {
                this.miniorbExplosion = new StaticImage[5];
                for (n = 0; n < this.miniorbExplosion.length; ++n) {
                    this.miniorbExplosion[n] = new StaticImage(Game.getSprite(Game.SPRITE_EXPLOSION));
                    this.miniorbExplosion[n].setPosition(this.scroll.getX() + Game.rand(this.scroll.getWidth()) - this.miniorbExplosion[n].getWidth() / 2, this.scroll.getY() + Game.rand(this.scroll.getHeight()) - this.miniorbExplosion[n].getHeight() / 2);
                    this.miniorbExplosion[n].setFrame(Game.rand(this.miniorbExplosion[n].getFrameCount()), Game.rand(8));
                    this.miniorbExplosion[n].setVisible(false);
                    Game.layerManager.add(this.miniorbExplosion[n]);
                }
            }
            this.emotion = (byte)(this.goalCompleted ? 3 : 0);
            this.state = (byte)8;
            return;
        }
        this.timeBar.setValue(this.gameTimeLeft / 1000);
        switch (this.state) {
            case 0: {
                this.cursorColorFrame = (byte)(this.cursorColorFrame + 1);
                if (this.cursorColorFrame == this.cursorColor.length) {
                    this.cursorColorFrame = 0;
                }
                this.cursor.setOutline(this.cursorColor[this.cursorColorFrame]);
                break;
            }
            case 1: {
                this.arrowsFrame = (byte)(this.arrowsFrame + 1);
                if (this.arrowsFrame == 3) {
                    this.arrowsFrame = 0;
                }
                this.cursorArrowL.setFrame(this.arrowsFrame);
                this.cursorArrowR.setFrame(this.arrowsFrame);
                this.cursorArrowU.setFrame(this.arrowsFrame);
                this.cursorArrowD.setFrame(this.arrowsFrame);
                break;
            }
            case 2: {
                if (Pawn.moveCounter != 0) break;
                if (this.removeLines()) {
                    this.state = (byte)4;
                    this.showCursor();
                    break;
                }
                this.movePawnBack();
                if (this.emotion <= 0) break;
                this.emotion = (byte)(this.emotion - 1);
                break;
            }
            case 3: {
                if (Pawn.moveCounter != 0) break;
                this.state = 0;
                this.board[this.cursorX][this.cursorY].setState((byte)1);
                this.showCursor();
                break;
            }
            case 4: {
                if (Pawn.explodeCounter != 0) break;
                this.drawNextPawns();
                this.state = (byte)5;
                this.showCursor();
                break;
            }
            case 5: {
                if (Pawn.moveCounter != 0) break;
                if (this.removeLines()) {
                    this.state = (byte)4;
                    this.showCursor();
                    break;
                }
                this.state = 0;
                this.board[this.cursorX][this.cursorY].setState((byte)1);
                this.showCursor();
            }
        }
    }

    boolean pointerPressed(int n, int n2) {
        if (paused) {
            return false;
        }
        int n3 = (n - this.x) / this.cellSize;
        int n4 = (n2 - this.y) / this.cellSize;
        if (n3 >= 0 && n3 <= 7 && n4 >= 0 && n4 <= 7) {
            switch (this.state) {
                case 0: {
                    this.board[this.cursorX][this.cursorY].setState((byte)0);
                    this.cursorX = (byte)n3;
                    this.cursorY = (byte)n4;
                    this.board[this.cursorX][this.cursorY].setState((byte)1);
                    this.keyFire();
                    break;
                }
                case 1: {
                    if (n3 == this.cursorX && n4 == this.cursorY) {
                        this.keyFire();
                        break;
                    }
                    if (n3 > this.cursorX && n4 == this.cursorY) {
                        this.keyRight();
                        break;
                    }
                    if (n3 < this.cursorX && n4 == this.cursorY) {
                        this.keyLeft();
                        break;
                    }
                    if (n3 == this.cursorX && n4 < this.cursorY) {
                        this.keyUp();
                        break;
                    }
                    if (n3 != this.cursorX || n4 <= this.cursorY) break;
                    this.keyDown();
                }
            }
        }
        return true;
    }

    void doLayout() {
        int n;
        int n2;
        this.bg.setWidth(Game.canvasWidth);
        this.bg.setHeight(Game.canvasHeight);
        int n3 = this.x;
        int n4 = this.y;
        if (Game.CANVAS_ORIENTATION == 0) {
            this.center();
            this.hudBg.setPosition(0, 0);
            this.hudBg.setTransform(0, true);
            this.hudBg.setWidth(Game.canvasWidth);
            this.hudBg.setHeight(this.hourGlass.getHeight() + this.miniorb[0].getHeight() + 3);
            this.avatar.setPosition(2, this.hudBg.getHeight() / 2 - this.avatar.getHeight() / 2);
            this.hourGlass.setPosition(this.avatar.getX() + this.avatar.getWidth() + 2, this.hudBg.getY() + 1);
            this.timeBar.setLayout((byte)0);
            this.timeBar.setPosition(this.hourGlass.getX() + this.hourGlass.getWidth() + 2, this.hourGlass.getCenterY() - this.timeBar.getHeight() / 2);
            this.timeBar.setWidth(this.hudBg.getWidth() - this.hourGlass.getWidth() - this.avatar.getWidth() - 8);
            n2 = this.hudBg.getY() + this.hudBg.getHeight() + 2 + this.boardBorder.getSpriteWidth();
            if (this.y < n2) {
                this.y = n2;
            }
        } else {
            this.center();
            this.hudBg.setPosition(0, 0);
            this.hudBg.setTransform(5, true);
            n2 = this.goalCounter[0][0].getWidth() * 7 - this.goalCounter[0][0].getWidth() / 2;
            this.hudBg.setWidth(n2 + 2);
            this.hudBg.setHeight(Game.canvasHeight);
            this.avatar.setPosition(this.hudBg.getWidth() / 2 - this.avatar.getWidth() / 2, 2);
            this.hourGlass.setPosition(this.hudBg.getCenterX() - this.hourGlass.getWidth() / 2, this.avatar.getY() + this.avatar.getHeight() + 2 + this.goalCounter[0][0].getHeight() * 3 * this.goal.length + 1);
            this.timeBar.setLayout((byte)1);
            this.timeBar.setPosition(this.hourGlass.getCenterX() - this.timeBar.getWidth() / 2, this.hourGlass.getY() + this.hourGlass.getHeight() + 1);
            this.timeBar.setHeight(this.hudBg.getHeight() - this.timeBar.getY() - 4 - this.leftSoft.getHeight());
            n = this.hudBg.getX() + this.hudBg.getWidth() + 2 + this.boardBorder.getSpriteWidth();
            if (this.x < n) {
                this.x = n;
            }
        }
        this.boardBg.setWidth(this.width);
        this.boardBg.setHeight(this.height);
        this.boardBg.setPosition(this.x, this.y);
        this.boardBorder.setWidth(this.width);
        this.boardBorder.setHeight(this.height);
        this.boardBorder.setPosition(this.x, this.y);
        int n5 = this.x - n3;
        int n6 = this.y - n4;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < 8; ++n) {
                this.board[n2][n].move(n5, n6);
            }
        }
        if (this.goalBorder != null) {
            this.goalBorder.center();
            this.goalBg.setPosition(this.goalBorder.getX(), this.goalBorder.getY());
            this.goalLabel.setPosition(this.goalBorder.getCenterX() - this.goalLabel.getWidth() / 2, this.goalBorder.getY());
        }
        this.positionGoalCounters();
        this.menu.setPosition(this.menu.border.getSpriteWidth() * 2, this.menu.up.getHeight() * 2);
        this.menu.setWidth(Game.canvasWidth - this.menu.border.getSpriteWidth() * 4);
        this.menu.setHeight(Game.canvasHeight - this.menu.up.getHeight() * 4);
        this.menu.shrink();
        this.showCursor();
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
    }

    void positionGoalCounters() {
        if (this.state == 7) {
            int n;
            int n2 = this.goalCounter[0][0].getHeight() * 3;
            int n3 = this.goalCounter[0][0].getWidth() * 7 - this.goalCounter[0][0].getWidth() / 2;
            int n4 = n = this.goalBorder.getCenterX() - n3 / 2;
            int n5 = this.goalLabel.getY() + this.goalLabel.getHeight() + this.goalCounter[0][0].getHeight();
            for (int i = 0; i < this.goal.length; ++i) {
                n4 = n;
                this.goalCounter[i][0].setPosition(n4, n5);
                this.goalCounter[i][1].setPosition(n4 += this.goalCounter[i][0].getWidth(), n5);
                this.goalCounter[i][2].setPosition(n4 += this.goalCounter[i][0].getWidth() + this.goalCounter[i][0].getWidth() / 2, n5);
                this.goalCounter[i][2].setFrame(10);
                this.goalCounter[i][3].setPosition(n4 += this.goalCounter[i][0].getWidth() + this.goalCounter[i][0].getWidth(), n5);
                this.miniorb[i].setPosition(this.goalCounter[i][3].getX() + this.goalCounter[i][3].getWidth() / 2 - this.miniorb[i].getWidth() / 2, this.goalCounter[i][3].getY() + this.goalCounter[i][3].getHeight() / 2 - this.miniorb[i].getHeight() / 2);
                n5 += n2;
            }
        } else if (Game.CANVAS_ORIENTATION == 0) {
            int n = this.goalCounter[0][0].getWidth();
            int n6 = (n * 5 + n / 2) * this.goal.length + n * (this.goal.length - 1) + n / 2;
            int n7 = this.hourGlass.getX() + (this.hudBg.getX() + this.hudBg.getWidth() - this.hourGlass.getX()) / 2 - n6 / 2;
            int n8 = this.hourGlass.getY() + this.hourGlass.getHeight() + (this.miniorb[0].getHeight() - this.goalCounter[0][0].getHeight()) / 2;
            for (int i = 0; i < this.goal.length; ++i) {
                this.goalCounter[i][0].setPosition(n7, n8);
                this.goalCounter[i][1].setPosition(n7 += n, n8);
                this.goalCounter[i][2].setPosition(n7 += n + n / 2, n8);
                this.goalCounter[i][2].setFrame(10);
                this.goalCounter[i][3].setPosition(n7 += n + n, n8);
                this.miniorb[i].setPosition(this.goalCounter[i][3].getX() + this.goalCounter[i][3].getWidth() / 2 - this.miniorb[i].getWidth() / 2, this.goalCounter[i][3].getY() + this.goalCounter[i][3].getHeight() / 2 - this.miniorb[i].getHeight() / 2);
                n7 += n + n;
            }
        } else {
            int n;
            int n9 = this.goalCounter[0][0].getWidth() * 7 - this.goalCounter[0][0].getWidth() / 2;
            int n10 = this.goalCounter[0][0].getHeight() * 3;
            int n11 = n = this.hudBg.getCenterX() - n9 / 2;
            int n12 = this.avatar.getY() + this.avatar.getHeight() + this.goalCounter[0][0].getHeight();
            for (int i = 0; i < this.goal.length; ++i) {
                n11 = n;
                this.goalCounter[i][0].setPosition(n11, n12);
                this.goalCounter[i][1].setPosition(n11 += this.goalCounter[i][0].getWidth(), n12);
                this.goalCounter[i][2].setPosition(n11 += this.goalCounter[i][0].getWidth() + this.goalCounter[i][0].getWidth() / 2, n12);
                this.goalCounter[i][2].setFrame(10);
                this.goalCounter[i][3].setPosition(n11 += this.goalCounter[i][0].getWidth() + this.goalCounter[i][0].getWidth(), n12);
                this.miniorb[i].setPosition(this.goalCounter[i][3].getX() + this.goalCounter[i][3].getWidth() / 2 - this.miniorb[i].getWidth() / 2, this.goalCounter[i][3].getY() + this.goalCounter[i][3].getHeight() / 2 - this.miniorb[i].getHeight() / 2);
                n12 += n10;
            }
        }
    }

    void gameResumed() {
        this.gameEndTime = System.currentTimeMillis() + (long)this.gameTimeLeft;
    }

    void release() {
        super.release();
    }
}

